/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.stringsubs.impl;

import com.sun.enterprise.admin.servermgmt.stringsubs.impl.ArchiveEntryWrapper;
import com.sun.enterprise.admin.servermgmt.stringsubs.impl.ArchiveMember;
import com.sun.enterprise.admin.servermgmt.stringsubs.impl.FileSubstitutionHandler;
import com.sun.enterprise.admin.servermgmt.stringsubs.impl.LargeFileSubstitutionHandler;
import com.sun.enterprise.admin.servermgmt.stringsubs.impl.SmallFileSubstitutionHandler;
import com.sun.enterprise.admin.servermgmt.stringsubs.impl.SubstitutionFileUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Reader;
import java.io.Writer;

public class ArchiveMemberHandler
implements ArchiveMember {
    private ArchiveEntryWrapper _archiveWrapper;
    private FileSubstitutionHandler _handler;

    public ArchiveMemberHandler(File file, ArchiveEntryWrapper wrapper) throws FileNotFoundException {
        this._handler = file.length() > (long)SubstitutionFileUtil.getInMemorySubstitutionFileSizeInBytes() ? new LargeFileSubstitutionHandler(file) : new SmallFileSubstitutionHandler(file);
        this._archiveWrapper = wrapper;
    }

    @Override
    public void finish() {
        this._handler.finish();
        this.getParent().notifyCompletion();
    }

    @Override
    public ArchiveEntryWrapper getParent() {
        return this._archiveWrapper;
    }

    @Override
    public String getName() {
        return this._handler.getName();
    }

    @Override
    public Reader getReader() {
        return this._handler.getReader();
    }

    @Override
    public Writer getWriter() {
        return this._handler.getWriter();
    }
}

