/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.embed.impl;

import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.web.ContextFacade;
import com.sun.enterprise.web.EmbeddedWebContainer;
import com.sun.enterprise.web.VirtualServer;
import com.sun.enterprise.web.VirtualServerFacade;
import com.sun.enterprise.web.WebConnector;
import com.sun.enterprise.web.WebContainer;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Engine;
import org.apache.catalina.core.StandardHost;
import org.glassfish.api.container.Container;
import org.glassfish.api.container.Sniffer;
import org.glassfish.embeddable.GlassFishException;
import org.glassfish.embeddable.web.ConfigException;
import org.glassfish.embeddable.web.Context;
import org.glassfish.embeddable.web.HttpListener;
import org.glassfish.embeddable.web.HttpsListener;
import org.glassfish.embeddable.web.WebListener;
import org.glassfish.embeddable.web.config.SslConfig;
import org.glassfish.embeddable.web.config.SslType;
import org.glassfish.embeddable.web.config.WebContainerConfig;
import org.glassfish.grizzly.config.dom.FileCache;
import org.glassfish.grizzly.config.dom.Http;
import org.glassfish.grizzly.config.dom.NetworkConfig;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.config.dom.NetworkListeners;
import org.glassfish.grizzly.config.dom.Protocol;
import org.glassfish.grizzly.config.dom.Protocols;
import org.glassfish.grizzly.config.dom.Ssl;
import org.glassfish.grizzly.config.dom.ThreadPool;
import org.glassfish.grizzly.config.dom.Transport;
import org.glassfish.grizzly.config.dom.Transports;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.internal.embedded.Port;
import org.glassfish.internal.embedded.Ports;
import org.glassfish.web.embed.impl.ScatteredWebArchivist;
import org.jvnet.hk2.annotations.ContractsProvided;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigCode;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service
@ContractsProvided(value={WebContainerImpl.class, org.glassfish.embeddable.web.WebContainer.class})
public class WebContainerImpl
implements org.glassfish.embeddable.web.WebContainer {
    private ServiceHandle<Container> container;
    private ServiceHandle<?> embeddedInhabitant;
    @Inject
    private ServiceLocator habitat;
    @Inject
    @Named(value="default-instance-name")
    private HttpService httpService;
    private static Logger log = Logger.getLogger(WebContainerImpl.class.getName());
    @Inject
    @Named(value="default-instance-name")
    private NetworkConfig networkConfig;
    @Inject
    private ServerContext serverContext;
    private WebContainerConfig config;
    private EmbeddedWebContainer embedded;
    private Engine engine = null;
    private boolean initialized = false;
    private String listenerName = "embedded-listener";
    private final List<WebListener> listeners = new ArrayList<WebListener>();
    private String securityEnabled = "false";
    private WebContainer webContainer;

    private void init() {
        if (this.initialized) {
            return;
        }
        if (this.config == null) {
            this.config = new WebContainerConfig();
        }
        this.container = this.habitat.getServiceHandle(Container.class, "com.sun.enterprise.web.WebContainer", new Annotation[0]);
        if (this.container == null) {
            log.severe("Cannot find webcontainer implementation");
            return;
        }
        ActiveDescriptor activeDescriptor = this.habitat.getBestDescriptor((Filter)BuilderHelper.createContractFilter((String)"com.sun.enterprise.web.EmbeddedWebContainer"));
        if (activeDescriptor == null) {
            log.severe("Cannot find embedded implementation");
            return;
        }
        this.embeddedInhabitant = this.habitat.getServiceHandle(activeDescriptor);
        try {
            this.webContainer = (WebContainer)this.container.getService();
            this.embedded = (EmbeddedWebContainer)((Object)this.embeddedInhabitant.getService());
            if (this.webContainer == null || this.embedded == null) {
                log.severe("Cannot find webcontainer implementation");
                return;
            }
            this.engine = this.webContainer.getEngine();
            if (this.engine == null) {
                log.severe("Cannot find engine implementation");
                return;
            }
            this.initialized = true;
        }
        catch (Exception e) {
            log.severe("Init exception " + e.getMessage());
        }
    }

    private void bind(Port port, WebListener webListener, String vsId) {
        String protocol = "http";
        final int portNumber = port.getPortNumber();
        final String defaultVS = vsId;
        final WebListener listener = webListener;
        if (webListener == null) {
            this.listenerName = this.getListenerName();
            webListener = new HttpListener();
            webListener.setId(this.listenerName);
            webListener.setPort(portNumber);
        } else {
            this.listenerName = webListener.getId();
            protocol = webListener.getProtocol();
        }
        this.listeners.add(webListener);
        if (protocol.equals("http")) {
            this.securityEnabled = "false";
        } else if (protocol.equals("https")) {
            this.securityEnabled = "true";
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Protocols>(){

                public Object run(Protocols param) throws TransactionFailure {
                    Protocol protocol = (Protocol)param.createChild(Protocol.class);
                    protocol.setName(WebContainerImpl.this.listenerName);
                    protocol.setSecurityEnabled(WebContainerImpl.this.securityEnabled);
                    param.getProtocol().add(protocol);
                    Http http = (Http)protocol.createChild(Http.class);
                    http.setDefaultVirtualServer(defaultVS);
                    http.setFileCache((FileCache)http.createChild(FileCache.class));
                    protocol.setHttp(http);
                    return protocol;
                }
            }, (ConfigBeanProxy)this.networkConfig.getProtocols());
            ConfigSupport.apply((ConfigCode)new ConfigCode(){

                public Object run(ConfigBeanProxy ... params) throws TransactionFailure {
                    NetworkListeners nls = (NetworkListeners)params[0];
                    Transports transports = (Transports)params[1];
                    NetworkListener listener = (NetworkListener)nls.createChild(NetworkListener.class);
                    listener.setName(WebContainerImpl.this.listenerName);
                    listener.setPort(Integer.toString(portNumber));
                    listener.setProtocol(WebContainerImpl.this.listenerName);
                    listener.setThreadPool("http-thread-pool");
                    if (listener.findThreadPool() == null) {
                        ThreadPool pool = (ThreadPool)nls.createChild(ThreadPool.class);
                        pool.setName(WebContainerImpl.this.listenerName);
                        listener.setThreadPool(WebContainerImpl.this.listenerName);
                    }
                    listener.setTransport("tcp");
                    if (listener.findTransport() == null) {
                        Transport transport = (Transport)transports.createChild(Transport.class);
                        transport.setName(WebContainerImpl.this.listenerName);
                        listener.setTransport(WebContainerImpl.this.listenerName);
                    }
                    nls.getNetworkListener().add(listener);
                    return listener;
                }
            }, (ConfigBeanProxy[])new ConfigBeanProxy[]{this.networkConfig.getNetworkListeners(), this.networkConfig.getTransports()});
            if (webListener.getProtocol().equals("https")) {
                NetworkListener networkListener = this.networkConfig.getNetworkListener(this.listenerName);
                Protocol httpProtocol = networkListener.findHttpProtocol();
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Protocol>(){

                    public Object run(Protocol param) throws TransactionFailure {
                        Ssl newSsl = (Ssl)param.createChild(Ssl.class);
                        WebContainerImpl.this.populateSslElement(newSsl, listener);
                        System.out.println("SSL " + newSsl.getKeyStore() + " " + newSsl.getKeyStorePassword() + " " + newSsl.getTrustStore() + " " + newSsl.getTrustStorePassword());
                        param.setSsl(newSsl);
                        return newSsl;
                    }
                }, (ConfigBeanProxy)httpProtocol);
            }
            com.sun.enterprise.config.serverbeans.VirtualServer vs = this.httpService.getVirtualServerByName(this.config.getVirtualServerId());
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<com.sun.enterprise.config.serverbeans.VirtualServer>(){

                public Object run(com.sun.enterprise.config.serverbeans.VirtualServer avs) throws PropertyVetoException {
                    avs.addNetworkListener(WebContainerImpl.this.listenerName);
                    return avs;
                }
            }, (ConfigBeanProxy)vs);
        }
        catch (Exception e) {
            if (this.listeners.contains(webListener)) {
                this.listeners.remove(webListener);
            }
            e.printStackTrace();
        }
    }

    private void populateSslElement(Ssl newSsl, WebListener webListener) {
        if (webListener instanceof HttpsListener) {
            HttpsListener listener = (HttpsListener)webListener;
            SslConfig sslConfig = listener.getSslConfig();
            if (sslConfig == null) {
                return;
            }
            if (sslConfig.getKeyStore() != null) {
                newSsl.setKeyStore(sslConfig.getKeyStore());
            }
            if (sslConfig.getKeyPassword() != null) {
                newSsl.setKeyStorePassword(new String(sslConfig.getKeyPassword()));
            }
            if (sslConfig.getTrustStore() != null) {
                newSsl.setTrustStore(sslConfig.getTrustStore());
            }
            if (sslConfig.getTrustPassword() != null) {
                newSsl.setTrustStorePassword(new String(sslConfig.getTrustPassword()));
            }
            if (sslConfig.getAlgorithms() != null) {
                for (SslType sslType : sslConfig.getAlgorithms()) {
                    if (sslType.equals((Object)SslType.SSLv2)) {
                        newSsl.setSsl2Enabled("true");
                    }
                    if (sslType.equals((Object)SslType.SSLv3)) {
                        newSsl.setSsl3Enabled("true");
                    }
                    if (!sslType.equals((Object)SslType.TLS)) continue;
                    newSsl.setSsl3TlsCiphers("true");
                }
            }
            if (sslConfig.getHandshakeTimeout() > 0) {
                newSsl.setSSLInactivityTimeout(sslConfig.getHandshakeTimeout());
            }
            if (sslConfig.getCertNickname() != null) {
                newSsl.setCertNickname(sslConfig.getCertNickname());
            }
        } else {
            log.severe("HttpsListener required for https protocol");
        }
    }

    private void addWebListener(WebListener webListener, String vsId) throws ConfigException, GlassFishException {
        if (!this.initialized) {
            this.init();
        }
        if (this.getWebListener(webListener.getId()) != null) {
            throw new ConfigException("Connector with name '" + webListener.getId() + "' already exsits");
        }
        this.listenerName = webListener.getId();
        try {
            Ports ports = (Ports)this.habitat.getService(Ports.class, new Annotation[0]);
            Port port = ports.createPort(webListener.getPort());
            this.bind(port, webListener, vsId);
        }
        catch (IOException ex) {
            throw new ConfigException((Throwable)ex);
        }
        webListener.setWebContainer((org.glassfish.embeddable.web.WebContainer)this);
        if (log.isLoggable(Level.INFO)) {
            log.info("Added connector " + webListener.getId() + " port " + webListener.getPort() + " to virtual server " + vsId);
        }
    }

    private String getListenerName() {
        int i = 1;
        if (!this.existsListener(this.listenerName)) {
            return this.listenerName;
        }
        Object name = "embedded-listener";
        while (this.existsListener((String)name)) {
            name = "embedded-listener-" + i++;
        }
        return name;
    }

    private boolean existsListener(String lName) {
        for (NetworkListener nl : this.networkConfig.getNetworkListeners().getNetworkListener()) {
            if (!nl.getName().equals(lName)) continue;
            return true;
        }
        return false;
    }

    private void removeListener(String name) {
        try {
            NetworkListeners networkListeners = this.networkConfig.getNetworkListeners();
            final NetworkListener listenerToBeRemoved = this.networkConfig.getNetworkListener(name);
            Protocols protocols = this.networkConfig.getProtocols();
            Protocol protocol = this.networkConfig.findProtocol(name);
            if (listenerToBeRemoved == null) {
                log.severe("Network Listener " + name + " doesn't exist");
            } else {
                com.sun.enterprise.config.serverbeans.VirtualServer virtualServer = this.httpService.getVirtualServerByName(listenerToBeRemoved.findHttpProtocol().getHttp().getDefaultVirtualServer());
                ConfigSupport.apply((ConfigCode)new ConfigCode(){

                    public Object run(ConfigBeanProxy ... params) throws PropertyVetoException {
                        NetworkListeners listeners = (NetworkListeners)params[0];
                        com.sun.enterprise.config.serverbeans.VirtualServer server = (com.sun.enterprise.config.serverbeans.VirtualServer)params[1];
                        listeners.getNetworkListener().remove(listenerToBeRemoved);
                        server.removeNetworkListener(listenerToBeRemoved.getName());
                        return listenerToBeRemoved;
                    }
                }, (ConfigBeanProxy[])new ConfigBeanProxy[]{networkListeners, virtualServer});
                ConfigSupport.apply((ConfigCode)new ConfigCode(){

                    public Object run(ConfigBeanProxy ... params) throws PropertyVetoException {
                        Protocols protocols = (Protocols)params[0];
                        Protocol protocol = (Protocol)params[1];
                        protocols.getProtocol().remove(protocol);
                        return protocol;
                    }
                }, (ConfigBeanProxy[])new ConfigBeanProxy[]{protocols, protocol});
            }
        }
        catch (TransactionFailure e) {
            log.severe("Remove listener " + name + " failed " + e.getMessage());
        }
    }

    public void setConfiguration(WebContainerConfig config) {
        if (!this.initialized) {
            this.init();
        }
        this.config = config;
        final WebContainerConfig webConfig = config;
        try {
            com.sun.enterprise.config.serverbeans.VirtualServer vsBean;
            org.glassfish.embeddable.web.VirtualServer vs = this.getVirtualServer(config.getVirtualServerId());
            if (vs != null) {
                ((StandardHost)vs).setDefaultWebXmlLocation(config.getDefaultWebXml().getPath());
            }
            if ((vsBean = this.httpService.getVirtualServerByName(config.getVirtualServerId())) != null) {
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<com.sun.enterprise.config.serverbeans.VirtualServer>(){

                    public Object run(com.sun.enterprise.config.serverbeans.VirtualServer avs) throws PropertyVetoException, TransactionFailure {
                        avs.setId(webConfig.getVirtualServerId());
                        if (webConfig.getDocRootDir() != null) {
                            avs.setDocroot(webConfig.getDocRootDir().getAbsolutePath());
                        }
                        avs.setHosts(webConfig.getHostNames());
                        avs.setNetworkListeners(webConfig.getListenerName());
                        Property property = (Property)avs.createChild(Property.class);
                        property.setName("default-web-xml");
                        property.setValue(webConfig.getDefaultWebXml().getPath());
                        avs.getProperty().add(property);
                        return avs;
                    }
                }, (ConfigBeanProxy)vsBean);
            } else {
                vs = this.createVirtualServer(config.getVirtualServerId(), config.getDocRootDir());
                this.addVirtualServer(vs);
            }
            ScatteredWebArchivist.setDefaultWebXml(config.getDefaultWebXml());
            this.embedded.setDirectoryListing(config.getListings());
            WebListener listener = this.getWebListener(config.getListenerName());
            if (listener == null) {
                listener = this.getWebListener(config.getPort());
                if (listener == null) {
                    boolean found = false;
                    for (Map.Entry<String, WebConnector> entry : this.webContainer.getConnectorMap().entrySet()) {
                        if (entry.getValue().getPort() != config.getPort()) continue;
                        found = true;
                        log.info("Port " + config.getPort() + " is already configured");
                    }
                    if (!found) {
                        listener = this.createWebListener(config.getListenerName(), HttpListener.class);
                        listener.setPort(config.getPort());
                        this.addWebListener(listener, config.getVirtualServerId());
                    }
                }
            } else if (listener.getPort() != config.getPort()) {
                listener.setPort(config.getPort());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public List<Sniffer> getSniffers() {
        ArrayList<Sniffer> sniffers = new ArrayList<Sniffer>();
        sniffers.add((Sniffer)this.habitat.getService(Sniffer.class, "web", new Annotation[0]));
        sniffers.add((Sniffer)this.habitat.getService(Sniffer.class, "weld", new Annotation[0]));
        Sniffer security = (Sniffer)this.habitat.getService(Sniffer.class, "Security", new Annotation[0]);
        if (security != null) {
            sniffers.add(security);
        }
        return sniffers;
    }

    public Context createContext(File docRoot) {
        return this.createContext(docRoot, null);
    }

    public Context createContext(File docRoot, ClassLoader classLoader) {
        if (docRoot == null) {
            log.severe("Cannot create context with NULL docroot");
            return null;
        }
        if (!this.initialized) {
            this.init();
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("Creating context '" + docRoot.getName() + "' with docBase '" + docRoot.getAbsolutePath() + "'");
        }
        return new ContextFacade(docRoot, null, classLoader);
    }

    public Context createContext(File docRoot, String contextRoot, ClassLoader classLoader) {
        Context context = this.createContext(docRoot, classLoader);
        try {
            this.addContext(context, contextRoot);
        }
        catch (Exception ex) {
            log.severe("Couldn't add context " + context + " using " + contextRoot);
            ex.printStackTrace();
        }
        return context;
    }

    public void addContext(Context context, String contextRoot) throws ConfigException, GlassFishException {
        if (contextRoot == null) {
            throw new ConfigException("Context root cannot be NULL");
        }
        for (org.glassfish.embeddable.web.VirtualServer vs : this.getVirtualServers()) {
            if (vs.getContext(contextRoot) != null) {
                throw new ConfigException("Context with contextRoot " + contextRoot + " is already registered");
            }
            if ("__asadmin".equals(vs.getID())) continue;
            vs.addContext(context, contextRoot);
            if (!log.isLoggable(Level.INFO)) continue;
            log.info("Added context with path " + contextRoot + " from virtual server " + vs.getID());
        }
    }

    public void removeContext(Context context) throws ConfigException, GlassFishException {
        String contextRoot = context.getPath();
        for (org.glassfish.embeddable.web.VirtualServer vs : this.getVirtualServers()) {
            if ("__asadmin".equals(vs.getID())) continue;
            if (vs.getContext(contextRoot) != null) {
                vs.removeContext(context);
                if (!log.isLoggable(Level.INFO)) continue;
                log.info("Removed context with path " + contextRoot + " from virtual server " + vs.getID());
                continue;
            }
            throw new GlassFishException("Context with context path " + context.getPath() + " does not exist on virtual server " + vs.getID());
        }
    }

    public <T extends WebListener> T createWebListener(String id, Class<T> c) throws InstantiationException, IllegalAccessException {
        WebListener webListener = null;
        if (log.isLoggable(Level.INFO)) {
            log.info("Creating connector " + id);
        }
        try {
            webListener = (WebListener)c.newInstance();
            webListener.setId(id);
        }
        catch (Exception e) {
            log.severe("Couldn't create connector " + e.getMessage());
        }
        return (T)webListener;
    }

    public void addWebListener(WebListener webListener) throws ConfigException, GlassFishException {
        if (!this.initialized) {
            this.init();
        }
        this.addWebListener(webListener, this.config.getVirtualServerId());
    }

    public WebListener getWebListener(String id) {
        if (!this.initialized) {
            this.init();
        }
        for (WebListener listener : this.listeners) {
            if (!listener.getId().equals(id)) continue;
            return listener;
        }
        return null;
    }

    private WebListener getWebListener(int port) {
        for (WebListener listener : this.listeners) {
            if (listener.getPort() != port) continue;
            return listener;
        }
        return null;
    }

    public Collection<WebListener> getWebListeners() {
        return this.listeners;
    }

    public void removeWebListener(WebListener webListener) throws GlassFishException {
        if (!this.listeners.contains(webListener)) {
            throw new GlassFishException((Throwable)new ConfigException("Connector with name '" + webListener.getId() + "' does not exsits"));
        }
        this.listeners.remove(webListener);
        this.removeListener(webListener.getId());
        if (log.isLoggable(Level.INFO)) {
            log.info("Removed connector " + webListener.getId());
        }
    }

    public org.glassfish.embeddable.web.VirtualServer createVirtualServer(String id, File docRoot, WebListener ... webListeners) {
        return new VirtualServerFacade(id, docRoot, webListeners);
    }

    public org.glassfish.embeddable.web.VirtualServer createVirtualServer(String id, File docRoot) {
        return new VirtualServerFacade(id, docRoot, null);
    }

    public void addVirtualServer(org.glassfish.embeddable.web.VirtualServer virtualServer) throws ConfigException, GlassFishException {
        VirtualServer vs;
        if (!this.initialized) {
            this.init();
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("Adding virtual server " + virtualServer.getID());
        }
        if ((vs = (VirtualServer)this.engine.findChild(virtualServer.getID())) != null) {
            throw new ConfigException("VirtualServer with id " + virtualServer.getID() + " is already registered");
        }
        List<WebListener> webListeners = virtualServer.getWebListeners();
        ArrayList<String> names = new ArrayList<String>();
        if (webListeners != null && !webListeners.isEmpty()) {
            for (WebListener listener : webListeners) {
                names.add(listener.getId());
            }
        } else {
            for (NetworkListener networkListener : this.networkConfig.getNetworkListeners().getNetworkListener()) {
                names.add(networkListener.getName());
            }
            webListeners = this.listeners;
        }
        StringBuffer networkListeners = new StringBuffer("");
        if (names.size() > 0) {
            networkListeners.append((String)names.get(0));
        }
        for (int i = 1; i < names.size(); ++i) {
            networkListeners.append(",");
            networkListeners.append((String)names.get(i));
        }
        String docRoot = null;
        if (virtualServer.getDocRoot() != null) {
            docRoot = virtualServer.getDocRoot().getAbsolutePath();
        }
        String hostName = null;
        if (virtualServer.getConfig() != null) {
            hostName = virtualServer.getConfig().getHostNames();
        }
        final String root = docRoot;
        final String nl = networkListeners.toString();
        final String id = virtualServer.getID();
        final String hosts = hostName;
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<HttpService>(){

                public Object run(HttpService param) throws PropertyVetoException, TransactionFailure {
                    com.sun.enterprise.config.serverbeans.VirtualServer newVirtualServer = (com.sun.enterprise.config.serverbeans.VirtualServer)param.createChild(com.sun.enterprise.config.serverbeans.VirtualServer.class);
                    newVirtualServer.setId(id);
                    newVirtualServer.setNetworkListeners(nl);
                    if (hosts != null) {
                        newVirtualServer.setHosts(hosts);
                    }
                    Property property = (Property)newVirtualServer.createChild(Property.class);
                    property.setName("docroot");
                    property.setValue(root);
                    newVirtualServer.getProperty().add(property);
                    param.getVirtualServer().add(newVirtualServer);
                    return newVirtualServer;
                }
            }, (ConfigBeanProxy)this.httpService);
        }
        catch (Exception ex) {
            throw new GlassFishException((Throwable)ex);
        }
        if (webListeners != null && !webListeners.isEmpty()) {
            for (WebListener listener : webListeners) {
                if (this.getWebListener(listener.getId()) != null) continue;
                this.addWebListener(listener, virtualServer.getID());
            }
        }
        if ((vs = (VirtualServer)this.engine.findChild(id)) != null) {
            if (log.isLoggable(Level.INFO)) {
                log.info("Added virtual server " + id + " docroot " + docRoot + " networklisteners " + nl);
            }
            if (virtualServer instanceof VirtualServerFacade) {
                ((VirtualServerFacade)virtualServer).setVirtualServer(vs);
            }
        } else {
            log.severe("Could not add virtual server " + id);
            throw new GlassFishException((Throwable)new Exception("Cannot add virtual server " + id));
        }
        vs.setNetworkListenerNames(names.toArray(new String[names.size()]));
    }

    public org.glassfish.embeddable.web.VirtualServer getVirtualServer(String id) {
        if (!this.initialized) {
            this.init();
        }
        return (org.glassfish.embeddable.web.VirtualServer)this.engine.findChild(id);
    }

    public Collection<org.glassfish.embeddable.web.VirtualServer> getVirtualServers() {
        if (!this.initialized) {
            this.init();
        }
        ArrayList<org.glassfish.embeddable.web.VirtualServer> virtualServers = new ArrayList<org.glassfish.embeddable.web.VirtualServer>();
        for (org.apache.catalina.Container child : this.engine.findChildren()) {
            if (!(child instanceof org.glassfish.embeddable.web.VirtualServer)) continue;
            virtualServers.add((org.glassfish.embeddable.web.VirtualServer)child);
        }
        return virtualServers;
    }

    public void removeVirtualServer(org.glassfish.embeddable.web.VirtualServer virtualServer) throws GlassFishException {
        if (!this.initialized) {
            this.init();
        }
        if (virtualServer instanceof org.apache.catalina.Container) {
            this.engine.removeChild((org.apache.catalina.Container)virtualServer);
        } else if (virtualServer instanceof VirtualServerFacade) {
            this.engine.removeChild((org.apache.catalina.Container)((VirtualServerFacade)virtualServer).getVirtualServer());
        }
    }

    public void setLogLevel(Level level) {
        log.setLevel(level);
    }
}

