/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.logviewer;

import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class LogRecord {
    private long recordNumber;
    private OffsetDateTime loggedDateTime;
    private String loggedLevel;
    private String productName;
    private String loggerName;
    private String nameValuePairs;
    private String messageID;
    private String message;

    public LogRecord() {
    }

    public LogRecord(List<? extends Serializable> logRecord) {
        int fieldIndex = 0;
        this.recordNumber = (Long)logRecord.get(fieldIndex++);
        this.loggedDateTime = (OffsetDateTime)logRecord.get(fieldIndex++);
        this.loggedLevel = (String)((Object)logRecord.get(fieldIndex++));
        this.productName = (String)((Object)logRecord.get(fieldIndex++));
        this.loggerName = (String)((Object)logRecord.get(fieldIndex++));
        this.nameValuePairs = (String)((Object)logRecord.get(fieldIndex++));
        this.messageID = (String)((Object)logRecord.get(fieldIndex++));
        this.message = (String)((Object)logRecord.get(fieldIndex));
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String Message2) {
        this.message = Message2;
    }

    public OffsetDateTime getLoggedDateTime() {
        return this.loggedDateTime;
    }

    public void setLoggedDateTime(OffsetDateTime loggedDateTime) {
        this.loggedDateTime = loggedDateTime;
    }

    public String getLoggedLevel() {
        return this.loggedLevel;
    }

    public void setLoggedLevel(String loggedLevel) {
        this.loggedLevel = loggedLevel;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public void setLoggerName(String loggerName) {
        this.loggerName = loggerName;
    }

    public String getMessageID() {
        return this.messageID;
    }

    public void setMessageID(String messageID) {
        this.messageID = messageID;
    }

    public String getNameValuePairs() {
        return this.nameValuePairs;
    }

    public void setNameValuePairs(String nameValuePairs) {
        this.nameValuePairs = nameValuePairs;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public long getRecordNumber() {
        return this.recordNumber;
    }

    public void setRecordNumber(long recordNumber) {
        this.recordNumber = recordNumber;
    }

    public JSONObject toJSONObject() throws JSONException {
        return new JSONObject().put("recordNumber", this.recordNumber).put("loggedDateTimeInMS", this.loggedDateTime == null ? null : Long.valueOf(this.loggedDateTime.toInstant().toEpochMilli())).put("loggedLevel", (Object)this.loggedLevel).put("productName", (Object)this.productName).put("loggerName", (Object)this.loggerName).put("nameValuePairs", (Object)this.nameValuePairs).put("messageID", (Object)this.messageID).put("Message", (Object)this.message);
    }

    public void writeXml(XMLStreamWriter writer) throws XMLStreamException {
        boolean hasMessage;
        boolean bl = hasMessage = this.message != null && !this.message.isEmpty();
        if (hasMessage) {
            writer.writeStartElement("record");
        } else {
            writer.writeEmptyElement("record");
        }
        writer.writeAttribute("recordNumber", Long.toString(this.recordNumber));
        writer.writeAttribute("loggedDateTimeInMS", this.loggedDateTime == null ? "" : Long.toString(this.loggedDateTime.toInstant().toEpochMilli()));
        writer.writeAttribute("loggedLevel", this.loggedLevel);
        writer.writeAttribute("productName", this.productName);
        writer.writeAttribute("loggerName", this.loggerName);
        writer.writeAttribute("nameValuePairs", this.nameValuePairs);
        writer.writeAttribute("messageID", this.messageID);
        if (hasMessage) {
            writer.writeCharacters(this.message);
            writer.writeEndElement();
        }
    }

    public void writeCsv(StringBuilder sb) {
        sb.append(this.recordNumber).append(",");
        sb.append(this.loggedDateTime == null ? "" : Long.toString(this.loggedDateTime.toInstant().toEpochMilli())).append(",");
        sb.append(this.loggedLevel).append(",");
        sb.append(this.productName).append(",");
        sb.append(this.loggerName).append(",");
        sb.append(this.nameValuePairs).append(",");
        sb.append("\"").append(this.message.replace("\"", "\"\"")).append("\"");
    }
}

