/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.io.disk;

import com.sun.messaging.jmq.io.disk.VRFileWarning;
import com.sun.messaging.jmq.io.disk.VRecord;
import com.sun.messaging.jmq.resources.SharedResources;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.RandomAccessFile;
import java.io.StreamCorruptedException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public abstract class VRFile {
    private static boolean DEBUG = Boolean.getBoolean("vrfile.debug");
    public static final short FILE_VERSION_1 = 1;
    public static final int FILE_HEADER_SIZE_1 = 16;
    public static final short STATE_LAST_1 = 0;
    public static final short STATE_FREE_1 = 1;
    public static final short STATE_ALLOCATED_1 = 2;
    public static final short FILE_VERSION = 2;
    public static final int FILE_HEADER_SIZE = 24;
    public static final int FILE_MAGIC_NUMBER = 0x5555AAAA;
    public static final short RESERVED_SHORT = 0;
    public static final int RECORD_HEADER_SIZE = 12;
    public static final int RECORD_MAGIC_NUMBER = -1431677611;
    public static final int RECORD_CAPACITY_OFFSET = 4;
    public static final int RECORD_STATE_OFFSET = 8;
    public static final int RECORD_COOKIE_OFFSET = 10;
    public static final short STATE_CUTOFF = -1;
    public static final short STATE_BAD_MAGIC_NUMBER = -2;
    public static final short STATE_BAD_STATE = -3;
    public static final short STATE_BAD_CAPACITY_TOO_SMALL = -4;
    public static final short STATE_BAD_NEXT_MAGIC_NUMBER = -5;
    public static final short STATE_BAD_CAPACITY = -6;
    public static final short STATE_BAD_TRUNCATED_HEADER = -7;
    public static final short STATE_FREE = 1;
    public static final short STATE_ALLOCATED = 2;
    public static final short STATE_LAST = 3;
    public static final short STATE_PROPERTIES = 4;
    protected static final short _STATE_LAST = 1001;
    public static final int SHORT_LEN = 2;
    public static final int INT_LEN = 4;
    public static final int LONG_LEN = 8;
    public static final int DEFAULT_BLOCK_SIZE = 128;
    public static final long DEFAULT_INITIAL_FILE_SIZE = 0xA00000L;
    public static final long MINIMUM_INITIAL_FILE_SIZE = 36L;
    public static final float DEFAULT_GROWTH_FACTOR = 0.5f;
    public static final float DEFAULT_THRESHOLD_FACTOR = 0.0f;
    public static final long DEFAULT_THRESHOLD = 0L;
    protected long threshold = 0L;
    protected float thresholdFactor = 0.0f;
    protected int blockSize = 128;
    protected long initialFileSize = 0xA00000L;
    protected float growthFactor = 0.5f;
    protected boolean safe = false;
    protected short fileversion = (short)2;
    protected long fileSize = 0L;
    protected long filePointer = 0L;
    protected File backingFile = null;
    protected HashSet allocated = null;
    protected long bytesAllocated = 0L;
    protected TreeMap freeMap = null;
    protected int numFree = 0;
    protected long cookie = 0L;
    long fileCookie = 0L;
    protected byte[] lastRecordHeader = null;
    protected boolean opened = false;
    protected VRFileWarning warning = null;
    protected int hits = 0;
    protected int misses = 0;
    protected boolean isMinimumWrites = false;
    protected boolean interruptSafe = false;

    protected VRFile(File file, long size, boolean isMinimumWrites, boolean interruptSafe) {
        if (DEBUG) {
            System.out.println("backing file: " + String.valueOf(file));
        }
        this.isMinimumWrites = isMinimumWrites;
        this.interruptSafe = interruptSafe;
        this.backingFile = file;
        this.initialFileSize = size < 36L ? 36L : size;
        this.lastRecordHeader = new byte[12];
        ByteBuffer temp = ByteBuffer.wrap(this.lastRecordHeader);
        temp.putInt(-1431677611);
        temp.putInt(0);
        temp.putShort((short)3);
        temp.putShort((short)0);
        this.allocated = new HashSet(1000);
        this.freeMap = new TreeMap();
    }

    protected boolean isMinimumWrites() {
        return this.isMinimumWrites;
    }

    public File getFile() {
        return this.backingFile;
    }

    public short getFileVersion() {
        this.checkOpen();
        return this.fileversion;
    }

    public abstract void open() throws IOException, VRFileWarning;

    public abstract void close();

    protected void reset() {
        this.allocated.clear();
        this.freeMap.clear();
        this.opened = false;
        this.numFree = 0;
        this.bytesAllocated = 0L;
        this.hits = 0;
        this.misses = 0;
    }

    public void setSafe(boolean safe) {
        this.safe = safe;
    }

    public boolean getSafe() {
        return this.safe;
    }

    public void setBlockSize(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Block size must be postive. Illegal block size: " + n);
        }
        this.blockSize = n;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public void setGrowthFactor(float n) {
        if (n <= 0.0f) {
            throw new IllegalArgumentException("Growth factor must be postive. Illegal growth factor: " + n);
        }
        this.growthFactor = n;
    }

    public float getGrowthFactor() {
        return this.growthFactor;
    }

    public int getNRecords() {
        this.checkOpen();
        return this.allocated.size();
    }

    public int getNFreeRecords() {
        this.checkOpen();
        return this.numFree;
    }

    public long getBytesUsed() {
        this.checkOpen();
        return this.bytesAllocated;
    }

    public long getBytesFree() {
        this.checkOpen();
        int offset = this.fileversion == 2 ? 24 : 16;
        return this.filePointer - this.getBytesUsed() - (long)offset;
    }

    public int getHits() {
        return this.hits;
    }

    public int getMisses() {
        return this.misses;
    }

    public float getHitRatio() {
        if (this.hits + this.misses == 0) {
            return 0.0f;
        }
        return (float)((double)this.hits * 1.0) / (float)(this.hits + this.misses);
    }

    public float getFragmentationRatio() {
        throw new UnsupportedOperationException();
    }

    public float getUtilizationRatio() {
        int offset = this.fileversion == 2 ? 24 : 16;
        long total = this.filePointer - (long)offset;
        if (total == 0L) {
            return 1.0f;
        }
        float r = (float)((double)this.getBytesUsed() * 1.0) / (float)total;
        return r;
    }

    public abstract int[] getMap() throws IOException;

    public abstract VRecord allocate(int var1) throws IOException;

    protected VRecord findFreeRecord(int size) {
        Integer cap = size;
        LinkedList list = (LinkedList)this.freeMap.get(cap);
        if (list != null && !list.isEmpty()) {
            return (VRecord)list.removeLast();
        }
        SortedMap tail = this.freeMap.tailMap(cap);
        for (Map.Entry entry : tail.entrySet()) {
            list = (LinkedList)entry.getValue();
            if (list == null || list.isEmpty()) continue;
            return (VRecord)list.removeLast();
        }
        return null;
    }

    public synchronized void free(VRecord vr) throws IOException {
        boolean in;
        this.checkOpenAndWrite();
        if (DEBUG) {
            System.out.println("free record:" + String.valueOf(vr));
        }
        if (!(in = this.allocated.remove(vr))) {
            String msg = this.backingFile.toString() + ":" + String.valueOf(vr);
            throw new IllegalStateException(SharedResources.getResources().getString("S3016", msg));
        }
        this.bytesAllocated -= (long)vr.getCapacity();
        this.putFreeList(vr, false);
        try {
            vr.free();
            if (this.safe) {
                vr.force();
            }
        }
        catch (BufferOverflowException e) {
            String errmsg = "Failed to free vrecord:" + String.valueOf(this.backingFile) + ":" + String.valueOf(vr) + ":";
            throw new IOException(errmsg + String.valueOf(e));
        }
    }

    public synchronized Set getRecords() {
        this.checkOpen();
        return (Set)this.allocated.clone();
    }

    public synchronized void compact() throws IOException, VRFileWarning {
        File backupFile;
        if (this.opened) {
            throw new IllegalStateException(SharedResources.getResources().getString("S3009"));
        }
        if (this.fileversion < 2) {
            throw new IllegalStateException(String.valueOf(this.backingFile) + "Cannot compact a file of version " + this.fileversion);
        }
        if (!this.backingFile.exists() || this.backingFile.length() == 0L) {
            return;
        }
        RandomAccessFile from = new RandomAccessFile(this.backingFile, "r");
        byte[] barray = new byte[24];
        int num = from.read(barray);
        if (num != 24) {
            throw new IOException(SharedResources.getResources().getString("S3017", this.backingFile, num));
        }
        this.checkFileHeader(ByteBuffer.wrap(barray));
        File tempfile = new File(this.backingFile.getParentFile(), this.backingFile.getName() + ".temp");
        RandomAccessFile temp = new RandomAccessFile(tempfile, "rw");
        temp.write(barray);
        int numtransferred = 0;
        int numfreeskipped = 0;
        long filelength = from.length();
        long frompos = from.getFilePointer();
        boolean done = false;
        ByteBuffer recordheader = ByteBuffer.wrap(new byte[12]);
        while (!done) {
            int capacity = 0;
            short state = this.getRecordState(from, recordheader, frompos, filelength);
            switch (state) {
                case 2: 
                case 4: {
                    capacity = recordheader.getInt(4);
                    byte[] buf = new byte[capacity];
                    from.seek(frompos);
                    from.read(buf);
                    temp.write(buf);
                    ++numtransferred;
                    break;
                }
                case 1: {
                    capacity = recordheader.getInt(4);
                    ++numfreeskipped;
                    break;
                }
                case 1001: {
                    this.writeLastRecordHeader(temp);
                    done = true;
                    break;
                }
                case -7: 
                case -6: 
                case -5: 
                case -4: 
                case -3: 
                case -2: {
                    long nextstart = this.findGoodRecord(from, frompos, filelength);
                    if (nextstart == filelength) {
                        this.writeLastRecordHeader(temp);
                        done = true;
                    } else {
                        frompos = nextstart;
                    }
                    VRFile.addCompactWarning(this.getNewWarning(), state, frompos, recordheader, nextstart);
                }
            }
            from.seek(frompos += (long)capacity);
        }
        temp.close();
        from.close();
        if (DEBUG) {
            System.out.println("compact(): size of original file is " + this.backingFile.length());
            System.out.println("compact(): size of new file is " + tempfile.length());
        }
        if (!this.backingFile.renameTo(backupFile = new File(this.backingFile.getParentFile(), this.backingFile.getName() + ".bak"))) {
            throw new IOException(SharedResources.getResources().getString("S3011", this.backingFile, backupFile));
        }
        if (!tempfile.renameTo(this.backingFile)) {
            throw new IOException(SharedResources.getResources().getString("S3012", tempfile, this.backingFile));
        }
        if (!backupFile.delete()) {
            throw new IOException(SharedResources.getResources().getString("S3013", backupFile));
        }
        this.hits = 0;
        this.misses = 0;
        if (DEBUG) {
            System.out.println("compact(): number of records written is " + numtransferred);
            System.out.println("compact(): number of free records skipped is " + numfreeskipped);
        }
        if (this.warning != null) {
            throw this.warning;
        }
    }

    protected short adjustRecordState(short fversion, short s) {
        if (fversion == 1 ? s < 0 || s > 2 : s < 1 || s > 4) {
            return -3;
        }
        if (fversion == 1 && s == 0) {
            return 1001;
        }
        if (fversion == 2 && s == 3) {
            return 1001;
        }
        return s;
    }

    short getRecordState(RandomAccessFile file, ByteBuffer recordheader, long pos, long limit) throws IOException {
        int n = file.read(recordheader.array());
        if (n != 12) {
            return -7;
        }
        recordheader.rewind();
        int magic = recordheader.getInt();
        int capacity = recordheader.getInt();
        short state = this.adjustRecordState(this.fileversion, recordheader.getShort());
        if (magic != -1431677611) {
            if (DEBUG) {
                System.out.println("BAD RECORD(" + pos + "): BAD MAGIC NUMER:" + magic);
            }
            return -2;
        }
        if (state == -3) {
            return state;
        }
        if (state == 1001) {
            if (capacity != 0) {
                if (DEBUG) {
                    System.out.println("BAD RECORD(" + pos + "): LAST RECORD WOTH CAP=" + capacity);
                }
                return -6;
            }
            return state;
        }
        if (capacity <= 12) {
            if (DEBUG) {
                System.out.println("BAD RECORD(" + pos + "): CAP<RECORD_HEADER:" + capacity);
            }
            return -4;
        }
        if (pos + (long)capacity <= limit - 4L) {
            file.seek(pos + (long)capacity);
            magic = file.readInt();
            file.seek(pos);
            if (magic != -1431677611) {
                return -5;
            }
            return state;
        }
        return -6;
    }

    public abstract void force() throws IOException;

    public synchronized void setCookie(long n) throws IOException {
        this.cookie = n;
    }

    public synchronized long getCookie() {
        return this.cookie;
    }

    public abstract void clear(boolean var1) throws IOException;

    public VRFileWarning getWarning() {
        return this.warning;
    }

    protected void writeLastRecordHeader(RandomAccessFile file) throws IOException {
        if (file.length() < this.initialFileSize) {
            file.setLength(this.initialFileSize);
        }
        if (this.interruptSafe) {
            boolean interrupted = false;
            try {
                Thread.currentThread();
                interrupted = Thread.interrupted();
                file.write(this.lastRecordHeader);
            }
            catch (InterruptedIOException e) {
                interrupted = true;
                throw e;
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        } else {
            file.write(this.lastRecordHeader);
        }
    }

    protected void writeFileHeader(ByteBuffer buf) throws IOException {
        buf.putInt(0x5555AAAA);
        buf.putShort((short)2);
        buf.putShort((short)0);
        buf.putLong(this.cookie);
        buf.putLong(0L);
    }

    protected void writeFileHeader(DataOutput out) throws IOException {
        if (this.interruptSafe) {
            boolean interrupted = false;
            try {
                Thread.currentThread();
                interrupted = Thread.interrupted();
                out.writeInt(0x5555AAAA);
                out.writeShort(2);
                out.writeShort(0);
                out.writeLong(this.cookie);
                out.writeLong(0L);
            }
            catch (InterruptedIOException e) {
                interrupted = true;
                throw e;
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        } else {
            out.writeInt(0x5555AAAA);
            out.writeShort(2);
            out.writeShort(0);
            out.writeLong(this.cookie);
            out.writeLong(0L);
        }
    }

    protected short checkFileHeader(ByteBuffer buf) throws IOException {
        int magic = buf.getInt();
        if (magic != 0x5555AAAA) {
            Object[] args = new Object[]{this.backingFile, Integer.toString(magic), Integer.toString(0x5555AAAA)};
            throw new StreamCorruptedException(SharedResources.getResources().getString("S3014", args));
        }
        this.fileversion = buf.getShort();
        if (this.fileversion != 1 && this.fileversion != 2) {
            Object[] args = new Object[]{this.backingFile, Short.toString(this.fileversion), Short.toString((short)2)};
            throw new IOException(SharedResources.getResources().getString("S3015", args));
        }
        buf.getShort();
        this.fileCookie = buf.getLong();
        return this.fileversion;
    }

    protected void doForce() throws IOException {
        if (this.safe) {
            this.force();
        }
    }

    protected void putAllocatedList(VRecord vr) {
        this.allocated.add(vr);
        this.bytesAllocated += (long)vr.getCapacity();
    }

    protected void putFreeList(VRecord vr, boolean addToHead) {
        Integer cap = vr.getCapacity();
        LinkedList<VRecord> list = (LinkedList<VRecord>)this.freeMap.get(cap);
        if (list == null) {
            list = new LinkedList<VRecord>();
            this.freeMap.put(cap, list);
        }
        if (addToHead) {
            list.addFirst(vr);
        } else {
            list.add(vr);
        }
        ++this.numFree;
    }

    protected long findGoodRecord(RandomAccessFile file, long pos, long filelen) {
        while (pos < filelen) {
            try {
                file.seek(pos);
                int magic = file.readInt();
                if (magic == -1431677611) {
                    int capacity = file.readInt();
                    short state = this.adjustRecordState(this.fileversion, file.readShort());
                    long nextpos = pos + (long)capacity;
                    if (state != -3 && (state == 1001 || capacity > 12)) {
                        if (state == 1001) {
                            if (capacity == 0) {
                                return pos;
                            }
                        } else if (nextpos < filelen) {
                            file.seek(nextpos);
                            magic = file.readInt();
                            if (magic == -1431677611) {
                                return pos;
                            }
                        }
                    }
                }
                pos += 4L;
            }
            catch (IOException e) {
                pos = filelen;
            }
        }
        return pos;
    }

    protected void checkOpen() {
        if (!this.opened) {
            throw new IllegalStateException(SharedResources.getResources().getString("S3010") + "[" + String.valueOf(this.backingFile) + "]");
        }
    }

    protected void checkOpenAndWrite() {
        if (!this.opened) {
            throw new IllegalStateException(SharedResources.getResources().getString("S3010"));
        }
        if (this.fileversion < 2) {
            throw new IllegalStateException(String.valueOf(this.backingFile) + "Cannot write to a file of version " + this.fileversion);
        }
    }

    VRFileWarning getNewWarning() {
        if (this.warning == null) {
            this.warning = new VRFileWarning("Found bad record while loading " + String.valueOf(this.backingFile) + "(length=" + this.backingFile.length() + ")");
        }
        return this.warning;
    }

    static StringBuilder getWarningPrefix(short code, long from, ByteBuffer header) {
        StringBuilder wstr = new StringBuilder("\n    Bad record found:");
        wstr.append("\n    =================");
        wstr.append("\n      At file position: \n        " + from);
        if (code != -7) {
            header.rewind();
            wstr.append("\n      Record header loaded:");
            wstr.append("\n        magic number: " + header.getInt());
            wstr.append("\n        capacity: " + header.getInt());
            wstr.append("\n        state: " + header.getShort());
        }
        wstr.append("\n      Reason: " + VRFile.getReason(code));
        return wstr;
    }

    static VRFileWarning addCompactWarning(VRFileWarning w, short code, long from, ByteBuffer header, long to) {
        StringBuilder wstr = VRFile.getWarningPrefix(code, from, header);
        wstr.append("\n      Skipped to:" + to);
        w.addWarning(wstr.toString());
        return w;
    }

    static VRFileWarning addWarning(VRFileWarning w, short code, long from, ByteBuffer header, VRecord r) {
        StringBuilder wstr = VRFile.getWarningPrefix(code, from, header);
        if (r == null) {
            wstr.append("\n      Resolution:\n        Could not find any valid records beyond this file position.\n        Any data stored after this position is lost.");
        } else {
            long to = from + (long)r.getCapacity();
            wstr.append("\n      Resolution:\n        A valid record is found at file position " + to + ".\n        The block between " + from + " and " + to + "\n        will be returned to the free record pool.\n        Any data stored between them is lost.");
        }
        w.addWarning(wstr.toString());
        return w;
    }

    static String getReason(short code) {
        switch (code) {
            case -2: {
                return "\n        bad magic number, expected -1431677611";
            }
            case -5: {
                return "\n        bad magic number found at the next record, possibly due to\n        corrupted capacity or the next record was corrupted";
            }
            case -3: {
                return "\n        bad state";
            }
            case -6: {
                return "\n        bad capacity - either found non-zero capacity in the last record\n        header or the capacity makes the record span beyond the end of file";
            }
            case -4: {
                return "\n        bad capacity: it's less than the size of record header";
            }
            case -7: {
                return "\n        record header truncated; end of file reached";
            }
        }
        return "\n        unknown error code found: " + code;
    }

    public long getThreshold() {
        return this.threshold;
    }

    public void setThreshold(long threshold) {
        if (DEBUG) {
            System.out.println("VRFile.setThreshold: " + threshold);
        }
        if (threshold < 0L) {
            throw new IllegalArgumentException("Threshold must be postive. Illegal threshold: " + threshold);
        }
        this.threshold = threshold;
    }

    public float getThresholdFactor() {
        return this.thresholdFactor;
    }

    public void setThresholdFactor(float thresholdFactor) {
        if (DEBUG) {
            System.out.println("VRFile.setThresholdFactor: " + thresholdFactor);
        }
        if (thresholdFactor < 0.0f) {
            throw new IllegalArgumentException("Threshold factor must be postive. Illegal threshold factor: " + thresholdFactor);
        }
        this.thresholdFactor = thresholdFactor;
    }

    public boolean isThresholdReached() {
        if (this.threshold > 0L) {
            return this.threshold <= this.fileSize;
        }
        return false;
    }

    public void checkGrowthFactorSanity() {
        if (this.threshold <= 0L || !(this.thresholdFactor > 0.0f)) {
            this.threshold = 0L;
            this.thresholdFactor = 0.0f;
            String errorText = "Illegal values. Both threshold and threshold_factor must be greater than zero. Broker will continue using default values.";
            throw new IllegalStateException(errorText);
        }
    }

    public long getFileCookie() {
        return this.fileCookie;
    }
}

