/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.servlets;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.UnavailableException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.catalina.LogFacade;
import org.apache.catalina.core.ContextsAdapterUtility;
import org.apache.catalina.util.ServerInfo;
import org.apache.catalina.util.URLEncoder;
import org.apache.naming.resources.CacheEntry;
import org.apache.naming.resources.ProxyDirContext;
import org.apache.naming.resources.Resource;
import org.apache.naming.resources.ResourceAttributes;
import org.glassfish.grizzly.http.server.util.AlternateDocBase;
import org.glassfish.web.util.HtmlEntityEncoder;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;

public class DefaultServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    protected static final ResourceBundle rb = LogFacade.getLogger().getResourceBundle();
    private static final DocumentBuilderFactory factory;
    private static final SecureEntityResolver secureEntityResolver;
    protected int debug = 0;
    protected int input = 2048;
    protected volatile boolean listings = false;
    protected SortedBy sortedBy = SortedBy.NAME;
    protected boolean readOnly = true;
    protected int output = 2048;
    protected static final URLEncoder urlEncoder;
    protected String localXsltFile = null;
    protected String contextXsltFile = null;
    protected String globalXsltFile = null;
    protected String readmeFile = null;
    protected transient ProxyDirContext resources = null;
    protected transient ArrayList<AlternateDocBase> alternateDocBases = null;
    protected String fileEncoding = null;
    protected int sendfileSize = 49152;
    protected boolean useAcceptRanges = true;
    protected static final ArrayList<Range> FULL;
    protected int maxHeaderRangeItems = 10;
    protected static final String mimeSeparation = "CATALINA_MIME_BOUNDARY";
    protected static final String RESOURCES_JNDI_NAME = "java:comp/Resources";
    protected static final int BUFFER_SIZE = 4096;

    public void destroy() {
    }

    public void init() throws ServletException {
        ServletConfig sc = this.getServletConfig();
        if (sc.getInitParameter("debug") != null) {
            this.debug = Integer.parseInt(sc.getInitParameter("debug"));
        }
        if (sc.getInitParameter("input") != null) {
            this.input = Integer.parseInt(sc.getInitParameter("input"));
        }
        if (sc.getInitParameter("output") != null) {
            this.output = Integer.parseInt(sc.getInitParameter("output"));
        }
        this.listings = Boolean.parseBoolean(sc.getInitParameter("listings"));
        String sortedByInitParam = sc.getInitParameter("sortedBy");
        if (sortedByInitParam != null) {
            this.sortedBy = Enum.valueOf(SortedBy.class, sortedByInitParam);
        }
        if (sc.getInitParameter("readonly") != null) {
            this.readOnly = Boolean.parseBoolean(sc.getInitParameter("readonly"));
        }
        if (sc.getInitParameter("sendfileSize") != null) {
            this.sendfileSize = Integer.parseInt(sc.getInitParameter("sendfileSize")) * 1024;
        }
        if (sc.getInitParameter("maxHeaderRangeItems") != null) {
            this.maxHeaderRangeItems = Integer.parseInt(sc.getInitParameter("maxHeaderRangeItems"));
        }
        this.fileEncoding = sc.getInitParameter("fileEncoding");
        this.globalXsltFile = sc.getInitParameter("globalXsltFile");
        this.contextXsltFile = sc.getInitParameter("contextXsltFile");
        this.localXsltFile = sc.getInitParameter("localXsltFile");
        this.readmeFile = sc.getInitParameter("readmeFile");
        if (sc.getInitParameter("useAcceptRanges") != null) {
            this.useAcceptRanges = Boolean.parseBoolean(sc.getInitParameter("useAcceptRanges"));
        }
        if (this.input < 256) {
            this.input = 256;
        }
        if (this.output < 256) {
            this.output = 256;
        }
        if (this.debug > 0) {
            this.log("DefaultServlet.init:  input buffer size=" + this.input + ", output buffer size=" + this.output);
        }
        this.resources = (ProxyDirContext)this.getServletContext().getAttribute("org.apache.catalina.resources");
        if (this.resources == null) {
            try {
                this.resources = (ProxyDirContext)new InitialContext().lookup(RESOURCES_JNDI_NAME);
            }
            catch (NamingException e) {
                throw new ServletException("No resources", (Throwable)e);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (this.resources == null) {
            throw new UnavailableException("No resources");
        }
        try {
            this.alternateDocBases = this.getAlternateDocBases();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    private ArrayList<AlternateDocBase> getAlternateDocBases() {
        return (ArrayList)this.getServletContext().getAttribute("org.apache.catalina.alternateResources");
    }

    public boolean isListings() {
        return this.listings;
    }

    public void setListings(boolean listings) {
        this.listings = listings;
    }

    protected String getRelativePath(HttpServletRequest request) {
        if (request.getAttribute("jakarta.servlet.include.request_uri") != null) {
            String result = (String)request.getAttribute("jakarta.servlet.include.path_info");
            if (result == null) {
                result = (String)request.getAttribute("jakarta.servlet.include.servlet_path");
            }
            if (result == null || result.equals("")) {
                result = "/";
            }
            return result;
        }
        Object result = request.getPathInfo();
        result = result == null ? request.getServletPath() : request.getServletPath() + (String)result;
        if (result == null || ((String)result).equals("")) {
            result = "/";
        }
        return result;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.serveResource(request, response, true);
    }

    protected void doHead(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.serveResource(request, response, false);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doGet(request, response);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.readOnly) {
            resp.sendError(403);
            return;
        }
        String path = this.getRelativePath(req);
        boolean exists = true;
        try {
            this.resources.lookup(path);
        }
        catch (NamingException e) {
            exists = false;
        }
        boolean result = true;
        File contentFile = null;
        Range range = this.parseContentRange(req, resp);
        Object resourceInputStream = null;
        if (range != null) {
            contentFile = this.executePartialPut(req, range, path);
            resourceInputStream = new FileInputStream(contentFile);
        } else {
            resourceInputStream = req.getInputStream();
        }
        try {
            Resource newResource = new Resource((InputStream)resourceInputStream);
            if (exists) {
                this.resources.rebind(path, (Object)newResource);
            } else {
                this.resources.bind(path, (Object)newResource);
            }
        }
        catch (NamingException e) {
            result = false;
        }
        if (result) {
            if (exists) {
                resp.setStatus(204);
            } else {
                resp.setStatus(201);
            }
        } else {
            resp.sendError(409);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File executePartialPut(HttpServletRequest req, Range range, String path) throws IOException {
        String convertedResourcePath;
        File tempDir = (File)this.getServletContext().getAttribute("jakarta.servlet.context.tempdir");
        File contentFile = new File(tempDir, convertedResourcePath = path.replace('/', '.'));
        if (contentFile.createNewFile()) {
            contentFile.deleteOnExit();
        }
        Resource oldResource = null;
        try {
            Object obj = this.resources.lookup(path);
            if (obj instanceof Resource) {
                oldResource = (Resource)obj;
            }
        }
        catch (NamingException obj) {
            // empty catch block
        }
        try (RandomAccessFile randAccessContentFile = new RandomAccessFile(contentFile, "rw");){
            if (oldResource != null) {
                try (BufferedInputStream bufOldRevStream = null;){
                    int numBytesRead;
                    bufOldRevStream = new BufferedInputStream(oldResource.streamContent(), 4096);
                    byte[] copyBuffer = new byte[4096];
                    while ((numBytesRead = bufOldRevStream.read(copyBuffer)) != -1) {
                        randAccessContentFile.write(copyBuffer, 0, numBytesRead);
                    }
                }
            }
            randAccessContentFile.setLength(range.length);
            randAccessContentFile.seek(range.start);
            byte[] transferBuffer = new byte[4096];
            try (BufferedInputStream requestBufInStream = null;){
                int numBytesRead;
                requestBufInStream = new BufferedInputStream((InputStream)req.getInputStream(), 4096);
                while ((numBytesRead = requestBufInStream.read(transferBuffer)) != -1) {
                    randAccessContentFile.write(transferBuffer, 0, numBytesRead);
                }
            }
        }
        return contentFile;
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.readOnly) {
            resp.sendError(403);
            return;
        }
        String path = this.getRelativePath(req);
        boolean exists = true;
        try {
            this.resources.lookup(path);
        }
        catch (NamingException e) {
            exists = false;
        }
        if (exists) {
            boolean result = true;
            try {
                this.resources.unbind(path);
            }
            catch (NamingException e) {
                result = false;
            }
            if (result) {
                resp.setStatus(204);
            } else {
                resp.sendError(405);
            }
        } else {
            resp.sendError(404);
        }
    }

    protected boolean checkIfHeaders(HttpServletRequest request, HttpServletResponse response, ResourceAttributes resourceAttributes) throws IOException {
        return this.checkIfMatch(request, response, resourceAttributes) && this.checkIfModifiedSince(request, response, resourceAttributes) && this.checkIfNoneMatch(request, response, resourceAttributes) && this.checkIfUnmodifiedSince(request, response, resourceAttributes);
    }

    protected String rewriteUrl(String path) {
        return urlEncoder.encode(path);
    }

    protected void displaySize(StringBuilder buf, int filesize) {
        int leftside = filesize / 1024;
        int rightside = filesize % 1024 / 103;
        if (leftside == 0 && rightside == 0 && filesize != 0) {
            rightside = 1;
        }
        buf.append(leftside).append(".").append(rightside);
        buf.append(" KB");
    }

    protected void serveResource(HttpServletRequest request, HttpServletResponse response, boolean content) throws IOException, ServletException {
        String contentType;
        AlternateDocBase match;
        String path = this.getRelativePath(request);
        if (this.debug > 0) {
            if (content) {
                this.log("DefaultServlet.serveResource:  Serving resource '" + path + "' headers and data");
            } else {
                this.log("DefaultServlet.serveResource:  Serving resource '" + path + "' headers only");
            }
        }
        CacheEntry cacheEntry = null;
        ProxyDirContext proxyDirContext = this.resources;
        cacheEntry = this.alternateDocBases == null || this.alternateDocBases.size() == 0 ? proxyDirContext.lookupCache(path) : ((match = AlternateDocBase.findMatch((String)path, this.alternateDocBases)) != null ? ((ProxyDirContext)ContextsAdapterUtility.unwrap(match.getResources())).lookupCache(path) : proxyDirContext.lookupCache(path));
        if (!cacheEntry.exists) {
            String requestUri = (String)request.getAttribute("jakarta.servlet.include.request_uri");
            if (requestUri != null) {
                throw new FileNotFoundException(requestUri);
            }
            response.sendError(404);
            return;
        }
        if (cacheEntry.context == null && (path.endsWith("/") || path.endsWith("\\"))) {
            response.sendError(404);
            return;
        }
        if (cacheEntry.context == null) {
            boolean included;
            boolean bl = included = request.getAttribute("jakarta.servlet.include.context_path") != null;
            if (!included && !this.checkIfHeaders(request, response, cacheEntry.attributes)) {
                return;
            }
        }
        if ((contentType = cacheEntry.attributes.getMimeType()) == null && !cacheEntry.attributes.isMimeTypeInitialized()) {
            contentType = this.getServletContext().getMimeType(cacheEntry.name);
            cacheEntry.attributes.setMimeType(contentType);
        }
        ArrayList<Range> ranges = null;
        long contentLength = -1L;
        if (cacheEntry.context != null) {
            if (!this.listings) {
                response.sendError(404);
                return;
            }
            contentType = "text/html;charset=UTF-8";
        } else {
            if (this.useAcceptRanges) {
                response.setHeader("Accept-Ranges", "bytes");
            }
            ranges = this.parseRange(request, response, cacheEntry.attributes);
            response.setHeader("ETag", cacheEntry.attributes.getETag());
            response.setHeader("Last-Modified", cacheEntry.attributes.getLastModifiedHttp());
            contentLength = cacheEntry.attributes.getContentLength();
            if (contentLength == 0L) {
                content = false;
            }
        }
        ServletOutputStream ostream = null;
        PrintWriter writer = null;
        if (content) {
            try {
                ostream = response.getOutputStream();
            }
            catch (IllegalStateException e) {
                if (contentType == null || contentType.startsWith("text") || contentType.startsWith("xml")) {
                    writer = response.getWriter();
                }
                throw e;
            }
        }
        if (cacheEntry.context != null || (ranges == null || ranges.isEmpty()) && request.getHeader("Range") == null || ranges == FULL) {
            if (contentType != null) {
                if (this.debug > 0) {
                    this.log("DefaultServlet.serveFile:  contentType='" + contentType + "'");
                }
                response.setContentType(contentType);
            }
            if (cacheEntry.resource != null && contentLength >= 0L) {
                if (this.debug > 0) {
                    this.log("DefaultServlet.serveFile:  contentLength=" + contentLength);
                }
                if (contentLength < Integer.MAX_VALUE) {
                    response.setContentLength((int)contentLength);
                } else {
                    response.setHeader("content-length", "" + contentLength);
                }
            }
            InputStream renderResult = null;
            if (cacheEntry.context != null && content) {
                renderResult = this.render(request.getContextPath(), cacheEntry, proxyDirContext);
            }
            if (content) {
                try {
                    response.setBufferSize(this.output);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                if (ostream != null) {
                    if (!this.checkSendfile(request, response, cacheEntry, contentLength, null)) {
                        this.copy(cacheEntry, renderResult, ostream);
                    }
                } else {
                    this.copy(cacheEntry, renderResult, writer);
                }
            }
        } else {
            if (ranges == null || ranges.isEmpty()) {
                return;
            }
            if (this.maxHeaderRangeItems >= 0 && ranges.size() > this.maxHeaderRangeItems) {
                response.sendError(403);
                return;
            }
            response.setStatus(206);
            if (ranges.size() == 1) {
                Range range = ranges.get(0);
                response.addHeader("Content-Range", "bytes " + range.start + "-" + range.end + "/" + range.length);
                long length = range.end - range.start + 1L;
                if (length < Integer.MAX_VALUE) {
                    response.setContentLength((int)length);
                } else {
                    response.setHeader("content-length", "" + length);
                }
                if (contentType != null) {
                    if (this.debug > 0) {
                        this.log("DefaultServlet.serveFile:  contentType='" + contentType + "'");
                    }
                    response.setContentType(contentType);
                }
                if (content) {
                    try {
                        response.setBufferSize(this.output);
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                    if (ostream != null) {
                        if (!this.checkSendfile(request, response, cacheEntry, range.end - range.start + 1L, range)) {
                            this.copy(cacheEntry, ostream, range);
                        }
                    } else {
                        this.copy(cacheEntry, writer, range);
                    }
                }
            } else {
                response.setContentType("multipart/byteranges; boundary=CATALINA_MIME_BOUNDARY");
                if (content) {
                    try {
                        response.setBufferSize(this.output);
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                    if (ostream != null) {
                        this.copy(cacheEntry, ostream, ranges.iterator(), contentType);
                    } else {
                        this.copy(cacheEntry, writer, ranges.iterator(), contentType);
                    }
                }
            }
        }
    }

    protected Range parseContentRange(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String rangeHeader = request.getHeader("Content-Range");
        if (rangeHeader == null) {
            return null;
        }
        if (!rangeHeader.startsWith("bytes")) {
            response.sendError(400);
            return null;
        }
        rangeHeader = rangeHeader.substring(6).trim();
        int dashPos = rangeHeader.indexOf(45);
        int slashPos = rangeHeader.indexOf(47);
        if (dashPos == -1) {
            response.sendError(400);
            return null;
        }
        if (slashPos == -1) {
            response.sendError(400);
            return null;
        }
        Range range = new Range();
        try {
            range.start = Long.parseLong(rangeHeader.substring(0, dashPos));
            range.end = Long.parseLong(rangeHeader.substring(dashPos + 1, slashPos));
            range.length = Long.parseLong(rangeHeader.substring(slashPos + 1, rangeHeader.length()));
        }
        catch (NumberFormatException e) {
            response.sendError(400);
            return null;
        }
        if (!range.validate()) {
            response.sendError(400);
            return null;
        }
        return range;
    }

    protected ArrayList<Range> parseRange(HttpServletRequest request, HttpServletResponse response, ResourceAttributes resourceAttributes) throws IOException {
        long fileLength;
        String headerValue = request.getHeader("If-Range");
        if (headerValue != null) {
            long headerValueTime = -1L;
            try {
                headerValueTime = request.getDateHeader("If-Range");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            String eTag = resourceAttributes.getETag();
            long lastModified = resourceAttributes.getLastModified();
            if (headerValueTime == -1L ? !eTag.equals(headerValue.trim()) : lastModified > headerValueTime + 1000L) {
                return FULL;
            }
        }
        if ((fileLength = resourceAttributes.getContentLength()) == 0L) {
            return null;
        }
        String rangeHeader = request.getHeader("Range");
        if (rangeHeader == null) {
            return null;
        }
        if (!rangeHeader.startsWith("bytes")) {
            response.addHeader("Content-Range", "bytes */" + fileLength);
            response.sendError(416);
            return null;
        }
        rangeHeader = rangeHeader.substring(6);
        ArrayList<Range> result = new ArrayList<Range>();
        StringTokenizer commaTokenizer = new StringTokenizer(rangeHeader, ",");
        while (commaTokenizer.hasMoreTokens()) {
            String rangeDefinition = commaTokenizer.nextToken().trim();
            Range currentRange = new Range();
            currentRange.length = fileLength;
            int dashPos = rangeDefinition.indexOf(45);
            if (dashPos == -1) {
                response.addHeader("Content-Range", "bytes */" + fileLength);
                response.sendError(416);
                return null;
            }
            if (dashPos == 0) {
                try {
                    long offset = Long.parseLong(rangeDefinition);
                    currentRange.start = fileLength + offset;
                    currentRange.end = fileLength - 1L;
                }
                catch (NumberFormatException e) {
                    response.addHeader("Content-Range", "bytes */" + fileLength);
                    response.sendError(416);
                    return null;
                }
            }
            try {
                currentRange.start = Long.parseLong(rangeDefinition.substring(0, dashPos));
                currentRange.end = dashPos < rangeDefinition.length() - 1 ? Long.parseLong(rangeDefinition.substring(dashPos + 1, rangeDefinition.length())) : fileLength - 1L;
            }
            catch (NumberFormatException e) {
                response.addHeader("Content-Range", "bytes */" + fileLength);
                response.sendError(416);
                return null;
            }
            if (!currentRange.validate()) {
                response.addHeader("Content-Range", "bytes */" + fileLength);
                response.sendError(416);
                return null;
            }
            result.add(currentRange);
        }
        return result;
    }

    protected InputStream render(String contextPath, CacheEntry cacheEntry) throws IOException, ServletException {
        return this.render(contextPath, cacheEntry, this.resources);
    }

    private InputStream render(String contextPath, CacheEntry cacheEntry, ProxyDirContext proxyDirContext) throws IOException, ServletException {
        Source xsltSource = this.findXsltInputStream(cacheEntry.context);
        if (xsltSource == null) {
            return this.renderHtml(contextPath, cacheEntry, proxyDirContext);
        }
        return this.renderXml(contextPath, cacheEntry, xsltSource, proxyDirContext);
    }

    protected InputStream renderXml(String contextPath, CacheEntry cacheEntry, Source xsltSource) throws IOException, ServletException {
        return this.renderXml(contextPath, cacheEntry, xsltSource, this.resources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream renderXml(String contextPath, CacheEntry cacheEntry, Source xsltSource, ProxyDirContext proxyDirContext) throws IOException, ServletException {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\"?>");
        sb.append("<listing ");
        sb.append(" contextPath='");
        sb.append(contextPath);
        sb.append("'");
        sb.append(" directory='");
        sb.append(cacheEntry.name);
        sb.append("' ");
        sb.append(" hasParent='").append(!cacheEntry.name.equals("/"));
        sb.append("'>");
        sb.append("<entries>");
        try {
            Enumeration enumeration = proxyDirContext.list(cacheEntry.name);
            if (this.sortedBy.equals((Object)SortedBy.LAST_MODIFIED)) {
                list = Collections.list(enumeration);
                c = new LastModifiedComparator(proxyDirContext, cacheEntry.name);
                Collections.sort(list, c);
                enumeration = Collections.enumeration(list);
            } else if (this.sortedBy.equals((Object)SortedBy.SIZE)) {
                list = Collections.list(enumeration);
                c = new SizeComparator(proxyDirContext, cacheEntry.name);
                Collections.sort(list, c);
                enumeration = Collections.enumeration(list);
            }
            String rewrittenContextPath = this.rewriteUrl(contextPath);
            while (enumeration.hasMoreElements()) {
                NameClassPair ncPair = (NameClassPair)enumeration.nextElement();
                String resourceName = ncPair.getName();
                String trimmed = resourceName;
                if (trimmed.equalsIgnoreCase("WEB-INF") || trimmed.equalsIgnoreCase("META-INF") || trimmed.equalsIgnoreCase(this.localXsltFile) || (cacheEntry.name + trimmed).equals(this.contextXsltFile)) continue;
                CacheEntry childCacheEntry = proxyDirContext.lookupCache(cacheEntry.name + resourceName);
                if (!childCacheEntry.exists) continue;
                sb.append("<entry");
                sb.append(" type='").append(childCacheEntry.context != null ? "dir" : "file").append("'");
                sb.append(" urlPath='").append(rewrittenContextPath).append(this.rewriteUrl(cacheEntry.name + resourceName)).append(childCacheEntry.context != null ? "/" : "").append("'");
                if (childCacheEntry.resource != null) {
                    sb.append(" size='").append(this.renderSize(childCacheEntry.attributes.getContentLength())).append("'");
                }
                sb.append(" date='").append(childCacheEntry.attributes.getLastModifiedHttp()).append("'");
                sb.append(">");
                sb.append(HtmlEntityEncoder.encodeXSS((String)trimmed));
                if (childCacheEntry.context != null) {
                    sb.append("/");
                }
                sb.append("</entry>");
            }
        }
        catch (NamingException e) {
            throw new ServletException("Error accessing resource", (Throwable)e);
        }
        sb.append("</entries>");
        String readme = this.getReadme(cacheEntry.context);
        if (readme != null) {
            sb.append("<readme><![CDATA[");
            sb.append(readme);
            sb.append("]]></readme>");
        }
        sb.append("</listing>");
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(DefaultServlet.class.getClassLoader());
            TransformerFactory tFactory = TransformerFactory.newInstance();
            StreamSource xmlSource = new StreamSource(new StringReader(sb.toString()));
            Transformer transformer = tFactory.newTransformer(xsltSource);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            OutputStreamWriter osWriter = new OutputStreamWriter((OutputStream)stream, "UTF8");
            StreamResult out = new StreamResult(osWriter);
            transformer.transform(xmlSource, out);
            osWriter.flush();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(stream.toByteArray());
            return byteArrayInputStream;
        }
        catch (Exception e) {
            this.log("directory transform failure: " + e.getMessage());
            InputStream inputStream = this.renderHtml(contextPath, cacheEntry);
            return inputStream;
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    protected InputStream renderHtml(String contextPath, CacheEntry cacheEntry) throws IOException, ServletException {
        return this.renderHtml(contextPath, cacheEntry, this.resources);
    }

    private InputStream renderHtml(String contextPath, CacheEntry cacheEntry, ProxyDirContext proxyDirContext) throws IOException, ServletException {
        String serverInfo;
        int slash;
        String name = cacheEntry.name;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        OutputStreamWriter osWriter = null;
        try {
            osWriter = new OutputStreamWriter((OutputStream)stream, "UTF8");
        }
        catch (Exception e) {
            osWriter = new OutputStreamWriter(stream);
        }
        PrintWriter writer = new PrintWriter(osWriter);
        StringBuilder sb = new StringBuilder();
        String rewrittenContextPath = this.rewriteUrl(contextPath);
        String dirTitle = MessageFormat.format(rb.getString("AS-WEB-CORE-00324"), name);
        sb.append("<html>\r\n");
        sb.append("<head>\r\n");
        sb.append("<title>");
        sb.append(dirTitle);
        sb.append("</title>\r\n");
        sb.append("<STYLE><!--");
        sb.append("H1 {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:22px;} H2 {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:16px;} H3 {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:14px;} BODY {font-family:Tahoma,Arial,sans-serif;color:black;background-color:white;} B {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;} P {font-family:Tahoma,Arial,sans-serif;background:white;color:black;font-size:12px;}A {color : black;}HR {color : #525D76;}");
        sb.append("--></STYLE> ");
        sb.append("</head>\r\n");
        sb.append("<body>");
        sb.append("<h1>");
        sb.append(dirTitle);
        String parentDirectory = name;
        if (parentDirectory.endsWith("/")) {
            parentDirectory = parentDirectory.substring(0, parentDirectory.length() - 1);
        }
        if ((slash = parentDirectory.lastIndexOf(47)) >= 0) {
            String parent = name.substring(0, slash);
            String dirParent = MessageFormat.format(rb.getString("AS-WEB-CORE-00325"), parent);
            sb.append(" - <a href=\"");
            sb.append(rewrittenContextPath);
            if (parent.equals("")) {
                parent = "/";
            }
            sb.append(this.rewriteUrl(parent));
            if (!parent.endsWith("/")) {
                sb.append("/");
            }
            sb.append("\">");
            sb.append("<b>");
            sb.append(dirParent);
            sb.append("</b>");
            sb.append("</a>");
        }
        sb.append("</h1>");
        sb.append("<HR size=\"1\" noshade=\"noshade\">");
        sb.append("<table width=\"100%\" cellspacing=\"0\" cellpadding=\"5\" align=\"center\">\r\n");
        sb.append("<tr>\r\n");
        sb.append("<td align=\"left\"><font size=\"+1\"><strong>");
        sb.append(rb.getString("AS-WEB-CORE-00326"));
        sb.append("</strong></font></td>\r\n");
        sb.append("<td align=\"center\"><font size=\"+1\"><strong>");
        sb.append(rb.getString("AS-WEB-CORE-00327"));
        sb.append("</strong></font></td>\r\n");
        sb.append("<td align=\"right\"><font size=\"+1\"><strong>");
        sb.append(rb.getString("AS-WEB-CORE-00328"));
        sb.append("</strong></font></td>\r\n");
        sb.append("</tr>");
        try {
            Enumeration enumeration = proxyDirContext.list(cacheEntry.name);
            if (this.sortedBy.equals((Object)SortedBy.LAST_MODIFIED)) {
                list = Collections.list(enumeration);
                c = new LastModifiedComparator(proxyDirContext, cacheEntry.name);
                Collections.sort(list, c);
                enumeration = Collections.enumeration(list);
            } else if (this.sortedBy.equals((Object)SortedBy.SIZE)) {
                list = Collections.list(enumeration);
                c = new SizeComparator(proxyDirContext, cacheEntry.name);
                Collections.sort(list, c);
                enumeration = Collections.enumeration(list);
            }
            boolean shade = false;
            while (enumeration.hasMoreElements()) {
                NameClassPair ncPair = (NameClassPair)enumeration.nextElement();
                String resourceName = ncPair.getName();
                String trimmed = resourceName;
                if (trimmed.equalsIgnoreCase("WEB-INF") || trimmed.equalsIgnoreCase("META-INF")) continue;
                CacheEntry childCacheEntry = proxyDirContext.lookupCache(cacheEntry.name + resourceName);
                if (!childCacheEntry.exists) continue;
                sb.append("<tr");
                if (shade) {
                    sb.append(" bgcolor=\"#eeeeee\"");
                }
                sb.append(">\r\n");
                shade = !shade;
                sb.append("<td align=\"left\">&nbsp;&nbsp;\r\n");
                sb.append("<a href=\"");
                sb.append(rewrittenContextPath);
                resourceName = this.rewriteUrl(name + resourceName);
                sb.append(resourceName);
                if (childCacheEntry.context != null) {
                    sb.append("/");
                }
                sb.append("\"><tt>");
                sb.append(HtmlEntityEncoder.encodeXSS((String)trimmed));
                if (childCacheEntry.context != null) {
                    sb.append("/");
                }
                sb.append("</tt></a></td>\r\n");
                sb.append("<td align=\"right\"><tt>");
                if (childCacheEntry.context != null) {
                    sb.append("&nbsp;");
                } else {
                    sb.append(this.renderSize(childCacheEntry.attributes.getContentLength()));
                }
                sb.append("</tt></td>\r\n");
                sb.append("<td align=\"right\"><tt>");
                sb.append(childCacheEntry.attributes.getLastModifiedHttp());
                sb.append("</tt></td>\r\n");
                sb.append("</tr>\r\n");
            }
        }
        catch (NamingException e) {
            throw new ServletException("Error accessing resource", (Throwable)e);
        }
        sb.append("</table>\r\n");
        sb.append("<HR size=\"1\" noshade=\"noshade\">");
        String readme = this.getReadme(cacheEntry.context);
        if (readme != null) {
            sb.append(readme);
            sb.append("<HR size=\"1\" noshade=\"noshade\">");
        }
        if ((serverInfo = ServerInfo.getPublicServerInfo()) != null && !serverInfo.isEmpty()) {
            sb.append("<h3>").append(serverInfo).append("</h3>");
        }
        sb.append("</body>\r\n");
        sb.append("</html>\r\n");
        writer.write(sb.toString());
        writer.flush();
        return new ByteArrayInputStream(stream.toByteArray());
    }

    protected String renderSize(long size) {
        long leftSide = size / 1024L;
        long rightSide = size % 1024L / 103L;
        if (leftSide == 0L && rightSide == 0L && size > 0L) {
            rightSide = 1L;
        }
        return leftSide + "." + rightSide + " kb";
    }

    protected String getReadme(DirContext directory) throws IOException, ServletException {
        block4: {
            if (this.readmeFile != null) {
                try {
                    Object obj = directory.lookup(this.readmeFile);
                    if (obj != null && obj instanceof Resource) {
                        StringWriter buffer = new StringWriter();
                        InputStream is = ((Resource)obj).streamContent();
                        this.copyRange(new InputStreamReader(is), new PrintWriter(buffer));
                        return buffer.toString();
                    }
                }
                catch (Throwable e) {
                    if (this.debug <= 10) break block4;
                    this.log("readme '" + this.readmeFile + "' not found", e);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Source findXsltInputStream(DirContext directory) throws IOException, ServletException {
        File f;
        if (this.localXsltFile != null) {
            try {
                InputStream is;
                Object obj = directory.lookup(this.localXsltFile);
                if (obj != null && obj instanceof Resource && (is = ((Resource)obj).streamContent()) != null) {
                    return new StreamSource(is);
                }
            }
            catch (Throwable e) {
                if (this.debug > 10) {
                    this.log("localXsltFile '" + this.localXsltFile + "' not found", e);
                }
                return null;
            }
        }
        if (this.contextXsltFile != null) {
            InputStream is = this.getServletContext().getResourceAsStream(this.contextXsltFile);
            if (is != null) {
                return new StreamSource(is);
            }
            if (this.debug > 10) {
                this.log("contextXsltFile '" + this.contextXsltFile + "' not found");
            }
        }
        if (this.globalXsltFile != null && (f = this.validateGlobalXsltFile()) != null) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(f);
                long len = f.length();
                byte[] b = new byte[(int)len];
                if (len != (long)fis.read(b)) {
                    throw new IOException(MessageFormat.format(rb.getString("AS-WEB-CORE-00543"), f.getAbsolutePath()));
                }
                StreamSource streamSource = new StreamSource(new ByteArrayInputStream(b));
                return streamSource;
            }
            finally {
                block18: {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException ioe) {
                            if (this.debug <= 10) break block18;
                            this.log(ioe.getMessage(), ioe);
                        }
                    }
                }
            }
        }
        return null;
    }

    private File validateGlobalXsltFile() {
        String home;
        File result = null;
        String base = System.getProperty("catalina.base");
        if (base != null) {
            File baseConf = new File(base, "conf");
            result = this.validateGlobalXsltFile(baseConf);
        }
        if (result == null && (home = System.getProperty("catalina.home")) != null && !home.equals(base)) {
            File homeConf = new File(home, "conf");
            result = this.validateGlobalXsltFile(homeConf);
        }
        return result;
    }

    private File validateGlobalXsltFile(File base) {
        File candidate = new File(this.globalXsltFile);
        if (!candidate.isAbsolute()) {
            candidate = new File(base, this.globalXsltFile);
        }
        if (!candidate.isFile()) {
            return null;
        }
        try {
            if (!candidate.getCanonicalPath().startsWith(base.getCanonicalPath())) {
                return null;
            }
        }
        catch (IOException ioe) {
            return null;
        }
        String nameLower = candidate.getName().toLowerCase(Locale.ENGLISH);
        if (!nameLower.endsWith(".xslt") && !nameLower.endsWith(".xsl")) {
            return null;
        }
        return candidate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Source secureXslt(InputStream is) {
        DOMSource result = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(secureEntityResolver);
            Document document = builder.parse(is);
            result = new DOMSource(document);
        }
        catch (ParserConfigurationException e) {
            if (this.debug > 0) {
                this.log(e.getMessage(), e);
            }
        }
        catch (SAXException e) {
            if (this.debug > 0) {
                this.log(e.getMessage(), e);
            }
        }
        catch (IOException e) {
            if (this.debug > 0) {
                this.log(e.getMessage(), e);
            }
        }
        finally {
            block24: {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        if (this.debug <= 10) break block24;
                        this.log(e.getMessage(), e);
                    }
                }
            }
        }
        return result;
    }

    protected boolean checkSendfile(HttpServletRequest request, HttpServletResponse response, CacheEntry entry, long length, Range range) {
        if (this.sendfileSize > 0 && entry.resource != null && (length > (long)this.sendfileSize || entry.resource.getContent() == null) && entry.attributes.getCanonicalPath() != null && Boolean.TRUE.equals(request.getAttribute("org.apache.tomcat.sendfile.support")) && request.getClass().getName().equals("org.apache.catalina.connector.RequestFacade") && response.getClass().getName().equals("org.apache.catalina.connector.ResponseFacade")) {
            request.setAttribute("org.apache.tomcat.sendfile.filename", (Object)entry.attributes.getCanonicalPath());
            if (range == null) {
                request.setAttribute("org.apache.tomcat.sendfile.start", (Object)0L);
                request.setAttribute("org.apache.tomcat.sendfile.end", (Object)length);
            } else {
                request.setAttribute("org.apache.tomcat.sendfile.start", (Object)range.start);
                request.setAttribute("org.apache.tomcat.sendfile.end", (Object)(range.end + 1L));
            }
            request.setAttribute("org.apache.tomcat.sendfile.token", (Object)this);
            return true;
        }
        return false;
    }

    protected boolean checkIfMatch(HttpServletRequest request, HttpServletResponse response, ResourceAttributes resourceAttributes) throws IOException {
        String eTag = resourceAttributes.getETag();
        String headerValue = request.getHeader("If-Match");
        if (headerValue != null && headerValue.indexOf(42) == -1) {
            StringTokenizer commaTokenizer = new StringTokenizer(headerValue, ",");
            boolean conditionSatisfied = false;
            while (!conditionSatisfied && commaTokenizer.hasMoreTokens()) {
                String currentToken = commaTokenizer.nextToken();
                if (!currentToken.trim().equals(eTag)) continue;
                conditionSatisfied = true;
            }
            if (!conditionSatisfied) {
                response.sendError(412);
                return false;
            }
        }
        return true;
    }

    protected boolean checkIfModifiedSince(HttpServletRequest request, HttpServletResponse response, ResourceAttributes resourceAttributes) throws IOException {
        try {
            long headerValue = request.getDateHeader("If-Modified-Since");
            long lastModified = resourceAttributes.getLastModified();
            if (headerValue != -1L && request.getHeader("If-None-Match") == null && lastModified < headerValue + 1000L) {
                response.setStatus(304);
                response.setHeader("ETag", resourceAttributes.getETag());
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgument) {
            return true;
        }
        return true;
    }

    protected boolean checkIfNoneMatch(HttpServletRequest request, HttpServletResponse response, ResourceAttributes resourceAttributes) throws IOException {
        String eTag = resourceAttributes.getETag();
        String headerValue = request.getHeader("If-None-Match");
        if (headerValue != null) {
            boolean conditionSatisfied = false;
            if (!headerValue.equals("*")) {
                StringTokenizer commaTokenizer = new StringTokenizer(headerValue, ",");
                while (!conditionSatisfied && commaTokenizer.hasMoreTokens()) {
                    String currentToken = commaTokenizer.nextToken();
                    if (!currentToken.trim().equals(eTag)) continue;
                    conditionSatisfied = true;
                }
            } else {
                conditionSatisfied = true;
            }
            if (conditionSatisfied) {
                if ("GET".equals(request.getMethod()) || "HEAD".equals(request.getMethod())) {
                    response.setStatus(304);
                    response.setHeader("ETag", eTag);
                    return false;
                }
                response.sendError(412);
                return false;
            }
        }
        return true;
    }

    protected boolean checkIfUnmodifiedSince(HttpServletRequest request, HttpServletResponse response, ResourceAttributes resourceAttributes) throws IOException {
        try {
            long lastModified = resourceAttributes.getLastModified();
            long headerValue = request.getDateHeader("If-Unmodified-Since");
            if (headerValue != -1L && lastModified >= headerValue + 1000L) {
                response.sendError(412);
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgument) {
            return true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copy(CacheEntry cacheEntry, InputStream is, ServletOutputStream ostream) throws IOException {
        IOException exception = null;
        InputStream resourceInputStream = null;
        if (cacheEntry.resource != null) {
            byte[] buffer = cacheEntry.resource.getContent();
            if (buffer != null) {
                ostream.write(buffer, 0, buffer.length);
                return;
            }
            resourceInputStream = cacheEntry.resource.streamContent();
        } else {
            resourceInputStream = is;
        }
        try (BufferedInputStream istream = new BufferedInputStream(resourceInputStream, this.input);){
            exception = this.copyRange(istream, ostream);
        }
        if (exception != null) {
            throw exception;
        }
    }

    protected void copy(CacheEntry cacheEntry, InputStream is, PrintWriter writer) throws IOException {
        IOException exception = null;
        InputStream resourceInputStream = null;
        resourceInputStream = cacheEntry.resource != null ? cacheEntry.resource.streamContent() : is;
        InputStreamReader reader = this.fileEncoding == null ? new InputStreamReader(resourceInputStream) : new InputStreamReader(resourceInputStream, this.fileEncoding);
        exception = this.copyRange(reader, writer);
        ((Reader)reader).close();
        if (exception != null) {
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copy(CacheEntry cacheEntry, ServletOutputStream ostream, Range range) throws IOException {
        IOException exception = null;
        InputStream resourceInputStream = cacheEntry.resource.streamContent();
        try (BufferedInputStream istream = new BufferedInputStream(resourceInputStream, this.input);){
            exception = this.copyRange(istream, ostream, range.start, range.end);
        }
        if (exception != null) {
            throw exception;
        }
    }

    protected void copy(CacheEntry cacheEntry, PrintWriter writer, Range range) throws IOException {
        IOException exception = null;
        InputStream resourceInputStream = cacheEntry.resource.streamContent();
        InputStreamReader reader = this.fileEncoding == null ? new InputStreamReader(resourceInputStream) : new InputStreamReader(resourceInputStream, this.fileEncoding);
        exception = this.copyRange(reader, writer, range.start, range.end);
        ((Reader)reader).close();
        if (exception != null) {
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copy(CacheEntry cacheEntry, ServletOutputStream ostream, Iterator<Range> ranges, String contentType) throws IOException {
        IOException exception = null;
        while (exception == null && ranges.hasNext()) {
            InputStream resourceInputStream = cacheEntry.resource.streamContent();
            InputStream istream = null;
            try {
                istream = new BufferedInputStream(resourceInputStream, this.input);
                Range currentRange = ranges.next();
                ostream.println();
                ostream.println("--CATALINA_MIME_BOUNDARY");
                if (contentType != null) {
                    ostream.println("Content-Type: " + contentType);
                }
                ostream.println("Content-Range: bytes " + currentRange.start + "-" + currentRange.end + "/" + currentRange.length);
                ostream.println();
                exception = this.copyRange(istream, ostream, currentRange.start, currentRange.end);
            }
            finally {
                if (istream == null) continue;
                istream.close();
            }
        }
        ostream.println();
        ostream.print("--CATALINA_MIME_BOUNDARY--");
        if (exception != null) {
            throw exception;
        }
    }

    protected void copy(CacheEntry cacheEntry, PrintWriter writer, Iterator<Range> ranges, String contentType) throws IOException {
        IOException exception = null;
        while (exception == null && ranges.hasNext()) {
            InputStream resourceInputStream = cacheEntry.resource.streamContent();
            InputStreamReader reader = this.fileEncoding == null ? new InputStreamReader(resourceInputStream) : new InputStreamReader(resourceInputStream, this.fileEncoding);
            Range currentRange = ranges.next();
            writer.println();
            writer.println("--CATALINA_MIME_BOUNDARY");
            if (contentType != null) {
                writer.println("Content-Type: " + contentType);
            }
            writer.println("Content-Range: bytes " + currentRange.start + "-" + currentRange.end + "/" + currentRange.length);
            writer.println();
            exception = this.copyRange(reader, writer, currentRange.start, currentRange.end);
            ((Reader)reader).close();
        }
        writer.println();
        writer.print("--CATALINA_MIME_BOUNDARY--");
        if (exception != null) {
            throw exception;
        }
    }

    protected IOException copyRange(InputStream istream, ServletOutputStream ostream) {
        IOException exception = null;
        byte[] buffer = new byte[this.input];
        try {
            int len;
            while ((len = istream.read(buffer)) != -1) {
                ostream.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            exception = e;
        }
        return exception;
    }

    protected IOException copyRange(Reader reader, PrintWriter writer) {
        IOException exception = null;
        char[] buffer = new char[this.input];
        try {
            int len;
            while ((len = reader.read(buffer)) != -1) {
                writer.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            exception = e;
        }
        return exception;
    }

    protected IOException copyRange(InputStream istream, ServletOutputStream ostream, long start, long end) {
        if (this.debug > 10) {
            this.log("Serving bytes:" + start + "-" + end);
        }
        long skipped = 0L;
        try {
            skipped = istream.skip(start);
        }
        catch (IOException e) {
            return e;
        }
        if (skipped < start) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00323"), skipped, start);
            return new IOException(msg);
        }
        IOException exception = null;
        long bytesToRead = end - start + 1L;
        byte[] buffer = new byte[this.input];
        int len = buffer.length;
        while (bytesToRead > 0L && len >= buffer.length) {
            try {
                len = istream.read(buffer);
                if (bytesToRead >= (long)len) {
                    ostream.write(buffer, 0, len);
                    bytesToRead -= (long)len;
                } else {
                    ostream.write(buffer, 0, (int)bytesToRead);
                    bytesToRead = 0L;
                }
            }
            catch (IOException e) {
                exception = e;
                len = -1;
            }
            if (len >= buffer.length) continue;
            break;
        }
        return exception;
    }

    protected IOException copyRange(Reader reader, PrintWriter writer, long start, long end) {
        long skipped = 0L;
        try {
            skipped = reader.skip(start);
        }
        catch (IOException e) {
            return e;
        }
        if (skipped < start) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00323"), skipped, start);
            return new IOException(msg);
        }
        IOException exception = null;
        long bytesToRead = end - start + 1L;
        char[] buffer = new char[this.input];
        int len = buffer.length;
        while (bytesToRead > 0L && len >= buffer.length) {
            try {
                len = reader.read(buffer);
                if (bytesToRead >= (long)len) {
                    writer.write(buffer, 0, len);
                    bytesToRead -= (long)len;
                } else {
                    writer.write(buffer, 0, (int)bytesToRead);
                    bytesToRead = 0L;
                }
            }
            catch (IOException e) {
                exception = e;
                len = -1;
            }
            if (len >= buffer.length) continue;
            break;
        }
        return exception;
    }

    static {
        FULL = new ArrayList();
        urlEncoder = new URLEncoder();
        urlEncoder.addSafeCharacter('-');
        urlEncoder.addSafeCharacter('_');
        urlEncoder.addSafeCharacter('.');
        urlEncoder.addSafeCharacter('*');
        urlEncoder.addSafeCharacter('/');
        factory = null;
        secureEntityResolver = null;
    }

    private static enum SortedBy {
        NAME,
        LAST_MODIFIED,
        SIZE;

    }

    protected static class Range {
        public long start;
        public long end;
        public long length;

        protected Range() {
        }

        public boolean validate() {
            if (this.end >= this.length) {
                this.end = this.length - 1L;
            }
            return this.start >= 0L && this.end >= 0L && this.start <= this.end && this.length > 0L;
        }
    }

    private static class LastModifiedComparator
    implements Comparator<NameClassPair> {
        private final ProxyDirContext resources;
        private final String dirName;

        public LastModifiedComparator(ProxyDirContext resources, String dirName) {
            this.resources = resources;
            this.dirName = dirName;
        }

        @Override
        public int compare(NameClassPair p1, NameClassPair p2) {
            CacheEntry ce1 = this.resources.lookupCache(this.dirName + p1.getName());
            Date date1 = ce1.attributes.getCreationOrLastModifiedDate();
            CacheEntry ce2 = this.resources.lookupCache(this.dirName + p2.getName());
            Date date2 = ce2.attributes.getCreationOrLastModifiedDate();
            if (date1.before(date2)) {
                return -1;
            }
            if (date1.after(date2)) {
                return 1;
            }
            return 0;
        }
    }

    private static class SizeComparator
    implements Comparator<NameClassPair> {
        private final ProxyDirContext resources;
        private final String dirName;

        public SizeComparator(ProxyDirContext resources, String dirName) {
            this.resources = resources;
            this.dirName = dirName;
        }

        @Override
        public int compare(NameClassPair p1, NameClassPair p2) {
            CacheEntry ce1 = this.resources.lookupCache(this.dirName + p1.getName());
            long size1 = ce1.attributes.getContentLength();
            CacheEntry ce2 = this.resources.lookupCache(this.dirName + p2.getName());
            long size2 = ce2.attributes.getContentLength();
            if (size1 < size2) {
                return -1;
            }
            if (size1 > size2) {
                return 1;
            }
            return 0;
        }
    }

    private static class SecureEntityResolver
    implements EntityResolver2 {
        private SecureEntityResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            throw new SAXException(MessageFormat.format(rb.getString("AS-WEB-CORE-00540"), publicId, systemId));
        }

        @Override
        public InputSource getExternalSubset(String name, String baseURI) throws SAXException, IOException {
            throw new SAXException(MessageFormat.format(rb.getString("AS-WEB-CORE-00542"), name, baseURI));
        }

        @Override
        public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
            throw new SAXException(MessageFormat.format(rb.getString("AS-WEB-CORE-00541"), name, publicId, baseURI, systemId));
        }
    }
}

