/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdeparser;

import java.io.IOException;
import org.jboss.jdeparser.AbstractJExpr;
import org.jboss.jdeparser.Assoc;
import org.jboss.jdeparser.ParenJExpr;
import org.jboss.jdeparser.SourceFileWriter;
import org.jboss.jdeparser.Tokens$;

class BinaryJExpr
extends AbstractJExpr {
    private final Tokens$.PUNCT.BINOP op;
    private final AbstractJExpr e1;
    private final AbstractJExpr e2;
    private final Assoc assoc;

    BinaryJExpr(Tokens$.PUNCT.BINOP op, AbstractJExpr e1, AbstractJExpr e2, int prec) {
        this(op, e1, e2, prec, Assoc.LEFT);
    }

    BinaryJExpr(Tokens$.PUNCT.BINOP op, AbstractJExpr e1, AbstractJExpr e2, int prec, Assoc assoc) {
        super(prec);
        this.op = op;
        this.e1 = e1.prec() > prec ? new ParenJExpr(e1) : e1;
        this.e2 = e2.prec() > prec ? new ParenJExpr(e2) : e2;
        this.assoc = assoc;
    }

    AbstractJExpr getExpr1() {
        return this.e1;
    }

    AbstractJExpr getExpr2() {
        return this.e2;
    }

    Assoc getAssoc() {
        return this.assoc;
    }

    @Override
    public void write(SourceFileWriter writer) throws IOException {
        writer.write(this.e1);
        writer.write(this.op.getSpacingRule());
        writer.write(this.op);
        writer.write(this.op.getSpacingRule());
        writer.write(this.e2);
    }
}

