/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.validator;

import com.sun.webui.jsf.component.ListSelector;
import com.sun.webui.jsf.model.list.ListItem;
import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.ThemeUtilities;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.validator.Validator;
import jakarta.faces.validator.ValidatorException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.List;

public final class ValueMatchesOptionsValidator
implements Validator,
Serializable {
    public static final String VALIDATOR_ID = "com.sun.webui.jsf.ValueMatchesOptions";
    private String message = null;
    private static final boolean DEBUG = false;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String newMessage) {
        this.message = newMessage;
    }

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        if (context == null || component == null) {
            String msg = "Context or component is null";
            throw new NullPointerException(msg);
        }
        if (!(component instanceof ListSelector)) {
            String msg = this.getClass().getName() + " can only be used with components which subclass " + ListSelector.class.getName();
            throw new RuntimeException(msg);
        }
        ListSelector list = (ListSelector)component;
        Object valuesAsArray = value instanceof List ? ((List)value).toArray() : (value.getClass().isArray() ? value : new Object[]{value});
        int numValues = Array.getLength(valuesAsArray);
        if (numValues == 0) {
            return;
        }
        boolean error = false;
        for (int counter = 0; counter < numValues; ++counter) {
            Object currentValue = Array.get(valuesAsArray, counter);
            Iterator itemsIterator = list.getListItems();
            boolean foundValue = false;
            while (itemsIterator.hasNext()) {
                ListItem listItem;
                Object listObject = itemsIterator.next();
                if (!(listObject instanceof ListItem) || !currentValue.equals((listItem = (ListItem)listObject).getValueObject())) continue;
                foundValue = true;
                break;
            }
            if (foundValue) continue;
            error = true;
            break;
        }
        if (error) {
            if (this.message == null) {
                this.message = ThemeUtilities.getTheme(context).getMessage("ListSelector.badValue");
            }
            throw new ValidatorException(new FacesMessage(this.message));
        }
    }

    private static void log(String msg) {
        LogUtil.finest(ValueMatchesOptionsValidator.class.getName() + "::" + msg);
    }
}

