/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.acc.agent;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glassfish.appclient.client.acc.agent.ClassPathUtils;
import org.glassfish.embeddable.GlassFishVariable;
import org.glassfish.embeddable.client.ApplicationClientCLIEncoding;

public class CLIBootstrap {
    private static final boolean IS_WINDOWS = System.getProperty("os.name", "generic").startsWith("Win");
    public static final String FILE_OPTIONS_INTRODUCER = "argsfile=";
    private static final boolean DEBUG = System.getenv("AS_DEBUG") != null;
    private static final String WINDOWS_ARGS = CLIBootstrap.isWindows() ? System.getenv("APPCLIENT_WINDOWS_ARGS") : null;
    static final String ENV_VAR_PROP_PREFIX = "acc.";
    private static final String SECURITY_POLICY_PROPERTY_EXPR = "-Djava.security.policy=";
    private static final String SECURITY_AUTH_LOGIN_CONFIG_PROPERTY_EXPR = "-Djava.security.auth.login.config=";
    private static final String SYSPROP_SYSTEM_CLASS_LOADER = "-Djava.system.class.loader=";
    private static final String[] ENV_VARS = new String[]{"AS_INSTALL", "APPCPATH", "VMARGS"};
    private final JavaInfo java = new JavaInfo();
    private final GlassFishInfo gfInfo = new GlassFishInfo();
    private final JVMMainOption jvmMainSetting = new JVMMainOption();
    private final UserVMArgs userVMArgs = new UserVMArgs(this, System.getProperty("acc.VMARGS"));
    private final CommandLineElement accValuedOptions = new ACCValuedOption("-mainclass|-name|-xml|-configxml|-user|-password|-passwordfile|-targetserver");
    private final CommandLineElement accUnvaluedOptions = new ACCUnvaluedOption("-textauth|-noappinvoke|-usage|-help");
    private final CommandLineElement jvmValuedOptions;
    private final CommandLineElement jvmPropertySettings;
    private final CommandLineElement otherJVMOptions;
    private final CommandLineElement arguments;
    private final CommandLineElement[] elementsInScanOrder;
    private final CommandLineElement[] elementsInOutputOrder;
    private final AgentArgs agentArgs;

    public static void main(String[] args) {
        try {
            CLIBootstrap.envToProps();
            CLIBootstrap boot = new CLIBootstrap();
            if (WINDOWS_ARGS != null) {
                args = CLIBootstrap.convertInputArgsVariable(WINDOWS_ARGS);
            }
            String outputCommandLine = boot.run(args);
            if (DEBUG) {
                System.err.println(outputCommandLine);
            }
            System.out.print(outputCommandLine);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    private static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("windows");
    }

    private static void envToProps() {
        for (String envVar : ENV_VARS) {
            String value = System.getenv(envVar);
            if (value == null) continue;
            System.setProperty(ENV_VAR_PROP_PREFIX + envVar, value);
            if (!DEBUG) continue;
            System.err.println(ENV_VAR_PROP_PREFIX + envVar + " set to " + value);
        }
    }

    private static String[] convertInputArgsVariable(String inputArgs) {
        String escapedDoubleQuoteRegex = "?:(?<!\\\\)(?:(?:\\\\\\\\)*\\\\)\"";
        Pattern argPattern = Pattern.compile("\"((?:(?<!\\\\)(?:(?:\\\\\\\\)*\\\\)\"|[^\"])*)\"|((?:(?<!\\\\)(?:(?:\\\\\\\\)*\\\\)\"|[^\"\\s])+)");
        Matcher matcher = argPattern.matcher(inputArgs);
        ArrayList<String> argList = new ArrayList<String>();
        while (matcher.find()) {
            String arg = matcher.group(1) != null ? matcher.group(1) : matcher.group(2);
            argList.add(arg);
            if (!DEBUG) continue;
            System.err.println("Captured argument " + arg);
        }
        return argList.toArray(new String[argList.size()]);
    }

    CLIBootstrap() throws Error {
        this.jvmValuedOptions = new JVMValuedOption("-classpath|-cp", this.userVMArgs.evJVMValuedOptions);
        this.jvmPropertySettings = new JVMOption("-D.*", this.userVMArgs.evJVMPropertySettings);
        this.otherJVMOptions = new JVMOption("-.*", this.userVMArgs.evOtherJVMOptions);
        this.arguments = new CommandLineArgument(this, ".*", 32);
        this.elementsInScanOrder = new CommandLineElement[]{this.accValuedOptions, this.accUnvaluedOptions, this.jvmValuedOptions, this.jvmPropertySettings, this.jvmMainSetting, this.otherJVMOptions, this.arguments};
        this.elementsInOutputOrder = new CommandLineElement[]{this.jvmValuedOptions, this.jvmPropertySettings, this.otherJVMOptions, this.jvmMainSetting, this.arguments};
        this.agentArgs = new AgentArgs();
    }

    JavaInfo initJava() {
        return new JavaInfo();
    }

    private String run(String[] args) throws Error {
        String[] augmentedArgs = new String[args.length + 2];
        augmentedArgs[0] = "-configxml";
        augmentedArgs[1] = this.gfInfo.configxml().getAbsolutePath();
        System.arraycopy(args, 0, augmentedArgs, 2, args.length);
        int i = 0;
        while (i < augmentedArgs.length) {
            boolean isMatched = false;
            for (CommandLineElement cle : this.elementsInScanOrder) {
                isMatched = cle.matches(augmentedArgs[i]);
                if (!isMatched) continue;
                i = cle.processValue(augmentedArgs, i);
                break;
            }
            if (isMatched) continue;
            throw new Error("arg " + i + " = " + augmentedArgs[i] + " not recognized");
        }
        StringBuilder command = new StringBuilder(CLIBootstrap.quote(this.java.javaExe));
        this.addProperties(command);
        this.addAgentOption();
        if (!(this.jvmMainSetting.isSet() || this.isHelp() || this.isUsage())) {
            this.accUnvaluedOptions.processValue(new String[]{"-usage"}, 0);
        }
        boolean needSep = true;
        for (CommandLineElement e : this.elementsInOutputOrder) {
            needSep = this.processCommandElement(command, e, needSep);
        }
        return command.toString();
    }

    private void addProperties(StringBuilder command) {
        Path gfBootstrapLibs = this.gfInfo.lib.toPath().resolve("bootstrap").normalize();
        command.append(' ').append("--module-path ").append(CLIBootstrap.quote(gfBootstrapLibs.toString()));
        command.append(' ').append("--add-modules ALL-MODULE-PATH");
        command.append(' ').append("--add-opens=java.base/java.lang=ALL-UNNAMED");
        if (this.userVMArgs.evJVMValuedOptions.values.isEmpty()) {
            command.append(' ').append("-cp ").append(this.gfInfo.agentJarPath());
        }
        command.append(' ').append("-Xshare:off");
        command.append(' ').append(SYSPROP_SYSTEM_CLASS_LOADER).append("org.glassfish.appclient.client.acc.agent.ACCAgentClassLoader");
        command.append(' ').append("-D").append(GlassFishVariable.INSTALL_ROOT.getSystemPropertyName()).append('=').append(CLIBootstrap.quote(this.gfInfo.home().getAbsolutePath()));
        command.append(' ').append("-Dorg.glassfish.gmbal.no.multipleUpperBoundsException=true");
        command.append(' ').append(SECURITY_POLICY_PROPERTY_EXPR).append(CLIBootstrap.quote(this.gfInfo.securityPolicy().getAbsolutePath()));
        command.append(' ').append(SECURITY_AUTH_LOGIN_CONFIG_PROPERTY_EXPR).append(CLIBootstrap.quote(this.gfInfo.loginConfig().toExternalForm()));
    }

    private void addAgentOption() throws Error {
        this.otherJVMOptions.processValue(new String[]{"-javaagent:" + CLIBootstrap.quote(this.gfInfo.agentJarPath()) + this.agentOptionsFromFile()}, 0);
    }

    private boolean processCommandElement(StringBuilder command, CommandLineElement commandLineElement, boolean needSep) {
        if (needSep) {
            command.append(' ');
        }
        return commandLineElement.format(command);
    }

    private static String quote(String string) {
        if (string.length() > 2 && string.charAt(0) != '\"' && string.charAt(string.length() - 1) != '\"') {
            return "\"" + string + "\"";
        }
        return string;
    }

    private static String quoteSuppressTokenSubst(String string) {
        return IS_WINDOWS ? CLIBootstrap.quote(string) : CLIBootstrap.quote(string.replace("$", "\\$"));
    }

    static String quoteEscapedArgument(String string) {
        if (!IS_WINDOWS) {
            string = string.replace("\\", "\\\\").replace("\"", "\\\"").replace("$", "\\$").replace("`", "\\`");
        }
        return "\"" + string + "\"";
    }

    private boolean isHelp() {
        return this.accUnvaluedOptions.values.contains("-help");
    }

    private boolean isUsage() {
        return this.accUnvaluedOptions.values.contains("-usage");
    }

    private String agentOptionsFromFile() {
        try {
            return "=argsfile=" + CLIBootstrap.quote(this.fileContainingAgentArgs().getAbsolutePath());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private File fileContainingAgentArgs() throws IOException {
        File argsFile = File.createTempFile("acc", ".dat");
        try (PrintStream ps = new PrintStream(argsFile);){
            ps.println(this.agentArgs.toString());
        }
        return argsFile;
    }

    static class JavaInfo {
        private static final String SHELL_PROP_NAME = "org.glassfish.appclient.shell";
        private static final String ACCJava_ENV_VAR_NAME = "JAVA";
        private final boolean useWindowsSyntax = File.separatorChar == '\\' && System.getProperty("org.glassfish.appclient.shell") == null;
        protected String javaExe;
        protected File jreHome;

        private JavaInfo() {
            this.init();
        }

        private void init() {
            this.jreHome = new File(System.getProperty(GlassFishVariable.JAVA_HOME.getSystemPropertyName()));
            this.javaExe = this.javaExe();
        }

        protected boolean isValid() {
            return this.javaExe != null && new File(this.javaExe).canExecute();
        }

        protected File javaBinDir() {
            return new File(this.jreHome, "bin");
        }

        String javaExe() {
            return System.getenv(ACCJava_ENV_VAR_NAME);
        }

        File ext() {
            return new File(this.lib(), "ext");
        }

        File lib() {
            return new File(this.jreHome, "lib");
        }

        String pathSeparator() {
            return this.useWindowsSyntax ? ";" : ":";
        }
    }

    static class GlassFishInfo {
        private final File home;
        private final File modules;
        private final File lib;
        private final File libAppclient;
        private static final String ACC_CONFIG_PREFIX = "domains/domain1/config";

        GlassFishInfo() {
            String asInstallPath = System.getProperty("acc.AS_INSTALL");
            if (asInstallPath == null || asInstallPath.isEmpty()) {
                throw new IllegalArgumentException("AS_INSTALL == null");
            }
            this.home = new File(asInstallPath).toPath().normalize().toFile();
            this.modules = new File(this.home, "modules");
            this.lib = new File(this.home, "lib");
            this.libAppclient = new File(this.lib, "appclient");
        }

        File home() {
            return this.home;
        }

        File modules() {
            return this.modules;
        }

        File lib() {
            return this.lib;
        }

        File libAppclient() {
            return this.libAppclient;
        }

        File configxml() {
            File configXMLFile = new File(new File(this.home, ACC_CONFIG_PREFIX), "glassfish-acc.xml");
            if (configXMLFile.canRead()) {
                return configXMLFile;
            }
            File sunACCXMLFile = new File(new File(this.home, ACC_CONFIG_PREFIX), "sun-acc.xml");
            if (sunACCXMLFile.canRead()) {
                return sunACCXMLFile;
            }
            return configXMLFile;
        }

        String extPaths() {
            return new File(this.lib, "ext").getAbsolutePath();
        }

        String agentJarPath() {
            return new File(this.lib, "gf-client.jar").getAbsolutePath();
        }

        File securityPolicy() {
            return new File(this.libAppclient, "client.policy");
        }

        URL loginConfig() {
            try {
                return new File(this.libAppclient, "appclientlogin.conf").toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException("Could not create URL for appclientlogin.conf", e);
            }
        }
    }

    private class JVMMainOption
    extends CommandLineElement {
        private static final String JVM_MAIN_PATTERN = "-jar|-client|[^-][^\\s]*";
        private String introducer;

        JVMMainOption() {
            super(CLIBootstrap.this, JVM_MAIN_PATTERN);
        }

        boolean isJarSetting() {
            return "-jar".equals(this.introducer);
        }

        boolean isClientSetting() {
            return "-client".equals(this.introducer);
        }

        boolean isSet() {
            return !this.values.isEmpty();
        }

        @Override
        boolean matches(String element) {
            return (!this.isSet() || this.isClientSetting() && element.equals("-client")) && super.matches(element);
        }

        @Override
        int processValue(String[] args, int slot) throws Error {
            this.values.clear();
            if (args[slot].charAt(0) != '-') {
                this.values.add("-classpath");
                this.values.add(CLIBootstrap.this.gfInfo.agentJarPath() + File.pathSeparatorChar + ClassPathUtils.getClassPathForGfClient("."));
                int result = super.processValue(args, slot);
                String className = (String)this.values.get(this.values.size() - 1);
                CLIBootstrap.this.agentArgs.add("client=class=" + className);
                return result;
            }
            if (!this.nextLooksOK(args, slot)) {
                throw new Error("-jar or -client requires value but missing");
            }
            this.introducer = args[slot++];
            int result = super.processValue(args, slot);
            String clientJarPath = (String)this.values.remove(this.values.size() - 1);
            File clientJarFile = new File(clientJarPath);
            if (clientJarFile.isDirectory()) {
                CLIBootstrap.this.agentArgs.add("client=dir=" + CLIBootstrap.quote(clientJarFile.getAbsolutePath()));
                this.introducer = "-jar";
                this.values.add(CLIBootstrap.this.gfInfo.agentJarPath());
            } else {
                CLIBootstrap.this.agentArgs.add("client=jar=" + CLIBootstrap.quote(clientJarPath));
                if (clientJarPath.endsWith(".ear")) {
                    this.introducer = "-jar";
                    this.values.add(CLIBootstrap.this.gfInfo.agentJarPath());
                } else if (clientJarPath.endsWith(".jar")) {
                    this.introducer = null;
                    this.values.add("-classpath");
                    this.values.add(CLIBootstrap.this.gfInfo.agentJarPath() + File.pathSeparatorChar + ClassPathUtils.getClassPathForGfClient(clientJarPath));
                    String mainClass = ClassPathUtils.getMainClass(clientJarFile);
                    this.values.add(mainClass == null ? "" : mainClass);
                } else {
                    throw new Error("Unexpected client: " + clientJarPath);
                }
            }
            return result;
        }

        @Override
        boolean format(StringBuilder commandLine) {
            if (this.introducer == null) {
                return super.format(commandLine, false);
            }
            super.format(commandLine, false, this.introducer);
            return super.format(commandLine, true);
        }

        private boolean nextLooksOK(String[] args, int slot) {
            return this.isNextArg(args, slot) && args[slot + 1].charAt(0) != '-';
        }
    }

    class UserVMArgs {
        private CommandLineElement evJVMPropertySettings;
        private CommandLineElement evJVMValuedOptions;
        private CommandLineElement evOtherJVMOptions;
        private final List<CommandLineElement> evElements = new ArrayList<CommandLineElement>();

        UserVMArgs(CLIBootstrap this$0, String vmargs) throws Error {
            if (DEBUG) {
                System.err.println("VMARGS = " + vmargs);
            }
            this.evJVMPropertySettings = this$0.new JVMOption("-D.*", null);
            this.evJVMValuedOptions = this$0.new JVMValuedOption("-classpath|-cp", null);
            this.evOtherJVMOptions = this$0.new JVMOption("-.*", null);
            this.initEVCommandLineElements();
            if (vmargs == null) {
                return;
            }
            this.processEVCommandLineElements(CLIBootstrap.convertInputArgsVariable(vmargs));
        }

        private void initEVCommandLineElements() {
            this.evElements.add(this.evJVMPropertySettings);
            this.evElements.add(this.evJVMValuedOptions);
            this.evElements.add(this.evOtherJVMOptions);
        }

        private void processEVCommandLineElements(String[] envVarJVMArgs) throws Error {
            int i = 0;
            while (i < envVarJVMArgs.length) {
                boolean isMatched = false;
                for (CommandLineElement cle : this.evElements) {
                    isMatched = cle.matches(envVarJVMArgs[i]);
                    if (!isMatched) continue;
                    i = cle.processValue(envVarJVMArgs, i);
                    break;
                }
                if (isMatched) continue;
                throw new Error("arg " + i + " = " + envVarJVMArgs[i] + " not recognized");
            }
        }
    }

    private class ACCValuedOption
    extends ValuedOption {
        ACCValuedOption(String patternString) {
            super(CLIBootstrap.this, patternString);
        }

        @Override
        boolean matches(String element) {
            return !CLIBootstrap.this.jvmMainSetting.isJarSetting() && super.matches(element);
        }

        @Override
        int processValue(String[] args, int slot) throws Error {
            int result = super.processValue(args, slot);
            ValuedOption.OptionValue newOptionValue = (ValuedOption.OptionValue)this.optValues.get(this.optValues.size() - 1);
            CLIBootstrap.this.agentArgs.addACCArg(newOptionValue.option);
            CLIBootstrap.this.agentArgs.addACCArg(CLIBootstrap.quote(newOptionValue.value));
            return result;
        }

        @Override
        boolean format(StringBuilder commandLine) {
            return false;
        }
    }

    private class CommandLineElement {
        private final Pattern pattern;
        private final Pattern whiteSpacePattern = Pattern.compile("[\\r\\n]");
        final List<String> values = new ArrayList<String>();

        CommandLineElement(CLIBootstrap cLIBootstrap, String patternString) {
            this(cLIBootstrap, patternString, 0);
        }

        CommandLineElement(CLIBootstrap cLIBootstrap, String patternString, int flags) {
            this.pattern = Pattern.compile(patternString, flags);
        }

        final boolean matchesPattern(String element) {
            Matcher matcher = this.pattern.matcher(element);
            return matcher.matches();
        }

        boolean matches(String element) {
            return this.matchesPattern(element);
        }

        int processValue(String[] args, int slot) throws Error {
            Matcher matcher = this.whiteSpacePattern.matcher(args[slot]);
            if (!matcher.matches()) {
                this.values.add(args[slot++]);
            } else {
                ++slot;
            }
            return slot;
        }

        boolean isNextArg(String[] args, int currentSlot) {
            return currentSlot < args.length - 1;
        }

        void ensureNonOptionNextArg(String[] args, int currentSlot) throws Error {
            if (currentSlot >= args.length - 1 || args[currentSlot + 1].charAt(0) == '-') {
                throw new Error("Command line element " + args[currentSlot] + " requires non-option value");
            }
        }

        boolean format(StringBuilder commandLine) {
            return this.format(commandLine, true);
        }

        boolean format(StringBuilder commandLine, boolean useQuotes) {
            boolean needSep = false;
            for (String value : this.values) {
                if (needSep) {
                    commandLine.append(this.valueSep());
                }
                this.format(commandLine, useQuotes, value);
                needSep = true;
            }
            return !this.values.isEmpty();
        }

        char valueSep() {
            return ' ';
        }

        StringBuilder format(StringBuilder commandLine, boolean useQuotes, String v) {
            if (commandLine.length() > 0) {
                commandLine.append(' ');
            }
            commandLine.append(useQuotes ? CLIBootstrap.quoteSuppressTokenSubst(v) : v);
            return commandLine;
        }
    }

    private class ACCUnvaluedOption
    extends Option {
        ACCUnvaluedOption(String patternString) {
            super(CLIBootstrap.this, patternString);
        }

        @Override
        boolean matches(String element) {
            return !CLIBootstrap.this.jvmMainSetting.isJarSetting() && super.matches(element);
        }

        @Override
        int processValue(String[] args, int slot) throws Error {
            int result = super.processValue(args, slot);
            CLIBootstrap.this.agentArgs.addACCArg((String)this.values.get(this.values.size() - 1));
            return result;
        }

        @Override
        boolean format(StringBuilder commandLine) {
            return false;
        }
    }

    private class JVMValuedOption
    extends ValuedOption {
        JVMValuedOption(String patternString, CommandLineElement vmargsJVMValuedOption) {
            super(CLIBootstrap.this, patternString);
            if (vmargsJVMValuedOption != null) {
                this.values.addAll(vmargsJVMValuedOption.values);
            }
        }

        @Override
        boolean matches(String element) {
            return !CLIBootstrap.this.jvmMainSetting.isJarSetting() && super.matches(element);
        }
    }

    private class JVMOption
    extends Option {
        JVMOption(String patternString, CommandLineElement vmargsJVMOptionElement) {
            super(CLIBootstrap.this, patternString);
            if (vmargsJVMOptionElement != null) {
                this.values.addAll(vmargsJVMOptionElement.values);
            }
        }

        @Override
        boolean matches(String element) {
            return !CLIBootstrap.this.jvmMainSetting.isSet() && super.matches(element);
        }
    }

    class CommandLineArgument
    extends CommandLineElement {
        CommandLineArgument(CLIBootstrap this$0, String patternString, int flags) {
            super(this$0, patternString, flags);
        }

        @Override
        StringBuilder format(StringBuilder commandLine, boolean useQuotes, String nextArg) {
            if (commandLine.length() > 0) {
                commandLine.append(' ');
            }
            commandLine.append(useQuotes ? CLIBootstrap.quoteEscapedArgument(nextArg) : nextArg);
            return commandLine;
        }
    }

    private static class AgentArgs {
        private final StringBuilder args = new StringBuilder("=mode=acscript");
        private final char sep = (char)44;

        AgentArgs() {
            String appcPath = System.getProperty("acc.APPCPATH");
            if (appcPath != null && appcPath.length() > 0) {
                this.add("appcpath=" + CLIBootstrap.quote(appcPath));
            }
        }

        final void add(String item) {
            this.args.append(',').append(item);
        }

        final void addACCArg(String accArg) {
            this.add("arg=" + ApplicationClientCLIEncoding.encodeArg((String)accArg));
        }

        public String toString() {
            return this.args.toString();
        }
    }

    private class ValuedOption
    extends Option {
        List<OptionValue> optValues = new ArrayList<OptionValue>();

        ValuedOption(CLIBootstrap cLIBootstrap, String patternString) {
            super(cLIBootstrap, patternString);
        }

        @Override
        int processValue(String[] args, int slot) throws Error {
            this.ensureNonOptionNextArg(args, slot);
            this.optValues.add(new OptionValue(this, args[slot++], args[slot++]));
            return slot;
        }

        @Override
        boolean format(StringBuilder commandLine) {
            for (OptionValue ov : this.optValues) {
                this.format(commandLine, false, ov.option);
                this.format(commandLine, true, ov.value);
            }
            return !this.optValues.isEmpty();
        }

        class OptionValue {
            private final String option;
            private final String value;

            OptionValue(ValuedOption this$1, String option, String value) {
                this.option = option;
                this.value = value;
            }
        }
    }

    private class Option
    extends CommandLineElement {
        Option(CLIBootstrap cLIBootstrap, String patternString) {
            super(cLIBootstrap, patternString);
        }
    }
}

