/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.asm;

import org.glassfish.rmic.asm.AsmClassFactory;
import org.glassfish.rmic.tools.java.ClassDeclaration;
import org.glassfish.rmic.tools.java.ClassDefinition;
import org.glassfish.rmic.tools.java.ClassNotFound;
import org.glassfish.rmic.tools.java.Environment;
import org.glassfish.rmic.tools.java.Identifier;

class AsmClass
extends ClassDefinition {
    private final AsmClassFactory factory;
    private boolean basicCheckDone = false;
    private boolean basicChecking = false;

    AsmClass(AsmClassFactory factory, String name, int modifiers, ClassDeclaration declaration, ClassDeclaration superClassDeclaration, ClassDeclaration[] interfaceDeclarations) {
        super(name, 0L, declaration, modifiers, null, null);
        this.factory = factory;
        this.superClass = superClassDeclaration;
        this.interfaces = interfaceDeclarations;
    }

    @Override
    public void loadNested(Environment env) {
        try {
            Identifier outerClass = this.factory.getOuterClassName(this.getName());
            if (outerClass != null) {
                this.outerClass = env.getClassDefinition(outerClass);
            }
        }
        catch (ClassNotFound classNotFound) {
            // empty catch block
        }
    }

    @Override
    protected void basicCheck(Environment env) throws ClassNotFound {
        env.dtEnter("AsmClass.basicCheck: " + this.getName());
        if (this.basicChecking || this.basicCheckDone) {
            env.dtExit("AsmClass.basicCheck: OK " + this.getName());
            return;
        }
        env.dtEvent("AsmClass.basicCheck: CHECKING " + this.getName());
        this.basicChecking = true;
        super.basicCheck(env);
        if (doInheritanceChecks) {
            this.collectInheritedMethods(env);
        }
        this.basicCheckDone = true;
        this.basicChecking = false;
        env.dtExit("AsmClass.basicCheck: " + this.getName());
    }
}

