/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.persistence.jpa;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.spi.ClassTransformer;
import jakarta.persistence.spi.TransformerException;
import jakarta.validation.Validation;
import jakarta.validation.ValidatorFactory;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.InstrumentableClassLoader;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.deployment.common.RootDeploymentDescriptor;
import org.glassfish.persistence.jpa.ProviderContainerContractInfoBase;

public class ServerProviderContainerContractInfo
extends ProviderContainerContractInfoBase {
    private final DeploymentContext deploymentContext;
    private final ClassLoader finalClassLoader;
    private ValidatorFactory validatorFactory;
    boolean isDas;

    public ServerProviderContainerContractInfo(DeploymentContext deploymentContext, ConnectorRuntime connectorRuntime, boolean isDas) {
        super(connectorRuntime, deploymentContext);
        this.deploymentContext = deploymentContext;
        this.finalClassLoader = deploymentContext.getFinalClassLoader();
        this.isDas = isDas;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.finalClassLoader;
    }

    @Override
    public ClassLoader getTempClassloader() {
        return ((InstrumentableClassLoader)this.deploymentContext.getClassLoader()).copy();
    }

    @Override
    public void addTransformer(final ClassTransformer transformer) {
        this.deploymentContext.addTransformer(new ClassFileTransformer(){

            @Override
            public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
                try {
                    return transformer.transform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer);
                }
                catch (TransformerException e) {
                    throw (IllegalClassFormatException)new IllegalClassFormatException().initCause(e);
                }
            }
        });
    }

    @Override
    public String getApplicationLocation() {
        ReadableArchive archive = this.deploymentContext.getSource();
        boolean appRootFound = false;
        while (!appRootFound) {
            ReadableArchive parentArchive = archive.getParentArchive();
            if (parentArchive != null) {
                archive = parentArchive;
                continue;
            }
            appRootFound = true;
        }
        return archive.getURI().getPath();
    }

    @Override
    public ValidatorFactory getValidatorFactory() {
        if (this.validatorFactory == null) {
            this.validatorFactory = Validation.buildDefaultValidatorFactory();
        }
        return this.validatorFactory;
    }

    @Override
    public boolean isJava2DBRequired() {
        OpsParams params = this.deploymentContext.getCommandParameters(OpsParams.class);
        return params.origin.isDeploy() && this.isDas;
    }

    @Override
    public DeploymentContext getDeploymentContext() {
        return this.deploymentContext;
    }

    @Override
    public void registerEMF(String unitName, String persistenceRootUri, RootDeploymentDescriptor containingBundle, EntityManagerFactory entityManagerFactory) {
        if (containingBundle.isApplication()) {
            assert (containingBundle instanceof Application);
            ((Application)Application.class.cast(containingBundle)).addEntityManagerFactory(unitName, persistenceRootUri, entityManagerFactory);
        } else {
            assert (containingBundle instanceof BundleDescriptor);
            ((BundleDescriptor)BundleDescriptor.class.cast(containingBundle)).addEntityManagerFactory(unitName, entityManagerFactory);
        }
    }

    @Override
    public SimpleJndiName getJTADataSourceOverride() {
        return (SimpleJndiName)this.deploymentContext.getTransientAppMetaData("org.glassfish.jta.datasource.jndi.name", SimpleJndiName.class);
    }
}

