/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.xr;

import org.eclipse.persistence.dbws.DBWSException;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.xr.QueryHandler;
import org.eclipse.persistence.internal.xr.QueryOperation;
import org.eclipse.persistence.internal.xr.XRServiceAdapter;
import org.eclipse.persistence.queries.DatabaseQuery;

public class NamedQueryHandler
extends QueryHandler {
    protected String name;
    protected String descriptor;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(String descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public void validate(XRServiceAdapter xrService, QueryOperation queryOperation) {
        if (this.descriptor != null) {
            if (!xrService.getORSession().getProject().getAliasDescriptors().containsKey(this.descriptor)) {
                throw DBWSException.couldNotLocateDescriptorForOperation(this.descriptor, this.getName());
            }
            ClassDescriptor cd = xrService.getORSession().getProject().getDescriptorForAlias(this.descriptor);
            if (cd.getQueryManager().getQuery(this.name) == null) {
                boolean foundQuery = false;
                for (DatabaseQuery q : xrService.getORSession().getProject().getJPAQueries()) {
                    if (!q.getName().equals(this.name)) continue;
                    foundQuery = true;
                    cd.getQueryManager().addQuery(this.name, q);
                    break;
                }
                if (!foundQuery) {
                    throw DBWSException.couldNotLocateQueryForDescriptor(this.name, this.descriptor);
                }
            }
        } else if (xrService.getORSession().getQuery(this.name) == null) {
            boolean foundQuery = false;
            for (DatabaseQuery q : xrService.getORSession().getJPAQueries()) {
                if (!q.getName().equals(this.name)) continue;
                foundQuery = true;
                break;
            }
            if (!foundQuery) {
                throw DBWSException.couldNotLocateQueryForSession(this.name, xrService.getORSession().getName());
            }
        }
    }

    @Override
    public void initialize(XRServiceAdapter xrService, QueryOperation queryOperation) {
        if (this.descriptor != null) {
            ClassDescriptor cd = xrService.getORSession().getProject().getDescriptorForAlias(this.descriptor);
            this.databaseQuery = cd.getQueryManager().getQuery(this.name);
        } else {
            this.databaseQuery = xrService.getORSession().getQuery(this.name);
            if (this.databaseQuery == null) {
                for (DatabaseQuery q : xrService.getORSession().getJPAQueries()) {
                    if (!q.getName().equals(this.name)) continue;
                    this.databaseQuery = q;
                    break;
                }
            }
        }
    }
}

