/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import jakarta.activation.DataHandler;
import org.eclipse.persistence.internal.core.queries.CoreContainerPolicy;
import org.eclipse.persistence.internal.core.sessions.CoreAbstractSession;
import org.eclipse.persistence.internal.oxm.ContainerValue;
import org.eclipse.persistence.internal.oxm.NodeValue;
import org.eclipse.persistence.internal.oxm.Unmarshaller;
import org.eclipse.persistence.internal.oxm.XMLBinaryDataHelper;
import org.eclipse.persistence.internal.oxm.mappings.BinaryDataCollectionMapping;
import org.eclipse.persistence.internal.oxm.mappings.Field;
import org.eclipse.persistence.internal.oxm.mappings.Mapping;
import org.eclipse.persistence.internal.oxm.mappings.XMLConverterMapping;
import org.eclipse.persistence.internal.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.internal.oxm.record.UnmarshalRecordImpl;
import org.eclipse.persistence.internal.oxm.record.XMLReader;
import org.eclipse.persistence.oxm.attachment.XMLAttachmentUnmarshaller;
import org.eclipse.persistence.oxm.exceptions.XMLMarshalException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class XMLBinaryAttachmentHandler
extends UnmarshalRecordImpl {
    UnmarshalRecord record;
    Mapping mapping;
    String c_id = null;
    XMLConverterMapping converter;
    NodeValue nodeValue;
    boolean isCollection = false;
    private static final String INCLUDE_ELEMENT_NAME = "Include";
    private static final String HREF_ATTRIBUTE_NAME = "href";

    public XMLBinaryAttachmentHandler(UnmarshalRecord unmarshalRecord, NodeValue nodeValue, Mapping mapping, XMLConverterMapping converter, boolean isCollection) {
        super(null);
        this.record = unmarshalRecord;
        this.mapping = mapping;
        this.nodeValue = nodeValue;
        this.converter = converter;
        this.isCollection = isCollection;
    }

    @Override
    public void characters(char[] ch, int offset, int length) throws SAXException {
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (INCLUDE_ELEMENT_NAME.equals(localName) || INCLUDE_ELEMENT_NAME.equals(qName)) {
            if (this.record.isNamespaceAware()) {
                if ("http://www.w3.org/2004/08/xop/include".equals(namespaceURI)) {
                    this.c_id = atts.getValue("", HREF_ATTRIBUTE_NAME);
                }
            } else {
                this.c_id = atts.getValue("", HREF_ATTRIBUTE_NAME);
            }
        } else if (this.c_id == null) {
            XMLReader xmlReader = this.record.getXMLReader();
            xmlReader.setContentHandler(this.record);
            xmlReader.setLexicalHandler(this.record);
            this.record.startElement(namespaceURI, localName, qName, atts);
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        Field xmlField = null;
        xmlField = this.isCollection ? (Field)this.mapping.getField() : (Field)this.mapping.getField();
        if (INCLUDE_ELEMENT_NAME.equals(localName) || INCLUDE_ELEMENT_NAME.equals(qName)) {
            if (this.record.isNamespaceAware() && !"http://www.w3.org/2004/08/xop/include".equals(namespaceURI)) {
                return;
            }
            XMLAttachmentUnmarshaller attachmentUnmarshaller = ((Unmarshaller)this.record.getUnmarshaller()).getAttachmentUnmarshaller();
            Object data = null;
            Class<?> attributeClassification = null;
            attributeClassification = this.isCollection ? ((BinaryDataCollectionMapping)this.mapping).getAttributeElementClass() : this.mapping.getAttributeClassification();
            if (attachmentUnmarshaller == null) {
                throw XMLMarshalException.noAttachmentUnmarshallerSet(this.c_id);
            }
            data = attributeClassification.equals(XMLBinaryDataHelper.getXMLBinaryDataHelper().DATA_HANDLER) ? attachmentUnmarshaller.getAttachmentAsDataHandler(this.c_id) : (Object)attachmentUnmarshaller.getAttachmentAsByteArray(this.c_id);
            CoreContainerPolicy cp = null;
            if (this.isCollection) {
                cp = (CoreContainerPolicy)this.mapping.getContainerPolicy();
            }
            data = XMLBinaryDataHelper.getXMLBinaryDataHelper().convertObject(data, this.mapping.getAttributeClassification(), (CoreAbstractSession)this.record.getSession(), cp);
            data = this.converter.convertDataValueToObjectValue(data, this.record.getSession(), this.unmarshaller);
            if (this.isCollection) {
                if (data != null) {
                    this.record.addAttributeValue((ContainerValue)((Object)this.nodeValue), data);
                }
            } else {
                this.record.setAttributeValue(data, this.mapping);
            }
            if (!xmlField.isSelfField()) {
                XMLReader xmlReader = this.record.getXMLReader();
                xmlReader.setContentHandler(this.record);
                xmlReader.setLexicalHandler(this.record);
            }
        } else if (this.c_id == null && !xmlField.isSelfField()) {
            XMLReader xmlReader = this.record.getXMLReader();
            xmlReader.setContentHandler(this.record);
            xmlReader.setLexicalHandler(this.record);
            this.record.endElement(namespaceURI, localName, qName);
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    public String getCID() {
        return this.c_id;
    }

    public Object getObjectValueFromDataHandler(DataHandler handler, Class<?> cls) {
        CoreContainerPolicy cp = null;
        if (this.isCollection) {
            cp = (CoreContainerPolicy)this.mapping.getContainerPolicy();
        }
        return XMLBinaryDataHelper.getXMLBinaryDataHelper().convertObject(handler, cls, (CoreAbstractSession)this.record.getSession(), cp);
    }
}

