/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxrs.jaxrs21.platform.providers.jsonp;

import com.sun.ts.tests.jaxrs.common.JAXRSCommonClient;
import com.sun.ts.tests.jaxrs.common.client.JaxrsCommonClient;
import com.sun.ts.tests.jaxrs.jaxrs21.platform.providers.jsonp.Resource;
import com.sun.ts.tests.jaxrs.jaxrs21.platform.providers.jsonp.TSAppConfig;
import jakarta.json.Json;
import jakarta.json.JsonNumber;
import jakarta.json.JsonString;
import jakarta.ws.rs.core.MediaType;
import java.io.IOException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="jaxrs"), @Tag(value="platform"), @Tag(value="web")})
public class JAXRSClientIT
extends JaxrsCommonClient {
    private static final long serialVersionUID = 21L;

    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_jaxrs21_platform_providers_jsonp_web/resource");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_jaxrs21_platform_providers_jsonp_web.war");
        archive.addClasses(new Class[]{Resource.class, TSAppConfig.class});
        archive.addAsWebInfResource(JAXRSClientIT.class.getPackage(), "web.xml.template", "web.xml");
        return archive;
    }

    @Test
    public void serverJsonStringReturnTest() throws Exception {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "tostring"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "This.is.some.message.to.be.sent.as.json");
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(JAXRSClientIT.getJsonType()));
        System.out.println((String)TEST_PROPS.get((Object)JAXRSCommonClient.Property.REQUEST_HEADERS));
        this.invoke();
    }

    @Test
    public void serverJsonNumberReturnTest() throws Exception {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "tonumber"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, String.valueOf(Long.MIN_VALUE));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(JAXRSClientIT.getJsonType()));
        this.invoke();
    }

    @Test
    public void serverJsonStringArgumentTest() throws Exception {
        String entity = this.getClass().getName();
        JsonString json = Json.createValue((String)entity);
        this.setRequestContentEntity(json);
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "fromstring"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(JAXRSClientIT.getJsonType()));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, entity);
        this.invoke();
    }

    @Test
    public void serverJsonNumberArgumentTest() throws Exception {
        JsonNumber number = Json.createValue((long)Long.MIN_VALUE);
        this.setRequestContentEntity(number);
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "fromnumber"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(JAXRSClientIT.getJsonType()));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, String.valueOf(Long.MIN_VALUE));
        this.invoke();
    }

    private static MediaType getJsonType() {
        return MediaType.APPLICATION_JSON_TYPE;
    }
}

