/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.closedTopicConnection;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.base.ServiceEETest;
import com.sun.ts.tests.jms.common.JmsTool;
import com.sun.ts.tests.jms.common.MessageTestImpl;
import jakarta.jms.BytesMessage;
import jakarta.jms.ConnectionMetaData;
import jakarta.jms.IllegalStateException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.ObjectMessage;
import jakarta.jms.StreamMessage;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicPublisher;
import jakarta.jms.TopicSession;
import jakarta.jms.TopicSubscriber;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Properties;

public class ClosedTopicConnectionTests
extends ServiceEETest {
    private static final String TestName = "com.sun.ts.tests.jms.core.closedTopicConnection.ClosedTopicConnectionTests";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private transient JmsTool tool = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    ArrayList connections = null;

    public static void main(String[] args) {
        ClosedTopicConnectionTests theTests = new ClosedTopicConnectionTests();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    private void createAndCloseConnection(int type, String user, String password) throws Exception {
        if (type == 1 || type == 3) {
            this.tool = new JmsTool(type, user, password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            TestUtil.logTrace((String)"Closing queue Connection");
            this.tool.getDefaultTopicConnection().close();
        }
        TestUtil.logTrace((String)"Connection closed");
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            this.timeout = Long.parseLong(p.getProperty("jms_timeout"));
            this.user = p.getProperty("user");
            this.password = p.getProperty("password");
            this.mode = p.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in ts.jte must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' in ts.jte must not be null");
            }
            if (this.password == null) {
                throw new Exception("'numProducers' in ts.jte must not be null");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' in ts.jte must not be null");
            }
            TestUtil.logTrace((String)"Getting Administrator and deleting any leftover destinations.");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Setup failed!", e);
        }
    }

    public void cleanup() throws Exception {
        try {
            if (this.tool != null) {
                TestUtil.logTrace((String)"Cleanup: Closing Topic and Topic Connections");
                this.tool.closeAllConnections(this.connections);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logErr((String)"An error occurred while cleaning");
            throw new Exception("Cleanup failed!", e);
        }
    }

    public void closedTopicConnectionCommitTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(3, this.user, this.password);
            TestUtil.logTrace((String)"Try to call commit with closed connection.");
            try {
                this.tool.getDefaultTopicSession().commit();
                TestUtil.logTrace((String)"Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                TestUtil.logTrace((String)"Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Fail: wrong exception: " + e.getClass().getName() + " was returned"));
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedTopicConnectionCommitTest");
        }
    }

    public void closedTopicConnectionRollbackTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            TestUtil.logTrace((String)"Try to call rollback() with closed connection.");
            try {
                this.tool.getDefaultTopicSession().rollback();
                TestUtil.logTrace((String)"Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                TestUtil.logTrace((String)"Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Fail: wrong exception: " + e.getClass().getName() + " was returned"));
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionRollbackTest", e);
        }
    }

    public void closedTopicConnectionRecoverTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            TestUtil.logTrace((String)"Try to call recover() with closed connection.");
            try {
                this.tool.getDefaultTopicSession().recover();
                TestUtil.logTrace((String)"Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                TestUtil.logTrace((String)"Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Fail: wrong exception: " + e.getClass().getName() + " was returned"));
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionRecoverTest", e);
        }
    }

    public void closedTopicConnectionCloseTest() throws Exception {
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            TestUtil.logTrace((String)"Try to call close again");
            this.tool.getDefaultTopicConnection().close();
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionCloseTest", e);
        }
    }

    public void closedTopicConnectionGetClientIDTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            TestUtil.logTrace((String)"Try to call getClientID");
            try {
                String foo = this.tool.getDefaultTopicConnection().getClientID();
                TestUtil.logTrace((String)"Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                TestUtil.logTrace((String)"Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Fail: wrong exception: " + e.getClass().getName() + " was returned"));
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionGetClientIDTest", e);
        }
    }

    public void closedTopicConnectionGetMetaDataTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            TestUtil.logTrace((String)"Try to call getMetaData");
            try {
                ConnectionMetaData foo = this.tool.getDefaultTopicConnection().getMetaData();
                TestUtil.logTrace((String)"Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                TestUtil.logTrace((String)"Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Fail: wrong exception: " + e.getClass().getName() + " was returned"));
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionGetMetaDataTest", e);
        }
    }

    public void closedTopicConnectionStartTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            TestUtil.logTrace((String)"Try to call start");
            try {
                this.tool.getDefaultTopicConnection().start();
                TestUtil.logTrace((String)"Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                TestUtil.logTrace((String)"Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Fail: wrong exception: " + e.getClass().getName() + " was returned"));
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionStartTest", e);
        }
    }

    public void closedTopicConnectionCreateTopicSessionTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            TestUtil.logTrace((String)"Try to call createTopicSession");
            try {
                TopicSession foo = this.tool.getDefaultTopicConnection().createTopicSession(true, 1);
                TestUtil.logTrace((String)"Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                TestUtil.logTrace((String)"Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Fail: wrong exception was returned:", (Throwable)e);
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionCreateTopicSessionTest", e);
        }
    }

    public void closedTopicConnectionSessionCloseTest() throws Exception {
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            TestUtil.logMsg((String)"Try to call close on closed session.");
            this.tool.getDefaultTopicSession().close();
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedTopicConnectionSessionCloseTest");
        }
    }

    public void closedTopicConnectionCreateTopicTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            TestUtil.logTrace((String)"Try to create topic with closed Connection.");
            try {
                Topic t = this.tool.getDefaultTopicSession().createTopic("closedTopicConnectionCreateTopicTest");
                TestUtil.logTrace((String)"Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                TestUtil.logTrace((String)"Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Fail: wrong exception: " + e.getClass().getName() + " was returned"));
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionCreateTopicTest", e);
        }
    }

    public void closedTopicConnectionCreateSubscriberTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            TestUtil.logTrace((String)"Try to create Subscriber with closed Connection.");
            try {
                TopicSubscriber tS = this.tool.getDefaultTopicSession().createSubscriber(this.tool.getDefaultTopic());
                TestUtil.logTrace((String)"Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                TestUtil.logTrace((String)"Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Fail: wrong exception: " + e.getClass().getName() + " was returned"));
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionCreateSubscriberTest", e);
        }
    }

    public void closedTopicConnectionCreateSubscriberMsgSelectorTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            TestUtil.logTrace((String)"Try to create Receiver with closed Connection.");
            try {
                TopicSubscriber tS = this.tool.getDefaultTopicSession().createSubscriber(this.tool.getDefaultTopic(), "TEST = 'test'", false);
                TestUtil.logTrace((String)"Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                TestUtil.logTrace((String)"Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Fail: wrong exception: " + e.getClass().getName() + " was returned"));
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionCreateSubscriberMsgSelectorTest", e);
        }
    }

    public void closedTopicConnectionCreatePublisherTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            TestUtil.logTrace((String)"Try to create Publisher with closed Connection.");
            try {
                TopicPublisher tP = this.tool.getDefaultTopicSession().createPublisher(this.tool.getDefaultTopic());
                TestUtil.logTrace((String)"Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                TestUtil.logTrace((String)"Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Fail: wrong exception: " + e.getClass().getName() + " was returned"));
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionCreatePublisherTest", e);
        }
    }

    public void closedTopicConnectionCreateTempTopicTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            TestUtil.logTrace((String)"Try to create TemporaryTopic with closed connection.");
            try {
                TemporaryTopic tT = this.tool.getDefaultTopicSession().createTemporaryTopic();
                TestUtil.logTrace((String)"Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                TestUtil.logTrace((String)"Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Fail: wrong exception: " + e.getClass().getName() + " was returned"));
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionCreateTempTopicTest", e);
        }
    }

    public void closedTopicConnectionCreateMessageTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            TestUtil.logTrace((String)"Try to create message with closed connection.");
            try {
                Message m = this.tool.getDefaultTopicSession().createMessage();
                TestUtil.logTrace((String)"Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                TestUtil.logTrace((String)"Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Fail: wrong exception: " + e.getClass().getName() + " was returned"));
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionCreateMessageTest", e);
        }
    }

    public void closedTopicConnectionCreateBytesMessageTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            TestUtil.logTrace((String)"Try to create BytesMessage with closed connection.");
            try {
                BytesMessage m = this.tool.getDefaultTopicSession().createBytesMessage();
                TestUtil.logTrace((String)"Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                TestUtil.logTrace((String)"Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Fail: wrong exception: " + e.getClass().getName() + " was returned"));
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionCreateBytesMessageTest", e);
        }
    }

    public void closedTopicConnectionCreateMapMessageTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            TestUtil.logTrace((String)"Try to create MapMessage with closed connection.");
            try {
                MapMessage m = this.tool.getDefaultTopicSession().createMapMessage();
                TestUtil.logTrace((String)"Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                TestUtil.logTrace((String)"Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Fail: wrong exception: " + e.getClass().getName() + " was returned"));
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionCreateMapMessageTest", e);
        }
    }

    public void closedTopicConnectionCreateObjectMessageTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            TestUtil.logTrace((String)"Try to create ObjectMessage with closed connection.");
            try {
                ObjectMessage m = this.tool.getDefaultTopicSession().createObjectMessage();
                if (m != null) {
                    TestUtil.logTrace((String)("m=" + String.valueOf(m)));
                }
                TestUtil.logTrace((String)"Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                TestUtil.logTrace((String)"Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Fail: wrong exception: " + e.getClass().getName() + " was returned"));
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionCreateObjectMessageTest", e);
        }
    }

    public void closedTopicConnectionCreateObject2MessageTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            TestUtil.logTrace((String)"Try to create ObjectMessage(object) with closed connection.");
            try {
                String s = "Simple object";
                ObjectMessage m = this.tool.getDefaultTopicSession().createObjectMessage((Serializable)((Object)s));
                if (m != null) {
                    TestUtil.logTrace((String)("m=" + String.valueOf(m)));
                }
                TestUtil.logTrace((String)"Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                TestUtil.logTrace((String)"Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Fail: wrong exception: " + e.getClass().getName() + " was returned"));
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionCreateObject2MessageTest", e);
        }
    }

    public void closedTopicConnectionCreateStreamMessageTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            TestUtil.logTrace((String)"Try to create StreamMessage with closed connection.");
            try {
                StreamMessage m = this.tool.getDefaultTopicSession().createStreamMessage();
                TestUtil.logTrace((String)"Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                TestUtil.logTrace((String)"Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Fail: wrong exception: " + e.getClass().getName() + " was returned"));
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionCreateStreamMessageTest", e);
        }
    }

    public void closedTopicConnectionCreateTextMessageTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            TestUtil.logTrace((String)"Try to create TextMessage with closed connection.");
            try {
                TextMessage m = this.tool.getDefaultTopicSession().createTextMessage();
                TestUtil.logTrace((String)"Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                TestUtil.logTrace((String)"Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Fail: wrong exception: " + e.getClass().getName() + " was returned"));
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionCreateTextMessageTest", e);
        }
    }

    public void closedTopicConnectionCreateText2MessageTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            TestUtil.logTrace((String)"Try to create TextMessage with closed connection.");
            try {
                TextMessage m = this.tool.getDefaultTopicSession().createTextMessage("test message");
                TestUtil.logTrace((String)"Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                TestUtil.logTrace((String)"Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Fail: wrong exception: " + e.getClass().getName() + " was returned"));
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionCreateText2MessageTest", e);
        }
    }

    public void closedTopicConnectionGetTransactedTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            TestUtil.logTrace((String)"Try to call getTransacted() with closed connection.");
            try {
                boolean b = this.tool.getDefaultTopicSession().getTransacted();
                TestUtil.logTrace((String)"Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                TestUtil.logTrace((String)"Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Fail: wrong exception: " + e.getClass().getName() + " was returned"));
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionGetTransactedTest", e);
        }
    }

    public void closedTopicConnectionSubscriberCloseTest() throws Exception {
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            TestUtil.logTrace((String)"Try to call close again");
            this.tool.getDefaultTopicSubscriber().close();
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionSubscriberCloseTest", e);
        }
    }

    public void closedTopicConnectionGetMessageSelectorTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            TestUtil.logTrace((String)"Try to call getMessageSelector");
            try {
                String foo = this.tool.getDefaultTopicSubscriber().getMessageSelector();
                TestUtil.logTrace((String)"Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                TestUtil.logTrace((String)"Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Fail: wrong exception: " + e.getClass().getName() + " was returned"));
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionGetMessageSelectorTest", e);
        }
    }

    public void closedTopicConnectionReceiveTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            TestUtil.logTrace((String)"Try to call receive");
            try {
                Message foo = this.tool.getDefaultTopicSubscriber().receive();
                TestUtil.logTrace((String)"Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                TestUtil.logTrace((String)"Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Fail: wrong exception: " + e.getClass().getName() + " was returned"));
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionReceiveTest", e);
        }
    }

    public void closedTopicConnectionReceiveTimeoutTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            TestUtil.logTrace((String)"Try to call receive(timeout)");
            try {
                Message foo = this.tool.getDefaultTopicSubscriber().receive(this.timeout);
                TestUtil.logTrace((String)"Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                TestUtil.logTrace((String)"Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Fail: wrong exception: " + e.getClass().getName() + " was returned"));
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionReceiveTimeoutTest", e);
        }
    }

    public void closedTopicConnectionReceiveNoWaitTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            TestUtil.logTrace((String)"Try to call receiveNoWait");
            try {
                Message foo = this.tool.getDefaultTopicSubscriber().receiveNoWait();
                TestUtil.logTrace((String)"Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                TestUtil.logTrace((String)"Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Fail: wrong exception: " + e.getClass().getName() + " was returned"));
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionReceiveNoWaitTest", e);
        }
    }

    public void closedTopicConnectionGetNoLocalTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            TestUtil.logTrace((String)"Try to call getNoLocal");
            try {
                boolean foo = this.tool.getDefaultTopicSubscriber().getNoLocal();
                TestUtil.logTrace((String)"Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                TestUtil.logTrace((String)"Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Fail: wrong exception: " + e.getClass().getName() + " was returned"));
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionGetNoLocalTest", e);
        }
    }

    public void closedTopicConnectionSubscriberGetTopicTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            TestUtil.logTrace((String)"Try to call getTopic");
            try {
                Topic foo = this.tool.getDefaultTopicSubscriber().getTopic();
                TestUtil.logTrace((String)"Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                TestUtil.logTrace((String)"Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Fail: wrong exception: " + e.getClass().getName() + " was returned"));
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionSubscriberGetTopicTest", e);
        }
    }

    public void closedTopicConnectionPublisherCloseTest() throws Exception {
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            TestUtil.logTrace((String)"Try to call close again");
            this.tool.getDefaultTopicPublisher().close();
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionPublisherCloseTest", e);
        }
    }

    public void closedTopicConnectionGetDeliveryModeTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            TestUtil.logTrace((String)"Try to call getDeliveryMode");
            try {
                int foo = this.tool.getDefaultTopicPublisher().getDeliveryMode();
                TestUtil.logTrace((String)"Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                TestUtil.logTrace((String)"Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Fail: wrong exception: " + e.getClass().getName() + " was returned"));
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionGetDeliveryModeTest", e);
        }
    }

    public void closedTopicConnectionGetDisableMessageIDTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            TestUtil.logTrace((String)"Try to call getDisableMessageID");
            try {
                boolean foo = this.tool.getDefaultTopicPublisher().getDisableMessageID();
                TestUtil.logTrace((String)"Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                TestUtil.logTrace((String)"Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Fail: wrong exception: " + e.getClass().getName() + " was returned"));
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionGetDisableMessageIDTest", e);
        }
    }

    public void closedTopicConnectionGetDisableMessageTimestampTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            TestUtil.logTrace((String)"Try to call getDisableMessageTimestamp");
            try {
                boolean foo = this.tool.getDefaultTopicPublisher().getDisableMessageTimestamp();
                TestUtil.logTrace((String)"Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                TestUtil.logTrace((String)"Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Fail: wrong exception: " + e.getClass().getName() + " was returned"));
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionGetDisableMessageTimestampTest", e);
        }
    }

    public void closedTopicConnectionGetPriorityTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            TestUtil.logTrace((String)"Try to call getPriority");
            try {
                int foo = this.tool.getDefaultTopicPublisher().getPriority();
                TestUtil.logTrace((String)"Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                TestUtil.logTrace((String)"Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Fail: wrong exception: " + e.getClass().getName() + " was returned"));
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionGetPriorityTest", e);
        }
    }

    public void closedTopicConnectionGetTimeToLiveTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            TestUtil.logTrace((String)"Try to call getTimeToLive");
            try {
                long foo = this.tool.getDefaultTopicPublisher().getTimeToLive();
                TestUtil.logTrace((String)"Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                TestUtil.logTrace((String)"Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Fail: wrong exception: " + e.getClass().getName() + " was returned"));
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionGetTimeToLiveTest", e);
        }
    }

    public void closedTopicConnectionSetDeliveryModeTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            TestUtil.logTrace((String)"Try to call setDeliveryMode");
            try {
                this.tool.getDefaultTopicPublisher().setDeliveryMode(2);
                TestUtil.logTrace((String)"Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                TestUtil.logTrace((String)"Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Fail: wrong exception: " + e.getClass().getName() + " was returned"));
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionSetDeliveryModeTest", e);
        }
    }

    public void closedTopicConnectionSetDisableMessageIDTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            TestUtil.logTrace((String)"Try to call setDisableMessageID");
            try {
                this.tool.getDefaultTopicPublisher().setDisableMessageID(true);
                TestUtil.logTrace((String)"Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                TestUtil.logTrace((String)"Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Fail: wrong exception: " + e.getClass().getName() + " was returned"));
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionSetDisableMessageIDTest", e);
        }
    }

    public void closedTopicConnectionSetDisableMessageTimestampTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            TestUtil.logTrace((String)"Try to call setDisableMessageTimestamp");
            try {
                this.tool.getDefaultTopicPublisher().setDisableMessageTimestamp(true);
                TestUtil.logTrace((String)"Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                TestUtil.logTrace((String)"Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Fail: wrong exception: " + e.getClass().getName() + " was returned"));
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionSetDisableMessageTimestampTest", e);
        }
    }

    public void closedTopicConnectionSetPriorityTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            TestUtil.logTrace((String)"Try to call setPriority");
            try {
                this.tool.getDefaultTopicPublisher().setPriority(4);
                TestUtil.logTrace((String)"Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                TestUtil.logTrace((String)"Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Fail: wrong exception: " + e.getClass().getName() + " was returned"));
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionSetPriorityTest", e);
        }
    }

    public void closedTopicConnectionSetTimeToLiveTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            TestUtil.logTrace((String)"Try to call setTimeToLive");
            try {
                this.tool.getDefaultTopicPublisher().setTimeToLive(0L);
                TestUtil.logTrace((String)"Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                TestUtil.logTrace((String)"Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Fail: wrong exception: " + e.getClass().getName() + " was returned"));
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionSetTimeToLiveTest", e);
        }
    }

    public void closedTopicConnectionPublisherGetTopicTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            TestUtil.logTrace((String)"Try to call getTopic");
            try {
                Topic foo = this.tool.getDefaultTopicPublisher().getTopic();
                TestUtil.logTrace((String)"Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                TestUtil.logTrace((String)"Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Fail: wrong exception: " + e.getClass().getName() + " was returned"));
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionPublisherGetTopicTest", e);
        }
    }

    public void closedTopicConnectionPublish1Test() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            TestUtil.logTrace((String)"Try to call publish(Message)");
            try {
                this.tool.getDefaultTopicPublisher().publish((Message)new MessageTestImpl());
                TestUtil.logTrace((String)"Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                TestUtil.logTrace((String)"Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Fail: wrong exception: " + e.getClass().getName() + " was returned"));
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionPublish1Test", e);
        }
    }

    public void closedTopicConnectionPublish2Test() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            TestUtil.logTrace((String)"Try to call publish(Message,int,int,long)");
            try {
                this.tool.getDefaultTopicPublisher().publish((Message)new MessageTestImpl(), 2, 4, 0L);
                TestUtil.logTrace((String)"Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                TestUtil.logTrace((String)"Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Fail: wrong exception: " + e.getClass().getName() + " was returned"));
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionPublish2Test", e);
        }
    }
}

