/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core20.appclient.listenerexceptiontests;

import com.sun.ts.lib.util.TestUtil;
import jakarta.jms.CompletionListener;
import jakarta.jms.Connection;
import jakarta.jms.IllegalStateException;
import jakarta.jms.Message;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.ArrayList;

public class MyCompletionListener
implements CompletionListener {
    private String name = null;
    private Message message = null;
    private Connection connection = null;
    private Session session = null;
    private ArrayList<Message> messages = new ArrayList();
    private Exception exception = null;
    private int numMessages = 1;
    private int countMessages = 0;
    boolean complete = false;
    boolean gotCorrectException = false;
    boolean gotException = false;

    public MyCompletionListener() {
        this("MyCompletionListener");
    }

    public MyCompletionListener(String name) {
        this.name = name;
    }

    public MyCompletionListener(int numMessages) {
        this.numMessages = numMessages;
        this.messages.clear();
    }

    public MyCompletionListener(Connection connection) {
        this.connection = connection;
    }

    public MyCompletionListener(Session session) {
        this.session = session;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Message getMessage() {
        return this.message;
    }

    public Message getMessage(int index) {
        return this.messages.get(index);
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public boolean gotCorrectException() {
        return this.gotCorrectException;
    }

    public boolean gotException() {
        return this.gotException;
    }

    public boolean gotAllMsgs() {
        return this.messages.size() == this.numMessages;
    }

    public boolean haveMsg(int i) {
        return this.messages.size() > i;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    public void onCompletion(Message message) {
        try {
            TestUtil.logMsg((String)("onCompletion(): Got Message: " + ((TextMessage)message).getText()));
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + String.valueOf(e)));
        }
        this.message = message;
        this.messages.add(message);
        if (message instanceof TextMessage) {
            TextMessage tMsg = (TextMessage)message;
            try {
                if (tMsg.getText().equals("Call connection close method")) {
                    TestUtil.logMsg((String)"Calling Connection.close() MUST throw IllegalStateException");
                    if (this.connection != null) {
                        this.connection.close();
                    }
                } else if (tMsg.getText().equals("Call session close method")) {
                    TestUtil.logMsg((String)"Calling Session.close() MUST throw IllegalStateException");
                    if (this.session != null) {
                        this.session.close();
                    }
                }
            }
            catch (IllegalStateException e) {
                TestUtil.logMsg((String)"onCompletion(): Caught expected IllegalStateException");
                this.gotCorrectException = true;
                this.gotException = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)("onCompletion(): Caught unexpected exception: " + String.valueOf(e)));
                this.gotCorrectException = false;
                this.gotException = true;
                this.exception = e;
            }
        }
        this.complete = true;
        TestUtil.logMsg((String)"onCompletion(): Leaving");
    }

    public void onException(Message message, Exception exception) {
        TestUtil.logMsg((String)("Got Exception: " + String.valueOf(exception)));
        TestUtil.logMsg((String)("With Message: " + String.valueOf(message)));
        this.exception = exception;
        this.message = message;
        this.complete = true;
    }
}

