/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee20.cditests.usecases;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.ee20.cditests.usecases.CMBean2IF;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import jakarta.ejb.EJBException;
import jakarta.ejb.Remote;
import jakarta.ejb.Stateless;
import jakarta.ejb.TransactionAttribute;
import jakarta.ejb.TransactionAttributeType;
import jakarta.ejb.TransactionManagement;
import jakarta.ejb.TransactionManagementType;
import jakarta.inject.Inject;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSConnectionFactory;
import jakarta.jms.JMSContext;
import jakarta.jms.Queue;
import jakarta.jms.Topic;
import java.util.Properties;

@TransactionManagement(value=TransactionManagementType.CONTAINER)
@Stateless(name="CDIUseCasesCMBEAN2")
@Remote(value={CMBean2IF.class})
public class CMBean2
implements CMBean2IF {
    private static final long serialVersionUID = 1L;
    @Inject
    @JMSConnectionFactory(value="jms/ConnectionFactory")
    JMSContext context;
    @Inject
    @JMSConnectionFactory(value="jms/QueueConnectionFactory")
    JMSContext context2;
    @Resource(name="jms/MyConnectionFactory")
    ConnectionFactory cfactory;
    @Resource(name="jms/MY_QUEUE")
    Queue queue;
    @Resource(name="jms/MY_TOPIC")
    Topic topic;

    @PostConstruct
    public void postConstruct() {
        System.out.println("CMBean2:postConstruct()");
        System.out.println("queue=" + String.valueOf(this.queue));
        System.out.println("topic=" + String.valueOf(this.topic));
        System.out.println("cfactory=" + String.valueOf(this.cfactory));
        if (this.queue == null || this.topic == null || this.context == null || this.cfactory == null) {
            throw new EJBException("postConstruct failed: injection failure");
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void init(Properties p) {
        TestUtil.logMsg((String)"CMBean2.init()");
        try {
            TestUtil.init((Properties)p);
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("CMBean2.init: failed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("CMBean2.init: failed");
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void method2a() {
        TestUtil.logMsg((String)("CMBean2.method2a(): context=" + String.valueOf(this.context)));
        TestUtil.logMsg((String)"Sending message [Message 1]");
        this.context.createProducer().send((Destination)this.queue, "Message 1");
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void method2b() {
        TestUtil.logMsg((String)("CMBean2.method2b(): context=" + String.valueOf(this.context)));
        TestUtil.logMsg((String)"Sending message [Message 2]");
        this.context.createProducer().send((Destination)this.queue, "Message 2");
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void method3() {
        TestUtil.logMsg((String)("CMBean2.method3(): context=" + String.valueOf(this.context)));
        TestUtil.logMsg((String)"Sending message [Message 2]");
        this.context.createProducer().send((Destination)this.queue, "Message 2");
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void method5() {
        TestUtil.logMsg((String)("CMBean2.method5(): context=" + String.valueOf(this.context)));
        TestUtil.logMsg((String)"Sending message [Message 2]");
        this.context.createProducer().send((Destination)this.queue, "Message 2");
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void method6() {
        TestUtil.logMsg((String)("CMBean2.method6(): context=" + String.valueOf(this.context)));
        TestUtil.logMsg((String)"Sending message [Message 2]");
        this.context2.createProducer().send((Destination)this.queue, "Message 2");
    }
}

