/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.ee.propagation.cm.jta;

import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import ee.jakarta.tck.persistence.ee.common.Account;
import ee.jakarta.tck.persistence.ee.propagation.cm.jta.Teller;
import ee.jakarta.tck.persistence.ee.util.HttpTCKServlet;
import jakarta.ejb.EJB;
import jakarta.persistence.EntityManager;
import jakarta.persistence.LockModeType;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.PersistenceContexts;
import jakarta.persistence.TransactionRequiredException;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.transaction.UserTransaction;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;

@PersistenceContexts(value={@PersistenceContext(name="persistence/cmpropagation", unitName="CTS-JTA-UNIT"), @PersistenceContext(name="persistence/cmpropagation2", unitName="CTS-JTA-UNIT2")})
public class ServletTest
extends HttpTCKServlet {
    private UserTransaction ut;
    private EntityManager entityManager;
    private EntityManager entityManager2;
    private static final String EM_LOOKUP_NAME = "java:comp/env/persistence/cmpropagation";
    private static final String EM_LOOKUP_NAME2 = "java:comp/env/persistence/cmpropagation2";
    @EJB(beanName="TellerBean")
    private Teller beanRef;
    @EJB(beanName="TellerBean2")
    private Teller beanRef2;

    public UserTransaction getTx() {
        try {
            TSNamingContext nctx = new TSNamingContext();
            this.ut = (UserTransaction)nctx.lookup("java:comp/UserTransaction");
        }
        catch (Exception e) {
            System.out.println("Naming service exception: " + e.getMessage());
            e.printStackTrace();
        }
        return this.ut;
    }

    private void getEM() {
        try {
            if (this.entityManager == null) {
                TSNamingContext nctx = new TSNamingContext();
                this.entityManager = (EntityManager)nctx.lookup(EM_LOOKUP_NAME);
            }
        }
        catch (Exception e) {
            System.out.println("Exception caught looking up EntityManager");
            e.printStackTrace();
        }
    }

    private void getEM2() {
        try {
            if (this.entityManager2 == null) {
                TSNamingContext nctx = new TSNamingContext();
                this.entityManager2 = (EntityManager)nctx.lookup(EM_LOOKUP_NAME2);
            }
        }
        catch (Exception e) {
            System.out.println("Exception caught looking up EntityManager");
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String convertExceptionToString(Exception ex) {
        StringWriter str = new StringWriter();
        PrintWriter writer = new PrintWriter(str);
        try {
            ex.printStackTrace(writer);
            String string = str.getBuffer().toString();
            return string;
        }
        finally {
            try {
                str.close();
                writer.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test1(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        PrintWriter pw = res.getWriter();
        try {
            this.ut = this.getTx();
            this.ut.begin();
            this.getEM();
            this.beanRef.removeTestData();
            System.out.println("test1: createAccountData");
            this.beanRef.createTestData();
            String accounts = this.beanRef.getAllAccounts();
            if (accounts != null) {
                System.out.println(accounts);
            }
            Account ACCOUNT = (Account)this.entityManager.find(Account.class, (Object)1075);
            boolean status = this.beanRef.checkAccountStatus(ACCOUNT);
            this.ut.commit();
            if (status) {
                System.out.println("test1: TEST PASSED - STATUS IS TRUE");
                pw.println("Test PASSED.  Account entities are identical");
            } else {
                System.out.println("test1: TEST FAILED - STATUS IS FALSE");
                pw.println("Test FAILED.  ERROR: Account entities are not identical");
            }
        }
        catch (Exception e) {
            System.out.println("Unexpected exception caught in test1:" + this.convertExceptionToString(e));
            try {
                if (this.ut.getStatus() != 6) {
                    this.ut.rollback();
                }
            }
            catch (Exception se) {
                System.out.println("Unexpected exception caught in test1 while checking TX status:" + this.convertExceptionToString(se));
            }
        }
        finally {
            try {
                this.ut.begin();
                this.beanRef.removeTestData();
                this.ut.commit();
            }
            catch (Exception e) {
                System.out.println("Unexpected exception caught cleaning up test data in test1:" + this.convertExceptionToString(e));
                try {
                    if (this.ut.getStatus() != 6) {
                        this.ut.rollback();
                    }
                }
                catch (Exception se) {
                    System.out.println("Unexpected exception caught in test1 while checking TX status :" + this.convertExceptionToString(e));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test1a(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        PrintWriter pw = res.getWriter();
        try {
            this.ut = this.getTx();
            this.ut.begin();
            this.getEM2();
            this.beanRef2.removeTestData();
            System.out.println("test1a: createAccountData");
            this.beanRef2.createTestData();
            this.ut.commit();
            String accounts = this.beanRef2.getAllAccounts();
            if (accounts != null) {
                System.out.println("Accounts[" + accounts + "]");
            }
            Account account = (Account)this.entityManager2.find(Account.class, (Object)5555);
            boolean status = this.beanRef2.checkAccountStatus(account);
            System.out.println("test1a: status[" + status + "]");
            if (status) {
                System.out.println("test1a: TEST PASSED - STATUS IS TRUE");
                pw.println("Test PASSED.  Account entities are identical");
            } else {
                System.out.println("test1a: TEST FAILED - STATUS IS FALSE");
                pw.println("Test FAILED.  ERROR: Account entities are not identical");
            }
        }
        catch (Exception e) {
            System.out.println("Unexpected exception caught in test1a:" + this.convertExceptionToString(e));
            try {
                if (this.ut.getStatus() != 6) {
                    this.ut.rollback();
                }
            }
            catch (Exception se) {
                System.out.println("Unexpected exception caught in test1a while checking TX status:" + this.convertExceptionToString(se));
            }
        }
        finally {
            try {
                this.ut.begin();
                this.beanRef2.removeTestData();
                this.ut.commit();
            }
            catch (Exception e) {
                System.out.println("Unexpected exception caught cleaning up test data in test1a:" + this.convertExceptionToString(e));
                try {
                    if (this.ut.getStatus() != 6) {
                        this.ut.rollback();
                    }
                }
                catch (Exception se) {
                    System.out.println("Unexpected exception caught in test1a while checking TX status:" + this.convertExceptionToString(se));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test2(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        PrintWriter pw = res.getWriter();
        Double EXPECTED_BALANCE = 10540.75;
        try {
            this.getEM();
            this.ut = this.getTx();
            this.ut.begin();
            this.beanRef.removeTestData();
            System.out.println("test2: createAccountData");
            this.beanRef.createTestData();
            this.ut.commit();
            this.ut.begin();
            Account ACCOUNT = (Account)this.entityManager.find(Account.class, (Object)1075);
            Double balance = this.beanRef.balance(ACCOUNT.id());
            System.out.println("test2: INITIAL BALANCE IS: " + balance);
            balance = this.beanRef.deposit(ACCOUNT.id(), 100.0);
            System.out.println("test2: BALANCE AFTER DEPOSIT IS: " + balance);
            System.out.println("test2: BALANCE FROM DB AFTER DEPOSIT IS: " + ACCOUNT.balance());
            balance = this.beanRef.withdraw(ACCOUNT.id(), 50.0);
            System.out.println("test2: BALANCE AFTER WITHDRAW IS: " + balance);
            System.out.println("test2: BALANCE FROM DB AFTER WITHDRAW IS: " + ACCOUNT.balance());
            this.ut.commit();
            System.out.println("Clearing cache");
            this.entityManager.getEntityManagerFactory().getCache().evictAll();
            Account updatedAccount = (Account)this.entityManager.find(Account.class, (Object)1075);
            balance = updatedAccount.balance();
            if (EXPECTED_BALANCE.compareTo(balance) == 0) {
                System.out.println("test2: TEST PASSED. BALANCE IS: " + balance);
                pw.println("Test PASSED.  Balance of account as expected");
            } else {
                System.out.println("test2: TEST FAILED - Account balance is not correct.  Expected: " + EXPECTED_BALANCE + "got: " + balance);
                pw.println("Test FAILED.  ERROR: Account balance is not correct.  Expected: " + EXPECTED_BALANCE + "got: " + balance);
            }
        }
        catch (Exception e) {
            System.out.println("Unexpected exception caught in test2:" + this.convertExceptionToString(e));
            try {
                if (this.ut.getStatus() != 6) {
                    this.ut.rollback();
                }
            }
            catch (Exception se) {
                System.out.println("Unexpected exception caught in test2 while checking TX status:" + this.convertExceptionToString(se));
            }
        }
        finally {
            try {
                this.ut.begin();
                this.beanRef.removeTestData();
                this.ut.commit();
            }
            catch (Exception e) {
                System.out.println("Unexpected exception caught in test2 while cleaning up test data:" + this.convertExceptionToString(e));
                try {
                    if (this.ut.getStatus() != 6) {
                        this.ut.rollback();
                    }
                }
                catch (Exception se) {
                    System.out.println("Unexpected exception caught in test2 while checking TX status :" + this.convertExceptionToString(se));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test3(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        PrintWriter pw = res.getWriter();
        Double INITIAL_BALANCE = 10490.75;
        try {
            this.getEM();
            this.ut = this.getTx();
            this.ut.begin();
            this.beanRef.removeTestData();
            System.out.println("test3: createAccountData");
            this.beanRef.createTestData();
            this.ut.commit();
            this.ut.begin();
            Account ACCOUNT = (Account)this.entityManager.find(Account.class, (Object)1075);
            Double balance = this.beanRef.balance(ACCOUNT.id());
            System.out.println("test3: INITIAL BALANCE IS: " + balance);
            balance = this.beanRef.deposit(ACCOUNT.id(), 100.0);
            System.out.println("test3: BALANCE AFTER DEPOSIT IS: " + balance);
            System.out.println("test3: BALANCE FROM DB AFTER DEPOSIT IS: " + ACCOUNT.balance());
            balance = this.beanRef.withdraw(ACCOUNT.id(), 50.0);
            System.out.println("test3: BALANCE AFTER WITHDRAW IS: " + balance);
            System.out.println("test3: BALANCE FROM DB AFTER WITHDRAW IS: " + ACCOUNT.balance());
            this.ut.rollback();
            System.out.println("Clearing cache");
            this.entityManager.getEntityManagerFactory().getCache().evictAll();
            Account updatedAccount = (Account)this.entityManager.find(Account.class, (Object)1075);
            balance = updatedAccount.balance();
            if (INITIAL_BALANCE.compareTo(balance) == 0) {
                System.out.println("test3: TEST PASSED. BALANCE IS: " + balance);
                pw.println("Test PASSED.  Balance of account as expected");
            } else {
                System.out.println("test3: TEST FAILED - Account balance is not correct.  Expected: " + INITIAL_BALANCE + "got: " + balance);
                pw.println("Test FAILED.  ERROR: Account balance is not correct.  Expected: " + INITIAL_BALANCE + "got: " + balance);
            }
        }
        catch (Exception e) {
            System.out.println("Unexpected exception caught in test3:" + this.convertExceptionToString(e));
            try {
                if (this.ut.getStatus() != 6) {
                    this.ut.rollback();
                }
            }
            catch (Exception se) {
                System.out.println("Unexpected exception caught in test3 while checking TX status:" + this.convertExceptionToString(se));
            }
        }
        finally {
            try {
                this.ut.begin();
                this.beanRef.removeTestData();
                this.ut.commit();
            }
            catch (Exception e) {
                System.out.println("Unexpected exception caught in test3 while cleaning up test data:" + this.convertExceptionToString(e));
                try {
                    if (this.ut.getStatus() != 6) {
                        this.ut.rollback();
                    }
                }
                catch (Exception se) {
                    System.out.println("Unexpected exception caught in test3 while checking TX status :" + this.convertExceptionToString(se));
                }
            }
        }
    }

    public void getTransactionIllegalStateException(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        boolean pass = true;
        PrintWriter pw = res.getWriter();
        String testName = "getTransactionIllegalStateException";
        try {
            this.getEM();
            this.entityManager.getTransaction();
            pass = false;
            System.out.println(testName + ": Did not throw IllegalStateException");
            pw.println(testName + ": Did not throw IllegalStateException");
        }
        catch (IllegalStateException ise) {
            System.out.println(testName + ": RECEIVED EXPECTED IllegalStateException");
            pw.println(testName + ": RECEIVED EXPECTED IllegalStateException");
        }
        catch (Exception e) {
            pass = false;
            System.out.println(testName + ": Unexpected exception caught in " + testName + ":" + this.convertExceptionToString(e));
            pw.println(testName + ": Unexpected exception caught in " + testName + ":" + this.convertExceptionToString(e));
        }
        if (pass) {
            System.out.println(testName + ": TEST PASSED");
            pw.println("Test PASSED. TEST PASSED");
        } else {
            System.out.println(testName + ": TEST FAILED");
            pw.println("Test FAILED. TEST FAILED");
        }
    }

    public void closeObjectTransactionRequiredExceptionTest(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        boolean pass = false;
        PrintWriter pw = res.getWriter();
        String testName = "closeObjectTransactionRequiredExceptionTest";
        try {
            this.getEM();
            this.entityManager.close();
            System.out.println(testName + ":Did not throw IllegalStateException");
            pw.println(testName + ":Did not throw IllegalStateException");
        }
        catch (IllegalStateException ise) {
            pass = true;
            System.out.println(testName + ": RECEIVED EXPECTED IllegalStateException");
            pw.println(testName + ": RECEIVED EXPECTED IllegalStateException");
        }
        catch (Exception e) {
            System.out.println(testName + ":Unexpected exception caught in " + testName + ":" + this.convertExceptionToString(e));
            pw.println(testName + ":Unexpected exception caught in " + testName + ":" + this.convertExceptionToString(e));
        }
        if (pass) {
            System.out.println("DEBUG: TEST PASSED");
            pw.println("Test PASSED. TEST PASSED");
        } else {
            System.out.println("DEBUG: TEST FAILED");
            pw.println("Test FAILED. TEST FAILED");
        }
    }

    public void mergeObjectTransactionRequiredExceptionTest(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        PrintWriter pw = res.getWriter();
        boolean pass = false;
        String testName = "mergeObjectTransactionRequiredExceptionTest";
        try {
            String desc;
            this.getEM();
            this.ut = this.getTx();
            this.ut.begin();
            this.beanRef.removeTestData();
            System.out.println(testName + ": createAccountData");
            this.beanRef.createTestData();
            this.ut.commit();
            Account account = (Account)this.entityManager.find(Account.class, (Object)1075);
            try {
                this.entityManager.merge((Object)account);
                desc = testName + ":Did not throw TransactionRequiredException";
                TestUtil.logErr((String)desc);
            }
            catch (TransactionRequiredException tre) {
                desc = testName + ": Received expected TransactionRequiredException";
                TestUtil.logTrace((String)desc);
                pass = true;
            }
            catch (Exception e) {
                desc = testName + ":Received unexpected Exception:" + this.convertExceptionToString(e);
                TestUtil.logErr((String)desc);
            }
            if (pass) {
                System.out.println(testName + ": TEST PASSED - " + desc);
                pw.println("Test PASSED.  " + desc);
            } else {
                System.out.println(testName + ": TEST FAILED - " + desc);
                pw.println("Test FAILED.  ERROR: " + desc);
            }
        }
        catch (Exception e) {
            System.out.println(testName + ": Unexpected exception caught");
            e.printStackTrace();
        }
    }

    public void persistObjectTransactionRequiredExceptionTest(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        PrintWriter pw = res.getWriter();
        boolean pass = false;
        String testName = "persistObjectTransactionRequiredExceptionTest";
        try {
            String desc;
            this.getEM();
            this.ut = this.getTx();
            this.ut.begin();
            this.beanRef.removeTestData();
            this.ut.commit();
            try {
                Account account = new Account(999, 9.99);
                this.entityManager.persist((Object)account);
                desc = testName + ":Did not throw TransactionRequiredException";
                TestUtil.logErr((String)desc);
            }
            catch (TransactionRequiredException tre) {
                desc = testName + ":Received expected TransactionRequiredException";
                TestUtil.logTrace((String)desc);
                pass = true;
            }
            catch (Exception e) {
                desc = testName + ":Received unexpected Exception:" + this.convertExceptionToString(e);
                TestUtil.logErr((String)desc);
            }
            if (pass) {
                System.out.println(testName + ": TEST PASSED - " + desc);
                pw.println("Test PASSED.  " + desc);
            } else {
                System.out.println(testName + ": TEST FAILED - " + desc);
                pw.println("Test FAILED.  ERROR: " + desc);
            }
        }
        catch (Exception e) {
            System.out.println(testName + ":Unexpected exception caught");
            e.printStackTrace();
        }
    }

    public void refreshObjectTransactionRequiredExceptionTest(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        block8: {
            PrintWriter pw = res.getWriter();
            boolean pass = false;
            String testName = "refreshObjectTransactionRequiredExceptionTest";
            try {
                this.getEM();
                this.ut = this.getTx();
                this.ut.begin();
                this.beanRef.removeTestData();
                System.out.println(testName + ": createAccountData");
                this.beanRef.createTestData();
                this.ut.commit();
                Account account = (Account)this.entityManager.find(Account.class, (Object)1075);
                if (account != null) {
                    String desc;
                    try {
                        this.entityManager.refresh((Object)account);
                        desc = testName + ":Did not throw TransactionRequiredException";
                        TestUtil.logErr((String)desc);
                    }
                    catch (TransactionRequiredException tre) {
                        desc = testName + ": Received expected TransactionRequiredException";
                        TestUtil.logTrace((String)desc);
                        pass = true;
                    }
                    catch (Exception e) {
                        desc = testName + ":Received unexpected Exception:" + this.convertExceptionToString(e);
                        TestUtil.logErr((String)desc);
                    }
                    if (pass) {
                        System.out.println(testName + ": TEST PASSED - " + desc);
                        pw.println("Test PASSED.  " + desc);
                    } else {
                        System.out.println(testName + ": TEST FAILED - " + desc);
                        pw.println("Test FAILED.  ERROR: " + desc);
                    }
                    break block8;
                }
                System.out.println(testName + ": TEST FAILED - STATUS IS FALSE");
                pw.println("Test FAILED.  ERROR: Account returned by find was null");
            }
            catch (Exception e) {
                System.out.println(testName + ": Unexpected exception caught");
                e.printStackTrace();
            }
        }
    }

    public void refreshObjectMapTransactionRequiredExceptionTest(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        block8: {
            PrintWriter pw = res.getWriter();
            boolean pass = false;
            String testName = "refreshObjectMapTransactionRequiredExceptionTest";
            HashMap<String, String> myMap = new HashMap<String, String>();
            myMap.put("some.cts.specific.property", "nothing.in.particular");
            try {
                this.getEM();
                this.ut = this.getTx();
                this.ut.begin();
                this.beanRef.removeTestData();
                System.out.println(testName + ": createAccountData");
                this.beanRef.createTestData();
                this.ut.commit();
                Account account = (Account)this.entityManager.find(Account.class, (Object)1075);
                if (account != null) {
                    String desc;
                    try {
                        this.entityManager.refresh((Object)account, myMap);
                        desc = testName + ":Did not throw TransactionRequiredException";
                        TestUtil.logErr((String)desc);
                    }
                    catch (TransactionRequiredException tre) {
                        desc = testName + ": Received expected TransactionRequiredException";
                        TestUtil.logTrace((String)desc);
                        pass = true;
                    }
                    catch (Exception e) {
                        desc = testName + ":Received unexpected Exception:" + this.convertExceptionToString(e);
                        TestUtil.logErr((String)desc);
                    }
                    if (pass) {
                        System.out.println(testName + ": TEST PASSED - " + desc);
                        pw.println("Test PASSED.  " + desc);
                    } else {
                        System.out.println(testName + ": TEST FAILED - " + desc);
                        pw.println("Test FAILED.  ERROR: " + desc);
                    }
                    break block8;
                }
                System.out.println(testName + ": TEST FAILED - STATUS IS FALSE");
                pw.println("Test FAILED.  ERROR: Account returned by find was null");
            }
            catch (Exception e) {
                System.out.println(testName + ": Unexpected exception caught");
                e.printStackTrace();
            }
        }
    }

    public void refreshObjectLockModeTypeTransactionRequiredExceptionTest(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        block8: {
            PrintWriter pw = res.getWriter();
            boolean pass = false;
            String testName = "refreshObjectLockModeTypeTransactionRequiredExceptionTest";
            try {
                this.getEM();
                this.ut = this.getTx();
                this.ut.begin();
                this.beanRef.removeTestData();
                System.out.println(testName + ": createAccountData");
                this.beanRef.createTestData();
                this.ut.commit();
                Account account = (Account)this.entityManager.find(Account.class, (Object)1075);
                if (account != null) {
                    String desc;
                    try {
                        this.entityManager.refresh((Object)account, LockModeType.OPTIMISTIC);
                        desc = testName + ":Did not throw TransactionRequiredException";
                        TestUtil.logErr((String)desc);
                    }
                    catch (TransactionRequiredException tre) {
                        desc = testName + ": Received expected TransactionRequiredException";
                        TestUtil.logTrace((String)desc);
                        pass = true;
                    }
                    catch (Exception e) {
                        desc = testName + ":Received unexpected Exception:" + this.convertExceptionToString(e);
                        TestUtil.logErr((String)desc);
                    }
                    if (pass) {
                        System.out.println(testName + ": TEST PASSED - " + desc);
                        pw.println("Test PASSED.  " + desc);
                    } else {
                        System.out.println(testName + ": TEST FAILED - " + desc);
                        pw.println("Test FAILED.  ERROR: " + desc);
                    }
                    break block8;
                }
                System.out.println(testName + ": TEST FAILED - STATUS IS FALSE");
                pw.println("Test FAILED.  ERROR: Account returned by find was null");
            }
            catch (Exception e) {
                System.out.println(testName + ": Unexpected exception caught");
                e.printStackTrace();
            }
        }
    }

    public void refreshObjectLockModeTypeMapTransactionRequiredExceptionTest(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        block8: {
            PrintWriter pw = res.getWriter();
            boolean pass = false;
            String testName = "refreshObjectLockModeTypeMapTransactionRequiredExceptionTest";
            HashMap<String, String> myMap = new HashMap<String, String>();
            myMap.put("some.cts.specific.property", "nothing.in.particular");
            try {
                this.getEM();
                this.ut = this.getTx();
                this.ut.begin();
                this.beanRef.removeTestData();
                System.out.println(testName + ": createAccountData");
                this.beanRef.createTestData();
                this.ut.commit();
                Account account = (Account)this.entityManager.find(Account.class, (Object)1075);
                if (account != null) {
                    String desc;
                    try {
                        this.entityManager.refresh((Object)account, LockModeType.OPTIMISTIC, myMap);
                        desc = testName + ":Did not throw TransactionRequiredException";
                        TestUtil.logErr((String)desc);
                    }
                    catch (TransactionRequiredException tre) {
                        desc = testName + ": Received expected TransactionRequiredException";
                        TestUtil.logTrace((String)desc);
                        pass = true;
                    }
                    catch (Exception e) {
                        desc = testName + ":Received unexpected Exception:" + this.convertExceptionToString(e);
                        TestUtil.logErr((String)desc);
                    }
                    if (pass) {
                        System.out.println(testName + ": TEST PASSED - " + desc);
                        pw.println("Test PASSED.  " + desc);
                    } else {
                        System.out.println(testName + ": TEST FAILED - " + desc);
                        pw.println("Test FAILED.  ERROR: " + desc);
                    }
                    break block8;
                }
                System.out.println(testName + ": TEST FAILED - STATUS IS FALSE");
                pw.println("Test FAILED.  ERROR: Account returned by find was null");
            }
            catch (Exception e) {
                System.out.println(testName + ": Unexpected exception caught");
                e.printStackTrace();
            }
        }
    }

    public void removeObjectTransactionRequiredExceptionTest(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        block8: {
            PrintWriter pw = res.getWriter();
            boolean pass = false;
            String testName = "removeObjectTransactionRequiredExceptionTest";
            try {
                this.getEM();
                this.ut = this.getTx();
                this.ut.begin();
                this.beanRef.removeTestData();
                System.out.println(testName + ": createAccountData");
                this.beanRef.createTestData();
                this.ut.commit();
                Account account = (Account)this.entityManager.find(Account.class, (Object)1075);
                if (account != null) {
                    String desc;
                    try {
                        this.entityManager.remove((Object)account);
                        desc = testName + ":Did not throw TransactionRequiredException";
                        TestUtil.logErr((String)desc);
                    }
                    catch (TransactionRequiredException tre) {
                        desc = testName + ": Received expected TransactionRequiredException";
                        TestUtil.logTrace((String)desc);
                        pass = true;
                    }
                    catch (Exception e) {
                        desc = testName + ":Received unexpected Exception:" + this.convertExceptionToString(e);
                        TestUtil.logErr((String)desc);
                    }
                    if (pass) {
                        System.out.println(testName + ": TEST PASSED - " + desc);
                        pw.println("Test PASSED.  " + desc);
                    } else {
                        System.out.println(testName + ": TEST FAILED - " + desc);
                        pw.println("Test FAILED.  ERROR: " + desc);
                    }
                    break block8;
                }
                System.out.println(testName + ": TEST FAILED - STATUS IS FALSE");
                pw.println("Test FAILED.  ERROR: Account returned by find was null");
            }
            catch (Exception e) {
                System.out.println(testName + ": Unexpected exception caught");
                e.printStackTrace();
            }
        }
    }
}

