/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.json.bind.defaultmapping.attributeorder;

import ee.jakarta.tck.json.bind.defaultmapping.attributeorder.model.ExtendedContainer;
import ee.jakarta.tck.json.bind.defaultmapping.attributeorder.model.SimpleContainer;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class AttributeOrderMappingTest {
    private final Jsonb jsonb = JsonbBuilder.create();

    @Test
    public void testClassAttributeOrder() {
        String jsonString = this.jsonb.toJson((Object)new SimpleContainer(){
            {
                this.setIntInstance(0);
                this.setStringInstance("Test String");
                this.setLongInstance(0L);
            }
        });
        String validationPattern = "\\{\\s*\"intInstance\"\\s*\\:\\s*0\\s*,\\s*\"longInstance\"\\s*\\:\\s*0\\s*,\\s*\"stringInstance\"\\s*\\:\\s*\"Test String\"\\s*\\}";
        MatcherAssert.assertThat((String)"Failed to lexicographically order class attributes.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)validationPattern));
        String toDeserialize = "{ \"intInstance\" : 1, \"stringInstance\" : \"Test String\", \"longInstance\" : 0 }";
        SimpleContainer unmarshalledObject = (SimpleContainer)this.jsonb.fromJson(toDeserialize, SimpleContainer.class);
        MatcherAssert.assertThat((String)"Failed to set class attributes in order of appearance.", (Object)unmarshalledObject.getIntInstance(), (Matcher)Matchers.is((Object)3));
    }

    @Test
    public void testExtendedClassAttributeOrder() {
        String jsonString = this.jsonb.toJson((Object)new ExtendedContainer(){
            {
                this.setIntInstance(0);
                this.setStringInstance("Test String");
                this.setLongInstance(0L);
                this.setFloatInstance(0.0f);
                this.setShortInstance((short)0);
            }
        });
        String validationPattern = "\\{\\s*\"intInstance\"\\s*\\:\\s*0\\s*,\\s*\"longInstance\"\\s*\\:\\s*0\\s*,\\s*\"stringInstance\"\\s*\\:\\s*\"Test String\"\\s*\\,\\s*\"floatInstance\"\\s*\\:\\s*0.0\\s*,\\s*\"shortInstance\"\\s*\\:\\s*0\\s*}";
        MatcherAssert.assertThat((String)"Failed to correctly order extended class attributes.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)validationPattern));
        String toDeserialize = "{ \"intInstance\" : 1, \"shortInstance\" : 0, \"stringInstance\" : \"Test String\", \"floatInstance\" : 0.0, \"longInstance\" : 0 }";
        ExtendedContainer unmarshalledObject = (ExtendedContainer)this.jsonb.fromJson(toDeserialize, ExtendedContainer.class);
        MatcherAssert.assertThat((String)"Failed to set extended class attributes in order of appearance.", (Object)unmarshalledObject.getIntInstance(), (Matcher)Matchers.is((Object)5));
    }
}

