/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.api.rs.core.form;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class JAXRSClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = 1L;
    protected static final String tck = "tck";
    protected static final String cts = "cts";

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public Form constructorNoArgTest() throws JAXRSCommonClient.Fault {
        Form form = new Form();
        Assertions.assertTrue((form != null ? 1 : 0) != 0, (String)"No Form created");
        MultivaluedMap map = form.asMap();
        Assertions.assertTrue((boolean)map.isEmpty(), (String)"Created From instance is not empty");
        JAXRSClientIT.logMsg("Form instance created");
        return form;
    }

    @Test
    public void constructorStringArgsTest() throws JAXRSCommonClient.Fault {
        Form form = new Form(tck, cts);
        Assertions.assertTrue((form != null ? 1 : 0) != 0, (String)"No Form created");
        MultivaluedMap map = form.asMap();
        Assertions.assertTrue((boolean)map.containsKey((Object)tck), (String)"No given key tck exists in form instance");
        Assertions.assertTrue((boolean)((String)map.getFirst((Object)tck)).equals(cts), (String)("Different value has been given from map for key tck: " + (String)map.getFirst((Object)tck)));
        JAXRSClientIT.logMsg("Form instance with String arguments sucessfully created");
    }

    @Test
    public void constructorMultivaluedMapArgTest() throws JAXRSCommonClient.Fault {
        MultivaluedHashMap init = new MultivaluedHashMap();
        init.add((Object)tck, (Object)cts);
        init.add((Object)cts, (Object)cts);
        Form form = new Form((MultivaluedMap)init);
        Assertions.assertTrue((form != null ? 1 : 0) != 0, (String)"No Form created");
        MultivaluedMap map = form.asMap();
        Assertions.assertTrue((boolean)map.containsKey((Object)tck), (String)"No given key tck exists in form instance");
        Assertions.assertTrue((boolean)((String)map.getFirst((Object)tck)).equals(cts), (String)("Different value has been given from map for key tck: " + (String)map.getFirst((Object)tck)));
        Assertions.assertTrue((boolean)map.containsKey((Object)cts), (String)"No given key cts exists in form instance");
        Assertions.assertTrue((boolean)((String)map.getFirst((Object)cts)).equals(cts), (String)("Different value has been given from map for key cts: " + (String)map.getFirst((Object)cts)));
        JAXRSClientIT.logMsg("Form instance with MultivaluedMap argument sucessfully created");
    }

    @Test
    public void paramTest() throws JAXRSCommonClient.Fault {
        Form form = this.constructorNoArgTest();
        form.param(tck, tck);
        form.param(cts, cts);
        MultivaluedMap map = form.asMap();
        Assertions.assertTrue((boolean)map.containsKey((Object)tck), (String)"No given key tckexists in form instance");
        Assertions.assertTrue((boolean)((String)map.getFirst((Object)tck)).equals(tck), (String)("Different value has been given from map for key tck: " + (String)map.getFirst((Object)tck)));
        Assertions.assertTrue((boolean)map.containsKey((Object)cts), (String)"No given key cts exists in form instance");
        Assertions.assertTrue((boolean)((String)map.getFirst((Object)cts)).equals(cts), (String)("Different value has been given from map for key cts: " + (String)map.getFirst((Object)cts)));
    }
}

