/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.monitors;

import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum HealthCheckState {
    AVAILABLE("available"),
    DEGRADED("degraded"),
    UNAVAILABLE("unavailable"),
    NO_LOCAL_SERVERS("no-local-servers"),
    NO_REMOTE_SERVERS("no-remote-servers");

    private final String name;

    private HealthCheckState(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static HealthCheckState forName(String name) {
        String lowerName = StaticUtils.toLowerCase(name);
        if (lowerName.equals("available")) {
            return AVAILABLE;
        }
        if (lowerName.equals("degraded")) {
            return DEGRADED;
        }
        if (lowerName.equals("unavailable")) {
            return UNAVAILABLE;
        }
        if (lowerName.equals("no-local-servers") || lowerName.equals("no_local_servers")) {
            return NO_LOCAL_SERVERS;
        }
        if (lowerName.equals("no-remote-servers") || lowerName.equals("no_remote_servers")) {
            return NO_REMOTE_SERVERS;
        }
        return null;
    }

    public String toString() {
        return this.name;
    }
}

