/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.api.rs.serviceunavailableexception;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.ServiceUnavailableException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class JAXRSClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = 4296616216116337115L;
    private static final Response.Status STATUS = Response.Status.SERVICE_UNAVAILABLE;
    protected static final String MESSAGE = "TCK ServiceUnavailableException description";
    protected static final String HOST = "www.jcp.org";
    protected Date date = Calendar.getInstance().getTime();

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void constructorTest() throws JAXRSCommonClient.Fault {
        ServiceUnavailableException e = new ServiceUnavailableException();
        JAXRSClientIT.assertResponse((WebApplicationException)e);
        this.assertRetryTimeIsNull(e, true);
        JAXRSClientIT.assertHasRetryAfter(e, false);
    }

    public void constructorLongTest() throws JAXRSCommonClient.Fault {
        ServiceUnavailableException e = new ServiceUnavailableException(Long.valueOf(5L));
        JAXRSClientIT.assertResponse((WebApplicationException)e);
        this.assertRetryTimeMin(e, 5);
        JAXRSClientIT.assertHasRetryAfter(e, true);
    }

    public void constructorDateTest() throws JAXRSCommonClient.Fault {
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, 50);
        ServiceUnavailableException e = new ServiceUnavailableException(calendar.getTime());
        JAXRSClientIT.assertResponse((WebApplicationException)e);
        this.assertRetryTimeMin(e, 50);
        JAXRSClientIT.assertHasRetryAfter(e, true);
    }

    public void constructorResponseTest() throws JAXRSCommonClient.Fault {
        ServiceUnavailableException e = new ServiceUnavailableException(this.buildResponse(STATUS));
        this.assertResponse((WebApplicationException)e, HOST);
        this.assertRetryTimeIsNull(e, true);
        JAXRSClientIT.assertHasRetryAfter(e, false);
    }

    public void constructorResponseThrowsExceptionTest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : Response.Status.values()) {
            if (status == STATUS) continue;
            try {
                ServiceUnavailableException e = new ServiceUnavailableException(this.buildResponse(status));
                JAXRSClientIT.fault("IllegalArgumentException has not been thrown for status", status, "; exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for status", status);
            }
        }
    }

    public void constructorDateThrowableTest() throws JAXRSCommonClient.Fault {
        Throwable[] throwables = new Throwable[]{new RuntimeException(), new IOException(), new Error(), new Throwable()};
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, 40);
        for (Throwable t : throwables) {
            ServiceUnavailableException e = new ServiceUnavailableException(calendar.getTime(), t);
            JAXRSClientIT.assertResponse((WebApplicationException)e);
            JAXRSClientIT.assertCause((WebApplicationException)e, t);
            this.assertRetryTimeMin(e, 40);
            JAXRSClientIT.assertHasRetryAfter(e, true);
        }
    }

    public void constructorLongThrowableTest() throws JAXRSCommonClient.Fault {
        Throwable[] throwables;
        for (Throwable t : throwables = new Throwable[]{new RuntimeException(), new IOException(), new Error(), new Throwable()}) {
            ServiceUnavailableException e = new ServiceUnavailableException(Long.valueOf(30L), t);
            JAXRSClientIT.assertResponse((WebApplicationException)e);
            JAXRSClientIT.assertCause((WebApplicationException)e, t);
            this.assertRetryTimeMin(e, 30);
            JAXRSClientIT.assertHasRetryAfter(e, true);
        }
    }

    public void constructorResponseThrowableTest() throws JAXRSCommonClient.Fault {
        Throwable[] throwables;
        for (Throwable t : throwables = new Throwable[]{new RuntimeException(), new IOException(), new Error(), new Throwable()}) {
            ServiceUnavailableException e = new ServiceUnavailableException(this.buildResponse(STATUS), t);
            this.assertResponse((WebApplicationException)e, HOST);
            JAXRSClientIT.assertCause((WebApplicationException)e, t);
            this.assertRetryTimeIsNull(e, true);
            JAXRSClientIT.assertHasRetryAfter(e, false);
        }
    }

    public void constructorResponseThrowableThrowsExceptionTest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : Response.Status.values()) {
            if (status == STATUS) continue;
            try {
                ServiceUnavailableException e = new ServiceUnavailableException(this.buildResponse(status), new Throwable());
                JAXRSClientIT.fault("IllegalArgumentException has not been thrown for status", status, "; exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for status", status);
            }
        }
    }

    public void constructorStringTest() throws JAXRSCommonClient.Fault {
        ServiceUnavailableException e = new ServiceUnavailableException(MESSAGE);
        JAXRSClientIT.assertResponse((WebApplicationException)e);
        this.assertRetryTimeIsNull(e, true);
        JAXRSClientIT.assertHasRetryAfter(e, false);
        JAXRSClientIT.assertMessage((WebApplicationException)e);
    }

    public void constructorStringLongTest() throws JAXRSCommonClient.Fault {
        ServiceUnavailableException e = new ServiceUnavailableException(MESSAGE, Long.valueOf(5L));
        JAXRSClientIT.assertResponse((WebApplicationException)e);
        this.assertRetryTimeMin(e, 5);
        JAXRSClientIT.assertHasRetryAfter(e, true);
        JAXRSClientIT.assertMessage((WebApplicationException)e);
    }

    public void constructorStringDateTest() throws JAXRSCommonClient.Fault {
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, 50);
        ServiceUnavailableException e = new ServiceUnavailableException(MESSAGE, calendar.getTime());
        JAXRSClientIT.assertResponse((WebApplicationException)e);
        this.assertRetryTimeMin(e, 50);
        JAXRSClientIT.assertHasRetryAfter(e, true);
        JAXRSClientIT.assertMessage((WebApplicationException)e);
    }

    public void constructorStringResponseTest() throws JAXRSCommonClient.Fault {
        ServiceUnavailableException e = new ServiceUnavailableException(MESSAGE, this.buildResponse(STATUS));
        this.assertResponse((WebApplicationException)e, HOST);
        this.assertRetryTimeIsNull(e, true);
        JAXRSClientIT.assertHasRetryAfter(e, false);
        JAXRSClientIT.assertMessage((WebApplicationException)e);
    }

    public void constructorStringResponseThrowsIAETest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : Response.Status.values()) {
            if (status == STATUS) continue;
            try {
                ServiceUnavailableException e = new ServiceUnavailableException(MESSAGE, this.buildResponse(status));
                JAXRSClientIT.fault("IllegalArgumentException has not been thrown for status", status, "; exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for status", status);
            }
        }
    }

    public void constructorStringDateThrowableTest() throws JAXRSCommonClient.Fault {
        Throwable[] throwables = new Throwable[]{new RuntimeException(), new IOException(), new Error(), new Throwable()};
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, 40);
        for (Throwable t : throwables) {
            ServiceUnavailableException e = new ServiceUnavailableException(MESSAGE, calendar.getTime(), t);
            JAXRSClientIT.assertResponse((WebApplicationException)e);
            JAXRSClientIT.assertCause((WebApplicationException)e, t);
            this.assertRetryTimeMin(e, 40);
            JAXRSClientIT.assertHasRetryAfter(e, true);
            JAXRSClientIT.assertMessage((WebApplicationException)e);
        }
    }

    public void constructorStringLongThrowableTest() throws JAXRSCommonClient.Fault {
        Throwable[] throwables;
        for (Throwable t : throwables = new Throwable[]{new RuntimeException(), new IOException(), new Error(), new Throwable()}) {
            ServiceUnavailableException e = new ServiceUnavailableException(MESSAGE, Long.valueOf(30L), t);
            JAXRSClientIT.assertResponse((WebApplicationException)e);
            JAXRSClientIT.assertCause((WebApplicationException)e, t);
            this.assertRetryTimeMin(e, 30);
            JAXRSClientIT.assertHasRetryAfter(e, true);
            JAXRSClientIT.assertMessage((WebApplicationException)e);
        }
    }

    public void constructorStringResponseThrowableTest() throws JAXRSCommonClient.Fault {
        Throwable[] throwables;
        for (Throwable t : throwables = new Throwable[]{new RuntimeException(), new IOException(), new Error(), new Throwable()}) {
            ServiceUnavailableException e = new ServiceUnavailableException(MESSAGE, this.buildResponse(STATUS), t);
            this.assertResponse((WebApplicationException)e, HOST);
            JAXRSClientIT.assertCause((WebApplicationException)e, t);
            this.assertRetryTimeIsNull(e, true);
            JAXRSClientIT.assertHasRetryAfter(e, false);
            JAXRSClientIT.assertMessage((WebApplicationException)e);
        }
    }

    public void constructorStringResponseThrowableThrowsIAETest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : Response.Status.values()) {
            if (status == STATUS) continue;
            try {
                ServiceUnavailableException e = new ServiceUnavailableException(MESSAGE, this.buildResponse(status), new Throwable());
                JAXRSClientIT.fault("IllegalArgumentException has not been thrown for status", status, "; exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for status", status);
            }
        }
    }

    protected Response buildResponse(Response.Status status) {
        return Response.status((Response.Status)status).header("Host", (Object)HOST).build();
    }

    protected static void assertResponse(WebApplicationException e) throws JAXRSCommonClient.Fault {
        JAXRSClientIT.assertNotNull(e.getResponse(), "#getResponse is null");
        Response response = e.getResponse();
        JAXRSClientIT.assertEqualsInt(response.getStatus(), STATUS.getStatusCode(), "response contains unexpected status", response.getStatus());
        JAXRSClientIT.logMsg("response contains expected", STATUS, "status");
    }

    protected void assertResponse(WebApplicationException e, String host) throws JAXRSCommonClient.Fault {
        JAXRSClientIT.assertResponse(e);
        String header = e.getResponse().getHeaderString("Host");
        JAXRSClientIT.assertNotNull(header, "http header", "Host", " of response is null");
        JAXRSClientIT.assertEquals(host, header, "Found unexpected http", "Host", "header", header);
        JAXRSClientIT.logMsg("Found expected http", "Host", "header");
    }

    protected static void assertCause(WebApplicationException e, Throwable expected) throws JAXRSCommonClient.Fault {
        JAXRSClientIT.assertEquals(e.getCause(), expected, "#getCause does not contain expected", expected, "but", e.getCause());
        JAXRSClientIT.logMsg("getCause contains expected", expected);
    }

    protected void assertRetryTimeIsNull(ServiceUnavailableException e, boolean isNull) throws JAXRSCommonClient.Fault {
        Date retryTime = e.getRetryTime(this.date);
        Assertions.assertTrue((isNull && retryTime == null || !isNull && retryTime != null ? 1 : 0) != 0, (String)("RetryTime was unexpectedly " + retryTime));
        JAXRSClientIT.logMsg("Found expected retry time", retryTime);
    }

    protected void assertRetryTimeMin(ServiceUnavailableException e, int seconds) throws JAXRSCommonClient.Fault {
        Date retryTime = e.getRetryTime(this.date);
        JAXRSClientIT.assertNotNull(this.date, "#getRetryTime is null");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.date);
        calendar.add(13, seconds);
        Date minTime = calendar.getTime();
        Assertions.assertTrue((retryTime.compareTo(minTime) >= -1000 ? 1 : 0) != 0, (String)("RetryTime " + retryTime.getTime() + " was unexpectedly lower then expected " + minTime.getTime()));
        JAXRSClientIT.logMsg("Found expected retry time", retryTime);
    }

    protected static void assertHasRetryAfter(ServiceUnavailableException e, boolean hasIt) throws JAXRSCommonClient.Fault {
        boolean retry = e.hasRetryAfter();
        JAXRSClientIT.assertEqualsBool(hasIt, retry, "#hasRetryAfter is unexpectedly", retry);
        JAXRSClientIT.logMsg("#hasRetryAfter returned expected", retry, "value");
    }

    protected static void assertMessage(WebApplicationException e) throws JAXRSCommonClient.Fault {
        JAXRSClientIT.assertNotNull(e.getMessage(), "getMessage() is null");
        JAXRSClientIT.assertContains(e.getMessage(), MESSAGE, new Object[]{"Unexpected getMessage()", e.getMessage()});
        JAXRSClientIT.logMsg("found expected getMessage()=", e.getMessage());
    }
}

