/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.spec.client.typedentities;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.client.JaxrsCommonClient;
import ee.jakarta.tck.ws.rs.common.impl.SinglevaluedMap;
import ee.jakarta.tck.ws.rs.common.impl.StringDataSource;
import ee.jakarta.tck.ws.rs.common.impl.StringStreamingOutput;
import ee.jakarta.tck.ws.rs.ee.rs.ext.messagebodyreaderwriter.ReadableWritableEntity;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import ee.jakarta.tck.ws.rs.spec.client.typedentities.EntityMessageReader;
import ee.jakarta.tck.ws.rs.spec.client.typedentities.EntityMessageWriter;
import ee.jakarta.tck.ws.rs.spec.client.typedentities.Resource;
import ee.jakarta.tck.ws.rs.spec.client.typedentities.TSAppConfig;
import jakarta.activation.DataSource;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JaxrsCommonClient {
    private static final long serialVersionUID = 1339633069677106930L;
    private static final String entity = Resource.class.getName();

    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_spec_client_typedentities_web/resource");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/spec/client/typedentities/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_spec_client_typedentities_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, Resource.class, EntityMessageReader.class, EntityMessageWriter.class, ReadableWritableEntity.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void clientAnyReaderUsageTest() throws JAXRSCommonClient.Fault {
        this.addProvider(new EntityMessageReader());
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "readerprovider"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(MediaType.TEXT_XML_TYPE));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, Resource.class.getName());
        this.bufferEntity(true);
        this.invoke();
        ReadableWritableEntity entity = (ReadableWritableEntity)this.getResponse().readEntity(ReadableWritableEntity.class);
        Assertions.assertTrue((entity != null ? 1 : 0) != 0, (String)"Returned Entity is null!");
        Assertions.assertTrue((boolean)entity.toString().equals(Resource.class.getName()), (String)("Returned Entity" + entity.toString() + "is unexpected"));
    }

    @Test
    public void clientAnyWriterUsageTest() throws JAXRSCommonClient.Fault {
        ReadableWritableEntity entity = new ReadableWritableEntity(String.valueOf(1339633069677106930L));
        this.addProvider(new EntityMessageWriter());
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "writerprovider"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(MediaType.TEXT_XML_TYPE));
        this.setRequestContentEntity(entity);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, entity.toXmlString());
        this.invoke();
    }

    @Test
    public void clientByteArrayReaderTest() throws JAXRSCommonClient.Fault {
        this.standardReaderInvocation(MediaType.WILDCARD_TYPE);
        this.toStringTest(byte[].class);
    }

    @Test
    public void clientStringReaderTest() throws JAXRSCommonClient.Fault {
        this.standardReaderInvocation(MediaType.WILDCARD_TYPE);
        this.toStringTest(String.class);
    }

    @Test
    public void clientInputStreamReaderTest() throws JAXRSCommonClient.Fault {
        this.standardReaderInvocation(MediaType.WILDCARD_TYPE);
        InputStream responseEntity = (InputStream)this.getResponse().readEntity(InputStream.class);
        Assertions.assertTrue((responseEntity != null ? 1 : 0) != 0, (String)"Returned Entity is null!");
        InputStreamReader reader = new InputStreamReader(responseEntity);
        this.readerTest(reader);
    }

    @Test
    public void clientReaderReaderTest() throws JAXRSCommonClient.Fault {
        this.standardReaderInvocation(MediaType.WILDCARD_TYPE);
        Reader responseEntity = (Reader)this.getResponse().readEntity(Reader.class);
        Assertions.assertTrue((responseEntity != null ? 1 : 0) != 0, (String)"Returned Entity is null!");
        this.readerTest(responseEntity);
    }

    @Test
    public void clientFileReaderTest() throws JAXRSCommonClient.Fault {
        FileReader fr;
        this.standardReaderInvocation(MediaType.WILDCARD_TYPE);
        File responseEntity = (File)this.getResponse().readEntity(File.class);
        Assertions.assertTrue((responseEntity != null ? 1 : 0) != 0, (String)"Returned Entity is null!");
        try {
            fr = new FileReader(responseEntity);
        }
        catch (FileNotFoundException e) {
            throw new JAXRSCommonClient.Fault(e);
        }
        this.readerTest(fr);
        responseEntity.deleteOnExit();
    }

    @Test
    public void clientDataSourceReaderTest() throws JAXRSCommonClient.Fault {
        InputStreamReader reader;
        this.standardReaderInvocation(MediaType.WILDCARD_TYPE);
        DataSource responseEntity = (DataSource)this.getResponse().readEntity(DataSource.class);
        Assertions.assertTrue((responseEntity != null ? 1 : 0) != 0, (String)"Returned Entity is null!");
        try {
            reader = new InputStreamReader(responseEntity.getInputStream());
        }
        catch (IOException e) {
            throw new JAXRSCommonClient.Fault(e);
        }
        this.readerTest(reader);
    }

    @Test
    public void clientSourceReaderTest() throws JAXRSCommonClient.Fault {
        this.standardReaderInvocation(MediaType.TEXT_XML_TYPE);
        Source responseEntity = (Source)this.getResponse().readEntity(Source.class);
        Assertions.assertTrue((responseEntity != null ? 1 : 0) != 0, (String)"Returned Entity is null!");
        this.standardReaderInvocation(MediaType.APPLICATION_XML_TYPE);
        responseEntity = (Source)this.getResponse().readEntity(Source.class);
        Assertions.assertTrue((responseEntity != null ? 1 : 0) != 0, (String)"Returned Entity is null!");
        this.standardReaderInvocation(MediaType.APPLICATION_ATOM_XML_TYPE);
        responseEntity = (Source)this.getResponse().readEntity(Source.class);
        Assertions.assertTrue((responseEntity != null ? 1 : 0) != 0, (String)"Returned Entity is null!");
    }

    @Test
    public void clientMultivaluedMapReaderTest() throws JAXRSCommonClient.Fault {
        this.standardReaderInvocation(MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        MultivaluedMap responseEntity = (MultivaluedMap)this.getResponse().readEntity(MultivaluedMap.class);
        Assertions.assertTrue((responseEntity != null ? 1 : 0) != 0, (String)"Returned Entity is null!");
        boolean ok = responseEntity.containsKey((Object)entity) || responseEntity.containsValue((Object)entity);
        Assertions.assertTrue((boolean)ok, (String)("Returned Entity" + responseEntity + "does not contains supposed value"));
    }

    @Test
    public void clientByteArrayWriterTest() throws JAXRSCommonClient.Fault {
        this.standardWriterInvocation(entity.getBytes());
    }

    @Test
    public void clientStringWriterTest() throws JAXRSCommonClient.Fault {
        this.standardWriterInvocation(entity);
    }

    @Test
    public void clientInputStreamWriterTest() throws JAXRSCommonClient.Fault {
        ByteArrayInputStream bais = new ByteArrayInputStream(entity.getBytes());
        this.standardWriterInvocation(bais);
        this.close(bais);
    }

    @Test
    public void clientReaderWriterTest() throws JAXRSCommonClient.Fault {
        ByteArrayInputStream bais = new ByteArrayInputStream(entity.getBytes());
        InputStreamReader reader = new InputStreamReader(bais);
        this.standardWriterInvocation(reader);
        this.close(reader);
    }

    @Test
    public void clientFileWriterTest() throws JAXRSCommonClient.Fault {
        File file = this.createFileEntity(entity);
        this.standardWriterInvocation(file);
        file.deleteOnExit();
    }

    @Test
    public void clientDataSourceWriterTest() throws JAXRSCommonClient.Fault {
        StringDataSource ds = new StringDataSource(entity, MediaType.WILDCARD_TYPE);
        this.standardWriterInvocation(ds);
    }

    @Test
    public void clientSourceWriterTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(MediaType.APPLICATION_XML_TYPE));
        File file = this.createFileEntity("<xml>" + entity + "</xml>");
        StreamSource source = new StreamSource(file);
        this.standardWriterInvocation(source);
        file.deleteOnExit();
    }

    @Test
    public void clientMultivaluedMapWriterTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(MediaType.APPLICATION_FORM_URLENCODED_TYPE));
        SinglevaluedMap map = new SinglevaluedMap();
        map.add(entity, entity);
        this.standardWriterInvocation(map);
    }

    @Test
    public void clientStreamingOutputWriterTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(MediaType.APPLICATION_FORM_URLENCODED_TYPE));
        StringStreamingOutput output = new StringStreamingOutput(entity);
        this.standardWriterInvocation(output);
    }

    protected void standardReaderInvocation(MediaType mediaType) throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "standardreader"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, entity);
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(mediaType));
        this.bufferEntity(true);
        this.invoke();
    }

    protected void standardWriterInvocation(Object objectEntity) throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "standardwriter"));
        this.setRequestContentEntity(objectEntity);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, entity);
        this.invoke();
    }

    protected <T> void toStringTest(Class<T> clazz) throws JAXRSCommonClient.Fault {
        Object responseEntity = this.getResponse().readEntity(clazz);
        Assertions.assertTrue((responseEntity != null ? 1 : 0) != 0, (String)"Returned Entity is null!");
        String s = responseEntity.toString();
        if (s.startsWith("[B")) {
            s = new String((byte[])responseEntity);
        }
        Assertions.assertTrue((boolean)s.equals(entity), (String)("Was expected returned entity" + entity + "got" + s));
    }

    void readerTest(Reader reader) throws JAXRSCommonClient.Fault {
        BufferedReader bf = new BufferedReader(reader);
        String s = null;
        try {
            s = bf.readLine();
        }
        catch (IOException e) {
            throw new JAXRSCommonClient.Fault(e);
        }
        JAXRSClientIT.assertEquals(s, entity, "Returned Entity", s, "is unexpected");
        this.close(reader);
    }

    void close(Closeable closable) throws JAXRSCommonClient.Fault {
        try {
            closable.close();
        }
        catch (IOException e) {
            throw new JAXRSCommonClient.Fault(e);
        }
    }

    File createFileEntity(String entity) throws JAXRSCommonClient.Fault {
        File file;
        OutputStreamWriter fr = null;
        try {
            file = File.createTempFile("tckjaxrs", ".tmp");
            Assertions.assertTrue((boolean)file.canWrite(), (String)"file is not for writing");
            fr = new FileWriter(file);
            fr.write(entity);
            fr.flush();
            fr.close();
        }
        catch (IOException e) {
            try {
                fr.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new JAXRSCommonClient.Fault(e);
        }
        return file;
    }
}

