/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.jaxrs21.ee.sse.ssebroadcaster;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.impl.JaxbKeyValueBean;
import ee.jakarta.tck.ws.rs.common.impl.ReplacingOutputStream;
import ee.jakarta.tck.ws.rs.common.impl.SecurityContextImpl;
import ee.jakarta.tck.ws.rs.common.impl.SinglevaluedMap;
import ee.jakarta.tck.ws.rs.common.impl.StringDataSource;
import ee.jakarta.tck.ws.rs.common.impl.StringSource;
import ee.jakarta.tck.ws.rs.common.impl.StringStreamingOutput;
import ee.jakarta.tck.ws.rs.common.impl.TRACE;
import ee.jakarta.tck.ws.rs.common.util.Holder;
import ee.jakarta.tck.ws.rs.common.util.LinkedHolder;
import ee.jakarta.tck.ws.rs.jaxrs21.ee.sse.SSEJAXRSClient;
import ee.jakarta.tck.ws.rs.jaxrs21.ee.sse.SSEMessage;
import ee.jakarta.tck.ws.rs.jaxrs21.ee.sse.ssebroadcaster.BroadcastResource;
import ee.jakarta.tck.ws.rs.jaxrs21.ee.sse.ssebroadcaster.TSAppConfig;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.sse.InboundSseEvent;
import jakarta.ws.rs.sse.SseEventSource;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends SSEJAXRSClient {
    private static final long serialVersionUID = 21L;
    private static final int CLIENTS = 5;
    private BroadCasterClient[] clients;
    private WebTarget target;

    public JAXRSClientIT() {
        this.setContextRoot("/jaxrs_jaxrs21_ee_sse_ssebroadcaster_web");
        this.setup();
    }

    @Override
    public void setup() {
        super.setup();
        this.target = ClientBuilder.newClient().target(this.getAbsoluteUrl("broadcast/register"));
        this.clients = new BroadCasterClient[5];
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/jaxrs21/ee/sse/ssebroadcaster/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_jaxrs21_ee_sse_ssebroadcaster_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, BroadcastResource.class, Holder.class, SSEMessage.class, TRACE.class, StringSource.class, StringStreamingOutput.class, StringDataSource.class, SinglevaluedMap.class, SecurityContextImpl.class, ReplacingOutputStream.class, JaxbKeyValueBean.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @Override
    public void cleanup() throws JAXRSCommonClient.Fault {
        super.cleanup();
        try {
            for (int i = 0; i != this.clients.length; ++i) {
                System.out.println("cleanup" + i);
                this.clients[i].close();
            }
        }
        catch (Exception e) {
            throw new JAXRSCommonClient.Fault(e);
        }
    }

    @Test
    public void sseBroadcastTest() throws JAXRSCommonClient.Fault {
        List<String> events;
        int i;
        int MSG_MAX = 7;
        int wait = 25;
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "broadcast/clear"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "CLEAR");
        this.invoke();
        this.clients = new BroadCasterClient[5];
        for (i = 0; i != 5; ++i) {
            this.clients[i] = new BroadCasterClient();
            Thread t = new Thread(this.clients[i]);
            t.start();
        }
        for (i = 0; i != 5; ++i) {
            while (this.clients[i].getEvents().size() == 0 && wait-- > 0) {
                TestUtil.sleep(100);
            }
        }
        for (i = 0; i != MSG_MAX; ++i) {
            this.setProperty(JAXRSCommonClient.Property.CONTENT, "some_ServiceUnavailableEndpoint_message" + i);
            this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "broadcast/broadcast"));
            this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, (String)TEST_PROPS.get((Object)JAXRSCommonClient.Property.CONTENT));
            this.invoke();
        }
        for (wait = 25; this.clients[0].holder.size() <= MSG_MAX && wait > 0; --wait) {
            TestUtil.sleep(200);
        }
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "broadcast/close"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "CLOSE");
        this.invoke();
        for (i = 0; i != 5; ++i) {
            events = this.clients[i].getEvents();
            for (String e : events) {
                JAXRSClientIT.logMsg("Client", i, "Received message", e);
            }
        }
        for (i = 0; i != 5; ++i) {
            events = this.clients[i].getEvents();
            JAXRSClientIT.assertEquals(events.size(), MSG_MAX + 1, "Received unexpected number of events", events.size());
            Assertions.assertTrue((boolean)events.get(0).contains("WELCOME"), (String)("Received unexpected message" + events.get(0)));
            for (int j = 0; j != MSG_MAX; ++j) {
                JAXRSClientIT.assertEquals(events.get(j + 1), "some_ServiceUnavailableEndpoint_message" + j, "Received unexpected message", events.get(j + 1));
            }
        }
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "broadcast/check"));
        this.invoke();
        String response = this.getResponseBody();
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 != 5; ++i2) {
            sb.append("SseEventSink number ").append(i2).append(" is closed:true");
        }
        sb.append("OnCloseSink has been called:true");
        JAXRSClientIT.assertEquals(response, sb.toString(), "Unexpected check message received", response);
    }

    static class MsgHolder
    extends LinkedHolder<String> {
        MsgHolder() {
        }

        @Override
        public void add(InboundSseEvent value) {
            String data = value.readData();
            super.add(data);
            System.out.println("Received" + data);
        }
    }

    class BroadCasterClient
    implements Runnable,
    AutoCloseable {
        MsgHolder holder = new MsgHolder();
        volatile boolean isClosed = false;

        BroadCasterClient() {
        }

        @Override
        public void run() {
            try (SseEventSource source = SseEventSource.target((WebTarget)JAXRSClientIT.this.target).build();){
                source.register(this.holder::add);
                source.open();
                while (!this.isClosed) {
                    JAXRSClientIT.this.sleepUntilHolderGetsFilled(this.holder);
                    System.out.append("WAITING:").println(this.toString());
                }
            }
        }

        @Override
        public void close() throws Exception {
            this.isClosed = true;
        }

        public List<String> getEvents() {
            return this.holder.asList();
        }
    }
}

