/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.json.bind.api.builder;

import ee.jakarta.tck.json.bind.api.model.SimpleContainer;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import jakarta.json.bind.JsonbConfig;
import jakarta.json.bind.spi.JsonbProvider;
import jakarta.json.spi.JsonProvider;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class JsonbBuilderTest {
    @Test
    public void testBuild() {
        Jsonb jsonb = JsonbBuilder.newBuilder().build();
        MatcherAssert.assertThat((String)"Failed to create a new Jsonb instance using JsonBuilder.build method.", (Object)jsonb, (Matcher)Matchers.notNullValue());
    }

    @Test
    public void testCreate() {
        Jsonb jsonb = JsonbBuilder.create();
        MatcherAssert.assertThat((String)"Failed to create a new Jsonb instance using JsonBuilder.create method.", (Object)jsonb, (Matcher)Matchers.notNullValue());
    }

    @Test
    public void testCreateConfig() {
        JsonbConfig jsonbConfig = new JsonbConfig().withNullValues(Boolean.valueOf(true));
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)jsonbConfig);
        String jsonString = jsonb.toJson((Object)new SimpleContainer(){
            {
                this.setInstance(null);
            }
        });
        MatcherAssert.assertThat((String)"Failed to create a new Jsonb instance using JsonBuilder.create method with Config argument configured with provided configuration.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"instance\"\\s*:\\s*null\\s*}"));
    }

    @Test
    public void testNewBuilder() {
        JsonbBuilder jsonbBuilder = JsonbBuilder.newBuilder();
        String validationMessage = "Failed to create a new Jsonb instance as returned by jakarta.json.bind.spi.JsonbProvider#provider method using JsonBuilder.newBuilder method.";
        MatcherAssert.assertThat((String)validationMessage, (Object)jsonbBuilder, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((String)validationMessage, jsonbBuilder.getClass(), (Matcher)Matchers.is(JsonbProvider.provider().create().getClass()));
    }

    @Test
    public void testNewBuilderString() {
        JsonbBuilder jsonbBuilder = JsonbBuilder.newBuilder((String)JsonbProvider.provider().getClass().getName());
        String validationMessage = "Failed to create a new Jsonb instance as returned by jakarta.json.bind.spi.JsonbProvider#provider(String) method using JsonBuilder.newBuilder method with String argument.";
        MatcherAssert.assertThat((String)validationMessage, (Object)jsonbBuilder, (Matcher)Matchers.notNullValue());
        Class<?> clazz = JsonbProvider.provider((String)JsonbProvider.provider().getClass().getName()).create().getClass();
        MatcherAssert.assertThat((String)validationMessage, jsonbBuilder.getClass(), (Matcher)Matchers.is(clazz));
    }

    @Test
    public void testNewBuilderProvider() {
        JsonbBuilder jsonbBuilder = JsonbBuilder.newBuilder((JsonbProvider)JsonbProvider.provider());
        String validationMessage = "Failed to create a new Jsonb instance as returned by provider#create method using JsonBuilder.newBuilder method with JsonbProvider argument.";
        MatcherAssert.assertThat((String)validationMessage, (Object)jsonbBuilder, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((String)validationMessage, jsonbBuilder.getClass(), (Matcher)Matchers.is(JsonbProvider.provider().create().getClass()));
    }

    @Test
    public void testWithConfig() {
        JsonbConfig jsonbConfig = new JsonbConfig().withNullValues(Boolean.valueOf(true));
        Jsonb jsonb = JsonbBuilder.newBuilder().withConfig(jsonbConfig).build();
        String jsonString = jsonb.toJson((Object)new SimpleContainer(){
            {
                this.setInstance(null);
            }
        });
        MatcherAssert.assertThat((String)"Failed to apply configuration passed as an argument to JsonbBuilder.withConfig method.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"instance\"\\s*:\\s*null\\s*}"));
    }

    @Test
    public void testWithProvider() {
        JsonbBuilder jsonbBuilder = JsonbBuilder.newBuilder().withProvider(JsonProvider.provider());
        MatcherAssert.assertThat((String)"Failed to create a new JsonbBuilder instance using a specific JsonProvider using JsonbBuilder.withProvider method.", (Object)jsonbBuilder, (Matcher)Matchers.notNullValue());
    }
}

