/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.spec.filter.interceptor;

import ee.jakarta.tck.ws.rs.common.impl.StringDataSource;
import ee.jakarta.tck.ws.rs.common.impl.StringSource;
import ee.jakarta.tck.ws.rs.common.impl.StringStreamingOutput;
import ee.jakarta.tck.ws.rs.common.provider.StringBean;
import ee.jakarta.tck.ws.rs.common.util.JaxrsUtil;
import jakarta.activation.DataSource;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.GenericEntity;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.xml.bind.JAXBElement;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;

@Path(value="resource")
public class Resource {
    public static final String HEADERNAME = "FILTER_HEADER";
    public static final String DIRECTION = "FROM_RESOURCE";
    @Context
    private HttpHeaders headers;

    public static final String getName() {
        return "<resource>" + Resource.class.getName() + "</resource>";
    }

    @GET
    @Path(value="getbytearray")
    public Response getByteArray() {
        return this.buildResponse(Resource.getName().getBytes());
    }

    @POST
    @Path(value="postbytearray")
    public Response postByteArray(byte[] array) {
        return this.buildResponse(new String(array));
    }

    @GET
    @Path(value="getstring")
    public Response getString() {
        return this.buildResponse(Resource.getName());
    }

    @POST
    @Path(value="poststring")
    public Response postString(String string) {
        return this.buildResponse(string);
    }

    @GET
    @Path(value="getinputstream")
    public Response getInputStream() {
        return this.buildResponse(new ByteArrayInputStream(Resource.getName().getBytes()));
    }

    @POST
    @Path(value="postinputstream")
    public Response postInputStream(InputStream stream) throws IOException {
        String text = JaxrsUtil.readFromStream(stream);
        stream.close();
        return this.buildResponse(text);
    }

    @GET
    @Path(value="getreader")
    public Response getReader() {
        InputStream stream = (InputStream)this.getInputStream().getEntity();
        InputStreamReader reader = new InputStreamReader(stream);
        return this.buildResponse(reader);
    }

    @POST
    @Path(value="postreader")
    public Response postReader(Reader reader) throws IOException {
        String text = JaxrsUtil.readFromReader(reader);
        reader.close();
        return this.buildResponse(text);
    }

    @GET
    @Path(value="getfile")
    public Response getFile() throws IOException {
        File file = File.createTempFile("filter", "tmp");
        FileWriter writer = new FileWriter(file);
        writer.append(Resource.getName());
        writer.close();
        return this.buildResponse(file);
    }

    @POST
    @Path(value="postfile")
    public Response postFile(File file) throws IOException {
        String text = JaxrsUtil.readFromFile(file);
        return this.buildResponse(text);
    }

    @GET
    @Path(value="getdatasource")
    public Response getDataSource() {
        StringDataSource source = new StringDataSource(Resource.getName(), MediaType.WILDCARD_TYPE);
        return this.buildResponse(source);
    }

    @POST
    @Path(value="postdatasource")
    public Response postDataSource(DataSource source) throws IOException {
        InputStream stream = source.getInputStream();
        String text = JaxrsUtil.readFromStream(stream);
        return this.buildResponse(text);
    }

    @GET
    @Path(value="getsource")
    public Response getSource() {
        StringSource source = new StringSource(Resource.getName());
        return this.buildResponse(source, MediaType.TEXT_XML_TYPE);
    }

    @POST
    @Consumes(value={"text/xml"})
    @Path(value="postsource")
    public Response postSource(Source source) {
        String text = source.getSystemId();
        return this.buildResponse(text);
    }

    @GET
    @Path(value="getjaxb")
    public Response getJaxbElement() {
        JAXBElement element = new JAXBElement(new QName("resource"), String.class, (Object)this.getClass().getName());
        GenericEntity<JAXBElement<String>> generic = new GenericEntity<JAXBElement<String>>(element){};
        return this.buildResponse(generic, MediaType.TEXT_XML_TYPE);
    }

    @POST
    @Path(value="postjaxb")
    @Consumes(value={"text/xml"})
    public Response postJaxbElement(JAXBElement<String> element) {
        String text = (String)element.getValue();
        return this.buildResponse(text, MediaType.TEXT_XML_TYPE);
    }

    @GET
    @Path(value="getmap")
    public Response getMultivaluedMap() {
        MultivaluedHashMap map = new MultivaluedHashMap();
        map.add((Object)Resource.getName(), (Object)Resource.getName());
        GenericEntity<MultivaluedMap<String, String>> entity = new GenericEntity<MultivaluedMap<String, String>>((MultivaluedMap)map){};
        return this.buildResponse(entity, MediaType.APPLICATION_FORM_URLENCODED_TYPE);
    }

    @POST
    @Path(value="postmap")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response postMultivaluedMap(MultivaluedMap<String, String> map) {
        String key = (String)((Map.Entry)map.entrySet().iterator().next()).getKey();
        String value = (String)map.getFirst((Object)key);
        return this.buildResponse(value);
    }

    @GET
    @Path(value="getstreamingoutput")
    public Response getStreamingOutput() {
        StringStreamingOutput output = new StringStreamingOutput(Resource.getName());
        return this.buildResponse(output);
    }

    @GET
    @Path(value="getboolean")
    public Response getBoolean() {
        Boolean b = false;
        return this.buildResponse(b, MediaType.TEXT_PLAIN_TYPE);
    }

    @POST
    @Path(value="postboolean")
    public Response postBoolean(Boolean b) {
        String s = String.valueOf(b);
        return this.buildResponse(s);
    }

    @GET
    @Path(value="getchar")
    public Response getChar() {
        Character c = Character.valueOf('R');
        return this.buildResponse(c, MediaType.TEXT_PLAIN_TYPE);
    }

    @POST
    @Path(value="postchar")
    public Response postChar(char c) {
        String text = String.valueOf(c);
        return this.buildResponse(text);
    }

    @GET
    @Path(value="getnumber")
    public Response getNumber() {
        Integer n = Resource.getName().length();
        return this.buildResponse(n, MediaType.TEXT_PLAIN_TYPE);
    }

    @POST
    @Path(value="postnumber")
    public Response postNumber(Number n) {
        String s = String.valueOf(n.intValue());
        return this.buildResponse(s);
    }

    @GET
    @Path(value="getstringbean")
    public Response getStringBean() {
        StringBean bean = new StringBean(Resource.getName());
        return this.buildResponse(bean);
    }

    @POST
    @Path(value="poststringbean")
    public Response postStringBean(StringBean bean) {
        String text = bean.get();
        return this.buildResponse(text);
    }

    private Response buildResponse(Object content) {
        return this.buildResponse(content, MediaType.WILDCARD_TYPE);
    }

    private Response buildResponse(Object content, MediaType type) {
        List list = this.headers.getRequestHeader(HEADERNAME);
        String name = null;
        if (list != null && list.size() != 0) {
            name = (String)list.iterator().next();
        }
        Response.ResponseBuilder builder = Response.ok((Object)content, (MediaType)type).type(type);
        if (name != null) {
            builder.header(HEADERNAME, (Object)(name + DIRECTION));
        }
        return builder.build();
    }
}

