/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.api.rs.core.newcookie;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.NewCookie;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class JAXRSClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = 295711558453778471L;

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void constructorTest1() throws JAXRSCommonClient.Fault {
        String name = "name_1";
        String value = "value_1";
        String comment = "";
        String domain = "";
        String path = "";
        int maxage = -1;
        int version = 1;
        boolean secure = false;
        Cookie ck1 = new Cookie(name, value);
        NewCookie nck1 = new NewCookie(ck1);
        JAXRSClientIT.verifyNewCookie(nck1, name, value, path, domain, version, comment, maxage, secure);
    }

    @Test
    public void constructorTest2() throws JAXRSCommonClient.Fault {
        String name = "name_1";
        String value = "value_1";
        String path = "/acme";
        String domain = "";
        String comment = "";
        int maxage = -1;
        int version = 1;
        boolean secure = false;
        Cookie ck2 = new Cookie(name, value, path, domain);
        NewCookie nck2 = new NewCookie(ck2);
        JAXRSClientIT.verifyNewCookie(nck2, name, value, path, domain, version, comment, maxage, secure);
    }

    @Test
    public void constructorTest3() throws JAXRSCommonClient.Fault {
        String name = "name_1";
        String value = "value_1";
        String path = "";
        String domain = "y.x.foo.com";
        String comment = "";
        int maxage = -1;
        int version = 1;
        boolean secure = false;
        Cookie ck3 = new Cookie(name, value, path, domain);
        NewCookie nck3 = new NewCookie(ck3);
        JAXRSClientIT.verifyNewCookie(nck3, name, value, path, domain, version, comment, maxage, secure);
    }

    @Test
    public void constructorTest4() throws JAXRSCommonClient.Fault {
        String name = "name_1";
        String value = "value_1";
        String path = "/acme";
        String domain = "y.x.foo.com";
        String comment = "";
        int maxage = -1;
        int version = 1;
        boolean secure = false;
        Cookie ck4 = new Cookie(name, value, path, domain, version);
        NewCookie nck4 = new NewCookie(ck4);
        JAXRSClientIT.verifyNewCookie(nck4, name, value, path, domain, version, comment, maxage, secure);
    }

    @Test
    public void constructorTest5() throws JAXRSCommonClient.Fault {
        String name = "name_1";
        String value = "value_1";
        String path = "/acme";
        String domain = "y.x.foo.com";
        int version = 0;
        String comment = "";
        int maxage = -1;
        boolean secure = false;
        Cookie ck5 = new Cookie(name, value, path, domain, version);
        NewCookie nck5 = new NewCookie(ck5);
        JAXRSClientIT.verifyNewCookie(nck5, name, value, path, domain, version, comment, maxage, secure);
    }

    @Test
    public void constructorTest6() throws JAXRSCommonClient.Fault {
        String name = "name_1";
        String value = "value_1";
        String comment = "";
        String domain = "";
        String path = "";
        int maxage = -1;
        int version = 1;
        boolean secure = false;
        NewCookie nck6 = new NewCookie(name, value);
        JAXRSClientIT.verifyNewCookie(nck6, name, value, path, domain, version, comment, maxage, secure);
    }

    @Test
    public void constructorTest7() throws JAXRSCommonClient.Fault {
        String name = "name_1";
        String value = "value_1";
        String path = "/acme";
        String domain = "";
        String comment = "";
        int maxage = -1;
        int version = 1;
        boolean secure = false;
        NewCookie nck7 = new NewCookie(name, value, path, domain, comment, maxage, secure);
        JAXRSClientIT.verifyNewCookie(nck7, name, value, path, domain, version, comment, maxage, secure);
    }

    @Test
    public void constructorTest8() throws JAXRSCommonClient.Fault {
        String name = "name_1";
        String value = "value_1";
        String path = "";
        String domain = "y.x.foo.com";
        String comment = "";
        int maxage = -1;
        int version = 1;
        boolean secure = false;
        NewCookie nck8 = new NewCookie(name, value, path, domain, comment, maxage, secure);
        JAXRSClientIT.verifyNewCookie(nck8, name, value, path, domain, version, comment, maxage, secure);
    }

    @Test
    public void constructorTest9() throws JAXRSCommonClient.Fault {
        String name = "name_1";
        String value = "value_1";
        String path = "/acme";
        String domain = "y.x.foo.com";
        String comment = "cts test comment";
        int maxage = -1;
        int version = 1;
        boolean secure = false;
        NewCookie nck9 = new NewCookie(name, value, path, domain, comment, maxage, secure);
        JAXRSClientIT.verifyNewCookie(nck9, name, value, path, domain, version, comment, maxage, secure);
    }

    @Test
    public void constructorTest10() throws JAXRSCommonClient.Fault {
        String name = "name_1";
        String value = "value_1";
        String path = "/acme";
        String domain = "y.x.foo.com";
        int version = 1;
        String comment = "cts test comment";
        int maxage = -1;
        boolean secure = true;
        NewCookie nck10 = new NewCookie(name, value, path, domain, comment, maxage, secure);
        JAXRSClientIT.verifyNewCookie(nck10, name, value, path, domain, version, comment, maxage, secure);
    }

    @Test
    public void constructorTest11() throws JAXRSCommonClient.Fault {
        String name = "name_1";
        String value = "value_1";
        String path = "/acme";
        String domain = "y.x.foo.com";
        int version = 1;
        String comment = "cts test comment";
        int maxage = 12345;
        boolean secure = false;
        NewCookie nck11 = new NewCookie(name, value, path, domain, version, comment, maxage, secure);
        JAXRSClientIT.verifyNewCookie(nck11, name, value, path, domain, version, comment, maxage, secure);
    }

    @Test
    public void constructorTest12() throws JAXRSCommonClient.Fault {
        String name = "name_1";
        String value = "value_1";
        String path = "/acme";
        String domain = "";
        String comment = "";
        int maxage = -1;
        int version = 1;
        boolean secure = false;
        NewCookie nck12 = new NewCookie(name, value, path, domain, version, comment, maxage, secure);
        JAXRSClientIT.verifyNewCookie(nck12, name, value, path, domain, version, comment, maxage, secure);
    }

    @Test
    public void constructorTest13() throws JAXRSCommonClient.Fault {
        String name = "name_1";
        String value = "value_1";
        String path = "";
        String domain = "y.x.foo.com";
        String comment = "";
        int maxage = -1;
        int version = 1;
        boolean secure = false;
        NewCookie nck13 = new NewCookie(name, value, path, domain, version, comment, maxage, secure);
        JAXRSClientIT.verifyNewCookie(nck13, name, value, path, domain, version, comment, maxage, secure);
    }

    @Test
    public void constructorTest14() throws JAXRSCommonClient.Fault {
        String name = "name_1";
        String value = "value_1";
        String path = "/acme";
        String domain = "y.x.foo.com";
        String comment = "cts test comment";
        int maxage = -1;
        int version = 1;
        boolean secure = false;
        NewCookie nck14 = new NewCookie(name, value, path, domain, version, comment, maxage, secure);
        JAXRSClientIT.verifyNewCookie(nck14, name, value, path, domain, version, comment, maxage, secure);
    }

    @Test
    public void constructorTest15() throws JAXRSCommonClient.Fault {
        String name = "name_1";
        String value = "value_1";
        String path = "/acme";
        String domain = "y.x.foo.com";
        int version = 0;
        String comment = "cts test comment";
        int maxage = -1;
        boolean secure = true;
        NewCookie nck15 = new NewCookie(name, value, path, domain, version, comment, maxage, secure);
        JAXRSClientIT.verifyNewCookie(nck15, name, value, path, domain, version, comment, maxage, secure);
    }

    @Test
    public void constructorTest16() throws JAXRSCommonClient.Fault {
        String name = "name_1";
        String value = "value_1";
        String path = "/acme";
        String domain = "y.x.foo.com";
        int version = 0;
        String comment = "cts test comment";
        int maxage = -1;
        boolean secure = true;
        NewCookie nck16 = new NewCookie(name, value, path, domain, version, comment, maxage, secure);
        JAXRSClientIT.verifyNewCookie(nck16, name, value, path, domain, version, comment, maxage, secure);
    }

    @Test
    public void constructorTest17() throws JAXRSCommonClient.Fault {
        String name = "name_1";
        String value = "value_1";
        String path = "/acme";
        String domain = "y.x.foo.com";
        int version = 1;
        String comment = "cts test comment";
        int maxage = 123456;
        boolean secure = true;
        NewCookie nck17 = new NewCookie(name, value, path, domain, version, comment, maxage, secure);
        JAXRSClientIT.verifyNewCookie(nck17, name, value, path, domain, version, comment, maxage, secure);
    }

    @Test
    public void constructorTest18() throws JAXRSCommonClient.Fault {
        String name = "name_1";
        String value = "value_1";
        String comment = "";
        String domain = "";
        String path = "";
        int maxage = -1;
        int version = 1;
        boolean secure = false;
        Cookie ck18 = new Cookie(name, value);
        NewCookie nck18 = new NewCookie(ck18, comment, maxage, secure);
        JAXRSClientIT.verifyNewCookie(nck18, name, value, path, domain, version, comment, maxage, secure);
    }

    @Test
    public void constructorTest19() throws JAXRSCommonClient.Fault {
        String name = "name_1";
        String value = "value_1";
        String path = "/acme";
        String domain = "";
        String comment = "";
        int maxage = -1;
        int version = 1;
        boolean secure = false;
        Cookie ck2 = new Cookie(name, value, path, domain);
        NewCookie nck2 = new NewCookie(ck2, comment, maxage, secure);
        JAXRSClientIT.verifyNewCookie(nck2, name, value, path, domain, version, comment, maxage, secure);
    }

    @Test
    public void constructorTest20() throws JAXRSCommonClient.Fault {
        String name = "name_1";
        String value = "value_1";
        String path = "";
        String domain = "y.x.foo.com";
        String comment = "";
        int maxage = -1;
        int version = 1;
        boolean secure = false;
        Cookie ck20 = new Cookie(name, value, path, domain);
        NewCookie nck20 = new NewCookie(ck20, comment, maxage, secure);
        JAXRSClientIT.verifyNewCookie(nck20, name, value, path, domain, version, comment, maxage, secure);
    }

    @Test
    public void constructorTest21() throws JAXRSCommonClient.Fault {
        String name = "name_1";
        String value = "value_1";
        String path = "/acme";
        String domain = "y.x.foo.com";
        String comment = "";
        int maxage = -1;
        int version = 1;
        boolean secure = false;
        Cookie ck21 = new Cookie(name, value, path, domain, version);
        NewCookie nck21 = new NewCookie(ck21, comment, maxage, secure);
        JAXRSClientIT.verifyNewCookie(nck21, name, value, path, domain, version, comment, maxage, secure);
    }

    @Test
    public void constructorTest22() throws JAXRSCommonClient.Fault {
        String name = "name_1";
        String value = "value_1";
        String path = "/acme";
        String domain = "y.x.foo.com";
        int version = 1;
        String comment = "cts test comment";
        int maxage = -1;
        boolean secure = false;
        Cookie ck22 = new Cookie(name, value, path, domain, version);
        NewCookie nck22 = new NewCookie(ck22, comment, maxage, secure);
        JAXRSClientIT.verifyNewCookie(nck22, name, value, path, domain, version, comment, maxage, secure);
    }

    @Test
    public void constructorTest23() throws JAXRSCommonClient.Fault {
        String name = "name_1";
        String value = "value_1";
        String path = "/acme";
        String domain = "y.x.foo.com";
        int version = 0;
        String comment = "cts test comment";
        int maxage = -1;
        boolean secure = false;
        Cookie ck22 = new Cookie(name, value, path, domain, version);
        NewCookie nck22 = new NewCookie(ck22, comment, maxage, secure);
        JAXRSClientIT.verifyNewCookie(nck22, name, value, path, domain, version, comment, maxage, secure);
    }

    @Test
    public void constructorTest24() throws JAXRSCommonClient.Fault {
        String name = "name_1";
        String value = "value_1";
        String path = "/acme";
        String domain = "y.x.foo.com";
        int version = 1;
        String comment = "cts test comment";
        int maxage = -1;
        boolean secure = true;
        Cookie ck24 = new Cookie(name, value, path, domain, version);
        NewCookie nck24 = new NewCookie(ck24, comment, maxage, secure);
        JAXRSClientIT.verifyNewCookie(nck24, name, value, path, domain, version, comment, maxage, secure);
    }

    @Test
    public void constructorTest25() throws JAXRSCommonClient.Fault {
        String name = "name_1";
        String value = "value_1";
        String path = "/acme";
        String domain = "y.x.foo.com";
        int version = 1;
        String comment = "cts test comment";
        int maxage = 12345;
        boolean secure = false;
        Cookie ck25 = new Cookie(name, value, path, domain, version);
        NewCookie nck25 = new NewCookie(ck25, comment, maxage, secure);
        JAXRSClientIT.verifyNewCookie(nck25, name, value, path, domain, version, comment, maxage, secure);
    }

    @Test
    public void parseTest1() throws JAXRSCommonClient.Fault {
        String NewCookie_toParse = "NAME_1=Value_1;";
        String name = "name_1";
        String value = "value_1";
        String path = "";
        String domain = "";
        int version = 1;
        NewCookie nck26 = NewCookie.valueOf((String)NewCookie_toParse);
        JAXRSClientIT.verifyNewCookie(nck26, name, value, path, domain, version, "", -1, false);
    }

    @Test
    public void parseTest2() throws JAXRSCommonClient.Fault {
        String newCookie_toParse = "Customer=WILE_E_COYOTE; Path=/acme; Version=1";
        String name = "customer";
        String value = "wile_e_coyote";
        String path = "/acme";
        String domain = "";
        int version = 1;
        NewCookie nck27 = NewCookie.valueOf((String)newCookie_toParse);
        JAXRSClientIT.verifyNewCookie(nck27, name, value, path, domain, version, "", -1, false);
    }

    @Test
    public void parseTest3() throws JAXRSCommonClient.Fault {
        try {
            NewCookie.valueOf(null);
            throw new JAXRSCommonClient.Fault("Expected IllegalArgumentException not thrown. Test Failed.");
        }
        catch (IllegalArgumentException ilex) {
            JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected");
            return;
        }
    }

    @Test
    public void equalsTest() throws JAXRSCommonClient.Fault {
        boolean pass = true;
        StringBuffer sb = new StringBuffer();
        String name = "name_1";
        String value = "value_1";
        String path = "/acme";
        String domain = "y.x.foo.com";
        int version = 1;
        Cookie ck28 = new Cookie(name, value, path, domain, version);
        String comment = "cts test comment";
        int maxage = 12345;
        boolean secure = false;
        NewCookie nck28 = new NewCookie(ck28, comment, maxage, secure);
        NewCookie nck29 = new NewCookie(name, value, path, domain, version, comment, maxage, secure);
        if (!nck28.equals((Object)nck29)) {
            pass = false;
            sb.append("Equal test failed.").append(newline);
            sb.append("First  :").append(nck28.toString()).append(newline);
            sb.append("Second :").append(nck29.toString()).append(newline);
        }
        if (nck28.hashCode() != nck29.hashCode()) {
            pass = false;
            sb.append("HashCode equal test failed.").append(newline);
        }
        if (nck28.equals((Object)(nck29 = new NewCookie(name = "name1", value, path, domain, version, comment, maxage, secure)))) {
            pass = false;
            sb.append("UnEqual test failed at name.").append(newline);
            sb.append("First  :").append(nck28.toString()).append(newline);
            sb.append("Second :").append(nck29.toString()).append(newline);
        }
        if (nck28.hashCode() == nck29.hashCode()) {
            pass = false;
            sb.append("HashCode unequal test failed at name.").append(newline);
        }
        Assertions.assertTrue((boolean)pass, (String)("At least one assertion failed: " + sb.toString()));
    }

    @Test
    public void toCookieTest() throws JAXRSCommonClient.Fault {
        boolean pass = true;
        StringBuffer sb = new StringBuffer();
        String name = "name_1";
        String value = "value_1";
        String path = "/acme";
        String domain = "y.x.foo.com";
        int version = 1;
        Cookie ck30 = new Cookie(name, value, path, domain, version);
        String comment = "cts test comment";
        int maxage = 12345;
        boolean secure = false;
        NewCookie nck30 = new NewCookie(name, value, path, domain, version, comment, maxage, secure);
        Cookie ck31 = nck30.toCookie();
        if (!ck30.equals((Object)ck31)) {
            pass = false;
            sb.append("Equal test failed.").append(newline);
            sb.append("First  :").append(ck30.toString()).append(newline);
            sb.append("Second :").append(ck31.toString()).append(newline);
        }
        if (ck30.hashCode() != ck31.hashCode()) {
            pass = false;
            sb.append("HashCode equal test failed.").append(newline);
        }
        Assertions.assertTrue((boolean)pass, (String)("At least one assertion failed: " + sb.toString()));
    }

    @Test
    public void toStringTest() throws JAXRSCommonClient.Fault {
        boolean pass = true;
        StringBuffer sb = new StringBuffer();
        String name = "name_1";
        String value = "value_1";
        String path = "/acme";
        String domain = "y.x.foo.com";
        int version = 1;
        String comment = "cts test comment";
        int maxage = 12345;
        boolean secure = false;
        List<String> tobeVerified = Arrays.asList(name, value, path, domain, Integer.valueOf(version).toString(), comment, Integer.valueOf(maxage).toString(), secure ? Boolean.valueOf(secure).toString() : null);
        NewCookie nck31 = new NewCookie(name, value, path, domain, version, comment, maxage, secure);
        String nk_String = nck31.toString();
        for (String nk_part : tobeVerified) {
            if (nk_part == null) continue;
            if (!nk_String.contains(nk_part)) {
                sb.append("Test failed.  Expected ").append(nk_part + " not faound.").append(newline);
                pass = false;
                continue;
            }
            sb.append("Expected ").append(nk_part).append(" faound.").append(newline);
        }
        sb.append("Expected NewCookie: ").append(nk_String).append(newline);
        Assertions.assertTrue((boolean)pass, (String)("At least one assertion failed: " + sb.toString()));
        TestUtil.logTrace(sb.toString());
    }

    private static boolean verifyNewCookie(NewCookie nck, String name, String value, String path, String domain, int version, String comment, int maxage, boolean secure) throws JAXRSCommonClient.Fault {
        StringBuffer sb = new StringBuffer();
        boolean pass = true;
        if (name == "" || name == null) {
            pass = false;
            sb.append("NewCookie's name is empty");
        } else if (!nck.getName().toLowerCase().equals(name)) {
            pass = false;
            sb.append("Failed name test.  Expect ").append(name).append(" got " + nck.getName());
        }
        if (value == "" || value == null) {
            pass = false;
            sb.append("NewCookie's value is empty");
        } else if (!nck.getValue().toLowerCase().equals(value)) {
            pass = false;
            sb.append("Failed value test.  Expect ").append(value).append(" got " + nck.getValue());
        }
        if (nck.getVersion() != version) {
            pass = false;
            sb.append("Failed version test.  Expect ").append(version).append(" got " + nck.getVersion());
        }
        if (comment == "" || comment == null) {
            if (nck.getComment() != "" && nck.getComment() != null) {
                pass = false;
                sb.append("Failed comment test.  Expect null String, got <" + nck.getComment()).append(">");
            }
        } else if (!nck.getComment().toLowerCase().equals(comment)) {
            pass = false;
            sb.append("Failed comment test.  Expect ").append(comment).append(" got " + nck.getComment());
        }
        if (path == "" || path == null) {
            if (nck.getPath() != "" && nck.getPath() != null) {
                pass = false;
                sb.append("Failed path test.  Expect null String, got " + nck.getPath());
            }
        } else if (nck.getPath() == null || nck.getPath() == "") {
            pass = false;
            sb.append("Failed path test.  Got null, expecting ").append(path);
        } else if (!nck.getPath().toLowerCase().equals(path)) {
            pass = false;
            sb.append("Failed path test.  Expect ").append(path).append(" got " + nck.getPath());
        }
        if (domain == "" || domain == null) {
            if (nck.getDomain() != "" && nck.getDomain() != null) {
                pass = false;
                sb.append("Failed path test.  Expect ").append(domain).append(" got " + nck.getDomain());
            }
        } else if (!nck.getDomain().toLowerCase().equals(domain)) {
            pass = false;
            sb.append("Failed domain test.  Expect ").append(domain).append(" got " + nck.getDomain());
        }
        if (nck.getMaxAge() != maxage) {
            pass = false;
            sb.append("Failed maxage test.  Expect ").append(maxage).append(" got " + nck.getMaxAge());
        }
        if (nck.isSecure() != secure) {
            pass = false;
            sb.append("Failed secure test.  Expect ").append(secure).append(" got " + nck.isSecure());
        }
        Assertions.assertTrue((boolean)pass, (String)("At least one assertion falied: " + sb.toString()));
        return pass;
    }
}

