/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.resource.webappexception.mapper;

import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.ClientErrorException;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.NotAcceptableException;
import jakarta.ws.rs.NotAllowedException;
import jakarta.ws.rs.NotAuthorizedException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.NotSupportedException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.RedirectionException;
import jakarta.ws.rs.ServerErrorException;
import jakarta.ws.rs.ServiceUnavailableException;
import jakarta.ws.rs.core.Response;

@Path(value="resource/noentity")
public class ResponseWithNoEntityUsesMapperResource {
    public static final String MESSAGE = "Use mapper";

    private static Response buildResponse(int status) {
        Response.ResponseBuilder rb = Response.status((int)status);
        return rb.build();
    }

    @Path(value="{id}")
    public Response getException(@PathParam(value="id") int id) {
        ClientErrorException wae = null;
        switch (id) {
            case 4000: {
                wae = new ClientErrorException(MESSAGE, ResponseWithNoEntityUsesMapperResource.buildResponse(400));
                break;
            }
            case 400: {
                wae = new BadRequestException(MESSAGE, ResponseWithNoEntityUsesMapperResource.buildResponse(id));
                break;
            }
            case 403: {
                wae = new ForbiddenException(MESSAGE, ResponseWithNoEntityUsesMapperResource.buildResponse(id));
                break;
            }
            case 406: {
                wae = new NotAcceptableException(MESSAGE, ResponseWithNoEntityUsesMapperResource.buildResponse(id));
                break;
            }
            case 405: {
                wae = new NotAllowedException(MESSAGE, ResponseWithNoEntityUsesMapperResource.buildResponse(id));
                break;
            }
            case 401: {
                wae = new NotAuthorizedException(MESSAGE, ResponseWithNoEntityUsesMapperResource.buildResponse(id));
                break;
            }
            case 404: {
                wae = new NotFoundException(MESSAGE, ResponseWithNoEntityUsesMapperResource.buildResponse(id));
                break;
            }
            case 415: {
                wae = new NotSupportedException(MESSAGE, ResponseWithNoEntityUsesMapperResource.buildResponse(id));
                break;
            }
            case 3000: {
                wae = new RedirectionException(MESSAGE, ResponseWithNoEntityUsesMapperResource.buildResponse(300));
                break;
            }
            case 5000: {
                wae = new ServerErrorException(MESSAGE, ResponseWithNoEntityUsesMapperResource.buildResponse(500));
                break;
            }
            case 500: {
                wae = new InternalServerErrorException(MESSAGE, ResponseWithNoEntityUsesMapperResource.buildResponse(id));
                break;
            }
            case 503: {
                wae = new ServiceUnavailableException(MESSAGE, ResponseWithNoEntityUsesMapperResource.buildResponse(id));
            }
        }
        throw wae;
    }
}

