/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.jaxrs21.ee.sse;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.client.JaxrsCommonClient;
import ee.jakarta.tck.ws.rs.common.util.Holder;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.sse.InboundSseEvent;
import jakarta.ws.rs.sse.SseEventSource;
import java.util.function.BiConsumer;
import org.junit.jupiter.api.Assertions;

public abstract class SSEJAXRSClient
extends JaxrsCommonClient {
    private static final long serialVersionUID = 21L;
    protected long millis = 550L;
    protected int sleep = -1;
    public static final String MESSAGE = "some_ServiceUnavailableEndpoint_message";

    protected Holder<InboundSseEvent> querySSEEndpoint(String endpoint) throws JAXRSCommonClient.Fault {
        return this.querySSEEndpoint(endpoint, (a, b) -> a.register(b::set));
    }

    protected Holder<InboundSseEvent> querySSEEndpoint(String endpoint, BiConsumer<SseEventSource, Holder<InboundSseEvent>> registrator) throws JAXRSCommonClient.Fault {
        Holder<InboundSseEvent> holder = new Holder<InboundSseEvent>();
        WebTarget target = ClientBuilder.newClient().target(this.getAbsoluteUrl(endpoint));
        try (SseEventSource source = SseEventSource.target((WebTarget)target).build();){
            registrator.accept(source, holder);
            source.open();
            this.sleep = this.sleepUntilHolderGetsFilled(holder);
            Assertions.assertTrue((boolean)source.isOpen(), (String)"SseEventSource#isOpen returns false");
        }
        catch (Exception e) {
            throw new JAXRSCommonClient.Fault(e);
        }
        SSEJAXRSClient.assertNotNull(holder.get(), "The message was not received");
        return holder;
    }

    protected void querySSEEndpointAndAssert(String endpoint) throws JAXRSCommonClient.Fault {
        Holder<InboundSseEvent> holder = this.querySSEEndpoint(endpoint);
        SSEJAXRSClient.assertEquals(MESSAGE, holder.get().readData(), "Unexpected message received", holder.get().readData());
    }

    protected <T> int sleepUntilHolderGetsFilled(Holder<T> holder) {
        try {
            for (int i = 0; i != 7; ++i) {
                Thread.sleep(this.millis);
                if (holder.get() == null) continue;
                return i + 1;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return 7;
    }
}

