/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */


/*
 *  @(#)DefaultMappingTest.test.xml	1.1 07/04/19 auto generated
 * Generated from : java2schema/DefaultMapping/DefaultMappingTest.test.xml
 *
 * Tests to check default mapping
 */

package javasoft.sqe.tests.api.JAXB.DefaultMapping;

import javasoft.sqe.javatest.Status;


public class DefaultMappingTestTests extends javasoft.sqe.tests.api.jakarta.xml.bind.SchemaGenTestExt {

    /* standalone interface */
    public static void main(String argv[]) {
        DefaultMappingTestTests test = new DefaultMappingTestTests();
        test.run(argv, System.err, System.out).exit();
    }

    /**
     * Functional tests for DefaultMapping,
     * tests mapping 'null' to 'java.lang.Boolean'.
     */
    public Status BooleanTest() {
        checkElementType( "booleanTest", "java.lang.Boolean", "http://www.w3.org/2001/XMLSchema", "boolean" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping 'null' to 'java.lang.Byte'.
     */
    public Status ByteTest() {
        checkElementType( "byteTest", "java.lang.Byte", "http://www.w3.org/2001/XMLSchema", "byte" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping 'null' to 'java.lang.Short'.
     */
    public Status ShortTest() {
        checkElementType( "shortTest", "java.lang.Short", "http://www.w3.org/2001/XMLSchema", "short" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping 'null' to 'java.lang.Integer'.
     */
    public Status IntegerTest() {
        checkElementType( "integerTest", "java.lang.Integer", "http://www.w3.org/2001/XMLSchema", "int" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping 'null' to 'java.lang.Long'.
     */
    public Status LongTest() {
        checkElementType( "longTest", "java.lang.Long", "http://www.w3.org/2001/XMLSchema", "long" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping 'null' to 'java.lang.Float'.
     */
    public Status FloatTest() {
        checkElementType( "floatTest", "java.lang.Float", "http://www.w3.org/2001/XMLSchema", "float" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping 'null' to 'java.lang.Double'.
     */
    public Status DoubleTest() {
        checkElementType( "doubleTest", "java.lang.Double", "http://www.w3.org/2001/XMLSchema", "double" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping 'null' to 'java.lang.String'.
     */
    public Status StringTest() {
        checkElementType( "stringTest", "java.lang.String", "http://www.w3.org/2001/XMLSchema", "string" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping 'null' to 'java.math.BigInteger'.
     */
    public Status BigIntegerTest() {
        checkElementType( "bigIntegerTest", "java.math.BigInteger", "http://www.w3.org/2001/XMLSchema", "integer" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping 'null' to 'java.math.BigDecimal'.
     */
    public Status BigDecimalTest() {
        checkElementType( "bigDecimalTest", "java.math.BigDecimal", "http://www.w3.org/2001/XMLSchema", "decimal" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping 'null' to 'java.util.Calendar'.
     */
    public Status CalendarTest() {
        checkElementType( "calendarTest", "java.util.Calendar", "http://www.w3.org/2001/XMLSchema", "dateTime" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping 'null' to 'java.util.Date'.
     */
    public Status DateTest() {
        checkElementType( "dateTest", "java.util.Date", "http://www.w3.org/2001/XMLSchema", "dateTime" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping 'null' to 'javax.xml.namespace.QName'.
     */
    public Status QNameTest() {
        checkElementType( "qNameTest", "javax.xml.namespace.QName", "http://www.w3.org/2001/XMLSchema", "QName" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping 'null' to 'java.net.URI'.
     */
    public Status URITest() {
        checkElementType( "uriTest", "java.net.URI", "http://www.w3.org/2001/XMLSchema", "string" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping 'null' to 'javax.xml.datatype.XMLGregorianCalendar'.
     */
    public Status XMLGregorianCalendarTest() {
        checkElementType( "xmlGregorianCalendarTest", "javax.xml.datatype.XMLGregorianCalendar", "http://www.w3.org/2001/XMLSchema", "anySimpleType" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping 'null' to 'javax.xml.datatype.Duration'.
     */
    public Status DurationTest() {
        checkElementType( "durationTest", "javax.xml.datatype.Duration", "http://www.w3.org/2001/XMLSchema", "duration" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping 'null' to 'java.lang.Object'.
     */
    public Status ObjectTest() {
        checkElementType( "objectTest", "java.lang.Object", "http://www.w3.org/2001/XMLSchema", "anyType" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping 'null' to 'java.awt.Image'.
     */
    public Status ImageTest() {
        checkElementType( "imageTest", "java.awt.Image", "http://www.w3.org/2001/XMLSchema", "base64Binary" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping 'null' to 'jakarta.activation.DataHandler'.
     */
    public Status DataHandlerTest() {
        checkElementType( "dataHandlerTest", "jakarta.activation.DataHandler", "http://www.w3.org/2001/XMLSchema", "base64Binary" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping 'null' to 'javax.xml.transform.Source'.
     */
    public Status SourceTest() {
        checkElementType( "sourceTest", "javax.xml.transform.Source", "http://www.w3.org/2001/XMLSchema", "base64Binary" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping 'null' to 'java.util.UUID'.
     */
    public Status UUIDTest() {
        checkElementType( "uuidTest", "java.util.UUID", "http://www.w3.org/2001/XMLSchema", "string" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping 'null' to 'byte[]'.
     */
    public Status ByteArrayTest() {
        checkElementType( "byteArrayTest", "byte[]", "http://www.w3.org/2001/XMLSchema", "base64Binary" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping '&lt;T&gt;'' to 'T'.
     */
    public Status GenericTTest() {
        checkElementType( "genericTTest", "T", "http://www.w3.org/2001/XMLSchema", "anyType" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping '&lt;T extends javax.xml.namespace.QName&gt;'' to 'T'.
     */
    public Status GenericTExtendsTest() {
        checkElementType( "genericTExtendsTest", "T", "http://www.w3.org/2001/XMLSchema", "QName" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping 'null' to 'java.util.List&lt;? extends javax.xml.namespace.QName&gt;''.
     */
    public Status ListGenericExtendsTest() {
        checkElementType( "listGenericExtendsTest", "java.util.List<? extends javax.xml.namespace.QName>", "http://www.w3.org/2001/XMLSchema", "QName" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping 'null' to 'java.util.List&lt;? super javax.xml.namespace.QName&gt;''.
     */
    public Status ListGenericSuperTest() {
        checkElementType( "listGenericSuperTest", "java.util.List<? super javax.xml.namespace.QName>", "http://www.w3.org/2001/XMLSchema", "anyType" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping of 'java.util.Collection' container.
     */
    public Status java$util$CollectionTest() {
        checkContainer( "java.util.CollectionTest", "ContainersTest", "f0" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping of 'java.beans.beancontext.BeanContext' container.
     */
    public Status java$beans$beancontext$BeanContextTest() {
        checkContainer( "java.beans.beancontext.BeanContextTest", "ContainersTest", "f1" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping of 'java.beans.beancontext.BeanContextServices' container.
     */
    public Status java$beans$beancontext$BeanContextServicesTest() {
        checkContainer( "java.beans.beancontext.BeanContextServicesTest", "ContainersTest", "f2" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping of 'java.util.concurrent.BlockingQueue' container.
     */
    public Status java$util$concurrent$BlockingQueueTest() {
        checkContainer( "java.util.concurrent.BlockingQueueTest", "ContainersTest", "f3" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping of 'java.util.List' container.
     */
    public Status java$util$ListTest() {
        checkContainer( "java.util.ListTest", "ContainersTest", "f4" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping of 'java.util.Queue' container.
     */
    public Status java$util$QueueTest() {
        checkContainer( "java.util.QueueTest", "ContainersTest", "f5" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping of 'java.util.Set' container.
     */
    public Status java$util$SetTest() {
        checkContainer( "java.util.SetTest", "ContainersTest", "f6" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping of 'java.util.SortedSet' container.
     */
    public Status java$util$SortedSetTest() {
        checkContainer( "java.util.SortedSetTest", "ContainersTest", "f7" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping of 'java.util.AbstractCollection' container.
     */
    public Status java$util$AbstractCollectionTest() {
        checkContainer( "java.util.AbstractCollectionTest", "ContainersTest", "f8" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping of 'java.util.AbstractList' container.
     */
    public Status java$util$AbstractListTest() {
        checkContainer( "java.util.AbstractListTest", "ContainersTest", "f9" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping of 'java.util.AbstractQueue' container.
     */
    public Status java$util$AbstractQueueTest() {
        checkContainer( "java.util.AbstractQueueTest", "ContainersTest", "f10" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping of 'java.util.AbstractSequentialList' container.
     */
    public Status java$util$AbstractSequentialListTest() {
        checkContainer( "java.util.AbstractSequentialListTest", "ContainersTest", "f11" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping of 'java.util.AbstractSet' container.
     */
    public Status java$util$AbstractSetTest() {
        checkContainer( "java.util.AbstractSetTest", "ContainersTest", "f12" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping of 'java.util.concurrent.ArrayBlockingQueue' container.
     */
    public Status java$util$concurrent$ArrayBlockingQueueTest() {
        checkContainer( "java.util.concurrent.ArrayBlockingQueueTest", "ContainersTest", "f13" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping of 'java.util.ArrayList' container.
     */
    public Status java$util$ArrayListTest() {
        checkContainer( "java.util.ArrayListTest", "ContainersTest", "f14" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping of 'javax.management.AttributeList' container.
     */
    public Status javax$management$AttributeListTest() {
        checkContainer( "javax.management.AttributeListTest", "ContainersTest", "f15" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping of 'java.beans.beancontext.BeanContextServicesSupport' container.
     */
    public Status java$beans$beancontext$BeanContextServicesSupportTest() {
        checkContainer( "java.beans.beancontext.BeanContextServicesSupportTest", "ContainersTest", "f16" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping of 'java.beans.beancontext.BeanContextSupport' container.
     */
    public Status java$beans$beancontext$BeanContextSupportTest() {
        checkContainer( "java.beans.beancontext.BeanContextSupportTest", "ContainersTest", "f17" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping of 'java.util.concurrent.ConcurrentLinkedQueue' container.
     */
    public Status java$util$concurrent$ConcurrentLinkedQueueTest() {
        checkContainer( "java.util.concurrent.ConcurrentLinkedQueueTest", "ContainersTest", "f18" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping of 'java.util.concurrent.CopyOnWriteArrayList' container.
     */
    public Status java$util$concurrent$CopyOnWriteArrayListTest() {
        checkContainer( "java.util.concurrent.CopyOnWriteArrayListTest", "ContainersTest", "f19" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping of 'java.util.concurrent.CopyOnWriteArraySet' container.
     */
    public Status java$util$concurrent$CopyOnWriteArraySetTest() {
        checkContainer( "java.util.concurrent.CopyOnWriteArraySetTest", "ContainersTest", "f20" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping of 'java.util.HashSet' container.
     */
    public Status java$util$HashSetTest() {
        checkContainer( "java.util.HashSetTest", "ContainersTest", "f22" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping of 'java.util.concurrent.LinkedBlockingQueue' container.
     */
    public Status java$util$concurrent$LinkedBlockingQueueTest() {
        checkContainer( "java.util.concurrent.LinkedBlockingQueueTest", "ContainersTest", "f23" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping of 'java.util.LinkedHashSet' container.
     */
    public Status java$util$LinkedHashSetTest() {
        checkContainer( "java.util.LinkedHashSetTest", "ContainersTest", "f24" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping of 'java.util.LinkedList' container.
     */
    public Status java$util$LinkedListTest() {
        checkContainer( "java.util.LinkedListTest", "ContainersTest", "f25" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping of 'java.util.concurrent.PriorityBlockingQueue' container.
     */
    public Status java$util$concurrent$PriorityBlockingQueueTest() {
        checkContainer( "java.util.concurrent.PriorityBlockingQueueTest", "ContainersTest", "f26" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping of 'java.util.PriorityQueue' container.
     */
    public Status java$util$PriorityQueueTest() {
        checkContainer( "java.util.PriorityQueueTest", "ContainersTest", "f27" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping of 'javax.management.relation.RoleList' container.
     */
    public Status javax$management$relation$RoleListTest() {
        checkContainer( "javax.management.relation.RoleListTest", "ContainersTest", "f28" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping of 'javax.management.relation.RoleUnresolvedList' container.
     */
    public Status javax$management$relation$RoleUnresolvedListTest() {
        checkContainer( "javax.management.relation.RoleUnresolvedListTest", "ContainersTest", "f29" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping of 'java.util.Stack' container.
     */
    public Status java$util$StackTest() {
        checkContainer( "java.util.StackTest", "ContainersTest", "f30" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping of 'java.util.concurrent.SynchronousQueue' container.
     */
    public Status java$util$concurrent$SynchronousQueueTest() {
        checkContainer( "java.util.concurrent.SynchronousQueueTest", "ContainersTest", "f31" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping of 'java.util.TreeSet' container.
     */
    public Status java$util$TreeSetTest() {
        checkContainer( "java.util.TreeSetTest", "ContainersTest", "f32" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping of 'java.util.Vector' container.
     */
    public Status java$util$VectorTest() {
        checkContainer( "java.util.VectorTest", "ContainersTest", "f33" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping of 'java.util.Map' map.
     */
    public Status java$util$MapTest() {
        checkMap( "java.util.MapTest", "MapTest", "f0" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping of 'java.util.concurrent.ConcurrentMap' map.
     */
    public Status java$util$concurrent$ConcurrentMapTest() {
        checkMap( "java.util.concurrent.ConcurrentMapTest", "ConcurrentMapTest", "f0" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping of 'java.util.SortedMap' map.
     */
    public Status java$util$SortedMapTest() {
        checkMap( "java.util.SortedMapTest", "SortedMapTest", "f0" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping of 'java.util.AbstractMap' map.
     */
    public Status java$util$AbstractMapTest() {
        checkMap( "java.util.AbstractMapTest", "AbstractMapTest", "f0" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping of 'java.util.jar.Attributes' map.
     */
    public Status java$util$jar$AttributesTest() {
        checkMap( "java.util.jar.AttributesTest", "AttributesTest", "f0" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping of 'java.security.AuthProvider' map.
     */
    public Status java$security$AuthProviderTest() {
        checkMap( "java.security.AuthProviderTest", "AuthProviderTest", "f0" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping of 'java.util.concurrent.ConcurrentHashMap' map.
     */
    public Status java$util$concurrent$ConcurrentHashMapTest() {
        checkMap( "java.util.concurrent.ConcurrentHashMapTest", "ConcurrentHashMapTest", "f0" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping of 'java.util.HashMap' map.
     */
    public Status java$util$HashMapTest() {
        checkMap( "java.util.HashMapTest", "HashMapTest", "f0" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping of 'java.util.Hashtable' map.
     */
    public Status java$util$HashtableTest() {
        checkMap( "java.util.HashtableTest", "HashtableTest", "f0" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping of 'java.util.IdentityHashMap' map.
     */
    public Status java$util$IdentityHashMapTest() {
        checkMap( "java.util.IdentityHashMapTest", "IdentityHashMapTest", "f0" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping of 'java.util.LinkedHashMap' map.
     */
    public Status java$util$LinkedHashMapTest() {
        checkMap( "java.util.LinkedHashMapTest", "LinkedHashMapTest", "f0" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping of 'java.util.Properties' map.
     */
    public Status java$util$PropertiesTest() {
        checkMap( "java.util.PropertiesTest", "PropertiesTest", "f0" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping of 'java.security.Provider' map.
     */
    public Status java$security$ProviderTest() {
        checkMap( "java.security.ProviderTest", "ProviderTest", "f0" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping of 'java.awt.RenderingHints' map.
     */
    public Status java$awt$RenderingHintsTest() {
        checkMap( "java.awt.RenderingHintsTest", "RenderingHintsTest", "f0" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping of 'javax.management.openmbean.TabularDataSupport' map.
     */
    public Status javax$management$openmbean$TabularDataSupportTest() {
        checkMap( "javax.management.openmbean.TabularDataSupportTest", "TabularDataSupportTest", "f0" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping of 'java.util.TreeMap' map.
     */
    public Status java$util$TreeMapTest() {
        checkMap( "java.util.TreeMapTest", "TreeMapTest", "f0" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping of 'javax.swing.UIDefaults' map.
     */
    public Status javax$swing$UIDefaultsTest() {
        checkMap( "javax.swing.UIDefaultsTest", "UIDefaultsTest", "f0" ); return Status.passed("OK");}

    /**
     * Functional tests for DefaultMapping,
     * tests mapping of 'java.util.WeakHashMap' map.
     */
    public Status java$util$WeakHashMapTest() {
        checkMap( "java.util.WeakHashMapTest", "WeakHashMapTest", "f0" ); return Status.passed("OK");}
}
