/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaspic.tssv.config;

import com.sun.ts.tests.jaspic.tssv.module.servlet.TSServerAuthModule;
import com.sun.ts.tests.jaspic.tssv.module.servlet.TSServletWrapperSAM;
import com.sun.ts.tests.jaspic.tssv.module.soap.TSAuthExceptionServerAuthModule;
import com.sun.ts.tests.jaspic.tssv.module.soap.TSFailureServerAuthModule;
import com.sun.ts.tests.jaspic.tssv.module.soap.TSSendFailureServerAuthModule;
import com.sun.ts.tests.jaspic.tssv.module.soap.TSSendSuccessServerAuthModule;
import com.sun.ts.tests.jaspic.tssv.util.TSLogger;
import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.AuthStatus;
import jakarta.security.auth.message.MessageInfo;
import jakarta.security.auth.message.MessagePolicy;
import jakarta.security.auth.message.config.ServerAuthContext;
import jakarta.security.auth.message.module.ServerAuthModule;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.util.Map;
import java.util.logging.Level;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;

public class TSServerAuthContext
implements ServerAuthContext {
    private static ServerAuthModule serverAuthModule = null;
    private static String messageLayer = null;
    private static String appContext = null;
    private static CallbackHandler handler = null;
    private static String operation = null;
    private static Subject clientSubject = null;
    private static Map properties = null;
    private static TSLogger logger = null;
    private static String soapUPTokenAppContext = "HelloService HelloPort";
    private static String servletUPTokenAppContext = "spitests_servlet_web";
    private static MessageInfo messageInfoFromVerifyReq = null;
    private static boolean isMandatory = false;

    public TSServerAuthContext() {
    }

    public TSServerAuthContext(String messageLayer, String appContext, CallbackHandler handler, String operation, Subject clientSubject, Map properties, boolean isAuthMandatory, TSLogger tsLogger) throws AuthException {
        this(messageLayer, appContext, handler, operation, clientSubject, properties);
        logger = tsLogger;
        logger.log(Level.INFO, "TSServerAuthContext called");
        String logStr = "TSServerAuthContext called for messageLayer=" + messageLayer + " : appContext=" + appContext;
        logger.log(Level.INFO, logStr);
        logStr = logStr + " : operation=" + operation;
        logger.log(Level.INFO, logStr);
        Object sam = null;
        properties.put("TSLogger", logger);
        isMandatory = isAuthMandatory;
        MessagePolicy.TargetPolicy msgTargetPolicy = new MessagePolicy.TargetPolicy(null, new MessagePolicy.ProtectionPolicy(){

            public String getID() {
                return "#authenticateSender";
            }
        });
        MessagePolicy.TargetPolicy[] msgTargetPolicies = new MessagePolicy.TargetPolicy[]{msgTargetPolicy};
        MessagePolicy requestMessagePolicy = new MessagePolicy(msgTargetPolicies, isMandatory);
        MessagePolicy.TargetPolicy msgTargetPolicyContent = new MessagePolicy.TargetPolicy(null, new MessagePolicy.ProtectionPolicy(){

            public String getID() {
                return "#authenticateContent";
            }
        });
        MessagePolicy.TargetPolicy[] msgTargetPoliciesContent = new MessagePolicy.TargetPolicy[]{msgTargetPolicyContent};
        MessagePolicy responseMessagePolicy = new MessagePolicy(msgTargetPoliciesContent, isMandatory);
        if (messageLayer.equals("SOAP")) {
            sam = new com.sun.ts.tests.jaspic.tssv.module.soap.TSServerAuthModule();
            if (appContext.equals(soapUPTokenAppContext)) {
                sam.initialize(requestMessagePolicy, responseMessagePolicy, handler, properties);
            } else if (appContext.indexOf("SendSuccessHello") > -1) {
                sam = new TSSendSuccessServerAuthModule();
                sam.initialize(null, null, handler, properties);
            } else if (appContext.indexOf("SendFailureHello") > -1) {
                sam = new TSSendFailureServerAuthModule();
                sam.initialize(null, null, handler, properties);
            } else if (appContext.indexOf("FailureHello") > -1) {
                sam = new TSFailureServerAuthModule();
                sam.initialize(null, null, handler, properties);
            } else if (appContext.indexOf("AuthExceptionHello") > -1) {
                sam = new TSAuthExceptionServerAuthModule();
                sam.initialize(null, null, handler, properties);
            } else {
                sam = new com.sun.ts.tests.jaspic.tssv.module.soap.TSServerAuthModule();
                sam.initialize(null, null, handler, properties);
            }
        } else if (messageLayer.equals("HttpServlet")) {
            System.out.println("AppContext =" + appContext);
            if (appContext.contains(servletUPTokenAppContext) && operation.contains("WrapperServlet")) {
                sam = new TSServletWrapperSAM();
                sam.initialize(requestMessagePolicy, responseMessagePolicy, handler, properties);
            } else if (appContext.contains(servletUPTokenAppContext)) {
                sam = new TSServerAuthModule();
                sam.initialize(requestMessagePolicy, responseMessagePolicy, handler, properties);
            } else {
                sam = new TSServerAuthModule();
                sam.initialize(requestMessagePolicy, null, handler, properties);
            }
        }
        serverAuthModule = sam;
    }

    private TSServerAuthContext(String layer, String appCtxt, CallbackHandler hndlr, String optn, Subject cliSubject, Map props) throws AuthException {
        messageLayer = layer;
        appContext = appCtxt;
        handler = hndlr;
        operation = optn;
        clientSubject = cliSubject;
        properties = props;
    }

    public AuthStatus validateRequest(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws AuthException {
        Object reqObj = null;
        Object msg = "TSServerAuthContext.validateRequest called";
        logger.log(Level.INFO, (String)msg);
        msg = (String)msg + " for layer=" + messageLayer;
        logger.log(Level.INFO, (String)msg);
        if (messageInfo != null) {
            reqObj = messageInfo.getRequestMessage();
            if (reqObj != null) {
                if (reqObj instanceof HttpServletRequest) {
                    String contextPath = ((HttpServletRequest)reqObj).getContextPath();
                    String servletPath = ((HttpServletRequest)reqObj).getServletPath();
                    String requestURI = contextPath + servletPath;
                    msg = (String)msg + " for requestURI=" + requestURI;
                } else {
                    msg = (String)msg + " reqObj instanceof=" + reqObj.getClass().getName();
                }
            } else {
                msg = (String)msg + " reqObj=NULL";
            }
        }
        String subjStr = messageLayer + " profile: ";
        subjStr = clientSubject != null ? subjStr + "TSServerAuthContext.validateRequest called with non-null client Subject" : subjStr + "TSServerAuthContext.validateRequest called with null client Subject";
        logger.log(Level.INFO, subjStr);
        this.verifyClientSubject(clientSubject);
        this.verifyServiceSubject(serviceSubject);
        AuthStatus rval = serverAuthModule.validateRequest(messageInfo, clientSubject, serviceSubject);
        logger.log(Level.INFO, (String)msg);
        this.dumpAuthStatusString(rval, (String)msg);
        messageInfoFromVerifyReq = messageInfo;
        return rval;
    }

    public void dumpAuthStatusString(AuthStatus rval, String msg) {
        if (msg == null) {
            msg = "";
        }
        msg = rval == AuthStatus.SUCCESS ? (String)msg + " AuthStatus=AuthStatus.SUCCESS" : (rval == AuthStatus.FAILURE ? (String)msg + " AuthStatus=AuthStatus.FAILURE" : (rval == AuthStatus.SEND_SUCCESS ? (String)msg + " AuthStatus=AuthStatus.SEND_SUCCESS" : (rval == AuthStatus.SEND_FAILURE ? (String)msg + " AuthStatus=AuthStatus.SEND_FAILURE" : (rval == AuthStatus.SEND_CONTINUE ? (String)msg + " AuthStatus=AuthStatus.SEND_CONTINUE" : (String)msg + " AuthStatus=" + rval))));
        logger.log(Level.INFO, (String)msg);
    }

    public void verifyClientSubject(Subject clientSubject) {
        String msg = "";
        msg = clientSubject == null ? "FAILURE detected - ClientSubjects should not be null." : "Valid ClientSubjects - it was not null.";
        logger.log(Level.INFO, msg);
        if (clientSubject != null) {
            msg = clientSubject.isReadOnly() ? "FAILURE detected - ClientSubjects should not be read-only." : "Valid ClientSubjects - it was not read-only.";
            logger.log(Level.INFO, msg);
        }
    }

    public void verifyServiceSubject(Subject serviceSubject) {
        String msg = "";
        String key = "com.sun.ts.tests.jaspic.serviceSubjectKey";
        Subject value = (Subject)properties.get(key);
        if (value != null) {
            msg = "got a non-null subject out of the map";
            logger.log(Level.INFO, msg);
            msg = serviceSubject == null ? "FAILURE detected - ServiceSubjects should be the same and are not." : (value.equals(serviceSubject) ? "ServiceSubjects correctly matched." : "FAILURE detected - ServiceSubjects should be the same and are not.");
            logger.log(Level.INFO, msg);
            if (serviceSubject != null && value.equals(serviceSubject)) {
                if (serviceSubject.isReadOnly()) {
                    msg = "FAILURE detected - ServiceSubjects should not be read-only.";
                    logger.log(Level.INFO, msg);
                } else {
                    msg = "Valid ServiceSubjects - it was not read-only.";
                    logger.log(Level.INFO, msg);
                }
            }
        }
    }

    public AuthStatus secureResponse(MessageInfo messageInfo, Subject serviceSubject) throws AuthException {
        AuthStatus rval = AuthStatus.SUCCESS;
        Object reqObj = null;
        Object respObj = null;
        Object msg = "TSServerAuthContext.secureResponse called";
        logger.log(Level.INFO, (String)msg);
        msg = "secureResponse called for layer=" + messageLayer;
        try {
            if (messageInfo != null) {
                this.verifyMessageInfoObjsMatch(messageInfo);
                reqObj = messageInfo.getRequestMessage();
                respObj = messageInfo.getResponseMessage();
                if (reqObj != null) {
                    if (reqObj instanceof HttpServletRequest) {
                        String contextPath = ((HttpServletRequest)reqObj).getContextPath();
                        String servletPath = ((HttpServletRequest)reqObj).getServletPath();
                        String requestURI = contextPath + servletPath;
                        msg = (String)msg + " for requestURI=" + requestURI;
                    } else {
                        msg = (String)msg + " reqObj instanceof=" + reqObj.getClass().getName();
                    }
                } else {
                    msg = (String)msg + " reqObj=NULL";
                }
            }
            logger.log(Level.INFO, (String)msg);
            this.verifySecureRespServiceSubject(serviceSubject);
            rval = serverAuthModule.secureResponse(messageInfo, serviceSubject);
            msg = "";
            this.dumpAuthStatusString(rval, (String)msg);
            if (rval.equals(AuthStatus.SUCCESS)) {
                if (respObj != null) {
                    ((HttpServletResponse)respObj).setStatus(200);
                    HttpServletResponseWrapper respWrapper = null;
                    if (!(reqObj instanceof HttpServletResponseWrapper)) {
                        respWrapper = new HttpServletResponseWrapper((HttpServletResponse)respObj);
                        respWrapper.setStatus(200);
                        messageInfo.setResponseMessage((Object)respWrapper);
                    } else {
                        messageInfo.setResponseMessage((Object)((HttpServletResponse)respObj));
                    }
                    logger.log(Level.INFO, "Set the responseObjects return status to OK==200");
                } else {
                    logger.log(Level.INFO, "ResponseObject == null so we could NOT set response status");
                }
            } else {
                logger.log(Level.INFO, "authStatus != SUCCESS so not setting response object status == 200");
            }
        }
        catch (AuthException ex) {
            logger.log(Level.INFO, "Got AuthException");
            ex.printStackTrace();
            throw ex;
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "Got generic Exception");
            ex.printStackTrace();
        }
        return rval;
    }

    public void verifyMessageInfoObjsMatch(MessageInfo messageInfo) {
        Object err = "FAILURE:  MessageInfo object in secureRequest does not";
        err = (String)err + " match the messageInfo object from validateRequest";
        Object msg = "MessageInfo object from secureRequest matches the ";
        msg = (String)msg + " messageInfo object from validateRequest";
        if (messageInfo == null && messageInfoFromVerifyReq == null) {
            logger.log(Level.INFO, (String)msg);
        } else if (messageInfo == null || messageInfoFromVerifyReq == null) {
            logger.log(Level.INFO, (String)err);
            if (messageInfo == null) {
                msg = "Failure: secureRequest had null obj but validateRequest did not";
                logger.log(Level.INFO, (String)msg);
            } else {
                msg = "Failure: validateRequest had null obj but secureResponse did not";
                logger.log(Level.INFO, (String)msg);
            }
        } else if (!messageInfoFromVerifyReq.equals(messageInfo)) {
            logger.log(Level.INFO, (String)err);
            logger.log(Level.INFO, "FAILURE: messageInfo objects non-null but don't match");
        } else {
            logger.log(Level.INFO, (String)msg);
        }
    }

    public void verifySecureRespServiceSubject(Subject serviceSubject) {
        String msg = "";
        String key = "com.sun.ts.tests.jaspic.serviceSubjectKey";
        Subject value = (Subject)properties.get(key);
        if (value != null) {
            msg = "got a non-null subject out of the map";
            logger.log(Level.INFO, msg);
            msg = serviceSubject == null ? "FAILURE detected - SecureResponse ServiceSubjects should be the same and are not." : (value.equals(serviceSubject) ? "SecureResponse ServiceSubjects correctly matched." : "FAILURE detected - SecureResponse ServiceSubjects should be the same and are not.");
            logger.log(Level.INFO, msg);
            if (serviceSubject != null && value.equals(serviceSubject)) {
                if (serviceSubject.isReadOnly()) {
                    msg = "FAILURE detected - SecureResponse ServiceSubjects should not be read-only.";
                    logger.log(Level.INFO, msg);
                } else {
                    msg = "Valid SecureResponse ServiceSubjects - it was not read-only.";
                    logger.log(Level.INFO, msg);
                }
            }
        }
    }

    public void cleanSubject(MessageInfo messageInfo, Subject subject) throws AuthException {
        logger.log(Level.INFO, "TSServerAuthContext.cleanSubject called");
        serverAuthModule.cleanSubject(messageInfo, subject);
    }
}

