/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.jsonp.api.jsonarraytests;

import ee.jakarta.tck.jsonp.api.common.TestResult;
import ee.jakarta.tck.jsonp.api.jsonarraytests.ArrayBuildAdd;
import ee.jakarta.tck.jsonp.api.jsonarraytests.ArrayBuildRemove;
import ee.jakarta.tck.jsonp.api.jsonarraytests.ArrayBuildSet;
import ee.jakarta.tck.jsonp.api.jsonarraytests.ArrayBuilders;
import ee.jakarta.tck.jsonp.common.JSONP_Util;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonReader;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import jakarta.json.JsonWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ClientTests {
    private static final Logger LOGGER = Logger.getLogger(ClientTests.class.getName());

    @Test
    public void jsonArrayTest1() {
        try {
            JsonArray myJsonArray;
            LOGGER.info("Create sample JsonObject for testing");
            JsonObject object = JSONP_Util.createSampleJsonObject();
            LOGGER.info("Create sample JsonArray for testing");
            JsonArray array = JSONP_Util.createSampleJsonArray();
            LOGGER.info("Create the expected list of JsonArray values");
            ArrayList<Object> expList = new ArrayList<Object>();
            expList.add(JsonValue.FALSE);
            expList.add(JsonValue.TRUE);
            expList.add(JsonValue.NULL);
            expList.add(JSONP_Util.createJsonNumber((double)Double.MIN_VALUE));
            expList.add(JSONP_Util.createJsonNumber((double)Double.MAX_VALUE));
            expList.add(JSONP_Util.createJsonNumber((int)Integer.MIN_VALUE));
            expList.add(JSONP_Util.createJsonNumber((int)Integer.MAX_VALUE));
            expList.add(JSONP_Util.createJsonNumber((long)Long.MIN_VALUE));
            expList.add(JSONP_Util.createJsonNumber((long)Long.MAX_VALUE));
            expList.add(JSONP_Util.createJsonNumber((BigDecimal)BigDecimal.valueOf(1.2345678912345679E8)));
            expList.add(JSONP_Util.createJsonNumber((BigInteger)new BigInteger("123456789")));
            expList.add(JSONP_Util.createJsonString((String)"string1"));
            expList.add(object);
            expList.add(array);
            JSONP_Util.dumpList(expList, (String)"Expected List");
            LOGGER.info("Create JsonArray using all JsonArrayBuilder API's");
            JsonArray actualList = myJsonArray = Json.createArrayBuilder().add(JsonValue.FALSE).add(JsonValue.TRUE).add(JsonValue.NULL).add(Double.MIN_VALUE).add(Double.MAX_VALUE).add(Integer.MIN_VALUE).add(Integer.MAX_VALUE).add(Long.MIN_VALUE).add(Long.MAX_VALUE).add(BigDecimal.valueOf(1.2345678912345679E8)).add(new BigInteger("123456789")).add("string1").add((JsonValue)object).add((JsonValue)array).build();
            JSONP_Util.dumpList((List)actualList, (String)"Actual List");
            LOGGER.info("Compare actual list of JsonArray values with expected list of JsonArray values");
            Assertions.assertTrue((boolean)JSONP_Util.assertEqualsList(expList, (List)actualList), (String)"jsonArrayTest1 Failed");
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonArrayTest1 Failed: ", (Throwable)e);
        }
    }

    @Test
    public void jsonArrayTest2() {
        try {
            JsonArray myJsonArray2;
            LOGGER.info("Create sample JsonObject for testing");
            JsonObject object = JSONP_Util.createSampleJsonObject();
            LOGGER.info("Create sample JsonArray for testing");
            JsonArray array = JSONP_Util.createSampleJsonArray();
            LOGGER.info("Create JsonArray 'myJsonArray1' using all JsonArrayBuilder API's");
            JsonArray myJsonArray1 = Json.createArrayBuilder().add(JsonValue.FALSE).add(JsonValue.TRUE).add(JsonValue.NULL).add(Double.MIN_VALUE).add(Double.MAX_VALUE).add(Integer.MIN_VALUE).add(Integer.MAX_VALUE).add(Long.MIN_VALUE).add(Long.MAX_VALUE).add(BigDecimal.valueOf(1.2345678912345679E8)).add(new BigInteger("123456789")).add("string1").add((JsonValue)object).add((JsonValue)array).build();
            LOGGER.info("Write the JsonArray 'myJsonArray1' out to a JsonWriter");
            StringWriter sw = new StringWriter();
            try (JsonWriter writer = Json.createWriter((Writer)sw);){
                writer.writeArray(myJsonArray1);
                LOGGER.info("Close JsonWriter");
            }
            LOGGER.info("Save contents of the JsonWriter as a String");
            String contents = sw.toString();
            LOGGER.info("Dump contents of JsonWriter as a String");
            LOGGER.info("JsonWriterContents=" + contents);
            LOGGER.info("Read the JsonArray back into 'myJsonArray2' using a JsonReader");
            try (JsonReader reader = Json.createReader((Reader)new StringReader(contents));){
                myJsonArray2 = reader.readArray();
            }
            LOGGER.info("Dump contents of JsonArray read from String Contents");
            JSONP_Util.dumpJsonValue((JsonValue)myJsonArray2);
            LOGGER.info("Compare myJsonArray1 and myJsonArray2 for equality");
            Assertions.assertTrue((boolean)JSONP_Util.assertEqualsJsonArrays((JsonArray)myJsonArray1, (JsonArray)myJsonArray2), (String)"jsonArrayTest2 Failed");
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonArrayTest2 Failed: ", (Throwable)e);
        }
    }

    @Test
    public void jsonArrayTest3() {
        boolean pass = true;
        try {
            int i;
            LOGGER.info("Create sample JsonObject for testing");
            JsonObject object = JSONP_Util.createSampleJsonObject();
            LOGGER.info("Create sample JsonArray for testing");
            JsonArray array = JSONP_Util.createSampleJsonArray();
            int[] expInt = new int[]{-1, 1, 1, -1000, 1000, 1000, -2000, 2000, 2000, Integer.MAX_VALUE, Integer.MIN_VALUE};
            long[] expLong = new long[]{Long.MAX_VALUE, Long.MIN_VALUE};
            double[] expDouble = new double[]{Double.MAX_VALUE, Double.MIN_VALUE};
            LOGGER.info("Create myArray Jsonarray of 23 elements");
            JsonArray myArray = Json.createArrayBuilder().add(-1).add(1).add(1).add(-1000.0).add(1000.0).add(1000.0).add(-2000.0).add(2000.0).add(2000.0).add(Integer.MAX_VALUE).add(Integer.MIN_VALUE).add(Long.MAX_VALUE).add(Long.MIN_VALUE).add(Double.MAX_VALUE).add(Double.MIN_VALUE).add(BigDecimal.valueOf(1.2345678912345679E8)).add(new BigInteger("123456789")).add(JsonValue.TRUE).add(JsonValue.FALSE).add(JsonValue.NULL).add("!@#$%^&*()_+|~1234567890-=;',./<>? qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM").add((JsonValue)object).add((JsonValue)array).build();
            LOGGER.info("Array size=" + myArray.size());
            boolean[] expectedIntTypes = new boolean[]{true, false};
            for (i = 0; i < 11; ++i) {
                LOGGER.info("Checking getValue(" + i + ") for correctness");
                LOGGER.info("Retrieve and verify (JsonValueType=NUMBER)");
                if (!JSONP_Util.assertEqualsJsonValueType((JsonValue.ValueType)JsonValue.ValueType.NUMBER, (JsonValue.ValueType)myArray.getJsonNumber(i).getValueType())) {
                    pass = false;
                }
                LOGGER.info("Retrieve and (expect JsonNumber NumberType be one of " + JSONP_Util.toStringJsonNumberTypes((boolean[])expectedIntTypes) + ")");
                if (!JSONP_Util.assertEqualsJsonNumberTypes((boolean[])expectedIntTypes, (boolean)myArray.getJsonNumber(i).isIntegral())) {
                    pass = false;
                }
                LOGGER.info("Retrieve and verify integer value via JsonNumber.intValue()");
                if (!JSONP_Util.assertEquals((int)expInt[i], (int)myArray.getJsonNumber(i).intValue())) {
                    pass = false;
                }
                LOGGER.info("Retrieve and verify integer value via JsonArray.getInt");
                if (!JSONP_Util.assertEquals((int)expInt[i], (int)myArray.getInt(i))) {
                    pass = false;
                }
                LOGGER.info("Retrieve and verify integer value via JsonNumber.intValueExact()");
                if (JSONP_Util.assertEquals((int)expInt[i], (int)myArray.getJsonNumber(i).intValueExact())) continue;
                pass = false;
            }
            i = 11;
            int j = 0;
            while (i < 13) {
                LOGGER.info("Checking getValue(" + i + ") for correctness");
                LOGGER.info("Retrieve and verify (JsonValueType=NUMBER)");
                if (!JSONP_Util.assertEqualsJsonValueType((JsonValue.ValueType)JsonValue.ValueType.NUMBER, (JsonValue.ValueType)myArray.getJsonNumber(i).getValueType())) {
                    pass = false;
                }
                LOGGER.info("Retrieve and (expect JsonNumber NumberType be INTEGRAL)");
                if (!JSONP_Util.assertEqualsJsonNumberType((boolean)true, (boolean)myArray.getJsonNumber(i).isIntegral())) {
                    pass = false;
                }
                LOGGER.info("Retrieve and verify long value via JsonNumber.longValue()");
                if (!JSONP_Util.assertEquals((long)expLong[j], (long)myArray.getJsonNumber(i).longValue())) {
                    pass = false;
                }
                LOGGER.info("Retrieve and verify long value via JsonNumber.longValueExact()");
                if (!JSONP_Util.assertEquals((long)expLong[j], (long)myArray.getJsonNumber(i).longValueExact())) {
                    pass = false;
                }
                ++i;
                ++j;
            }
            boolean[] expectedDoubleTypes = new boolean[]{true, false};
            int i2 = 13;
            int j2 = 0;
            while (i2 < 15) {
                LOGGER.info("Checking getValue(" + i2 + ") for correctness");
                LOGGER.info("Retrieve and verify (JsonValueType=NUMBER)");
                if (!JSONP_Util.assertEqualsJsonValueType((JsonValue.ValueType)JsonValue.ValueType.NUMBER, (JsonValue.ValueType)myArray.getJsonNumber(i2).getValueType())) {
                    pass = false;
                }
                LOGGER.info("Retrieve and (expect JsonNumber NumberType be one of " + JSONP_Util.toStringJsonNumberTypes((boolean[])expectedDoubleTypes) + ")");
                if (!JSONP_Util.assertEqualsJsonNumberTypes((boolean[])expectedDoubleTypes, (boolean)myArray.getJsonNumber(i2).isIntegral())) {
                    pass = false;
                }
                LOGGER.info("Retrieve and verify double value via JsonNumber.doubleValue()");
                if (!JSONP_Util.assertEquals((double)expDouble[j2], (double)myArray.getJsonNumber(i2).doubleValue())) {
                    pass = false;
                }
                ++i2;
                ++j2;
            }
            LOGGER.info("Checking getValue(15) for correctness");
            LOGGER.info("Retrieve and verify (JsonValueType=NUMBER)");
            if (!JSONP_Util.assertEqualsJsonValueType((JsonValue.ValueType)JsonValue.ValueType.NUMBER, (JsonValue.ValueType)myArray.getJsonNumber(15).getValueType())) {
                pass = false;
            }
            LOGGER.info("Retrieve and (expect JsonNumber NumberType be one of " + JSONP_Util.toStringJsonNumberTypes((boolean[])expectedDoubleTypes) + ")");
            if (!JSONP_Util.assertEqualsJsonNumberTypes((boolean[])expectedDoubleTypes, (boolean)myArray.getJsonNumber(15).isIntegral())) {
                pass = false;
            }
            LOGGER.info("Retrieve and verify BigDecimal value via JsonNumber.bigDecimalValue()");
            if (!JSONP_Util.assertEquals((BigDecimal)BigDecimal.valueOf(1.2345678912345679E8), (BigDecimal)myArray.getJsonNumber(15).bigDecimalValue())) {
                pass = false;
            }
            LOGGER.info("Checking getValue(16) for correctness");
            LOGGER.info("Retrieve and verify (JsonValueType=NUMBER)");
            if (!JSONP_Util.assertEqualsJsonValueType((JsonValue.ValueType)JsonValue.ValueType.NUMBER, (JsonValue.ValueType)myArray.getJsonNumber(16).getValueType())) {
                pass = false;
            }
            LOGGER.info("Retrieve and (expect JsonNumber NumberType be INTEGRAL)");
            if (!JSONP_Util.assertEqualsJsonNumberType((boolean)true, (boolean)myArray.getJsonNumber(16).isIntegral())) {
                pass = false;
            }
            LOGGER.info("Retrieve and verify BigInteger value via JsonNumber.bigIntegerValue()");
            if (!JSONP_Util.assertEquals((BigInteger)new BigInteger("123456789"), (BigInteger)myArray.getJsonNumber(16).bigIntegerValue())) {
                pass = false;
            }
            LOGGER.info("Retrieve and verify BigInteger value via JsonNumber.bigIntegerValueExact()");
            if (!JSONP_Util.assertEquals((BigInteger)new BigInteger("123456789"), (BigInteger)myArray.getJsonNumber(16).bigIntegerValueExact())) {
                pass = false;
            }
            LOGGER.info("Retrieve and verify true value via JsonArray.getBoolean(int)");
            if (!JSONP_Util.assertEquals((boolean)true, (boolean)myArray.getBoolean(17))) {
                pass = false;
            }
            LOGGER.info("Retrieve and verify false value via JsonArray.getBoolean(int)");
            if (!JSONP_Util.assertEquals((boolean)false, (boolean)myArray.getBoolean(18))) {
                pass = false;
            }
            LOGGER.info("Retrieve and verify null value via JsonArray.isNull(int)");
            if (!JSONP_Util.assertEquals((boolean)true, (boolean)myArray.isNull(19))) {
                pass = false;
            }
            LOGGER.info("Retrieve and verify non-null value via JsonArray.isNull(int)");
            if (!JSONP_Util.assertEquals((boolean)false, (boolean)myArray.isNull(20))) {
                pass = false;
            }
            LOGGER.info("Checking getValue(20) for correctness");
            LOGGER.info("Retrieve and (expect JsonValueType=STRING)");
            if (!JSONP_Util.assertEqualsJsonValueType((JsonValue.ValueType)JsonValue.ValueType.STRING, (JsonValue.ValueType)myArray.getJsonString(20).getValueType())) {
                pass = false;
            }
            LOGGER.info("Retrieve and verify string value via JsonString.getString()");
            if (!JSONP_Util.assertEquals((String)"!@#$%^&*()_+|~1234567890-=;',./<>? qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM", (String)myArray.getJsonString(20).getString())) {
                pass = false;
            }
            LOGGER.info("Retrieve and verify string value via JsonArray.getString()");
            if (!JSONP_Util.assertEquals((String)"!@#$%^&*()_+|~1234567890-=;',./<>? qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM", (String)myArray.getString(20))) {
                pass = false;
            }
            LOGGER.info("Checking getJsonObject(21) for correctness");
            LOGGER.info("Retrieve and (expect JsonValueType=OBJECT)");
            if (!JSONP_Util.assertEqualsJsonValueType((JsonValue.ValueType)JsonValue.ValueType.OBJECT, (JsonValue.ValueType)myArray.getJsonObject(21).getValueType())) {
                pass = false;
            }
            LOGGER.info("Retrieve and verify object value via JsonArray.getJsonObject(int)");
            if (!JSONP_Util.assertEqualsJsonObjects((JsonObject)object, (JsonObject)myArray.getJsonObject(21))) {
                pass = false;
            }
            LOGGER.info("Checking getJsonArray(22) for correctness");
            LOGGER.info("Retrieve and (expect JsonValueType=ARRAY)");
            if (!JSONP_Util.assertEqualsJsonValueType((JsonValue.ValueType)JsonValue.ValueType.ARRAY, (JsonValue.ValueType)myArray.getJsonArray(22).getValueType())) {
                pass = false;
            }
            LOGGER.info("Retrieve and verify array value via JsonArray.getJsonArray(int)");
            if (!JSONP_Util.assertEqualsJsonArrays((JsonArray)array, (JsonArray)myArray.getJsonArray(22))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals((boolean)true, (boolean)myArray.getBoolean(17))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals((boolean)false, (boolean)myArray.getBoolean(18))) {
                pass = false;
            }
            LOGGER.info("Testing JsonArray.getBoolean(int, boolean) with/without default value setting.");
            if (!JSONP_Util.assertEquals((boolean)true, (boolean)myArray.getBoolean(17, false))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals((boolean)false, (boolean)myArray.getBoolean(0, false))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals((boolean)false, (boolean)myArray.getBoolean(19, false))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals((boolean)false, (boolean)myArray.getBoolean(20, false))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals((boolean)false, (boolean)myArray.getBoolean(21, false))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals((boolean)false, (boolean)myArray.getBoolean(22, false))) {
                pass = false;
            }
            LOGGER.info("Testing JsonArray.getInt(int, int) with/without default value setting.");
            if (!JSONP_Util.assertEquals((int)-1, (int)myArray.getInt(0, 10))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals((int)10, (int)myArray.getInt(17, 10))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals((int)10, (int)myArray.getInt(19, 10))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals((int)10, (int)myArray.getInt(20, 10))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals((int)10, (int)myArray.getInt(21, 10))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals((int)10, (int)myArray.getInt(22, 10))) {
                pass = false;
            }
            LOGGER.info("Testing JsonArray.getString(int, String) with/without default value setting.");
            if (!JSONP_Util.assertEquals((String)"!@#$%^&*()_+|~1234567890-=;',./<>? qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM", (String)myArray.getString(20, "foo"))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals((String)"foo", (String)myArray.getString(17, "foo"))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals((String)"foo", (String)myArray.getString(19, "foo"))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals((String)"foo", (String)myArray.getString(2, "foo"))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals((String)"foo", (String)myArray.getString(21, "foo"))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals((String)"foo", (String)myArray.getString(22, "foo"))) {
                pass = false;
            }
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonArrayTest3 Failed: ", (Throwable)e);
        }
        Assertions.assertTrue((boolean)pass, (String)"jsonArrayTest3 Failed");
    }

    @Test
    public void jsonArrayTest4() {
        try {
            LOGGER.info("Create sample JsonArray for testing");
            JsonArray myJsonArray1 = JSONP_Util.createSampleJsonArray();
            LOGGER.info("Write the JsonArray 'myJsonArray1' out to a JsonWriter");
            StringWriter sw = new StringWriter();
            try (JsonWriter writer = Json.createWriter((Writer)sw);){
                writer.writeArray(myJsonArray1);
                LOGGER.info("Close JsonWriter");
            }
            LOGGER.info("Save contents of the JsonWriter as a String");
            String contents = sw.toString();
            LOGGER.info("Dump contents of JsonWriter as a String");
            LOGGER.info("JsonWriterContents=" + contents);
            LOGGER.info("Remove whitespace from contents.");
            String actJsonText = JSONP_Util.removeWhitespace((String)contents);
            LOGGER.info("Compare expected JsonArray text with actual JsonArray text for equality");
            Assertions.assertTrue((boolean)JSONP_Util.assertEqualsJsonText((String)"[{\"name1\":\"value1\",\"name2\":\"value2\"},true,false,null,100,200,\"string\",123456789,123456789,{\"name3\":\"value3\",\"name4\":\"value4\"},true,false,null,[2,4],{\"objectFooBar\":{\"foo\":\"bar\"},\"arrayFooBar\":[\"foo\",\"bar\"]},[{\"foo\":\"bar\"},[\"foo\",\"bar\"]]]", (String)actJsonText), (String)"jsonArrayTest4 Failed");
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonArrayTest4 Failed: ", (Throwable)e);
        }
    }

    @Test
    public void jsonArrayGetValuesAsTest() {
        boolean pass = true;
        try {
            LOGGER.info("Create sample JsonArray of JsonNumber types for testing");
            JsonArray jsonArr = Json.createArrayBuilder().add(100).add(500).build();
            LOGGER.info("Create the expected list of JsonArray values");
            ArrayList<JsonNumber> expList = new ArrayList<JsonNumber>();
            expList.add(JSONP_Util.createJsonNumber((int)100));
            expList.add(JSONP_Util.createJsonNumber((int)500));
            JSONP_Util.dumpList(expList, (String)"Expected List");
            LOGGER.info("Create the JsonNumber list of JsonArray values");
            List numList = jsonArr.getValuesAs(JsonNumber.class);
            LOGGER.info("Create the actual list of JsonArray values");
            ArrayList<JsonNumber> actList = new ArrayList<JsonNumber>();
            for (JsonNumber num : numList) {
                actList.add(num);
            }
            LOGGER.info("Compare actual list with expected list for equality");
            pass = JSONP_Util.assertEqualsList(expList, actList);
            LOGGER.info("Create sample JsonArray of JsonString types for testing");
            jsonArr = Json.createArrayBuilder().add("hello").add("world").build();
            LOGGER.info("Create the list of JsonString values");
            List strList = jsonArr.getValuesAs(JsonString.class);
            LOGGER.info("Comparing JsonString list elements to expected values.");
            if (!JSONP_Util.assertEquals((String)jsonArr.getString(0), (String)((JsonString)strList.get(0)).getString())) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals((String)jsonArr.getString(1), (String)((JsonString)strList.get(1)).getString())) {
                pass = false;
            }
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonArrayGetValuesAsTest Failed: ", (Throwable)e);
        }
        Assertions.assertTrue((boolean)pass, (String)"jsonArrayGetValuesAsTest Failed");
    }

    @Test
    public void jsonArrayExceptionTests() {
        JsonArray array;
        String myString;
        JsonNumber myJsonValue;
        String value;
        JsonNumber value2;
        boolean pass = true;
        JsonObject testObject = null;
        JsonArray testArray = null;
        try {
            LOGGER.info("Create sample JsonObject for testing");
            testObject = JSONP_Util.createSampleJsonObject();
            LOGGER.info("Create sample JsonArray for testing");
            testArray = JSONP_Util.createSampleJsonArray();
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip ClassCastException trying to cast a JsonObject to JsonNumber via getJsonNumber(int)");
            value2 = testArray.getJsonNumber(0);
            pass = false;
            LOGGER.warning("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            LOGGER.info("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip ClassCastException trying to cast a JsonArray to JsonNumber via getJsonNumber(int)");
            value2 = testArray.getJsonNumber(15);
            pass = false;
            LOGGER.warning("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            LOGGER.info("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip ClassCastException trying to cast a JsonNumber to JsonString via getJsonString(int)");
            value2 = testArray.getJsonString(4);
            pass = false;
            LOGGER.warning("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            LOGGER.info("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip ClassCastException trying to cast a JsonString to JsonNumber via getJsonNumber(int)");
            value2 = testArray.getJsonNumber(6);
            pass = false;
            LOGGER.warning("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            LOGGER.info("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip ClassCastException trying to cast a JsonValue.TRUE to JsonNumber via getJsonNumber(int)");
            value2 = testArray.getJsonNumber(1);
            pass = false;
            LOGGER.warning("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            LOGGER.info("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip ClassCastException trying to cast a JsonObject to JsonArray via getJsonArray(int)");
            value2 = testArray.getJsonArray(0);
            pass = false;
            LOGGER.warning("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            LOGGER.info("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip ClassCastException trying to cast a JsonArray to JsonObject via getJsonObject(int)");
            value2 = testArray.getJsonObject(15);
            pass = false;
            LOGGER.warning("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            LOGGER.info("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip ClassCastException trying to cast a JsonObject to JsonNumber via getInt(int)");
            int value3 = testArray.getInt(0);
            pass = false;
            LOGGER.warning("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            LOGGER.info("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip ClassCastException trying to cast a JsonObject to JsonString via getString(int)");
            value = testArray.getString(0);
            pass = false;
            LOGGER.warning("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            LOGGER.info("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip ClassCastException trying to cast a JsonArray to JsonString via getString(int)");
            value = testArray.getString(15);
            pass = false;
            LOGGER.warning("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            LOGGER.info("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip ClassCastException trying to cast a JsonObject to boolean via getBoolean(int)");
            boolean value4 = testArray.getBoolean(0);
            pass = false;
            LOGGER.warning("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            LOGGER.info("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip ClassCastException trying to cast a JsonArray to boolean via getBoolean(int)");
            boolean value5 = testArray.getBoolean(13);
            pass = false;
            LOGGER.warning("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            LOGGER.info("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip ClassCastException trying to cast a JsonString to boolean via getBoolean(int)");
            boolean value6 = testArray.getBoolean(6);
            pass = false;
            LOGGER.warning("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            LOGGER.info("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip ClassCastException trying to cast a JsonNumber to boolean via getBoolean(int)");
            boolean value7 = testArray.getBoolean(4);
            pass = false;
            LOGGER.warning("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            LOGGER.info("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip IndexOutOfBoundsException passing -1 as index to getJsonNumber(int)");
            int myInt = testArray.getJsonNumber(-1).intValue();
            pass = false;
            LOGGER.warning("Failed to throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            LOGGER.info("Got expected IndexOutOfBoundsException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip IndexOutOfBoundsException passing 10000 as index to getJsonNumber(int)");
            myJsonValue = testArray.getJsonNumber(10000);
            pass = false;
            LOGGER.warning("Failed to throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            LOGGER.info("Got expected IndexOutOfBoundsException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip IndexOutOfBoundsException passing -1 as index to getJsonArray(int)");
            myJsonValue = testArray.getJsonArray(-1);
            pass = false;
            LOGGER.warning("Failed to throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            LOGGER.info("Got expected IndexOutOfBoundsException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip IndexOutOfBoundsException passing 10000 as index to getJsonArray(int)");
            myJsonValue = testArray.getJsonArray(10000);
            pass = false;
            LOGGER.warning("Failed to throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            LOGGER.info("Got expected IndexOutOfBoundsException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip IndexOutOfBoundsException passing -1 as index to getJsonObject(int)");
            myJsonValue = testArray.getJsonObject(-1);
            pass = false;
            LOGGER.warning("Failed to throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            LOGGER.info("Got expected IndexOutOfBoundsException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip IndexOutOfBoundsException passing 10000 as index to getJsonObject(int)");
            myJsonValue = testArray.getJsonObject(10000);
            pass = false;
            LOGGER.warning("Failed to throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            LOGGER.info("Got expected IndexOutOfBoundsException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip IndexOutOfBoundsException passing -1 as index to getJsonString(int)");
            myJsonValue = testArray.getJsonString(-1);
            pass = false;
            LOGGER.warning("Failed to throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            LOGGER.info("Got expected IndexOutOfBoundsException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip IndexOutOfBoundsException passing 10000 as index to getJsonString(int)");
            myJsonValue = testArray.getJsonString(10000);
            pass = false;
            LOGGER.warning("Failed to throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            LOGGER.info("Got expected IndexOutOfBoundsException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip IndexOutOfBoundsException passing -1 as index to getInt(int)");
            int myInt = testArray.getInt(-1);
            pass = false;
            LOGGER.warning("Failed to throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            LOGGER.info("Got expected IndexOutOfBoundsException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip IndexOutOfBoundsException passing 10000 as index to getInt(int)");
            int myInt = testArray.getInt(10000);
            pass = false;
            LOGGER.warning("Failed to throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            LOGGER.info("Got expected IndexOutOfBoundsException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip IndexOutOfBoundsException passing -1 as index to getString(int)");
            myString = testArray.getString(-1);
            pass = false;
            LOGGER.warning("Failed to throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            LOGGER.info("Got expected IndexOutOfBoundsException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip IndexOutOfBoundsException passing 10000 as index to getString(int)");
            myString = testArray.getString(10000);
            pass = false;
            LOGGER.warning("Failed to throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            LOGGER.info("Got expected IndexOutOfBoundsException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip IndexOutOfBoundsException passing -1 as index to getBoolean(int)");
            boolean myBoolean = testArray.getBoolean(-1);
            pass = false;
            LOGGER.warning("Failed to throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            LOGGER.info("Got expected IndexOutOfBoundsException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip IndexOutOfBoundsException passing 10000 as index to getBoolean(int)");
            boolean myBoolean = testArray.getBoolean(10000);
            pass = false;
            LOGGER.warning("Failed to throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            LOGGER.info("Got expected IndexOutOfBoundsException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip IndexOutOfBoundsException passing -1 as index to isNull(int)");
            boolean myBoolean = testArray.isNull(-1);
            pass = false;
            LOGGER.warning("Failed to throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            LOGGER.info("Got expected IndexOutOfBoundsException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip IndexOutOfBoundsException passing 10000 as index to isNull(int)");
            boolean myBoolean = testArray.isNull(10000);
            pass = false;
            LOGGER.warning("Failed to throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            LOGGER.info("Got expected IndexOutOfBoundsException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip NumberFormatException calling add(Double.NaN)");
            array = Json.createArrayBuilder().add(Double.NaN).build();
            pass = false;
            LOGGER.warning("Failed to throw NumberFormatException");
        }
        catch (NumberFormatException e) {
            LOGGER.info("Got expected NumberFormatException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip NumberFormatException calling add(Double.NEGATIVE_INFINITY)");
            array = Json.createArrayBuilder().add(Double.NEGATIVE_INFINITY).build();
            pass = false;
            LOGGER.warning("Failed to throw NumberFormatException");
        }
        catch (NumberFormatException e) {
            LOGGER.info("Got expected NumberFormatException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip NumberFormatException calling add(Double.POSITIVE_INFINITY)");
            array = Json.createArrayBuilder().add(Double.POSITIVE_INFINITY).build();
            pass = false;
            LOGGER.warning("Failed to throw NumberFormatException");
        }
        catch (NumberFormatException e) {
            LOGGER.info("Got expected NumberFormatException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip ArithmeticException calling add(12345.12345) and attempting to extract as an exact integer value");
            array = Json.createArrayBuilder().add(12345.12345).build();
            LOGGER.info("Call JsonArray.getJsonNumber(0).intValueExact()");
            int value8 = array.getJsonNumber(0).intValueExact();
            pass = false;
            LOGGER.warning("Failed to throw ArithmeticException");
        }
        catch (ArithmeticException e) {
            LOGGER.info("Got expected ArithmeticException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip ArithmeticException calling add(12345.12345) and attempting to extract as an exact long value");
            array = Json.createArrayBuilder().add(12345.12345).build();
            LOGGER.info("Call JsonArray.getJsonNumber(0).longValueExact()");
            long value9 = array.getJsonNumber(0).longValueExact();
            pass = false;
            LOGGER.warning("Failed to throw ArithmeticException");
        }
        catch (ArithmeticException e) {
            LOGGER.info("Got expected ArithmeticException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip ArithmeticException calling add(12345.12345) and attempting to extract as an exact biginteger value");
            array = Json.createArrayBuilder().add(12345.12345).build();
            LOGGER.info("Call JsonArray.getJsonNumber(0).bigIntegerValueExact()");
            BigInteger value10 = array.getJsonNumber(0).bigIntegerValueExact();
            pass = false;
            LOGGER.warning("Failed to throw ArithmeticException");
        }
        catch (ArithmeticException e) {
            LOGGER.info("Got expected ArithmeticException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip UnsupportedOperationException JsonArray.add(E) trying to modify JsonArray list which should be immutable");
            testArray.add((Object)JsonValue.FALSE);
            pass = false;
            LOGGER.warning("Failed to throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            LOGGER.info("Got expected UnsupportedOperationException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip UnsupportedOperationException JsonArray.add(int,E) trying to modify JsonArray list which should be immutable");
            testArray.add(0, (Object)JsonValue.FALSE);
            pass = false;
            LOGGER.warning("Failed to throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            LOGGER.info("Got expected UnsupportedOperationException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip UnsupportedOperationException JsonArray.addAll(C) trying to modify JsonArray list which should be immutable");
            testArray.addAll((Collection)testArray);
            pass = false;
            LOGGER.warning("Failed to throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            LOGGER.info("Got expected UnsupportedOperationException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip UnsupportedOperationException JsonArray.addAll(int, C) trying to modify JsonArray list which should be immutable");
            testArray.addAll(0, (Collection)testArray);
            pass = false;
            LOGGER.warning("Failed to throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            LOGGER.info("Got expected UnsupportedOperationException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip UnsupportedOperationException JsonArray.clear() trying to modify JsonArray list which should be immutable");
            testArray.clear();
            pass = false;
            LOGGER.warning("Failed to throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            LOGGER.info("Got expected UnsupportedOperationException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip UnsupportedOperationException JsonArray.remove(int) trying to modify JsonArray list which should be immutable");
            testArray.remove(0);
            pass = false;
            LOGGER.warning("Failed to throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            LOGGER.info("Got expected UnsupportedOperationException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip UnsupportedOperationException JsonArray.removeAll(C) trying to modify JsonArray list which should be immutable");
            testArray.removeAll((Collection)testArray);
            pass = false;
            LOGGER.warning("Failed to throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            LOGGER.info("Got expected UnsupportedOperationException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip UnsupportedOperationException trying to modify JsonArray list which should be immutable");
            testArray.remove((Object)JsonValue.TRUE);
            pass = false;
            LOGGER.warning("Failed to throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            LOGGER.info("Got expected UnsupportedOperationException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        Assertions.assertTrue((boolean)pass, (String)"jsonArrayExceptionTests Failed");
    }

    @Test
    public void jsonArrayNullValueExceptionTests() {
        boolean pass = true;
        JsonArrayBuilder jab = Json.createArrayBuilder();
        try {
            LOGGER.info("Trip NullPointerException for JsonArrayBuilder.add(JsonValue) when JsonValue is null.");
            jab.add((JsonValue)null);
            pass = false;
            LOGGER.warning("Failed to throw NullPointerException");
        }
        catch (NullPointerException e) {
            LOGGER.info("Got expected NullPointerException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip NullPointerException for JsonArrayBuilder.add(BigInteger) when BigInteger is null.");
            jab.add((BigInteger)null);
            pass = false;
            LOGGER.warning("Failed to throw NullPointerException");
        }
        catch (NullPointerException e) {
            LOGGER.info("Got expected NullPointerException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip NullPointerException for JsonArrayBuilder.add(JsonArrayBuilder) when JsonArrayBuilder is null.");
            jab.add((JsonArrayBuilder)null);
            pass = false;
            LOGGER.warning("Failed to throw NullPointerException");
        }
        catch (NullPointerException e) {
            LOGGER.info("Got expected NullPointerException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip NullPointerException for JsonArrayBuilder.add(JsonObjectBuilder) when JsonObjectBuilder is null.");
            jab.add((JsonObjectBuilder)null);
            pass = false;
            LOGGER.warning("Failed to throw NullPointerException");
        }
        catch (NullPointerException e) {
            LOGGER.info("Got expected NullPointerException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip NullPointerException for JsonArrayBuilder.add(BigDecimal) when BigDecimal is null.");
            jab.add((BigDecimal)null);
            pass = false;
            LOGGER.warning("Failed to throw NullPointerException");
        }
        catch (NullPointerException e) {
            LOGGER.info("Got expected NullPointerException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip NullPointerException for JsonArrayBuilder.add(String) when String is null.");
            jab.add((String)null);
            pass = false;
            LOGGER.warning("Failed to throw NullPointerException");
        }
        catch (NullPointerException e) {
            LOGGER.info("Got expected NullPointerException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        Assertions.assertTrue((boolean)pass, (String)"jsonArrayNullValueExceptionTests Failed");
    }

    @Test
    public void jsonCreateArrayBuilder11Test() {
        ArrayBuilders createTest = new ArrayBuilders();
        TestResult result = createTest.test();
        result.eval();
    }

    @Test
    public void jsonArrayBuilder11AddTest() {
        ArrayBuildAdd addTest = new ArrayBuildAdd();
        TestResult result = addTest.test();
        result.eval();
    }

    @Test
    public void jsonArrayBuilder11SetTest() {
        ArrayBuildSet setTest = new ArrayBuildSet();
        TestResult result = setTest.test();
        result.eval();
    }

    @Test
    public void jsonArrayBuilder11RemoveTest() {
        ArrayBuildRemove removeTest = new ArrayBuildRemove();
        TestResult result = removeTest.test();
        result.eval();
    }
}

