/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.jsonp.api.jsonparserfactorytests;

import ee.jakarta.tck.jsonp.common.JSONP_Util;
import ee.jakarta.tck.jsonp.common.MyBufferedInputStream;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.stream.JsonParser;
import jakarta.json.stream.JsonParserFactory;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.logging.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ClientTests {
    private static final Logger LOGGER = Logger.getLogger(ClientTests.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void jsonParserFactoryTest1() {
        boolean pass = true;
        JsonParser parser1 = null;
        JsonParser parser2 = null;
        Object event = null;
        try {
            int parseErrs;
            LOGGER.info("Create JsonParserFactory with a configuration");
            JsonParserFactory parserFactory = Json.createParserFactory((Map)JSONP_Util.getEmptyConfig());
            LOGGER.info("Checking factory configuration properties");
            Map config = parserFactory.getConfigInUse();
            if (!JSONP_Util.doConfigCheck((Map)config, (int)0)) {
                pass = false;
            }
            LOGGER.info("--------------------------------------------------");
            LOGGER.info("TEST CASE [JsonParserFactory.createParser(Reader)]");
            LOGGER.info("--------------------------------------------------");
            String jsonObjectString = "{\"foo\":\"bar\"}";
            LOGGER.info("Create 1st JsonParser from the Reader using JsonParserFactory");
            parser1 = parserFactory.createParser((Reader)new StringReader(jsonObjectString));
            if (parser1 == null) {
                LOGGER.warning("ParserFactory failed to create parser1 from Reader");
                pass = false;
            } else {
                LOGGER.info("Parsing " + jsonObjectString);
                LOGGER.info("Verify that JSON Parser Events/Data matches");
                JSONP_Util.resetParseErrs();
                JSONP_Util.testEventType((JsonParser)parser1, (JsonParser.Event)JsonParser.Event.START_OBJECT);
                JSONP_Util.testKeyStringValue((JsonParser)parser1, (String)"foo", (String)"bar");
                JSONP_Util.testEventType((JsonParser)parser1, (JsonParser.Event)JsonParser.Event.END_OBJECT);
                parseErrs = JSONP_Util.getParseErrs();
                if (parseErrs != 0) {
                    LOGGER.warning("There were " + parseErrs + " parser errors that occurred.");
                    pass = false;
                }
            }
            LOGGER.info("Create 2nd JsonParser from the Reader using JsonParserFactory");
            parser2 = parserFactory.createParser((Reader)new StringReader(jsonObjectString));
            if (parser2 == null) {
                LOGGER.warning("ParserFactory failed to create parser2 from Reader");
                pass = false;
            } else {
                LOGGER.info("Parsing " + jsonObjectString);
                LOGGER.info("Verify that JSON Parser Events/Data matches");
                JSONP_Util.resetParseErrs();
                JSONP_Util.testEventType((JsonParser)parser2, (JsonParser.Event)JsonParser.Event.START_OBJECT);
                JSONP_Util.testKeyStringValue((JsonParser)parser2, (String)"foo", (String)"bar");
                JSONP_Util.testEventType((JsonParser)parser2, (JsonParser.Event)JsonParser.Event.END_OBJECT);
                parseErrs = JSONP_Util.getParseErrs();
                if (parseErrs != 0) {
                    LOGGER.warning("There were " + parseErrs + " parser errors that occurred.");
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonParserFactoryTest1 Failed: ", (Throwable)e);
        }
        finally {
            try {
                parser1.close();
                parser2.close();
            }
            catch (Exception exception) {}
        }
        Assertions.assertTrue((boolean)pass, (String)"jsonParserFactoryTest1 Failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void jsonParserFactoryTest2() {
        boolean pass = true;
        JsonParser parser1 = null;
        JsonParser parser2 = null;
        Object event = null;
        try {
            int parseErrs;
            LOGGER.info("Create JsonParserFactory with a configuration");
            JsonParserFactory parserFactory = Json.createParserFactory((Map)JSONP_Util.getEmptyConfig());
            LOGGER.info("Checking factory configuration properties");
            Map config = parserFactory.getConfigInUse();
            if (!JSONP_Util.doConfigCheck((Map)config, (int)0)) {
                pass = false;
            }
            LOGGER.info("------------------------------------------------------");
            LOGGER.info("TEST CASE [JsonParserFactory.createParser(JsonObject)]");
            LOGGER.info("------------------------------------------------------");
            String jsonObjectString = "{\"foo\":\"bar\"}";
            JsonObject jsonObj = JSONP_Util.createJsonObjectFromString((String)jsonObjectString);
            LOGGER.info("Create 1st JsonParser from the JsonObject using JsonParserFactory");
            parser1 = parserFactory.createParser(jsonObj);
            if (parser1 == null) {
                LOGGER.warning("ParserFactory failed to create parser1 from JsonObject");
                pass = false;
            } else {
                LOGGER.info("Parsing " + jsonObjectString);
                LOGGER.info("Verify that JSON Parser Events/Data matches");
                JSONP_Util.resetParseErrs();
                JSONP_Util.testEventType((JsonParser)parser1, (JsonParser.Event)JsonParser.Event.START_OBJECT);
                JSONP_Util.testKeyStringValue((JsonParser)parser1, (String)"foo", (String)"bar");
                JSONP_Util.testEventType((JsonParser)parser1, (JsonParser.Event)JsonParser.Event.END_OBJECT);
                parseErrs = JSONP_Util.getParseErrs();
                if (parseErrs != 0) {
                    LOGGER.warning("There were " + parseErrs + " parser errors that occurred.");
                    pass = false;
                }
            }
            LOGGER.info("Create 2nd JsonParser from the JsonObject using JsonParserFactory");
            parser2 = parserFactory.createParser(jsonObj);
            if (parser2 == null) {
                LOGGER.warning("ParserFactory failed to create parser2 from JsonObject");
                pass = false;
            } else {
                LOGGER.info("Parsing " + jsonObjectString);
                LOGGER.info("Verify that JSON Parser Events/Data matches");
                JSONP_Util.resetParseErrs();
                JSONP_Util.testEventType((JsonParser)parser2, (JsonParser.Event)JsonParser.Event.START_OBJECT);
                JSONP_Util.testKeyStringValue((JsonParser)parser2, (String)"foo", (String)"bar");
                JSONP_Util.testEventType((JsonParser)parser2, (JsonParser.Event)JsonParser.Event.END_OBJECT);
                parseErrs = JSONP_Util.getParseErrs();
                if (parseErrs != 0) {
                    LOGGER.warning("There were " + parseErrs + " parser errors that occurred.");
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonParserFactoryTest2 Failed: ", (Throwable)e);
        }
        finally {
            try {
                parser1.close();
                parser2.close();
            }
            catch (Exception exception) {}
        }
        Assertions.assertTrue((boolean)pass, (String)"jsonParserFactoryTest2 Failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void jsonParserFactoryTest3() {
        boolean pass = true;
        JsonParser parser1 = null;
        JsonParser parser2 = null;
        Object event = null;
        try {
            int parseErrs;
            LOGGER.info("Create JsonParserFactory with a configuration");
            JsonParserFactory parserFactory = Json.createParserFactory((Map)JSONP_Util.getEmptyConfig());
            LOGGER.info("Checking factory configuration properties");
            Map config = parserFactory.getConfigInUse();
            if (!JSONP_Util.doConfigCheck((Map)config, (int)0)) {
                pass = false;
            }
            LOGGER.info("-----------------------------------------------------");
            LOGGER.info("TEST CASE [JsonParserFactory.createParser(JsonArray)]");
            LOGGER.info("-----------------------------------------------------");
            String jsonArrayString = "[\"foo\",\"bar\"]";
            JsonArray jsonArr = JSONP_Util.createJsonArrayFromString((String)jsonArrayString);
            LOGGER.info("Create 1st JsonParser from the JsonArray using JsonParserFactory");
            parser1 = parserFactory.createParser(jsonArr);
            if (parser1 == null) {
                LOGGER.warning("ParserFactory failed to create parser1 from JsonArray");
                pass = false;
            } else {
                LOGGER.info("Parsing " + jsonArrayString);
                LOGGER.info("Verify that JSON Parser Events/Data matches");
                JSONP_Util.resetParseErrs();
                JSONP_Util.testEventType((JsonParser)parser1, (JsonParser.Event)JsonParser.Event.START_ARRAY);
                JSONP_Util.testStringValue((JsonParser)parser1, (String)"foo");
                JSONP_Util.testStringValue((JsonParser)parser1, (String)"bar");
                JSONP_Util.testEventType((JsonParser)parser1, (JsonParser.Event)JsonParser.Event.END_ARRAY);
                parseErrs = JSONP_Util.getParseErrs();
                if (parseErrs != 0) {
                    LOGGER.warning("There were " + parseErrs + " parser errors that occurred.");
                    pass = false;
                }
            }
            LOGGER.info("Create 2nd JsonParser from the JsonArray using JsonParserFactory");
            parser2 = parserFactory.createParser(jsonArr);
            if (parser2 == null) {
                LOGGER.warning("ParserFactory failed to create parser2 from JsonArray");
                pass = false;
            } else {
                LOGGER.info("Parsing " + jsonArrayString);
                LOGGER.info("Verify that JSON Parser Events/Data matches");
                JSONP_Util.resetParseErrs();
                JSONP_Util.testEventType((JsonParser)parser2, (JsonParser.Event)JsonParser.Event.START_ARRAY);
                JSONP_Util.testStringValue((JsonParser)parser2, (String)"foo");
                JSONP_Util.testStringValue((JsonParser)parser2, (String)"bar");
                JSONP_Util.testEventType((JsonParser)parser2, (JsonParser.Event)JsonParser.Event.END_ARRAY);
                parseErrs = JSONP_Util.getParseErrs();
                if (parseErrs != 0) {
                    LOGGER.warning("There were " + parseErrs + " parser errors that occurred.");
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonParserFactoryTest3 Failed: ", (Throwable)e);
        }
        finally {
            try {
                parser1.close();
                parser2.close();
            }
            catch (Exception exception) {}
        }
        Assertions.assertTrue((boolean)pass, (String)"jsonParserFactoryTest3 Failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void jsonParserFactoryTest4() {
        boolean pass = true;
        JsonParser parser1 = null;
        JsonParser parser2 = null;
        Object event = null;
        try {
            int parseErrs;
            LOGGER.info("Create JsonParserFactory with a configuration");
            JsonParserFactory parserFactory = Json.createParserFactory((Map)JSONP_Util.getEmptyConfig());
            LOGGER.info("Checking factory configuration properties");
            Map config = parserFactory.getConfigInUse();
            if (!JSONP_Util.doConfigCheck((Map)config, (int)0)) {
                pass = false;
            }
            LOGGER.info("-------------------------------------------------------");
            LOGGER.info("TEST CASE [JsonParserFactory.createParser(InputStream)]");
            LOGGER.info("-------------------------------------------------------");
            String jsonObjectString = "{\"foo\":\"bar\"}";
            LOGGER.info("Create 1st JsonParser from the InputStream using JsonParserFactory");
            parser1 = parserFactory.createParser((InputStream)new ByteArrayInputStream(jsonObjectString.getBytes(JSONP_Util.UTF_8)));
            if (parser1 == null) {
                LOGGER.warning("ParserFactory failed to create parser1 from InputStream");
                pass = false;
            } else {
                LOGGER.info("Parsing " + jsonObjectString);
                LOGGER.info("Verify that JSON Parser Events/Data matches");
                JSONP_Util.resetParseErrs();
                JSONP_Util.testEventType((JsonParser)parser1, (JsonParser.Event)JsonParser.Event.START_OBJECT);
                JSONP_Util.testKeyStringValue((JsonParser)parser1, (String)"foo", (String)"bar");
                JSONP_Util.testEventType((JsonParser)parser1, (JsonParser.Event)JsonParser.Event.END_OBJECT);
                parseErrs = JSONP_Util.getParseErrs();
                if (parseErrs != 0) {
                    LOGGER.warning("There were " + parseErrs + " parser errors that occurred.");
                    pass = false;
                }
            }
            LOGGER.info("Create 2nd JsonParser from the InputStream using JsonParserFactory");
            parser2 = parserFactory.createParser((InputStream)new ByteArrayInputStream(jsonObjectString.getBytes(JSONP_Util.UTF_8)));
            if (parser2 == null) {
                LOGGER.warning("ParserFactory failed to create parser2 from InputStream");
                pass = false;
            } else {
                LOGGER.info("Parsing " + jsonObjectString);
                LOGGER.info("Verify that JSON Parser Events/Data matches");
                JSONP_Util.resetParseErrs();
                JSONP_Util.testEventType((JsonParser)parser2, (JsonParser.Event)JsonParser.Event.START_OBJECT);
                JSONP_Util.testKeyStringValue((JsonParser)parser2, (String)"foo", (String)"bar");
                JSONP_Util.testEventType((JsonParser)parser2, (JsonParser.Event)JsonParser.Event.END_OBJECT);
                parseErrs = JSONP_Util.getParseErrs();
                if (parseErrs != 0) {
                    LOGGER.warning("There were " + parseErrs + " parser errors that occurred.");
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonParserFactoryTest4 Failed: ", (Throwable)e);
        }
        finally {
            try {
                parser1.close();
                parser2.close();
            }
            catch (Exception exception) {}
        }
        Assertions.assertTrue((boolean)pass, (String)"jsonParserFactoryTest4 Failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void jsonParserFactoryTest5() {
        boolean pass = true;
        JsonParser parser1 = null;
        JsonParser parser2 = null;
        Object event = null;
        try {
            int parseErrs;
            LOGGER.info("Create JsonParserFactory with a configuration");
            JsonParserFactory parserFactory = Json.createParserFactory((Map)JSONP_Util.getEmptyConfig());
            LOGGER.info("Checking factory configuration properties");
            Map config = parserFactory.getConfigInUse();
            if (!JSONP_Util.doConfigCheck((Map)config, (int)0)) {
                pass = false;
            }
            LOGGER.info("----------------------------------------------------------------");
            LOGGER.info("TEST CASE [JsonParserFactory.createParser(InputStream, Charset)]");
            LOGGER.info("----------------------------------------------------------------");
            String jsonObjectString = "{\"foo\":\"bar\"}";
            LOGGER.info("Create 1st JsonParser from the InputStream using JsonParserFactory");
            parser1 = parserFactory.createParser((InputStream)new ByteArrayInputStream(jsonObjectString.getBytes(JSONP_Util.UTF_8)), JSONP_Util.UTF_8);
            if (parser1 == null) {
                LOGGER.warning("ParserFactory failed to create parser1 from InputStream");
                pass = false;
            } else {
                LOGGER.info("Parsing " + jsonObjectString);
                LOGGER.info("Verify that JSON Parser Events/Data matches");
                JSONP_Util.resetParseErrs();
                JSONP_Util.testEventType((JsonParser)parser1, (JsonParser.Event)JsonParser.Event.START_OBJECT);
                JSONP_Util.testKeyStringValue((JsonParser)parser1, (String)"foo", (String)"bar");
                JSONP_Util.testEventType((JsonParser)parser1, (JsonParser.Event)JsonParser.Event.END_OBJECT);
                parseErrs = JSONP_Util.getParseErrs();
                if (parseErrs != 0) {
                    LOGGER.warning("There were " + parseErrs + " parser errors that occurred.");
                    pass = false;
                }
            }
            LOGGER.info("Create 2nd JsonParser from the InputStream using JsonParserFactory");
            parser2 = parserFactory.createParser((InputStream)new ByteArrayInputStream(jsonObjectString.getBytes(JSONP_Util.UTF_8)), JSONP_Util.UTF_8);
            if (parser2 == null) {
                LOGGER.warning("ParserFactory failed to create parser2 from InputStream");
                pass = false;
            } else {
                LOGGER.info("Parsing " + jsonObjectString);
                LOGGER.info("Verify that JSON Parser Events/Data matches");
                JSONP_Util.resetParseErrs();
                JSONP_Util.testEventType((JsonParser)parser2, (JsonParser.Event)JsonParser.Event.START_OBJECT);
                JSONP_Util.testKeyStringValue((JsonParser)parser2, (String)"foo", (String)"bar");
                JSONP_Util.testEventType((JsonParser)parser2, (JsonParser.Event)JsonParser.Event.END_OBJECT);
                parseErrs = JSONP_Util.getParseErrs();
                if (parseErrs != 0) {
                    LOGGER.warning("There were " + parseErrs + " parser errors that occurred.");
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonParserFactoryTest5 Failed: ", (Throwable)e);
        }
        finally {
            try {
                parser1.close();
                parser2.close();
            }
            catch (Exception exception) {}
        }
        Assertions.assertTrue((boolean)pass, (String)"jsonParserFactoryTest5 Failed");
    }

    @Test
    public void jsonParserFactoryTest6() {
        boolean pass = true;
        try {
            LOGGER.info("----------------------------------------------");
            LOGGER.info("Test scenario1: no supported provider property");
            LOGGER.info("----------------------------------------------");
            LOGGER.info("Create JsonParserFactory with Map<String, ?> with EMPTY config");
            JsonParserFactory parserFactory = Json.createParserFactory((Map)JSONP_Util.getEmptyConfig());
            Map config = parserFactory.getConfigInUse();
            if (!JSONP_Util.doConfigCheck((Map)config, (int)0)) {
                pass = false;
            }
            LOGGER.info("-----------------------------------------------");
            LOGGER.info("Test scenario2: non supported provider property");
            LOGGER.info("-----------------------------------------------");
            LOGGER.info("Create JsonParserFactory with Map<String, ?> with FOO config");
            parserFactory = Json.createParserFactory((Map)JSONP_Util.getFooConfig());
            config = parserFactory.getConfigInUse();
            if (!JSONP_Util.doConfigCheck((Map)config, (int)0)) {
                pass = false;
            }
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonParserFactoryTest6 Failed: ", (Throwable)e);
        }
        Assertions.assertTrue((boolean)pass, (String)"jsonParserFactoryTest6 Failed");
    }

    @Test
    public void jsonParserFactoryExceptionTest() {
        JsonParser parser;
        JsonParserFactory parserFactory;
        boolean pass = true;
        try {
            LOGGER.info("Tests JsonParserFactory.createParser(InputStream) for JsonException if i/o error.");
            parserFactory = Json.createParserFactory((Map)JSONP_Util.getEmptyConfig());
            MyBufferedInputStream mbi = new MyBufferedInputStream(JSONP_Util.getInputStreamFromString((String)"{}"), true);
            parser = parserFactory.createParser((InputStream)mbi);
            LOGGER.warning("Did not get expected JsonException");
            pass = false;
        }
        catch (JsonException e) {
            LOGGER.info("Caught expected JsonException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Tests JsonParserFactory.createParser(InputStream) for JsonException if unknown encoding.");
            parserFactory = Json.createParserFactory((Map)JSONP_Util.getEmptyConfig());
            InputStream is = JSONP_Util.getInputStreamFromResource((String)"jsonObjectUnknownEncoding.json");
            parser = parserFactory.createParser(is);
            LOGGER.info("parser=" + parser);
            LOGGER.warning("Did not get expected JsonException");
            pass = false;
        }
        catch (JsonException e) {
            LOGGER.info("Caught expected JsonException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        Assertions.assertTrue((boolean)pass, (String)"jsonParserFactoryExceptionTest Failed");
    }
}

