/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.rs.core.securitycontext.basic;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.ee.rs.core.securitycontext.JAXRSClient;
import ee.jakarta.tck.ws.rs.ee.rs.core.securitycontext.TSAppConfig;
import ee.jakarta.tck.ws.rs.ee.rs.core.securitycontext.TestServlet;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSBasicClientIT
extends JAXRSClient {
    private static final long serialVersionUID = 340277879725875946L;

    public JAXRSBasicClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_ee_core_securitycontext_basic_web/Servlet");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Deployment(testable=true)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSBasicClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/ee/rs/core/securitycontext/basic/web.xml.template");
        String webXml = JAXRSBasicClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_ee_core_securitycontext_basic_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, TestServlet.class, TestServlet.Security.class, TestServlet.Scheme.class, TestServlet.Role.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @Override
    @Test
    @Tag(value="security")
    @RunAsClient
    public void noAuthorizationTest() throws JAXRSCommonClient.Fault {
        super.noAuthorizationTest();
    }

    @Test
    @Tag(value="security")
    @RunAsClient
    public void basicAuthorizationAdminTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSBasicClientIT.getStatusCode(Response.Status.OK));
        this.setProperty(JAXRSCommonClient.Property.BASIC_AUTH_USER, this.user);
        this.setProperty(JAXRSCommonClient.Property.BASIC_AUTH_PASSWD, this.password);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, TestServlet.Security.UNSECURED.name());
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, TestServlet.Role.DIRECTOR.name());
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, this.user);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, TestServlet.Scheme.BASIC.name());
        this.invokeRequest();
    }

    @Test
    @Tag(value="security")
    @RunAsClient
    public void basicAuthorizationIncorrectUserTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSBasicClientIT.getStatusCode(Response.Status.UNAUTHORIZED));
        this.setProperty(JAXRSCommonClient.Property.BASIC_AUTH_USER, TestServlet.Scheme.NOSCHEME.name());
        this.setProperty(JAXRSCommonClient.Property.BASIC_AUTH_PASSWD, this.password);
        this.invokeRequest();
    }

    @Test
    @Tag(value="security")
    @RunAsClient
    public void basicAuthorizationIncorrectPasswordTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSBasicClientIT.getStatusCode(Response.Status.UNAUTHORIZED));
        this.setProperty(JAXRSCommonClient.Property.BASIC_AUTH_USER, this.authuser);
        this.setProperty(JAXRSCommonClient.Property.BASIC_AUTH_PASSWD, this.password);
        this.invokeRequest();
    }

    @Test
    @Tag(value="security")
    @RunAsClient
    public void basicAuthorizationStandardUserTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSBasicClientIT.getStatusCode(Response.Status.OK));
        this.setProperty(JAXRSCommonClient.Property.BASIC_AUTH_USER, this.authuser);
        this.setProperty(JAXRSCommonClient.Property.BASIC_AUTH_PASSWD, this.authpassword);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, TestServlet.Security.UNSECURED.name());
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, TestServlet.Role.OTHERROLE.name());
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, this.authuser);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, TestServlet.Scheme.BASIC.name());
        this.invokeRequest();
    }
}

