/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.session;

import com.gargoylesoftware.htmlunit.TextPage;
import com.gargoylesoftware.htmlunit.WebClient;
import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.ee.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.context.session.IntrospectFilter;
import org.jboss.cdi.tck.tests.context.session.IntrospectHttpSessionListener;
import org.jboss.cdi.tck.tests.context.session.IntrospectServlet;
import org.jboss.cdi.tck.tests.context.session.IntrospectServletRequestListener;
import org.jboss.cdi.tck.tests.context.session.SimpleSessionBean;
import org.jboss.cdi.tck.util.ActionSequence;
import org.jboss.cdi.tck.util.Timer;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0")
public class SessionContextTest
extends AbstractTest {
    private static final long DEFAULT_SLEEP_INTERVAL = 3000L;
    @ArquillianResource
    private URL contextPath;

    @Deployment(testable=false)
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(SessionContextTest.class)).withWebResource("SimplePage.html", "SimplePage.html")).build();
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="session_context_ee", id="aa"), @SpecAssertion(section="session_context_ee", id="ae")})
    public void testSessionScopeActiveDuringServiceMethod() throws Exception {
        WebClient webClient = new WebClient();
        webClient.getPage(String.valueOf(this.contextPath) + "test");
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="session_context_ee", id="ab"), @SpecAssertion(section="session_context_ee", id="ae")})
    public void testSessionScopeActiveDuringDoFilterMethod() throws Exception {
        WebClient webClient = new WebClient();
        webClient.getPage(String.valueOf(this.contextPath) + "SimplePage.html");
    }

    @Test(groups={"integration"})
    @SpecAssertion(section="session_context_ee", id="b")
    public void testSessionContextSharedBetweenServletRequestsInSameHttpSession() throws Exception {
        WebClient webClient = new WebClient();
        TextPage firstRequestResult = (TextPage)webClient.getPage(String.valueOf(this.contextPath) + "introspect");
        Assert.assertNotNull((Object)firstRequestResult.getContent());
        String sessionBeanId = firstRequestResult.getContent();
        Assert.assertNotNull((Object)sessionBeanId);
        TextPage secondRequestResult = (TextPage)webClient.getPage(String.valueOf(this.contextPath) + "introspect");
        Assert.assertNotNull((Object)secondRequestResult.getContent());
        Assert.assertEquals((String)secondRequestResult.getContent(), (String)sessionBeanId);
    }

    @Test(groups={"integration"})
    @SpecAssertion(section="session_context_ee", id="ca")
    public void testSessionContextDestroyedWhenHttpSessionInvalidated() throws Exception {
        WebClient webClient = new WebClient();
        TextPage firstRequestResult = (TextPage)webClient.getPage(String.valueOf(this.contextPath) + "introspect");
        Assert.assertNotNull((Object)firstRequestResult.getContent());
        String sessionBeanId = firstRequestResult.getContent();
        webClient.getPage(String.valueOf(this.contextPath) + "introspect?mode=invalidate");
        TextPage secondRequestResult = (TextPage)webClient.getPage(String.valueOf(this.contextPath) + "introspect");
        Assert.assertNotNull((Object)secondRequestResult.getContent());
        Assert.assertNotEquals((Object)secondRequestResult.getContent(), (Object)sessionBeanId);
        TextPage verifyResult = (TextPage)webClient.getPage(String.valueOf(this.contextPath) + "introspect?mode=verify");
        ActionSequence correctSequence = new ActionSequence().add(IntrospectServlet.class.getName()).add(IntrospectHttpSessionListener.class.getName()).add(IntrospectFilter.class.getName()).add(IntrospectServletRequestListener.class.getName()).add(SimpleSessionBean.class.getName());
        Assert.assertEquals((String)verifyResult.getContent(), (String)correctSequence.toString());
    }

    @Test(groups={"integration"})
    @SpecAssertion(section="session_context_ee", id="cb")
    public void testSessionContextDestroyedWhenHttpSessionTimesOut() throws Exception {
        WebClient webClient = new WebClient();
        TextPage firstRequestResult = (TextPage)webClient.getPage(String.valueOf(this.contextPath) + "introspect");
        Assert.assertNotNull((Object)firstRequestResult.getContent());
        String sessionBeanId = firstRequestResult.getContent();
        Assert.assertNotNull((Object)sessionBeanId);
        webClient.getPage(String.valueOf(this.contextPath) + "introspect?mode=timeout");
        Timer.startNew((long)3000L);
        TextPage secondRequestResult = (TextPage)webClient.getPage(String.valueOf(this.contextPath) + "introspect");
        Assert.assertNotNull((Object)secondRequestResult.getContent());
        Assert.assertNotEquals((Object)secondRequestResult.getContent(), (Object)sessionBeanId);
        TextPage verifyResult = (TextPage)webClient.getPage(String.valueOf(this.contextPath) + "introspect?mode=verify");
        ActionSequence correctSequence = new ActionSequence().add(IntrospectHttpSessionListener.class.getName()).add(SimpleSessionBean.class.getName());
        Assert.assertEquals((String)verifyResult.getContent(), (String)correctSequence.toString());
    }
}

