/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.bb.session.stateless.equals.annotated;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.tests.ejb30.common.equals.CartIF;
import com.sun.ts.tests.ejb30.common.equals.ClientBase;
import com.sun.ts.tests.ejb30.common.equals.Comparator;
import com.sun.ts.tests.ejb30.common.equals.ShoppingCartIF;
import com.sun.ts.tests.ejb30.common.helper.ServiceLocator;
import com.sun.ts.tests.ejb30.common.helper.TLogger;
import com.sun.ts.tests.ejb30.common.helper.TestFailedException;
import jakarta.ejb.EJB;
import javax.naming.NamingException;

public class Client
extends ClientBase {
    @EJB(name="cart")
    private static CartIF cart;
    @EJB(name="cartOther")
    private static CartIF cartOther;
    @EJB(name="shoppingCart")
    private static ShoppingCartIF shoppingCart;
    @EJB(name="shoppingCartOther")
    private static ShoppingCartIF shoppingCartOther;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void equalsNull() throws TestFailedException {
        TLogger.log("Comparing " + String.valueOf(cart) + " to null, expecting false.");
        Comparator.compare(cart, null, false, true);
        TLogger.log("Comparing " + String.valueOf(cartOther) + " to null, expecting false.");
        Comparator.compare(cartOther, null, false, true);
        TLogger.log("Comparing " + String.valueOf(shoppingCart) + " to null, expecting false.");
        Comparator.compare(shoppingCart, null, false, true);
        TLogger.log("Comparing " + String.valueOf(shoppingCartOther) + " to null, expecting false.");
        Comparator.compare(shoppingCartOther, null, false, true);
    }

    public void selfEquals() throws Exception {
        try {
            Comparator.compare(cart, cart, true, true);
            Comparator.compare(shoppingCart, shoppingCart, true, true);
        }
        catch (TestFailedException e) {
            throw new Exception(e);
        }
    }

    public void selfEqualsLookup() throws Exception {
        try {
            Object cart = ServiceLocator.lookupByShortName("cart");
            Object shoppingCart = ServiceLocator.lookupByShortName("shoppingCart");
            Comparator.compare(cart, cart, true, true);
            Comparator.compare(shoppingCart, shoppingCart, true, true);
        }
        catch (TestFailedException e) {
            throw new Exception(e);
        }
        catch (NamingException e) {
            throw new Exception(e);
        }
    }

    public void otherEquals() throws Exception {
        try {
            Comparator.compare(cart, cartOther, true, true);
            Comparator.compare(shoppingCart, shoppingCartOther, true, true);
        }
        catch (TestFailedException e) {
            throw new Exception(e);
        }
    }

    public void otherEqualsLookup() throws Exception {
        try {
            Object cart = ServiceLocator.lookupByShortName("cart");
            Object cartOther = ServiceLocator.lookupByShortName("cartOther");
            Object shoppingCart = ServiceLocator.lookupByShortName("shoppingCart");
            Object shoppingCartOther = ServiceLocator.lookupByShortName("shoppingCartOther");
            Comparator.compare(cart, cartOther, cart, true, true);
            Comparator.compare(shoppingCart, shoppingCartOther, shoppingCart, true, true);
        }
        catch (TestFailedException e) {
            throw new Exception(e);
        }
        catch (NamingException e) {
            throw new Exception(e);
        }
    }

    public void differentInterfaceNotEqual() throws Exception {
        try {
            Comparator.compare(cart, shoppingCart, false, true);
        }
        catch (TestFailedException e) {
            throw new Exception(e);
        }
    }

    public void differentInterfaceNotEqualLookup() throws Exception {
        try {
            Object cart = ServiceLocator.lookupByShortName("cart");
            Object shoppingCart = ServiceLocator.lookupByShortName("shoppingCart");
            Comparator.compare(cart, shoppingCart, false, true);
        }
        catch (TestFailedException e) {
            throw new Exception(e);
        }
        catch (NamingException e) {
            throw new Exception(e);
        }
    }
}

