/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.lite.async.common.annotated;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb30.common.calc.CalculatorException;
import com.sun.ts.tests.ejb30.common.helper.TestFailedException;
import com.sun.ts.tests.ejb30.lite.async.common.AsyncJsfClientBase;
import com.sun.ts.tests.ejb30.lite.async.common.annotated.Async2IF;
import com.sun.ts.tests.ejb30.lite.async.common.annotated.AsyncAnnotatedMethodsCommonIF;
import com.sun.ts.tests.ejb30.lite.async.common.annotated.AsyncAnnotatedMethodsIF;
import com.sun.ts.tests.ejb30.lite.async.common.annotated.AsyncIF;
import jakarta.ejb.EJB;
import jakarta.ejb.EJBException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class AnnotatedJsfClientBase
extends AsyncJsfClientBase {
    protected int num1 = 10;
    protected int num2 = 20;
    protected int expectedSum = this.num1 + this.num2;
    protected static final int DESTROYED_COUNT = 50;
    @EJB(name="annotatedMethodsIF", beanName="AsyncAnnotatedMethodsBean")
    private AsyncAnnotatedMethodsIF annotatedMethodsIF;
    protected AsyncIF interface1;
    protected Async2IF interface2;
    protected AsyncIF noInterface;
    protected final AsyncIF[] beans = new AsyncIF[3];
    protected final AsyncAnnotatedMethodsCommonIF[] annotatedMethodsLocal = new AsyncAnnotatedMethodsCommonIF[1];

    protected abstract void setNoInterface(AsyncIF var1);

    public abstract void setInterface1(AsyncIF var1);

    public abstract void setInterface2(Async2IF var1);

    protected void assertBeanInstances(AsyncIF b) throws ExecutionException, InterruptedException {
    }

    @Override
    public void setup(String[] args, Properties p) {
        super.setup(args, p);
        this.beans[0] = (AsyncIF)this.lookup("interface1", "Async2Bean", AsyncIF.class);
        this.beans[1] = (AsyncIF)this.lookup("interface2", "Async2Bean", Async2IF.class);
        this.beans[2] = (AsyncIF)this.lookup("noInterface", "AsyncBean", null);
        this.annotatedMethodsLocal[0] = (AsyncAnnotatedMethodsCommonIF)this.lookup("annotatedMethodsIF", "AsyncAnnotatedMethodsBean", AsyncAnnotatedMethodsIF.class);
    }

    public void addAway() {
        for (int i = 0; i < this.beans.length; ++i) {
            this.statusSingleton.removeResult(i);
            int expected = this.expectedSum + i;
            this.beans[i].addAway(this.num1, this.num2, i);
            this.assertEquals("Check result stored in singleton.", expected, this.getAndResetResult(i, new long[0]));
        }
    }

    public void voidRuntimeException() throws InterruptedException, ExecutionException {
        Integer key = 1;
        for (AsyncIF b : this.beans) {
            this.statusSingleton.removeResult(key);
            b.voidRuntimeException(key);
            Integer completed = this.getAndResetResult(key, new long[0]);
            this.appendReason("Is voidRuntimeException async method completed? " + completed);
            this.assertBeanInstances(b);
        }
    }

    public void futureRuntimeException() throws InterruptedException, ExecutionException {
        for (AsyncIF b : this.beans) {
            try {
                b.futureRuntimeException().get();
                throw new RuntimeException("Expecting ExecutionException, but got none.");
            }
            catch (ExecutionException ex) {
                this.appendReason("Got expected ExecutionException " + TestUtil.printStackTraceToString((Throwable)ex));
                EJBException ejbException = (EJBException)ex.getCause();
                this.assertBeanInstances(b);
            }
        }
    }

    public void futureError() throws InterruptedException, ExecutionException {
        for (AsyncIF b : this.beans) {
            try {
                b.futureError().get();
                throw new RuntimeException("Expecting ExecutionException, but got none.");
            }
            catch (ExecutionException ex) {
                this.appendReason(String.format("%nGot expected ExecutionException from %s%n%s", b, TestUtil.printStackTraceToString((Throwable)ex)));
                EJBException ejbException = (EJBException)ex.getCause();
                this.assertBeanInstances(b);
            }
        }
    }

    public void futureException() throws InterruptedException, ExecutionException {
        String expectedMsg = "futureException";
        for (AsyncIF b : this.beans) {
            try {
                b.futureException().get();
                throw new RuntimeException("Expecting ExecutionException, but got none.");
            }
            catch (ExecutionException ex) {
                Throwable cause = ex.getCause();
                String actualMsg = cause.getMessage();
                if (actualMsg == null) {
                    throw new RuntimeException("Unexpected exception ", cause);
                }
                this.assertEquals(null, "futureException", actualMsg.substring(0, "futureException".length()));
            }
            catch (CalculatorException e) {
                throw new RuntimeException("Unexpected " + String.valueOf(e));
            }
        }
    }

    public void futureValueList() throws InterruptedException, ExecutionException {
        List<String> la = null;
        List<String> lb = Arrays.asList("b", "bb");
        List<String> lc = Arrays.asList("c", "cc");
        for (AsyncIF b : this.beans) {
            this.assertEquals(null, la, b.futureValueList(la).get());
            this.assertEquals(null, lb, b.futureValueList(lb).get());
            this.assertEquals(null, lc, b.futureValueList(lc).get());
        }
    }

    public void addReturn() throws InterruptedException, ExecutionException {
        for (AsyncIF bean : this.beans) {
            Future<Integer> future = bean.addReturn(this.num1, this.num2);
            this.assertEquals("Check Future result " + String.valueOf(future), this.expectedSum, future.get());
        }
    }

    public void addSyncThrowException() {
        try {
            this.annotatedMethodsIF.addSyncThrowException(this.num1, this.num2);
            throw new RuntimeException("Expecting TestFailedException, but got none.");
        }
        catch (TestFailedException ex) {
            this.appendReason("Got expected ", ex);
            return;
        }
    }

    public void addSyncReturn() {
        long waitMillis = 2000L;
        long start = System.currentTimeMillis();
        this.annotatedMethodsIF.addSyncReturn(this.num1, this.num2, 2000L);
        long end = System.currentTimeMillis();
        long elapsed = end - start;
        if (elapsed < 2000L) {
            throw new RuntimeException("For a blocking method elapsed time should >= waitMillis: " + elapsed + " 2000");
        }
        this.appendReason("Time elapsed >= waitMillis: " + elapsed + " 2000");
    }

    public void addReturnWaitMillis() throws ExecutionException, InterruptedException, TimeoutException {
        long waitMillis = 2000L;
        for (AsyncAnnotatedMethodsCommonIF b : this.annotatedMethodsLocal) {
            long start = System.currentTimeMillis();
            Future<Integer> result = b.addReturn(this.num1, this.num2, 2000L);
            long end = System.currentTimeMillis();
            long elapsed = end - start;
            if (elapsed >= 2000L) {
                throw new RuntimeException("For async method elapsed time should < waitMillis: " + elapsed + " 2000");
            }
            this.appendReason("Time elapsed < waitMillis: " + elapsed + " 2000");
            this.assertEquals("", this.expectedSum, result.get());
            this.assertEquals("", this.expectedSum, result.get(10L, TimeUnit.MILLISECONDS));
            this.assertEquals("", true, result.isDone());
            this.assertEquals("", false, result.isCancelled());
            this.assertEquals("", false, result.cancel(false));
            this.assertEquals("", false, result.cancel(true));
        }
    }

    public void cancelMayInterruptIfRunningFalse() throws ExecutionException, InterruptedException, TimeoutException {
        this.cancelMayInterruptIfRunning(false);
    }

    public void cancelMayInterruptIfRunningTrue() throws ExecutionException, InterruptedException, TimeoutException {
        this.cancelMayInterruptIfRunning(true);
    }

    public void passByValueOrReference() {
        String a = "a";
        String b = "b";
        for (int i = 0; i <= 2; ++i) {
            String[] params = new String[]{"a", "b"};
            this.beans[i].passByValueOrReference(params);
            this.assertNotEquals(this.beans[i].toString(), "a", params[0]);
            this.assertNotEquals(this.beans[i].toString(), "b", params[1]);
        }
    }

    public void passByValueOrReferenceAsync() throws InterruptedException, ExecutionException {
        String a = "a";
        String b = "b";
        for (int i = 0; i <= 2; ++i) {
            String[] params = new String[]{"a", "b"};
            this.beans[i].passByValueOrReferenceAsync(params).get();
            this.assertNotEquals(this.beans[i].toString(), "a", params[0]);
            this.assertNotEquals(this.beans[i].toString(), "b", params[1]);
        }
    }

    private void cancelMayInterruptIfRunning(boolean mayInterruptIfRunning) throws ExecutionException, InterruptedException, TimeoutException {
        this.statusSingleton.removeResult("CANCEL_IN_BEAN_KEY");
        this.statusSingleton.removeResult("CANCEL_IN_CLIENT_KEY");
        Future<Boolean> result = this.noInterface.cancelMayInterruptIfRunning();
        long stopTime = System.currentTimeMillis() + 60000L;
        while (!this.statusSingleton.isResultAvailable("CANCEL_IN_BEAN_KEY") && System.currentTimeMillis() < stopTime) {
            Thread.sleep(1000L);
        }
        if (!this.statusSingleton.isResultAvailable("CANCEL_IN_BEAN_KEY")) {
            throw new RuntimeException("The bean has not started processing the async method after waiting millis 60000");
        }
        this.appendReason("The bean has started processing the async method.");
        result.cancel(mayInterruptIfRunning);
        this.statusSingleton.addResult("CANCEL_IN_CLIENT_KEY", "CANCEL_IN_CLIENT_VAL");
        this.assertEquals(null, mayInterruptIfRunning, result.get());
    }
}

