/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb32.lite.timer.schedule.lifecycle;

import com.sun.ts.tests.ejb30.common.helper.Helper;
import com.sun.ts.tests.ejb30.timer.common.JsfClientBase;
import com.sun.ts.tests.ejb30.timer.common.TimerInfo;
import com.sun.ts.tests.ejb32.lite.timer.schedule.lifecycle.ScheduleBean;
import jakarta.ejb.EJB;
import jakarta.ejb.NoSuchObjectLocalException;
import jakarta.ejb.ScheduleExpression;
import jakarta.ejb.Timer;
import jakarta.ejb.TimerConfig;
import jakarta.ejb.TimerHandle;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Named;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

@Named(value="client")
@RequestScoped
public class JsfClient
extends JsfClientBase {
    public static final String TIMER_STORE_DIR = System.getProperty("java.io.tmpdir");
    public static final String TIMER_STORE_NAME = "ts-ejb30-timer.ser";
    public static final File TIMER_STORE = new File(TIMER_STORE_DIR, "ts-ejb30-timer.ser");
    @EJB(beanName="ScheduleBean")
    private ScheduleBean scheduleBean;

    private void deleteTimerStore() {
        if (TIMER_STORE.exists()) {
            boolean deleted = TIMER_STORE.delete();
            if (deleted) {
                Helper.getLogger().info("Deleted existing TIMER_STORE file: " + TIMER_STORE.getAbsolutePath());
            } else {
                Helper.getLogger().info("Failed to delete TIMER_STORE: " + TIMER_STORE.getAbsolutePath());
            }
        }
    }

    private void writeTimerHandle(TimerHandle handle) throws IOException {
        try (ObjectOutputStream out = null;){
            out = new ObjectOutputStream(new FileOutputStream(TIMER_STORE));
            out.writeObject(handle);
        }
    }

    private TimerHandle readTimerHandle() throws IOException, ClassNotFoundException {
        Object obj;
        try (ObjectInputStream in = null;){
            in = new ObjectInputStream(new FileInputStream(TIMER_STORE));
            obj = in.readObject();
        }
        return (TimerHandle)obj;
    }

    public void timerHandle() throws IOException, ClassNotFoundException {
        this.deleteTimerStore();
        Timer t = this.scheduleBean.findTimer("year5000");
        TimerHandle handle = this.scheduleBean.getTimerHandle(t);
        this.appendReason(new Object[]{" Got TimerHandle: " + String.valueOf(handle)});
        this.writeTimerHandle(handle);
        this.appendReason(new Object[]{" Serialized it to " + TIMER_STORE.getAbsolutePath()});
        handle = this.readTimerHandle();
        this.appendReason(new Object[]{" Read it from TIMER_STORE "});
        this.appendReason(new Object[]{this.scheduleBean.compareTimer(handle)});
        this.scheduleBean.cancelTimer(handle);
        this.appendReason(new Object[]{" Auto timer cancelled."});
        this.assertEquals("Confirm the timer no long exists", null, this.scheduleBean.findTimer("year5000"));
        this.appendReason(new Object[]{this.scheduleBean.getTimerExpired(handle)});
    }

    public void timerHandleIllegalStateException() {
        this.appendReason(new Object[]{this.scheduleBean.timerHandleIllegalStateException()});
    }

    public void isCalendarTimerAndGetSchedule() {
        this.appendReason(new Object[]{this.scheduleBean.isCalendarTimerAndGetSchedule()});
    }

    public void timerEquals() {
        ScheduleExpression exp = new ScheduleExpression();
        Timer t2 = this.scheduleBean.createFarFutureTimer(new TimerConfig((Serializable)new TimerInfo(this.getTestName()), false));
        Timer t3 = this.scheduleBean.createTimer(exp, new TimerConfig((Serializable)new TimerInfo(this.getTestName()), false));
        Timer t4 = this.scheduleBean.createTimer(exp, new TimerConfig((Serializable)new TimerInfo(this.getTestName()), false));
        String t1Name = this.getTestName() + "t1";
        Timer t1 = this.scheduleBean.createSecondLaterTimer(new TimerConfig((Serializable)new TimerInfo(t1Name), false));
        Timer t1Found = this.scheduleBean.findTimer(t1Name);
        this.assertEquals("Compare timer to itself.", t1, t1);
        this.assertEquals("Compare timer to t1Found.", t1, t1Found);
        this.assertNotEquals("Compare timer to null.", t1, null);
        this.assertNotEquals("Compare timer to 1.", t1, 1);
        this.assertNotEquals("Compare timer to true.", t1, true);
        try {
            TimerHandle timerHandle = this.scheduleBean.getTimerHandle(t1);
            this.assertNotEquals("Compare timer to TimerHandle.", t1, timerHandle);
            this.assertNotEquals("Compare TimerHandle to timer.", timerHandle, t1);
        }
        catch (NoSuchObjectLocalException ex) {
            ex.printStackTrace();
        }
        this.assertNotEquals("Compare 2 timers.", t1, t2);
        this.assertNotEquals("Compare timer 3 to timer 4.", t3, t4);
        try {
            this.scheduleBean.cancelTimer(new Timer[]{t1, t2, t3, t4});
        }
        catch (NoSuchObjectLocalException ex) {
            ex.printStackTrace();
        }
    }

    public void createAndComplete() {
        this.scheduleBean.createSecondLaterTimer(new TimerConfig((Serializable)new TimerInfo(this.getTestName()), false));
        this.appendReason(new Object[]{"Created a timer and wait for its completion."});
        this.passIfTimeoutOnce(new long[0]);
    }

    public void completeAndNoSuchObjectLocalException() {
        Timer t = this.scheduleBean.createSecondLaterTimer(new TimerConfig((Serializable)new TimerInfo(this.getTestName()), false));
        this.passIfTimeoutOnce(new long[0]);
        this.appendReason(new Object[]{this.scheduleBean.passIfNoSuchObjectLocalException(t)});
    }

    public void cancelAndNoSuchObjectLocalException() {
        Timer t = this.scheduleBean.createFarFutureTimer(new TimerConfig((Serializable)new TimerInfo(this.getTestName()), false));
        this.scheduleBean.cancelTimerWithNoTransaction(t);
        this.appendReason(new Object[]{this.scheduleBean.passIfNoSuchObjectLocalException(t)});
    }

    public void cancelWithTxAndNoSuchObjectLocalException() {
        Timer t = this.scheduleBean.createFarFutureTimer(new TimerConfig((Serializable)new TimerInfo(this.getTestName()), false));
        this.scheduleBean.cancelTimer(new Timer[]{t});
        this.appendReason(new Object[]{this.scheduleBean.passIfNoSuchObjectLocalException(t)});
    }
}

