/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.pages.spec.configuration.includes;

import ee.jakarta.tck.pages.common.client.AbstractUrlClient;
import java.io.IOException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class URLClientIT
extends AbstractUrlClient {
    public URLClientIT() throws Exception {
        this.setContextRoot("/jsp_config_includes_web");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        String packagePath = URLClientIT.class.getPackageName().replace(".", "/");
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jsp_config_includes_web.war");
        archive.setWebXML(URLClientIT.class.getClassLoader().getResource(packagePath + "/jsp_config_includes_web.xml"));
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/jspf/prelude3.jspf", "jspf/prelude3.jspf");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/jspf/prelude2.jspf", "jspf/prelude2.jspf");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/jspf/prelude1.jspf", "jspf/prelude1.jspf");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/jspf/coda3.jspf", "jspf/coda3.jspf");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/jspf/coda2.jspf", "jspf/coda2.jspf");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/jspf/coda1.jspf", "jspf/coda1.jspf");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/IncludesTest.jsp")), "IncludesTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/two/Includes2Test.jsp")), "two/Includes2Test.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/three/Includes3Test.jspx")), "three/Includes3Test.jspx");
        return archive;
    }

    @Test
    public void jspConfigurationIncludesTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_config_includes_web/IncludesTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Prelude1|JSP Body|Coda1");
        this.invoke();
    }

    @Test
    public void jspConfigurationIncludes2Test() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_config_includes_web/two/Includes2Test.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Prelude1|Prelude2|JSP Body 2|Coda1|Coda2");
        this.invoke();
    }

    @Test
    public void jspConfigurationIncludes3Test() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_config_includes_web/three/Includes3Test.jspx HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Prelude2|Prelude3|JSP Body 3|Coda2|Coda3");
        this.invoke();
    }
}

