/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.StoredProcedureQuery;

import ee.jakarta.tck.persistence.core.StoredProcedureQuery.Client;
import ee.jakarta.tck.persistence.core.StoredProcedureQuery.Employee;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.LockModeType;
import jakarta.persistence.NoResultException;
import jakarta.persistence.NonUniqueResultException;
import jakarta.persistence.Parameter;
import jakarta.persistence.ParameterMode;
import jakarta.persistence.StoredProcedureQuery;
import jakarta.persistence.TemporalType;
import jakarta.persistence.TransactionRequiredException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client1
extends Client {
    private static final System.Logger logger = System.getLogger(Client1.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client1.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] xmlFiles = new String[]{"myMappingFile.xml"};
        String[] classes = new String[]{pkgName + "Employee", pkgName + "Employee2", pkgName + "EmployeeMappedSC"};
        return this.createDeploymentJar("jpa_core_types_StoredProcedureQuery1.jar", pkgNameWithoutSuffix, classes, xmlFiles);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
            this.createEmployeeTestData();
            this.dataBaseName = System.getProperty("jdbc.db");
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void executeTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        try {
            ArrayList<Integer> expected;
            List<List> listOfList;
            StoredProcedureQuery spq;
            this.getEntityTransaction().begin();
            try {
                logger.log(System.Logger.Level.INFO, "Testing using name,class");
                this.clearCache();
                spq = this.getEntityManager().createStoredProcedureQuery("GetEmpASCFromRS", new Class[]{Employee.class});
                if (this.dataBaseName.equalsIgnoreCase("oracle") || this.dataBaseName.equalsIgnoreCase("postgresql")) {
                    logger.log(System.Logger.Level.TRACE, "register refcursor parameter");
                    spq.registerStoredProcedureParameter(1, Void.TYPE, ParameterMode.REF_CURSOR);
                }
                logger.log(System.Logger.Level.TRACE, "executing:" + spq.toString());
                if (spq.execute()) {
                    listOfList = this.getResultSetsFromStoredProcedure(spq);
                    if (listOfList.size() == 1) {
                        expected = new ArrayList<Integer>();
                        for (Employee e : this.empRef) {
                            expected.add(e.getId());
                        }
                        pass1 = this.verifyEmployeeIds(expected, listOfList);
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Did not get the correct number of result sets returned, expected: 1, actual:" + listOfList.size());
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected execute() to return true, actual: false");
                }
            }
            catch (Exception ex) {
                logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
            }
            try {
                logger.log(System.Logger.Level.INFO, "Testing using name,result mapping");
                this.clearCache();
                spq = this.getEntityManager().createStoredProcedureQuery("GetEmpIdFNameLNameFromRS", new String[]{"id-firstname-lastname"});
                spq.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
                if (this.dataBaseName.equalsIgnoreCase("oracle") || this.dataBaseName.equalsIgnoreCase("postgresql")) {
                    logger.log(System.Logger.Level.TRACE, "register refcursor parameter");
                    spq.registerStoredProcedureParameter(2, Void.TYPE, ParameterMode.REF_CURSOR);
                }
                spq.setParameter(1, (Object)1);
                if (spq.execute()) {
                    listOfList = this.getResultSetsFromStoredProcedure(spq);
                    if (listOfList.size() == 1) {
                        expected = new ArrayList();
                        expected.add((Integer)((Object)new Employee(this.emp0.getId(), this.emp0.getFirstName(), this.emp0.getLastName())));
                        pass2 = this.verifyListOfListEmployees(expected, listOfList);
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Did not get the correct number of result sets returned, expected: 1, actual:" + listOfList.size());
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected execute() to return false, actual: true");
                }
            }
            catch (Exception ex) {
                logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
            }
            try {
                logger.log(System.Logger.Level.INFO, "Testing using named stored procedure");
                this.clearCache();
                if (this.dataBaseName.equalsIgnoreCase("oracle") || this.dataBaseName.equalsIgnoreCase("postgresql")) {
                    logger.log(System.Logger.Level.TRACE, "Calling refcursor specific named stored procedure query");
                    spq = this.getEntityManager().createNamedStoredProcedureQuery("get-id-firstname-lastname-refcursor");
                } else {
                    spq = this.getEntityManager().createNamedStoredProcedureQuery("get-id-firstname-lastname");
                }
                spq.setParameter(1, (Object)1);
                if (spq.execute()) {
                    listOfList = this.getResultSetsFromStoredProcedure(spq);
                    if (listOfList.size() == 1) {
                        expected = new ArrayList();
                        expected.add((Integer)((Object)new Employee(this.emp0.getId(), this.emp0.getFirstName(), this.emp0.getLastName())));
                        pass3 = this.verifyListOfListEmployees(expected, listOfList);
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Did not get the correct number of result sets returned, expected: 1, actual:" + listOfList.size());
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected execute() to return false, actual: true");
                }
            }
            catch (Exception ex) {
                logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new Exception("executeTest failed");
        }
    }

    @Test
    public void getOutputParameterValueIntTest() throws Exception {
        String actual;
        boolean pass2 = false;
        boolean pass4 = false;
        boolean pass6 = false;
        Object oActual = null;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.INFO, "Get the value from an OUT only parameter");
            StoredProcedureQuery spq3 = this.getEntityManager().createStoredProcedureQuery("GetEmpOneFirstNameFromOut");
            spq3.registerStoredProcedureParameter(1, String.class, ParameterMode.OUT);
            if (!spq3.execute()) {
                oActual = spq3.getOutputParameterValue(1);
                if (oActual instanceof String) {
                    actual = (String)oActual;
                    if (actual.equals(this.emp0.getFirstName())) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result:" + actual);
                        pass6 = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected result: " + this.emp0.getFirstName() + ", actual:" + actual);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Did not get instance of String, instead:" + oActual);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected execute() to return false, actual: true");
            }
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Get the value from an IN and OUT parameter");
            StoredProcedureQuery spq1 = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
            spq1.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            spq1.registerStoredProcedureParameter(2, String.class, ParameterMode.OUT);
            spq1.setParameter(1, (Object)1);
            if (!spq1.execute()) {
                oActual = spq1.getOutputParameterValue(2);
                if (oActual instanceof String) {
                    actual = (String)oActual;
                    if (actual.equals(this.emp0.getFirstName())) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result:" + actual);
                        pass2 = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected result: " + this.emp0.getFirstName() + ", actual:" + actual);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Did not get instance of String, instead:" + oActual);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected execute() to return false, actual: true");
            }
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Get the value from an INOUT parameter");
            StoredProcedureQuery spq2 = this.getEntityManager().createStoredProcedureQuery("GetEmpLastNameFromInOut");
            spq2.registerStoredProcedureParameter(1, String.class, ParameterMode.INOUT);
            spq2.setParameter(1, (Object)"1");
            if (!spq2.execute()) {
                oActual = spq2.getOutputParameterValue(1);
                if (oActual instanceof String) {
                    actual = (String)oActual;
                    if (actual.equals(this.emp0.getLastName())) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result:" + actual);
                        pass4 = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected result: " + this.emp0.getLastName() + ", actual:" + actual);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected Integer to be returned, actual:" + oActual);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected execute() to return false, actual: true");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
        }
        if (!(pass2 && pass4 && pass6)) {
            throw new Exception("getOutputParameterValueIntTest failed");
        }
    }

    @Test
    public void getOutputParameterValueIntIllegalArgumentExceptionTest() throws Exception {
        boolean pass4;
        boolean pass2;
        block15: {
            pass2 = false;
            pass4 = false;
            try {
                block14: {
                    this.getEntityTransaction().begin();
                    logger.log(System.Logger.Level.INFO, "Get a value that does not exist");
                    StoredProcedureQuery spq1 = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
                    spq1.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
                    spq1.registerStoredProcedureParameter(2, String.class, ParameterMode.OUT);
                    spq1.setParameter(1, (Object)1);
                    if (!spq1.execute()) {
                        try {
                            spq1.getOutputParameterValue(99);
                            logger.log(System.Logger.Level.ERROR, "Did not throw IllegalArgumentException");
                        }
                        catch (IllegalArgumentException iae) {
                            logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                            if (!this.getEntityTransaction().getRollbackOnly()) {
                                pass2 = true;
                                logger.log(System.Logger.Level.TRACE, "Transaction was not marked for rollback");
                                break block14;
                            }
                            logger.log(System.Logger.Level.ERROR, "Transaction was marked for rollback and should not have been");
                        }
                        catch (Exception e) {
                            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected execute() to return false, actual: true");
                    }
                }
                logger.log(System.Logger.Level.INFO, "Get the value from an IN parameter");
                StoredProcedureQuery spq2 = this.getEntityManager().createStoredProcedureQuery("GetEmpLastNameFromInOut");
                spq2.registerStoredProcedureParameter(1, String.class, ParameterMode.INOUT);
                spq2.setParameter(1, (Object)"1");
                if (!spq2.execute()) {
                    try {
                        spq2.getOutputParameterValue(99);
                        logger.log(System.Logger.Level.ERROR, "Did not throw IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                        pass4 = true;
                    }
                    catch (Exception e) {
                        logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
                    }
                    if (this.getEntityTransaction().isActive()) {
                        this.getEntityTransaction().rollback();
                    }
                    break block15;
                }
                logger.log(System.Logger.Level.ERROR, "Expected execute() to return false, actual: true");
            }
            catch (Exception ex) {
                logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
            }
        }
        if (!pass2 || !pass4) {
            throw new Exception("getOutputParameterValueIntIllegalArgumentExceptionTest failed");
        }
    }

    @Test
    public void getFirstResultTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        try {
            int num;
            this.getEntityTransaction().begin();
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpASCFromRS", new Class[]{Employee.class});
            if (this.dataBaseName.equalsIgnoreCase("oracle") || this.dataBaseName.equalsIgnoreCase("postgresql")) {
                logger.log(System.Logger.Level.TRACE, "register refcursor parameter");
                spq.registerStoredProcedureParameter(1, Void.TYPE, ParameterMode.REF_CURSOR);
            }
            if ((num = spq.getFirstResult()) == 0) {
                logger.log(System.Logger.Level.TRACE, "Received expected first result when none is set:" + num);
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected first result when none is set: 0, actual:" + num);
            }
            List actual = spq.getResultList();
            num = spq.getFirstResult();
            if (num == 0) {
                logger.log(System.Logger.Level.TRACE, "Received expected first result:" + num + " after getResultList");
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected first result: 0, actual:" + num + " after getResultList");
            }
            if (actual.size() > 0) {
                pass3 = this.verifyListEmployees(this.empRef, actual);
            } else {
                logger.log(System.Logger.Level.ERROR, "getResultList() returned 0 results");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new Exception("getFirstResultTest failed");
        }
    }

    @Test
    public void getMaxResultsTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        try {
            int num;
            this.getEntityTransaction().begin();
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpASCFromRS", new Class[]{Employee.class});
            if (this.dataBaseName.equalsIgnoreCase("oracle") || this.dataBaseName.equalsIgnoreCase("postgresql")) {
                logger.log(System.Logger.Level.TRACE, "register refcursor parameter");
                spq.registerStoredProcedureParameter(1, Void.TYPE, ParameterMode.REF_CURSOR);
            }
            if ((num = spq.getMaxResults()) == Integer.MAX_VALUE) {
                logger.log(System.Logger.Level.TRACE, "Received expected max result:" + num);
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected max result: 2147483647, actual:" + num);
            }
            List actual = spq.getResultList();
            num = spq.getMaxResults();
            if (num == Integer.MAX_VALUE) {
                logger.log(System.Logger.Level.TRACE, "Received expected max result:" + num + " after getResultList");
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected max result:2147483647, actual:" + num + " after getResultList");
            }
            if (actual.size() > 0) {
                pass3 = this.verifyListEmployees(this.empRef, actual);
            } else {
                logger.log(System.Logger.Level.ERROR, "getResultList() returned 0 results");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new Exception("getMaxResultsTest failed");
        }
    }

    @Test
    public void getSingleResultTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.clearCache();
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpIdFNameLNameFromRS", new String[]{"id-firstname-lastname"});
            spq.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            if (this.dataBaseName.equalsIgnoreCase("oracle") || this.dataBaseName.equalsIgnoreCase("postgresql")) {
                logger.log(System.Logger.Level.TRACE, "register refcursor parameter");
                spq.registerStoredProcedureParameter(2, Void.TYPE, ParameterMode.REF_CURSOR);
            }
            spq.setParameter(1, (Object)1);
            Employee expected = new Employee(this.emp0.getId(), this.emp0.getFirstName(), this.emp0.getLastName());
            Object o = spq.getSingleResult();
            if (o instanceof Employee) {
                Employee actual = (Employee)o;
                if (actual.equals(expected)) {
                    logger.log(System.Logger.Level.TRACE, "Received expected result:" + actual);
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected result:" + expected + ", actual:" + actual);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Did not get Integer result:" + o);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
        }
        if (!pass) {
            throw new Exception("getSingleResultTest failed");
        }
    }

    @Test
    public void getSingleResultOrNullWithValueTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.clearCache();
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpIdFNameLNameFromRS", new String[]{"id-firstname-lastname"});
            spq.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            if (this.dataBaseName.equalsIgnoreCase("oracle") || this.dataBaseName.equalsIgnoreCase("postgresql")) {
                logger.log(System.Logger.Level.TRACE, "register refcursor parameter");
                spq.registerStoredProcedureParameter(2, Void.TYPE, ParameterMode.REF_CURSOR);
            }
            spq.setParameter(1, (Object)1);
            Employee expected = new Employee(this.emp0.getId(), this.emp0.getFirstName(), this.emp0.getLastName());
            Object o = spq.getSingleResultOrNull();
            if (o instanceof Employee) {
                Employee actual = (Employee)o;
                if (actual.equals(expected)) {
                    logger.log(System.Logger.Level.TRACE, "Received expected result:" + actual);
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected result:" + expected + ", actual:" + actual);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Did not get Integer result:" + o);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
        }
        if (!pass) {
            throw new Exception("getSingleResultOrNullWithValueTest failed");
        }
    }

    @Test
    public void getSingleResultOrNullWithNullTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.clearCache();
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpIdFNameLNameFromRS", new String[]{"id-firstname-lastname"});
            spq.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            if (this.dataBaseName.equalsIgnoreCase("oracle") || this.dataBaseName.equalsIgnoreCase("postgresql")) {
                logger.log(System.Logger.Level.TRACE, "register refcursor parameter");
                spq.registerStoredProcedureParameter(2, Void.TYPE, ParameterMode.REF_CURSOR);
            }
            spq.setParameter(1, (Object)0);
            Object result = spq.getSingleResultOrNull();
            if (result == null) {
                logger.log(System.Logger.Level.TRACE, "Received expected null value.");
                pass = true;
            } else {
                Employee actual = (Employee)result;
                logger.log(System.Logger.Level.ERROR, "Unexpected not null result:" + actual);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
        }
        if (!pass) {
            throw new Exception("getSingleResultOrNullWithNullTest failed");
        }
    }

    @Test
    public void getSingleResultNoResultExceptionTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpIdFNameLNameFromRS");
            spq.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            if (this.dataBaseName.equalsIgnoreCase("oracle") || this.dataBaseName.equalsIgnoreCase("postgresql")) {
                logger.log(System.Logger.Level.TRACE, "register refcursor parameter");
                spq.registerStoredProcedureParameter(2, Void.TYPE, ParameterMode.REF_CURSOR);
            }
            spq.setParameter(1, (Object)99);
            try {
                spq.getSingleResult();
                logger.log(System.Logger.Level.ERROR, "Did not throw NoResultException");
            }
            catch (NoResultException nre) {
                logger.log(System.Logger.Level.TRACE, "Received expected NoResultException");
                pass = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
            }
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
        }
        if (!pass) {
            throw new Exception("getSingleResultNoResultExceptionTest failed");
        }
    }

    @Test
    public void getSingleResultNonUniqueResultExceptionTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpASCFromRS", new Class[]{Employee.class});
            if (this.dataBaseName.equalsIgnoreCase("oracle") || this.dataBaseName.equalsIgnoreCase("postgresql")) {
                logger.log(System.Logger.Level.TRACE, "register refcursor parameter");
                spq.registerStoredProcedureParameter(1, Void.TYPE, ParameterMode.REF_CURSOR);
            }
            try {
                spq.getSingleResult();
                logger.log(System.Logger.Level.ERROR, "Did not throw NonUniqueResultException");
            }
            catch (NonUniqueResultException nure) {
                logger.log(System.Logger.Level.TRACE, "Received expected NonUniqueResultException");
                pass = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
            }
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
        }
        if (!pass) {
            throw new Exception("getSingleResultNonUniqueResultExceptionTest failed");
        }
    }

    @Test
    public void setgetFlushModeTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            FlushModeType fmt;
            logger.log(System.Logger.Level.INFO, "Testing StoredProcedureQuery");
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpASCFromRS", new Class[]{Employee.class});
            if (this.dataBaseName.equalsIgnoreCase("oracle") || this.dataBaseName.equalsIgnoreCase("postgresql")) {
                logger.log(System.Logger.Level.TRACE, "register refcursor parameter");
                spq.registerStoredProcedureParameter(1, Void.TYPE, ParameterMode.REF_CURSOR);
            }
            if ((fmt = spq.getFlushMode()) != null) {
                if (fmt.equals((Object)this.getEntityManager().getFlushMode())) {
                    logger.log(System.Logger.Level.TRACE, "Setting mode to returned default mode");
                    spq.setFlushMode(fmt);
                    logger.log(System.Logger.Level.TRACE, "Setting mode to FlushModeType.COMMIT");
                    spq.setFlushMode(FlushModeType.COMMIT);
                    fmt = spq.getFlushMode();
                    if (fmt.equals((Object)FlushModeType.COMMIT)) {
                        logger.log(System.Logger.Level.TRACE, "Setting mode to FlushModeType.AUTO");
                        spq.setFlushMode(FlushModeType.AUTO);
                        fmt = spq.getFlushMode();
                        if (fmt.equals((Object)FlushModeType.AUTO)) {
                            logger.log(System.Logger.Level.TRACE, "Query object returned from setFlushMode");
                            StoredProcedureQuery q = spq.setFlushMode(FlushModeType.COMMIT);
                            fmt = q.getFlushMode();
                            if (fmt.equals((Object)FlushModeType.COMMIT)) {
                                logger.log(System.Logger.Level.TRACE, "Received expected Query FlushModeType:" + fmt.name());
                                pass1 = true;
                            } else {
                                logger.log(System.Logger.Level.ERROR, "Expected a value of:" + FlushModeType.COMMIT.name() + ", actual:" + fmt.name());
                            }
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Expected a value of:" + FlushModeType.AUTO.name() + ", actual:" + fmt.name());
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected a default value of:" + FlushModeType.COMMIT.name() + ", actual:" + fmt.name());
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected EntityManager value of:" + this.getEntityManager().getFlushMode() + ", actual:" + fmt.name());
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getFlushMode return null");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing Query object returned from setFlushMode");
            StoredProcedureQuery spq2 = this.getEntityManager().createStoredProcedureQuery("GetEmpASCFromRS", new Class[]{Employee.class});
            logger.log(System.Logger.Level.TRACE, "Setting mode to FlushModeType.AUTO");
            StoredProcedureQuery q = spq2.setFlushMode(FlushModeType.AUTO);
            FlushModeType fmt = q.getFlushMode();
            if (fmt.equals((Object)FlushModeType.AUTO)) {
                logger.log(System.Logger.Level.TRACE, "Received expected value of:" + fmt.name());
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected a value of:" + FlushModeType.AUTO.name() + ", actual:" + fmt.name());
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("setgetFlushModeTest failed");
        }
    }

    @Test
    public void setLockModeIllegalStateExceptionTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("UpdateEmpSalaryColumn");
            try {
                spq.setLockMode(LockModeType.PESSIMISTIC_READ);
                logger.log(System.Logger.Level.ERROR, "Did not throw IllegalStateException");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalStateException");
                pass = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
            }
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("setLockModeIllegalStateExceptionTest failed");
        }
    }

    @Test
    public void getLockModeIllegalStateExceptionTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("UpdateEmpSalaryColumn");
            try {
                spq.getLockMode();
                logger.log(System.Logger.Level.ERROR, "Did not throw IllegalStateException");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalStateException");
                pass = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
            }
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("getLockModeIllegalStateExceptionTest failed");
        }
    }

    @Test
    public void setGetParameterIntTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.INFO, "Testing StoredProcedureQuery");
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
            spq.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            spq.registerStoredProcedureParameter(2, String.class, ParameterMode.OUT);
            spq.setParameter(1, (Object)1);
            Parameter p = spq.getParameter(1);
            int pos = p.getPosition();
            if (pos == 1) {
                logger.log(System.Logger.Level.TRACE, "Received expected parameter:" + pos);
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected position: 1, actual:" + pos);
            }
            logger.log(System.Logger.Level.INFO, "Testing Query object returned from getParameter");
            StoredProcedureQuery spq2 = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
            spq2.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            spq2.registerStoredProcedureParameter(2, String.class, ParameterMode.OUT);
            StoredProcedureQuery q = spq2.setParameter(1, (Object)1);
            p = q.getParameter(1);
            pos = p.getPosition();
            if (pos == 1) {
                logger.log(System.Logger.Level.TRACE, "Received expected parameter:" + pos);
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected position: 1, actual:" + pos);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("setGetParameterIntTest failed");
        }
    }

    @Test
    public void getParameterStringExceptionTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.INFO, "Testing StoredProcedureQuery ");
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
            spq.registerStoredProcedureParameter("ID", Integer.class, ParameterMode.IN);
            spq.registerStoredProcedureParameter("FIRSTNAME", String.class, ParameterMode.OUT);
            spq.setParameter("ID", (Object)1);
            try {
                spq.getParameter("DOESNOTEXIST");
                logger.log(System.Logger.Level.ERROR, "Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                pass1 = true;
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalStateException");
                pass1 = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
            }
            logger.log(System.Logger.Level.INFO, "Testing Query object returned from getParameter");
            StoredProcedureQuery spq2 = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
            spq2.registerStoredProcedureParameter("ID", Integer.class, ParameterMode.IN);
            spq2.registerStoredProcedureParameter("FIRSTNAME", String.class, ParameterMode.OUT);
            StoredProcedureQuery q = spq2.setParameter("ID", (Object)1);
            try {
                q.getParameter("DOESNOTEXIST");
                logger.log(System.Logger.Level.ERROR, "Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                pass2 = true;
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalStateException");
                pass2 = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
            }
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("getParameterStringExceptionTest failed");
        }
    }

    @Test
    public void getParameterIntIllegalArgumentExceptionTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.INFO, "Testing StoredProcedureQuery ");
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
            spq.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            spq.registerStoredProcedureParameter(2, String.class, ParameterMode.OUT);
            spq.setParameter(1, (Object)1);
            try {
                spq.getParameter(99);
                logger.log(System.Logger.Level.ERROR, "Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                pass1 = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
            }
            logger.log(System.Logger.Level.INFO, "Testing Query object returned from getParameter");
            StoredProcedureQuery spq2 = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
            spq2.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            spq2.registerStoredProcedureParameter(2, String.class, ParameterMode.OUT);
            StoredProcedureQuery q = spq2.setParameter(1, (Object)1);
            try {
                q.getParameter(99);
                logger.log(System.Logger.Level.ERROR, "Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                pass2 = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
            }
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("getParameterIntIllegalArgumentExceptionTest failed");
        }
    }

    @Test
    public void setParameterParameterObjectTest() throws Exception {
        boolean pass4;
        boolean pass2;
        block18: {
            block17: {
                pass2 = false;
                pass4 = false;
                try {
                    this.getEntityTransaction().begin();
                    logger.log(System.Logger.Level.INFO, "Testing StoredProcedureQuery ");
                    StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
                    spq.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
                    spq.registerStoredProcedureParameter(2, String.class, ParameterMode.OUT);
                    spq.setParameter(1, (Object)99);
                    Parameter p = spq.getParameter(1);
                    spq.setParameter(p, (Object)1);
                    if (!spq.execute()) {
                        Object oActual = spq.getOutputParameterValue(2);
                        if (oActual instanceof String) {
                            String actual = (String)oActual;
                            if (actual.equals(this.emp0.getFirstName())) {
                                logger.log(System.Logger.Level.TRACE, "Received expected result:" + actual);
                                pass2 = true;
                            } else {
                                logger.log(System.Logger.Level.ERROR, "Expected result: " + this.emp0.getFirstName() + ", actual:" + actual);
                            }
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Did not get instance of String, instead:" + oActual.getClass());
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected execute() to return false, actual: true");
                    }
                    this.getEntityTransaction().commit();
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Caught exception", (Throwable)e);
                    if (!this.getEntityTransaction().isActive()) break block17;
                    this.getEntityTransaction().rollback();
                }
            }
            try {
                this.getEntityTransaction().begin();
                logger.log(System.Logger.Level.INFO, "Testing Query object returned from setParameter");
                StoredProcedureQuery spq2 = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
                spq2.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
                spq2.registerStoredProcedureParameter(2, String.class, ParameterMode.OUT);
                StoredProcedureQuery q = spq2;
                q.setParameter(1, (Object)99);
                Parameter p = q.getParameter(1);
                q.setParameter(p, (Object)1);
                StoredProcedureQuery spq3 = q;
                if (!spq3.execute()) {
                    Object oActual = spq3.getOutputParameterValue(2);
                    if (oActual instanceof String) {
                        String actual = (String)oActual;
                        if (actual.equals(this.emp0.getFirstName())) {
                            logger.log(System.Logger.Level.TRACE, "Received expected result:" + actual);
                            pass4 = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Expected result: " + this.emp0.getFirstName() + ", actual:" + actual);
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Did not get instance of String, instead:" + oActual);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected execute() to return false, actual: true");
                }
                this.getEntityTransaction().commit();
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught exception", (Throwable)e);
                if (!this.getEntityTransaction().isActive()) break block18;
                this.getEntityTransaction().rollback();
            }
        }
        if (!pass2 || !pass4) {
            throw new Exception("setParameterParameterObjectTest failed");
        }
    }

    @Test
    public void setParameterParameterObjectIllegalArgumentExceptionTest() throws Exception {
        boolean pass1 = false;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "Get parameter from other stored procedure");
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpLastNameFromInOut");
            spq.registerStoredProcedureParameter(1, String.class, ParameterMode.INOUT);
            spq.setParameter(1, (Object)"INOUT");
            Parameter p = spq.getParameter(1);
            StoredProcedureQuery spq2 = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
            spq2.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            spq2.registerStoredProcedureParameter(2, String.class, ParameterMode.OUT);
            try {
                spq2.setParameter(p, (Object)1);
                logger.log(System.Logger.Level.ERROR, "Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                pass1 = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
            }
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception", (Throwable)e);
        }
        if (!pass1) {
            throw new Exception("setParameterParameterObjectIllegalArgumentExceptionTest failed");
        }
    }

    @Test
    public void setParameterIntObjectIllegalArgumentExceptionTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        boolean pass4 = false;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.INFO, "Testing StoredProcedureQuery with incorrect position specified");
            StoredProcedureQuery spq1 = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
            spq1.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            spq1.registerStoredProcedureParameter(2, String.class, ParameterMode.OUT);
            try {
                spq1.setParameter(99, (Object)1);
                logger.log(System.Logger.Level.ERROR, "Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                pass1 = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
            }
            logger.log(System.Logger.Level.INFO, "Testing StoredProcedureQuery with incorrect type specified");
            StoredProcedureQuery spq2 = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
            spq2.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            spq2.registerStoredProcedureParameter(2, String.class, ParameterMode.OUT);
            try {
                spq2.setParameter(1, (Object)new Date());
                logger.log(System.Logger.Level.ERROR, "Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                pass2 = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
            }
            logger.log(System.Logger.Level.INFO, "Testing Query object with incorrect position specified");
            StoredProcedureQuery spq3 = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
            spq3.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            spq3.registerStoredProcedureParameter(2, String.class, ParameterMode.OUT);
            StoredProcedureQuery q1 = spq3.setParameter(1, (Object)1);
            try {
                spq3.setParameter(99, (Object)1);
                logger.log(System.Logger.Level.ERROR, "Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                pass3 = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
            }
            logger.log(System.Logger.Level.INFO, "Testing Query object with incorrect type specified");
            StoredProcedureQuery spq4 = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
            spq4.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            spq4.registerStoredProcedureParameter(2, String.class, ParameterMode.OUT);
            StoredProcedureQuery q2 = spq4.setParameter(1, (Object)1);
            try {
                q2.setParameter(1, (Object)new Date());
                logger.log(System.Logger.Level.ERROR, "Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                pass4 = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
            }
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception", (Throwable)e);
        }
        if (!(pass1 && pass2 && pass3 && pass4)) {
            throw new Exception("setParameterIntObjectIllegalArgumentExceptionTest failed");
        }
    }

    @Test
    public void getParametersTest() throws Exception {
        boolean pass1 = false;
        boolean pass3 = false;
        try {
            this.getEntityTransaction().begin();
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
            Set p1 = spq.getParameters();
            if (p1.size() == 0) {
                logger.log(System.Logger.Level.TRACE, "Received expected number of parameters when non exist:" + p1.size());
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected number of parameters when non exist: 0, actual:" + p1);
            }
            spq.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            spq.registerStoredProcedureParameter(2, String.class, ParameterMode.OUT);
            spq.setParameter(1, (Object)1);
            if (!spq.execute()) {
                Set p2 = spq.getParameters();
                if (p2.size() == 2) {
                    logger.log(System.Logger.Level.TRACE, "Received expected number of parameters:" + p2.size());
                    pass3 = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected number of parameters: 2, actual:" + p2.size());
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected execute() to return false, actual: true");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        if (!pass1 || !pass3) {
            throw new Exception("getParametersTest failed");
        }
    }

    @Test
    public void setParameterIntDateTemporalTypeTest() throws Exception {
        boolean pass2 = false;
        boolean pass4 = false;
        try {
            this.getEntityTransaction().begin();
            try {
                logger.log(System.Logger.Level.INFO, "Testing StoredProcedureQuery");
                StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpIdUsingHireDateFromOut");
                spq.registerStoredProcedureParameter(1, Date.class, ParameterMode.IN);
                spq.registerStoredProcedureParameter(2, Integer.class, ParameterMode.OUT);
                spq.setParameter(1, this.utilDate, TemporalType.DATE);
                if (!spq.execute()) {
                    Object o = spq.getOutputParameterValue(2);
                    if (o instanceof Integer) {
                        Integer actual = (Integer)o;
                        if (actual == 1) {
                            logger.log(System.Logger.Level.TRACE, "Received expected id:" + actual);
                            pass2 = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Expected id: 1, actual:" + actual);
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Did not get instance of Integer back:" + o);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected execute() to return false, actual: true");
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
            }
            try {
                logger.log(System.Logger.Level.INFO, "Testing Query object");
                StoredProcedureQuery spq1 = this.getEntityManager().createStoredProcedureQuery("GetEmpIdUsingHireDateFromOut");
                spq1.registerStoredProcedureParameter(1, Date.class, ParameterMode.IN);
                spq1.registerStoredProcedureParameter(2, Integer.class, ParameterMode.OUT);
                StoredProcedureQuery q = spq1;
                q.setParameter(1, this.utilDate, TemporalType.DATE);
                StoredProcedureQuery spq2 = q;
                if (!spq2.execute()) {
                    Object o = spq2.getOutputParameterValue(2);
                    if (o instanceof Integer) {
                        int actual = (Integer)o;
                        if (actual == 1) {
                            logger.log(System.Logger.Level.TRACE, "Received expected id:" + actual);
                            pass4 = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Expected id: 1, actual:" + actual);
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Did not get instance of Integer back:" + o);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected execute() to return false, actual: true");
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        if (!pass2 || !pass4) {
            throw new Exception("setParameterIntDateTemporalTypeTest failed");
        }
    }

    @Test
    public void setParameterIntDateTemporalTypeIllegalArgumentExceptionTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.INFO, "Testing StoredProcedureQuery with incorrect position specified");
            StoredProcedureQuery spq1 = this.getEntityManager().createStoredProcedureQuery("GetEmpIdUsingHireDateFromOut");
            spq1.registerStoredProcedureParameter(1, Date.class, ParameterMode.IN);
            try {
                spq1.setParameter(99, this.utilDate, TemporalType.DATE);
                logger.log(System.Logger.Level.ERROR, "Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                pass1 = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
            }
            logger.log(System.Logger.Level.INFO, "Testing Query object with incorrect position specified");
            StoredProcedureQuery spq3 = this.getEntityManager().createStoredProcedureQuery("GetEmpIdUsingHireDateFromOut");
            spq3.registerStoredProcedureParameter(1, Date.class, ParameterMode.IN);
            StoredProcedureQuery q1 = spq3.setParameter(1, (Object)this.getUtilDate());
            try {
                q1.setParameter(99, this.utilDate, TemporalType.DATE);
                logger.log(System.Logger.Level.ERROR, "Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                pass2 = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
            }
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("setParameterIntDateTemporalTypeIllegalArgumentExceptionTest failed");
        }
    }

    @Test
    public void setParameterParameterDateTemporalTypeTest() throws Exception {
        boolean pass5;
        boolean pass3;
        boolean pass2;
        block20: {
            block19: {
                pass2 = false;
                pass3 = false;
                pass5 = false;
                try {
                    this.getEntityTransaction().begin();
                    StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpIdUsingHireDateFromOut");
                    spq.registerStoredProcedureParameter(1, Date.class, ParameterMode.IN);
                    spq.registerStoredProcedureParameter(2, Integer.class, ParameterMode.OUT);
                    spq.setParameter(1, this.getUtilDate(), TemporalType.DATE);
                    Parameter p = spq.getParameter(1);
                    spq.setParameter(p, this.utilDate, TemporalType.DATE);
                    if (!spq.execute()) {
                        Object o = spq.getOutputParameterValue(2);
                        if (o instanceof Integer) {
                            int actual = (Integer)o;
                            if (actual == 1) {
                                logger.log(System.Logger.Level.TRACE, "Received expected id:" + actual);
                                pass2 = true;
                            } else {
                                logger.log(System.Logger.Level.ERROR, "Expected id: 1, actual:" + actual);
                            }
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Did not get instance of Integer back:" + o);
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected execute() to return false, actual: true");
                    }
                    this.getEntityTransaction().commit();
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
                    if (!this.getEntityTransaction().isActive()) break block19;
                    this.getEntityTransaction().rollback();
                }
            }
            try {
                this.getEntityTransaction().begin();
                logger.log(System.Logger.Level.INFO, "Testing Query object");
                StoredProcedureQuery spq1 = this.getEntityManager().createStoredProcedureQuery("GetEmpIdUsingHireDateFromOut");
                spq1.registerStoredProcedureParameter(1, Date.class, ParameterMode.IN);
                spq1.registerStoredProcedureParameter(2, Integer.class, ParameterMode.OUT);
                spq1.setParameter(1, this.getCalDate().getTime(), TemporalType.DATE);
                StoredProcedureQuery q = spq1;
                Parameter p = q.getParameter(1);
                q.setParameter(p, this.utilDate, TemporalType.DATE);
                Parameter p2 = q.getParameter(1);
                if (p.getPosition().equals(p2.getPosition()) && p.getParameterType().equals(p2.getParameterType())) {
                    logger.log(System.Logger.Level.TRACE, "Received expected parameter");
                    pass3 = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected parameter:" + p + ", actual:" + p2);
                }
                StoredProcedureQuery spq2 = q;
                if (!spq2.execute()) {
                    Object o = spq2.getOutputParameterValue(2);
                    if (o instanceof Integer) {
                        int actual = (Integer)o;
                        if (actual == this.emp0.getId()) {
                            logger.log(System.Logger.Level.TRACE, "Received expected id:" + actual);
                            pass5 = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Expected id: 1, actual:" + actual);
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Did not get instance of Integer back:" + o);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected execute() to return false, actual: true");
                }
                this.getEntityTransaction().commit();
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
                if (!this.getEntityTransaction().isActive()) break block20;
                this.getEntityTransaction().rollback();
            }
        }
        if (!(pass2 && pass3 && pass5)) {
            throw new Exception("setParameterParameterDateTemporalTypeTest failed");
        }
    }

    @Test
    public void setParameterParameterDateTemporalTypeIllegalArgumentExceptionTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "Get parameter from other stored procedure");
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpLastNameFromInOut");
            spq.registerStoredProcedureParameter(1, String.class, ParameterMode.INOUT);
            spq.setParameter(1, (Object)"INOUT");
            Parameter p = spq.getParameter(1);
            logger.log(System.Logger.Level.INFO, "Testing StoredProcedureQuery with parameter specified from another query");
            StoredProcedureQuery spq1 = this.getEntityManager().createStoredProcedureQuery("GetEmpIdUsingHireDateFromOut");
            spq1.registerStoredProcedureParameter(1, Date.class, ParameterMode.IN);
            spq1.setParameter(1, this.getUtilDate(), TemporalType.DATE);
            try {
                spq1.setParameter(p, this.getUtilDate(), TemporalType.DATE);
                logger.log(System.Logger.Level.ERROR, "Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                pass1 = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
            }
            logger.log(System.Logger.Level.INFO, "Testing Query object with parameter specified from another query");
            StoredProcedureQuery spq3 = this.getEntityManager().createStoredProcedureQuery("GetEmpIdUsingHireDateFromOut");
            spq3.registerStoredProcedureParameter(1, Calendar.class, ParameterMode.IN);
            StoredProcedureQuery q1 = spq3.setParameter(1, (Object)this.getCalDate());
            try {
                q1.setParameter(p, this.getCalDate(), TemporalType.DATE);
                logger.log(System.Logger.Level.ERROR, "Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                pass2 = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
            }
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("setParameterParameterDateTemporalTypeIllegalArgumentExceptionTest failed");
        }
    }

    @Test
    public void executeUpdateOfAnUpdateTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("UpdateEmpSalaryColumn");
            spq.executeUpdate();
            int updateCount = spq.getUpdateCount();
            if (updateCount == -1) {
                logger.log(System.Logger.Level.TRACE, "Received expected update count:" + updateCount);
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected update count: -1, actual:" + updateCount);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("executeUpdateOfAnUpdateTest failed");
        }
    }

    @Test
    public void executeUpdateOfADeleteTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("DeleteAllEmp");
            spq.executeUpdate();
            int updateCount = spq.getUpdateCount();
            if (updateCount == -1) {
                logger.log(System.Logger.Level.TRACE, "Received expected update count:" + updateCount);
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected update count: -1, actual:" + updateCount);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("executeUpdateOfADeleteTest failed");
        }
    }

    @Test
    public void executeUpdateTransactionRequiredExceptionTest() throws Exception {
        boolean pass = false;
        try {
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("DeleteAllEmp");
            try {
                logger.log(System.Logger.Level.INFO, "IsActive returns:" + this.getEntityTransaction().isActive());
                spq.executeUpdate();
                logger.log(System.Logger.Level.ERROR, "Did not throw TransactionRequiredException");
            }
            catch (TransactionRequiredException tre) {
                logger.log(System.Logger.Level.TRACE, "Received expected TransactionRequiredException");
                pass = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("executeUpdateTransactionRequiredExceptionTest failed");
        }
    }

    @Test
    public void getParameterValueParameterTest() throws Exception {
        boolean pass1 = false;
        boolean pass3 = false;
        try {
            this.getEntityTransaction().begin();
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
            spq.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            spq.registerStoredProcedureParameter(2, String.class, ParameterMode.OUT);
            spq.setParameter(1, (Object)1);
            Parameter p = spq.getParameter(1);
            boolean b = spq.isBound(p);
            if (b) {
                logger.log(System.Logger.Level.TRACE, "Received expected from isBound():" + b);
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected result from isBound():true, actual:" + b);
            }
            if (!spq.execute()) {
                p = spq.getParameter(1);
                Object o = spq.getParameterValue(p);
                if (o instanceof Integer) {
                    logger.log(System.Logger.Level.TRACE, "Received expected parameter type: Integer");
                    Integer i = (Integer)o;
                    if (i.equals(this.emp0.getId())) {
                        logger.log(System.Logger.Level.TRACE, "Received expected parameter value:" + i);
                        pass3 = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected getParameterValue() result: " + this.emp0.getId() + ", actual:" + i);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Did not get instance of Integer from getParameterValue():" + o);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected execute() to return false, actual: true");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass1 || !pass3) {
            throw new Exception("getParameterValueParameterTest failed");
        }
    }

    @Test
    public void getParameterValueParameterIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpLastNameFromInOut");
            spq.registerStoredProcedureParameter(1, String.class, ParameterMode.INOUT);
            spq.setParameter(1, (Object)"1");
            Parameter p = spq.getParameter(1);
            StoredProcedureQuery spq1 = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
            spq1.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            spq1.registerStoredProcedureParameter(2, String.class, ParameterMode.OUT);
            spq1.setParameter(1, (Object)1);
            try {
                spq1.getParameterValue(p);
                logger.log(System.Logger.Level.ERROR, "Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                pass = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
            }
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("getParameterValueParameterIllegalArgumentExceptionTest failed");
        }
    }

    @Test
    public void getParameterValueParameterIllegalStateExceptionTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.getEntityTransaction().begin();
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
            spq.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            spq.registerStoredProcedureParameter(2, String.class, ParameterMode.OUT);
            spq.setParameter(1, (Object)1);
            Parameter p = spq.getParameter(1);
            boolean b = spq.isBound(p);
            if (b) {
                logger.log(System.Logger.Level.TRACE, "Received expected from isBound():" + b);
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected result from isBound():true, actual:" + b);
            }
            Parameter p2 = spq.getParameter(2);
            try {
                spq.getParameterValue(p2);
                logger.log(System.Logger.Level.ERROR, "Did not throw IllegalStateException");
            }
            catch (IllegalStateException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalStateException");
                pass2 = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
            }
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("getParameterValueParameterIllegalStateExceptionTest failed");
        }
    }

    @Test
    public void getParameterValueIntTest() throws Exception {
        boolean pass4;
        boolean pass3;
        boolean pass2;
        boolean pass1;
        block24: {
            String s;
            Object o;
            StoredProcedureQuery spq;
            block23: {
                pass1 = false;
                pass2 = false;
                pass3 = false;
                pass4 = false;
                try {
                    this.getEntityTransaction().begin();
                    logger.log(System.Logger.Level.INFO, "Testing createStoredProcedureQuery");
                    spq = this.getEntityManager().createStoredProcedureQuery("GetEmpLastNameFromInOut");
                    spq.registerStoredProcedureParameter(1, String.class, ParameterMode.INOUT);
                    spq.setParameter(1, (Object)"1");
                    o = spq.getParameterValue(1);
                    if (o instanceof String) {
                        logger.log(System.Logger.Level.TRACE, "Received expected parameter type: String");
                        s = (String)o;
                        if (s.equals("1")) {
                            logger.log(System.Logger.Level.TRACE, "Received expected parameter value:" + s);
                            pass1 = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Expected getParameterValue() result: 1, actual:" + s);
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Did not get instance of String from getParameterValue():" + o);
                    }
                    if (!spq.execute()) {
                        o = spq.getParameterValue(1);
                        if (o instanceof String) {
                            logger.log(System.Logger.Level.TRACE, "Received expected parameter type: String");
                            s = (String)o;
                            if (s.equals("1")) {
                                logger.log(System.Logger.Level.TRACE, "Received expected parameter value:" + s);
                                pass2 = true;
                            } else {
                                logger.log(System.Logger.Level.ERROR, "Expected getParameterValue() result: 1, actual:" + s);
                            }
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected execute() to return false, actual: true");
                    }
                    this.getEntityTransaction().commit();
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
                    if (!this.getEntityTransaction().isActive()) break block23;
                    this.getEntityTransaction().rollback();
                }
            }
            try {
                this.getEntityTransaction().begin();
                logger.log(System.Logger.Level.INFO, "Testing createNamedStoredProcedureQuery");
                spq = this.getEntityManager().createNamedStoredProcedureQuery("getemplastnamefrominout");
                spq.setParameter(1, (Object)"1");
                o = spq.getParameterValue(1);
                if (o instanceof String) {
                    logger.log(System.Logger.Level.TRACE, "Received expected parameter type: String");
                    s = (String)o;
                    if (s.equals("1")) {
                        logger.log(System.Logger.Level.TRACE, "Received expected parameter value:" + s);
                        pass3 = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected getParameterValue() result: 1, actual:" + s);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Did not get instance of String from getParameterValue():" + o);
                }
                if (!spq.execute()) {
                    o = spq.getParameterValue(1);
                    if (o instanceof String) {
                        logger.log(System.Logger.Level.TRACE, "Received expected parameter type: String");
                        s = (String)o;
                        if (s.equals("1")) {
                            logger.log(System.Logger.Level.TRACE, "Received expected parameter value:" + s);
                            pass4 = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Expected getParameterValue() result: 1, actual:" + s);
                        }
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected execute() to return false, actual: true");
                }
                this.getEntityTransaction().commit();
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
                if (!this.getEntityTransaction().isActive()) break block24;
                this.getEntityTransaction().rollback();
            }
        }
        if (!(pass1 && pass2 && pass3 && pass4)) {
            throw new Exception("getParameterValueIntTest failed");
        }
    }

    @Test
    public void getParameterValueIntIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
            spq.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            spq.registerStoredProcedureParameter(2, String.class, ParameterMode.OUT);
            spq.setParameter(1, (Object)1);
            try {
                spq.getParameterValue(99);
                logger.log(System.Logger.Level.ERROR, "Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                pass = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
            }
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("getParameterValueIntIllegalArgumentExceptionTest failed");
        }
    }

    @Test
    public void getParameterValueIntIllegalStateExceptionTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
            spq.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            spq.registerStoredProcedureParameter(2, String.class, ParameterMode.OUT);
            spq.setParameter(1, (Object)1);
            try {
                spq.getParameterValue(2);
                logger.log(System.Logger.Level.ERROR, "Did not throw IllegalStateException");
            }
            catch (IllegalStateException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalStateException");
                pass = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
            }
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("getParameterValueIntIllegalStateExceptionTest failed");
        }
    }

    @Test
    public void setHintStringObjectTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
            spq.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            spq.registerStoredProcedureParameter(2, String.class, ParameterMode.OUT);
            spq.setParameter(1, (Object)1);
            spq.getParameterValue(1);
            spq.setHint("property.that.is.not.recognized", (Object)"property.that.is.not.recognized");
            spq.execute();
            this.getEntityTransaction().commit();
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("setHintStringObjectTest failed");
        }
    }

    @Test
    public void xmlOverridesNamedStoredProcedureQueryTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            StoredProcedureQuery spq = this.getEntityManager().createNamedStoredProcedureQuery("tobeoverridden1");
            spq.setParameter(1, (Object)1);
            Object o = spq.getParameterValue(1);
            if (o instanceof Integer) {
                logger.log(System.Logger.Level.TRACE, "Received expected parameter type: Integer");
                Integer i = (Integer)o;
                if (i.equals(1)) {
                    logger.log(System.Logger.Level.TRACE, "Received expected parameter value:" + i);
                    pass1 = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected getParameterValue() result: 1, actual:" + i);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Did not get instance of Integer from getParameterValue():" + o);
            }
            if (!spq.execute()) {
                o = spq.getOutputParameterValue(2);
                if (o instanceof String) {
                    logger.log(System.Logger.Level.TRACE, "Received expected parameter type: String");
                    String s = (String)o;
                    if (s.equals(this.emp0.getFirstName())) {
                        logger.log(System.Logger.Level.TRACE, "Received expected parameter value:" + s);
                        pass2 = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected getParameterValue() result: " + this.emp0.getFirstName() + ", actual:" + s);
                    }
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected execute() to return false, actual: true");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("xmlOverridesNamedStoredProcedureQueryTest failed");
        }
    }

    @Test
    public void xmlOverridesSqlResultSetMappingAnnotationTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            try {
                logger.log(System.Logger.Level.INFO, "Testing using name,result mapping");
                this.clearCache();
                StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpIdFNameLNameFromRS", new String[]{"tobeoverridden2"});
                spq.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
                if (this.dataBaseName.equalsIgnoreCase("oracle") || this.dataBaseName.equalsIgnoreCase("postgresql")) {
                    logger.log(System.Logger.Level.TRACE, "register refcursor parameter");
                    spq.registerStoredProcedureParameter(2, Void.TYPE, ParameterMode.REF_CURSOR);
                }
                spq.setParameter(1, (Object)1);
                if (spq.execute()) {
                    List<List> listOfList = this.getResultSetsFromStoredProcedure(spq);
                    if (listOfList.size() == 1) {
                        ArrayList<Employee> expected = new ArrayList<Employee>();
                        expected.add(new Employee(this.emp0.getId(), this.emp0.getFirstName(), this.emp0.getLastName()));
                        pass = this.verifyListOfListEmployees(expected, listOfList);
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Did not get the correct number of result sets returned, expected: 1, actual:" + listOfList.size());
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected execute() to return true, actual: false");
                }
            }
            catch (Exception ex) {
                logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
        }
        if (!pass) {
            throw new Exception("xmlOverridesSqlResultSetMappingAnnotationTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createEmployeeTestData() {
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.INFO, "Creating Employees");
            Date d2 = this.getUtilDate("2001-06-27");
            Date d3 = this.getUtilDate("2002-07-07");
            Date d4 = this.getUtilDate("2003-03-03");
            Date d5 = this.getUtilDate();
            this.emp0 = new Employee(1, "Alan", "Frechette", this.utilDate, 35000.0f);
            this.empRef.add(this.emp0);
            this.empRef.add(new Employee(2, "Arthur", "Frechette", d2, 35000.0f));
            this.empRef.add(new Employee(3, "Shelly", "McGowan", d3, 50000.0f));
            this.empRef.add(new Employee(4, "Robert", "Bissett", d4, 55000.0f));
            this.empRef.add(new Employee(5, "Stephen", "DMilla", d5, 25000.0f));
            for (Employee e : this.empRef) {
                if (e == null) continue;
                this.getEntityManager().persist((Object)e);
                logger.log(System.Logger.Level.TRACE, "persisted employee:" + e);
            }
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
    }
}

