/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.tableGenerator;

import ee.jakarta.tck.persistence.core.annotations.tableGenerator.Client;
import ee.jakarta.tck.persistence.core.annotations.tableGenerator.DataTypes3;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client3
extends Client {
    private DataTypes3 d3;
    private static final System.Logger logger = System.getLogger(Client3.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = Client.class.getPackageName() + ".";
        String[] classes = new String[]{pkgName + "DataTypes", pkgName + "DataTypes2", pkgName + "DataTypes3", pkgName + "DataTypes4"};
        return this.createDeploymentJar("jpa_core_annotations_tableGenerator3.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup3() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup3");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
            this.createTestData3();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void generatorOnFieldTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            int id = this.d3.getId();
            logger.log(System.Logger.Level.TRACE, "find id: " + id);
            DataTypes3 d = (DataTypes3)this.getEntityManager().find(DataTypes3.class, (Object)id);
            if (d != null) {
                if (d.getStringData().equals(this.d3.getStringData())) {
                    pass = true;
                }
                this.getEntityTransaction().commit();
            } else {
                logger.log(System.Logger.Level.ERROR, "EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("generatorOnFieldTest failed");
        }
    }

    public void createTestData3() {
        try {
            this.getEntityTransaction().begin();
            this.d3 = new DataTypes3();
            this.d3.setStringData("testData3");
            logger.log(System.Logger.Level.TRACE, "DataType3:" + this.d3.toString());
            this.getEntityManager().persist((Object)this.d3);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
    }
}

