/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.criteriaapi.CriteriaBuilder;

import ee.jakarta.tck.persistence.common.schema30.Customer;
import ee.jakarta.tck.persistence.common.schema30.Order;
import ee.jakarta.tck.persistence.common.schema30.Product;
import ee.jakarta.tck.persistence.common.schema30.UtilSetup;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.CriteriaUpdate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.ArrayList;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;

public class Client1
extends UtilSetup {
    private static final System.Logger logger = System.getLogger(Client1.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client1.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = this.getSchema30classes();
        return this.createDeploymentJar("jpa_core_criteriaapi_CriteriaBuilder1.jar", pkgNameWithoutSuffix, classes);
    }

    @Test
    public void createQuery() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery();
        if (cquery != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Criteria Query");
            pass = true;
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("createQuery Test  failed");
        }
    }

    @Test
    public void createQuery2() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Order.class);
        if (cquery != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Criteria Query");
            pass = true;
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("createQuery2 Test  failed");
        }
    }

    @Test
    public void createTuple() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createTupleQuery();
        if (cquery != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Criteria Query Tuple");
            pass = true;
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query Tuple");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("createTuple Test  failed");
        }
    }

    @Test
    public void tupleSelectionArrayIllegalArgumentExceptionTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            CriteriaBuilder qbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = qbuilder.createTupleQuery();
            if (cquery != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Criteria Query");
                Root cust = cquery.from(Customer.class);
                Selection[] s = new Selection[]{cust.get("id"), cust.get("name")};
                logger.log(System.Logger.Level.INFO, "Testing tuple");
                try {
                    qbuilder.tuple(new Selection[]{qbuilder.tuple(s)});
                    logger.log(System.Logger.Level.ERROR, "Did not throw IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    pass1 = true;
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
                }
                logger.log(System.Logger.Level.INFO, "Testing array");
                try {
                    qbuilder.tuple(new Selection[]{qbuilder.array(s)});
                    logger.log(System.Logger.Level.ERROR, "Did not throw IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    pass2 = true;
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("tupleSelectionArrayIllegalArgumentExceptionTest failed");
        }
    }

    @Test
    public void literalIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            cbuilder.literal(null);
            logger.log(System.Logger.Level.ERROR, "Did not throw IllegalArgumentException");
        }
        catch (IllegalArgumentException iae) {
            logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("literalIllegalArgumentExceptionTest failed");
        }
    }

    @Test
    public void trimspecTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = true;
        ArrayList<CriteriaBuilder.Trimspec> expected = new ArrayList<CriteriaBuilder.Trimspec>();
        expected.add(CriteriaBuilder.Trimspec.BOTH);
        expected.add(CriteriaBuilder.Trimspec.LEADING);
        expected.add(CriteriaBuilder.Trimspec.TRAILING);
        try {
            CriteriaBuilder.Trimspec[] ts = CriteriaBuilder.Trimspec.values();
            if (ts.length == 3) {
                for (CriteriaBuilder.Trimspec tspec : ts) {
                    pass1 = true;
                    if (expected.contains(tspec)) {
                        logger.log(System.Logger.Level.INFO, "Testing valueOf:" + tspec);
                        CriteriaBuilder.Trimspec.valueOf((String)tspec.toString());
                        continue;
                    }
                    pass2 = false;
                    logger.log(System.Logger.Level.ERROR, "values() returned incorrect value:" + tspec);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected number of values:3, actual:" + ts.length);
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("trimspecTest failed");
        }
    }

    @Test
    public void createCriteriaDeleteTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            CriteriaDelete cd = cbuilder.createCriteriaDelete(Product.class);
            if (cd != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null CriteriaDelete");
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Failed to get Non-null CriteriaDelete");
            }
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)ex);
        }
        if (!pass) {
            throw new Exception("createCriteriaDeleteTest test failed");
        }
    }

    @Test
    public void createCriteriaUpdateTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            CriteriaUpdate cd = cbuilder.createCriteriaUpdate(Product.class);
            if (cd != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null CriteriaUpdate");
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Failed to get Non-null CriteriaUpdate");
            }
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)ex);
        }
        if (!pass) {
            throw new Exception("createCriteriaUpdateTest test failed");
        }
    }

    @Test
    public void coalesceTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaBuilder.Coalesce col = cbuilder.coalesce();
        if (col != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Coalesce");
            pass = true;
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Coalesce");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("coalesceTest failed");
        }
    }
}

