/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.entitytest.cascadeall.manyXone;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.entitytest.cascadeall.manyXone.A;
import ee.jakarta.tck.persistence.core.entitytest.cascadeall.manyXone.B;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "A", pkgName + "B"};
        return this.createDeploymentJar("jpa_core_entitytest_cascadeall_manyXone.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void cascadeAllMX1Test1() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin cascadeAllMX1Test1");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "New instances");
            A aRef = new A("1", "bean1", 1);
            B b1 = new B("1", "b1", 1, aRef);
            this.getEntityManager().persist((Object)b1);
            B b2 = new B("2", "b2", 1, aRef);
            this.getEntityManager().persist((Object)b2);
            B b3 = new B("3", "b3", 1, aRef);
            this.getEntityManager().persist((Object)b3);
            B b4 = new B("4", "b4", 1, aRef);
            this.getEntityManager().persist((Object)b4);
            this.getEntityManager().flush();
            A newA1 = b1.getA1Info();
            A newA2 = b2.getA1Info();
            A newA3 = b3.getA1Info();
            A newA4 = b4.getA1Info();
            if (newA1 != null && newA2 != null && newA3 != null && newA4 != null) {
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Wrong results received");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("cascadeAllMX1Test1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void cascadeAllMX1Test2() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin cascadeAllMX1Test2");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            A aRef = new A("2", "bean2", 2);
            B b1 = new B("2", "b2", 2, aRef);
            this.getEntityManager().persist((Object)b1);
            this.getEntityManager().flush();
            A newA1 = b1.getA1Info();
            if (newA1 != null) {
                try {
                    logger.log(System.Logger.Level.TRACE, "Remove b1 ");
                    this.getEntityManager().remove((Object)newA1);
                    this.getEntityManager().remove((Object)b1);
                    this.getEntityManager().flush();
                    logger.log(System.Logger.Level.TRACE, "Persist a removed entity ");
                    B newB = this.findB("2");
                    if (null == newB) {
                        this.getEntityManager().persist((Object)b1);
                        this.getEntityManager().flush();
                        pass = this.getEntityManager().contains((Object)b1) && b1.getA1() != null;
                    } else {
                        logger.log(System.Logger.Level.TRACE, "entity B not removed");
                    }
                    this.getEntityTransaction().commit();
                }
                catch (Exception ee) {
                    logger.log(System.Logger.Level.ERROR, "Unexpected exception trying to persist a removed entity", (Throwable)ee);
                }
            } else {
                logger.log(System.Logger.Level.TRACE, "Instance is not already persisted. Test Fails.");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("cascadeAllMX1Test2 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void cascadeAllMX1Test3() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin cascadeAllMX1Test3");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "New instances");
            A aRef = new A("4", "bean4", 4);
            this.getEntityManager().persist((Object)aRef);
            B b1 = new B("1", "b1", 4);
            this.getEntityManager().persist((Object)b1);
            B b2 = new B("2", "b2", 4);
            this.getEntityManager().persist((Object)b2);
            B b3 = new B("3", "b3", 4);
            this.getEntityManager().persist((Object)b3);
            B b4 = new B("4", "b4", 4);
            this.getEntityManager().persist((Object)b4);
            b1.setA1(aRef);
            b2.setA1(aRef);
            b3.setA1(aRef);
            b4.setA1(aRef);
            this.getEntityManager().flush();
            A newA1 = b1.getA1Info();
            A newA2 = b2.getA1Info();
            A newA3 = b3.getA1Info();
            A newA4 = b4.getA1Info();
            if (newA1 != null && this.getEntityManager().contains((Object)newA1) && newA2 != null && this.getEntityManager().contains((Object)newA2) && newA3 != null && this.getEntityManager().contains((Object)newA3) && newA4 != null && this.getEntityManager().contains((Object)newA4)) {
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Unexpected exception caught: " + e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("cascadeAllMX1Test3 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void cascadeAllMX1Test4() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin cascadeAllMX1Test4");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "New instances");
            A aRef = new A("5", "bean5", 5);
            B b1 = new B("1", "b1", 5, aRef);
            this.getEntityManager().persist((Object)b1);
            B b2 = new B("2", "b2", 5, aRef);
            this.getEntityManager().persist((Object)b2);
            B b3 = new B("3", "b3", 5, aRef);
            this.getEntityManager().persist((Object)b3);
            B b4 = new B("4", "b4", 5, aRef);
            this.getEntityManager().persist((Object)b4);
            pass = this.getInstanceStatus(aRef);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("cascadeAllMX1Test4 failed");
        }
    }

    @Test
    public void cascadeAllMX1Test5() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "New instances");
            A aRef = new A("6", "bean6", 6);
            B b1 = new B("1", "b1", 6, aRef);
            B b2 = new B("2", "b2", 6, aRef);
            B b3 = new B("3", "b3", 6, aRef);
            B b4 = new B("4", "b4", 6, aRef);
            pass = !this.getInstanceStatus(aRef) && !this.getInstanceStatus(b1) && !this.getInstanceStatus(b2) && !this.getInstanceStatus(b3) && !this.getInstanceStatus(b4);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("cascadeAllMX1Test5 failed");
        }
    }

    @Test
    public void cascadeAllMX1Test6() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            A a1 = new A("7", "b7", 7);
            B bRef = new B("7", "bean7", 7, a1);
            pass = !this.getEntityManager().contains((Object)bRef) && !this.getEntityManager().contains((Object)a1);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("cascadeAllMX1Test6 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void cascadeAllMX1Test7() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            A a1 = new A("8", "a8", 8);
            B bRef = new B("8", "bean8", 8);
            this.getEntityManager().persist((Object)bRef);
            if (this.getEntityManager().contains((Object)bRef)) {
                B bRef1 = this.findB("8");
                bRef1.setA1(a1);
                this.getEntityManager().persist((Object)bRef1);
                pass = this.getEntityManager().contains((Object)a1);
                logger.log(System.Logger.Level.TRACE, "try to find A");
                A a2 = this.findA("8");
                if (null != a2) {
                    logger.log(System.Logger.Level.TRACE, "b2 is not null");
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("cascadeAllMX1Test7 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void cascadeAllMX1Test8() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "New instances");
            A a1 = new A("9", "A9", 9);
            B bRef = new B("9", "bean9", 9);
            this.getEntityManager().persist((Object)bRef);
            if (null == bRef.getA1()) {
                bRef.setA1(a1);
                this.getEntityManager().flush();
            }
            if (null != a1 && this.getEntityManager().contains((Object)a1)) {
                A result = bRef.getA1Info();
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Entity not managed - test fails.");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("cascadeAllMX1Test8 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void cascadeAllMX1Test9() throws Exception {
        boolean pass = false;
        try {
            logger.log(System.Logger.Level.TRACE, "New instances");
            this.getEntityTransaction().begin();
            A a1 = new A("10", "a10", 10);
            B bRef = new B("10", "bean10", 10, a1);
            this.getEntityManager().persist((Object)bRef);
            this.getEntityManager().flush();
            pass = this.getEntityManager().contains((Object)a1);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception :", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("cascadeAllMX1Test9 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void cascadeAllMX1Test10() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "New instances");
            A a1 = new A("11", "a11", 11);
            B bRef = new B("11", "bean11", 11, a1);
            this.getEntityManager().persist((Object)bRef);
            this.getEntityTransaction().commit();
            this.getEntityTransaction().begin();
            B b2 = this.findB("11");
            A newA = b2.getA1();
            newA.setAName("newA");
            this.getEntityManager().flush();
            if (b2.isA() && newA.getAName().equals("newA")) {
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("cascadeAllMX1Test10 failed");
        }
    }

    private A findA(String id) {
        logger.log(System.Logger.Level.TRACE, "Entered findA method");
        return (A)this.getEntityManager().find(A.class, (Object)id);
    }

    private B findB(String id) {
        logger.log(System.Logger.Level.TRACE, "Entered findB method");
        return (B)this.getEntityManager().find(B.class, (Object)id);
    }

    private boolean getInstanceStatus(Object o) {
        logger.log(System.Logger.Level.TRACE, "Entered getInstanceStatus method");
        return this.getEntityManager().contains(o);
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "Cleanup data");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM BEJB_MX1_UNI_BTOB").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM AEJB_MX1_UNI_BTOB").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

