/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.metamodelapi.singularattribute;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.metamodelapi.singularattribute.Address;
import ee.jakarta.tck.persistence.core.metamodelapi.singularattribute.B;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.Bindable;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.metamodel.SingularAttribute;
import jakarta.persistence.metamodel.Type;
import java.lang.reflect.Member;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "Address", pkgName + "B", pkgName + "ZipCode"};
        return this.createDeploymentJar("jpa_core_metamodelapi_singularattribute.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void isId() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeB = metaModel.managedType(B.class);
            if (mTypeB != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                SingularAttribute singAttrib = mTypeB.getDeclaredSingularAttribute("address", Address.class);
                if (!singAttrib.isId()) {
                    logger.log(System.Logger.Level.TRACE, "Received expected result singular attribute isId =" + singAttrib.isId());
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.TRACE, "Received UnExpected result singular attribute isId =" + singAttrib.isId());
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("isId Test  failed");
        }
    }

    @Test
    public void isVersion() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeB = metaModel.managedType(B.class);
            if (mTypeB != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                SingularAttribute singAttrib = mTypeB.getDeclaredSingularAttribute("address", Address.class);
                if (!singAttrib.isVersion()) {
                    logger.log(System.Logger.Level.TRACE, "Received expected result singular attribute isVersion =" + singAttrib.isVersion());
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.TRACE, "Received UnExpected result singular attribute isVersion =" + singAttrib.isVersion());
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("isVersion Test  failed");
        }
    }

    @Test
    public void isOptional() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeB = metaModel.managedType(B.class);
            if (mTypeB != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                SingularAttribute singAttrib = mTypeB.getDeclaredSingularAttribute("address", Address.class);
                if (singAttrib.isOptional()) {
                    logger.log(System.Logger.Level.TRACE, "Received expected result singular attribute isOptional =" + singAttrib.isOptional());
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.TRACE, "Received UnExpected result singular attribute isOptional =" + singAttrib.isOptional());
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("isOptional Test  failed");
        }
    }

    @Test
    public void getType() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeB = metaModel.managedType(B.class);
            if (mTypeB != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                SingularAttribute singAttrib = mTypeB.getDeclaredSingularAttribute("address", Address.class);
                Type attributeType = singAttrib.getType();
                String attributeJavaTypeName = attributeType.getJavaType().getName();
                if (attributeJavaTypeName.equals("ee.jakarta.tck.persistence.core.metamodelapi.singularattribute.Address")) {
                    logger.log(System.Logger.Level.TRACE, "Received expected result singular attribute JavaType =" + attributeJavaTypeName);
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Received Unexpected result singular attribute JavaType =" + attributeJavaTypeName);
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getType Test  failed");
        }
    }

    @Test
    public void isCollection() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeB = metaModel.managedType(B.class);
            if (mTypeB != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                SingularAttribute singAttrib = mTypeB.getDeclaredSingularAttribute("address", Address.class);
                boolean b = singAttrib.isCollection();
                if (!b) {
                    logger.log(System.Logger.Level.TRACE, "Received expected result:" + b);
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected: false, actual: " + b);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "managedType() returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("isCollection Test failed");
        }
    }

    @Test
    public void isAssociation() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeB = metaModel.managedType(B.class);
            if (mTypeB != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                SingularAttribute singAttrib = mTypeB.getDeclaredSingularAttribute("address", Address.class);
                boolean b = singAttrib.isAssociation();
                if (!b) {
                    logger.log(System.Logger.Level.TRACE, "Received expected result:" + b);
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected: false, actual: " + b);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "managedType() returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("isAssociation Test failed");
        }
    }

    @Test
    public void getPersistentAttributeType() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeB = metaModel.managedType(B.class);
            if (mTypeB != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                SingularAttribute singAttrib = mTypeB.getDeclaredSingularAttribute("address", Address.class);
                if (singAttrib != null) {
                    Attribute.PersistentAttributeType pAttribType = singAttrib.getPersistentAttributeType();
                    if (pAttribType == Attribute.PersistentAttributeType.EMBEDDED) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result " + pAttribType);
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: " + Attribute.PersistentAttributeType.EMBEDDED.toString() + ", actual:" + pAttribType);
                    }
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getPersistentAttributeType Test failed");
        }
    }

    @Test
    public void getName() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeB = metaModel.managedType(B.class);
            if (mTypeB != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                SingularAttribute singAttrib = mTypeB.getDeclaredSingularAttribute("address", Address.class);
                if (singAttrib != null) {
                    String name = singAttrib.getName();
                    if (name.equals("address")) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result" + name);
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: address, actual:" + name);
                    }
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getName Test failed");
        }
    }

    @Test
    public void getJavaType() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeB = metaModel.managedType(B.class);
            if (mTypeB != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                SingularAttribute singAttrib = mTypeB.getDeclaredSingularAttribute("address", Address.class);
                if (singAttrib != null) {
                    Class pSingAttribJavaType = singAttrib.getJavaType();
                    if (pSingAttribJavaType.getName().equals("ee.jakarta.tck.persistence.core.metamodelapi.singularattribute.Address")) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result " + pSingAttribJavaType);
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: address, actual:" + pSingAttribJavaType);
                    }
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getJavaType Test failed");
        }
    }

    @Test
    public void getJavaMember() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeB = metaModel.managedType(B.class);
            if (mTypeB != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                SingularAttribute singAttrib = mTypeB.getDeclaredSingularAttribute("address", Address.class);
                if (singAttrib != null) {
                    logger.log(System.Logger.Level.TRACE, "Singular attribute JavaMember = " + singAttrib.getJavaMember().getName());
                    Member javaMember = singAttrib.getJavaMember();
                    if (javaMember.getName().equals("address")) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result " + javaMember.getName());
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: address, actual:" + javaMember.getName());
                    }
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getJavaMember Test  failed");
        }
    }

    @Test
    public void getDeclaringType() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeB = metaModel.managedType(B.class);
            if (mTypeB != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                SingularAttribute singAttrib = mTypeB.getDeclaredSingularAttribute("address", Address.class);
                if (singAttrib != null) {
                    logger.log(System.Logger.Level.TRACE, "attribute Name = " + singAttrib.getName());
                    ManagedType newTypeOrder = singAttrib.getDeclaringType();
                    if (newTypeOrder != null) {
                        Class javaType = newTypeOrder.getJavaType();
                        if (javaType.getName().equals("ee.jakarta.tck.persistence.core.metamodelapi.singularattribute.B")) {
                            logger.log(System.Logger.Level.TRACE, "Received expected result:" + javaType.getName());
                            pass = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Expected: ee.jakarta.tck.persistence.core.metamodelapi.singularattribute.B, actual:" + javaType.getName());
                        }
                    }
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaringType Test  failed");
        }
    }

    @Test
    public void getBindableType() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeB = metaModel.managedType(B.class);
            if (mTypeB != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                SingularAttribute singAttrib = mTypeB.getDeclaredSingularAttribute("address", Address.class);
                if (singAttrib != null) {
                    logger.log(System.Logger.Level.TRACE, "attribute Name = " + singAttrib.getName());
                    Bindable.BindableType bType = singAttrib.getBindableType();
                    if (bType != null) {
                        if (bType.name().equals(Bindable.BindableType.SINGULAR_ATTRIBUTE.name())) {
                            logger.log(System.Logger.Level.TRACE, "Received expected result:" + bType.name());
                            pass = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Expected: " + Bindable.BindableType.SINGULAR_ATTRIBUTE.name() + ", actual:" + bType.name());
                        }
                    }
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getBindableType Test  failed");
        }
    }

    @Test
    public void getBindableJavaType() throws Exception {
        boolean pass = false;
        String expected = "ee.jakarta.tck.persistence.core.metamodelapi.singularattribute.Address";
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeB = metaModel.managedType(B.class);
            if (mTypeB != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                SingularAttribute singAttrib = mTypeB.getDeclaredSingularAttribute("address", Address.class);
                if (singAttrib != null) {
                    logger.log(System.Logger.Level.TRACE, "attribute Name = " + singAttrib.getName());
                    Class cType = singAttrib.getBindableJavaType();
                    if (cType != null) {
                        if (cType.getName().equals(expected)) {
                            logger.log(System.Logger.Level.TRACE, "Received expected result:" + cType.getName());
                            pass = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Expected: " + expected + ", actual:" + cType.getName());
                        }
                    }
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getBindableJavaType Test  failed");
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "Cleanup data");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
    }
}

