/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.versioning;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.versioning.Member;
import java.math.BigInteger;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "Member"};
        return this.createDeploymentJar("jpa_core_versioning.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void versionTest1() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin versionTest1");
        boolean pass1 = true;
        boolean pass2 = true;
        boolean pass3 = true;
        BigInteger donation = new BigInteger("5000000");
        try {
            this.getEntityTransaction().begin();
            Member m = new Member(1, "Jie Leng", true);
            this.getEntityManager().persist((Object)m);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            Member newMember = (Member)this.getEntityManager().find(Member.class, (Object)1);
            if (newMember.getVersion() == null) {
                logger.log(System.Logger.Level.ERROR, "version after persistence is null.");
                pass1 = false;
            } else {
                logger.log(System.Logger.Level.TRACE, "Correct non-null version after create: " + newMember.getVersion());
            }
            this.getEntityTransaction().begin();
            Member newMember2 = (Member)this.getEntityManager().find(Member.class, (Object)1);
            int oldVersion = newMember2.getVersion();
            newMember2.setDonation(donation);
            this.getEntityManager().merge((Object)newMember2);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            Member newMember3 = (Member)this.getEntityManager().find(Member.class, (Object)1);
            if (newMember3.getVersion() <= oldVersion) {
                logger.log(System.Logger.Level.ERROR, "Wrong version after update: " + newMember3.getVersion() + ", old version: " + oldVersion);
                pass2 = false;
            } else {
                logger.log(System.Logger.Level.TRACE, "Correct version after update: " + newMember3.getVersion() + ", old version: " + oldVersion);
            }
            oldVersion = newMember3.getVersion();
            this.getEntityTransaction().begin();
            this.getEntityManager().createQuery("SELECT m FROM Member m where m.memberName = :name").setParameter("name", (Object)"Jie Leng").getResultList();
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            Member newMember4 = (Member)this.getEntityManager().find(Member.class, (Object)1);
            if (newMember4.getVersion() != oldVersion) {
                logger.log(System.Logger.Level.ERROR, "Wrong version after query, expected " + oldVersion + ", got " + newMember4.getVersion());
                pass3 = false;
            } else {
                logger.log(System.Logger.Level.TRACE, "Correct version after query, expected " + oldVersion + ", got:" + newMember4.getVersion());
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass1 = false;
            pass2 = false;
            pass3 = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new Exception("versionTest1 failed");
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "cleanup");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM MEMBER").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

