/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.se.entityManagerFactory;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.se.entityManagerFactory.Order;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;
import jakarta.persistence.PersistenceException;
import java.util.Map;
import java.util.Properties;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class Client2
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client2.class.getName());
    Properties props = null;

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client2.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "Member", pkgName + "Member_", pkgName + "Order", pkgName + "Order_"};
        return this.createDeploymentJar("jpa_se_entityManagerFactory.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setupNoData() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setupNoData");
        try {
            super.setup();
            this.createDeployment();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        this.removeTestJarFromCP();
    }

    @Test
    public void createEntityManagerFactoryNoBeanValidatorTest() throws Exception {
        boolean pass = false;
        this.myProps.put("jakarta.persistence.validation.mode", "callback");
        this.displayMap(this.myProps);
        try {
            EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)this.getPersistenceUnitName(), (Map)this.myProps);
            EntityManager em = emf.createEntityManager();
            em.getTransaction().begin();
            em.persist((Object)new Order(1, 111));
            logger.log(System.Logger.Level.ERROR, "Did not receive expected PersistenceException");
        }
        catch (PersistenceException pe) {
            logger.log(System.Logger.Level.TRACE, "Received expected PersistenceException");
            pass = true;
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected Exception", (Throwable)ex);
        }
        if (!pass) {
            throw new Exception("createEntityManagerFactoryNoBeanValidatorTest failed");
        }
    }

    @Disabled
    @Test
    public void createEntityManagerFactoryStringMapTest() throws Exception {
        boolean pass = false;
        try {
            EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)this.getPersistenceUnitName(), (Map)this.getPersistenceUnitProperties());
            if (emf != null) {
                logger.log(System.Logger.Level.TRACE, "Received non-null EntityManagerFactory");
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Received null EntityManagerFactory");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("createEntityManagerFactoryStringTest failed");
        }
    }
}

