/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.signaturetest;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.signaturetest.SigTestEE;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public class JakartaEESigTest
extends SigTestEE {
    public static final String JAVAEE_FULL = "full";
    public static final String JAVAEE_KEYWORD = "javaee";
    public static final String JAVAEE_WEB = "web";
    public static final String JAVAEE_WEB_KEYWORD = "javaee_web_profile";
    public static final String KEYWORD_JAVAEE = "ejb interceptors caj jms javamail cdi data beanval persistence connector jacc jaspic jsonp jta el servlet jsf jaxrs websocket batch concurrency jsonb securityapi";
    public static final String KEYWORD_WEB = "caj ejb persistence el jsf jsonp jsp servlet jta jaxrs cdi data beanval interceptors websocket concurrency jsonb securityapi";
    public static final ArrayList<String> KEYWORD_JAVAEE_FULL_OPTIONAL_TECHS = new ArrayList();
    public static final ArrayList<String> KEYWORD_WEB_FULL_OPTIONAL_TECHS = new ArrayList<String>(Arrays.asList("batch", "connector", "jms", "javamail", "jacc", "jaspic"));
    public static final Map<Containers, Map<String, String[]>> CONTAINER_PACKAGE_MAPS;
    private boolean isFullEEProfile = true;
    private String level;
    private String otherTechnologyKeywords = null;

    private void debugit(String str) {
        TestUtil.logTrace((String)str);
    }

    private void setLevel() {
        this.level = this.testInfo.getJavaeeLevel().toLowerCase();
        this.debugit("in setLevel()");
        this.debugit("javaee.level = " + this.level);
        if (this.level.contains(JAVAEE_FULL)) {
            this.isFullEEProfile = true;
            this.debugit("isFullEEProfile = true");
            this.otherTechnologyKeywords = this.level.replace(JAVAEE_FULL, "");
        } else if (this.level.contains(JAVAEE_WEB)) {
            this.isFullEEProfile = false;
            this.debugit("isFullEEProfile = false");
            this.otherTechnologyKeywords = this.level.replace(JAVAEE_WEB, "");
        } else {
            System.err.println("ERROR level set to \"" + this.level + "\"");
            System.err.println("\t level must be set to full or web");
            System.err.println("Tests will run assuming level:  full");
            this.isFullEEProfile = true;
            this.debugit("level is indeterminate so setting isFullEEProfile = true");
        }
        this.debugit("JakartaEESigTest.ssetLevel():  otherTechnologyKeywords = " + this.otherTechnologyKeywords);
    }

    private Set<String> resolveAggregateKeywords() throws IOException {
        String tsHome = this.testInfo.getTSHome();
        HashSet<String> result = new HashSet<String>();
        Object strKeywords = this.isFullEEProfile ? KEYWORD_JAVAEE : KEYWORD_WEB;
        if (this.otherTechnologyKeywords != null) {
            strKeywords = (String)strKeywords + " " + this.otherTechnologyKeywords;
        }
        List<String> terminals = this.getTerminals((String)strKeywords);
        result.addAll(terminals);
        this.debugit("JakartaEESigTest.resolveAggregateKeywords(): strKeywords = " + (String)strKeywords);
        return result;
    }

    private List<String> getTerminals(String s) {
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(s, " \t\n\r\f,");
        while (st.hasMoreTokens()) {
            String keyword = st.nextToken().trim().toLowerCase();
            if (!(keyword.equals(JAVAEE_FULL) || keyword.equals(JAVAEE_KEYWORD) || keyword.equals(JAVAEE_WEB) || keyword.equals(JAVAEE_WEB_KEYWORD))) {
                result.add(keyword);
                this.debugit("added the following keyword to result:  " + keyword);
                continue;
            }
            this.debugit("not adding keyword (" + keyword + ") to result");
        }
        return result;
    }

    protected ArrayList<String> getUnlistedOptionalPackages() {
        ArrayList<String> unlistedOptPkgs = new ArrayList<String>();
        ArrayList<Object> unlistedKeywords = new ArrayList();
        this.debugit("Enterred getUnlistedOptionalPackages()");
        if (this.isFullEEProfile) {
            unlistedKeywords = this.cloneArrayList(KEYWORD_JAVAEE_FULL_OPTIONAL_TECHS);
            if (this.otherTechnologyKeywords == null) {
                this.debugit("No Optional Technology Keywords found in ts.jte's javaee.level property.");
            } else {
                this.debugit("Optional Technology Keywords found in ts.jte's javaee.level property: " + this.otherTechnologyKeywords);
                this.otherTechnologyKeywords = this.otherTechnologyKeywords.trim();
                otherTechKeywords = this.otherTechnologyKeywords.split(" ");
                for (ii = 0; ii < otherTechKeywords.length; ++ii) {
                    unlistedKeywords.remove(otherTechKeywords[ii]);
                }
            }
        } else {
            unlistedKeywords = this.cloneArrayList(KEYWORD_WEB_FULL_OPTIONAL_TECHS);
            if (this.otherTechnologyKeywords == null) {
                this.debugit("No Optional Technology Keywords found in ts.jte's javaee.level property.");
            } else {
                this.debugit("Optional Technology Keywords found in ts.jte's javaee.level property: " + this.otherTechnologyKeywords);
                this.otherTechnologyKeywords = this.otherTechnologyKeywords.trim();
                otherTechKeywords = this.otherTechnologyKeywords.split(" ");
                for (ii = 0; ii < otherTechKeywords.length; ++ii) {
                    unlistedKeywords.remove(otherTechKeywords[ii]);
                }
            }
        }
        block2: for (int ii = 0; ii < unlistedKeywords.size(); ++ii) {
            this.debugit("getting packages for Optional Technology Keyword == " + unlistedKeywords.get(ii));
            for (Containers cc : Containers.values()) {
                String[] pkgs;
                Map<String, String[]> containerMap = CONTAINER_PACKAGE_MAPS.get((Object)cc);
                if (!containerMap.containsKey(unlistedKeywords.get(ii))) continue;
                this.debugit("Container: " + cc + "  contains packages for Optional Technolgoy of: " + unlistedKeywords.get(ii));
                for (String otPkg : pkgs = containerMap.get(unlistedKeywords.get(ii))) {
                    unlistedOptPkgs.add(otPkg);
                }
                continue block2;
            }
        }
        this.debugit("getUnlistedOptionalPackages(): returning the following unlistedOptPkgs: " + unlistedOptPkgs.toString());
        return unlistedOptPkgs;
    }

    private ArrayList<String> cloneArrayList(ArrayList<String> listToBeCloned) {
        ArrayList<String> returnVal = new ArrayList<String>(listToBeCloned.size());
        for (String str : listToBeCloned) {
            returnVal.add(new String(str));
        }
        return returnVal;
    }

    protected String[] getPackages(String vehicleName) {
        HashSet<String> packages = new HashSet<String>();
        Containers vehicle = Containers.valueOf(vehicleName);
        Set<String> keywords = null;
        this.debugit("vehicleName = " + vehicleName);
        this.setLevel();
        try {
            keywords = this.resolveAggregateKeywords();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.dumpKeywords(keywords);
        Map<String, String[]> vehicleMap = CONTAINER_PACKAGE_MAPS.get((Object)vehicle);
        this.dumpMap(vehicle, vehicleMap);
        for (String keyword : keywords) {
            if (!vehicleMap.containsKey(keyword)) continue;
            packages.addAll(Arrays.asList(vehicleMap.get(keyword)));
        }
        this.dumpPackages(vehicle, packages);
        return packages.toArray(new String[packages.size()]);
    }

    private void dumpKeywords(Set<String> words) {
        this.debugit("Level is set to \"" + this.level + "\"");
        this.debugit("\tKeywords:");
        for (String s : words) {
            this.debugit("\t\t" + s);
        }
        this.debugit("// dumpKeywords *****");
    }

    private void dumpMap(Containers vehicle, Map<String, String[]> packages) {
        this.debugit("Vehicle is set to \"" + vehicle + "\"");
        for (String s : packages.keySet()) {
            if (packages != null) {
                String[] pkgs = packages.get(s);
                String outStr = s + " -> ";
                for (int ii = 0; ii < pkgs.length; ++ii) {
                    outStr = outStr + pkgs[ii] + " ";
                }
                this.debugit(outStr);
                continue;
            }
            this.debugit(s + " ->  no packages ");
        }
        this.debugit("// dumpMap *****");
    }

    private void dumpPackages(Containers vehicle, Set<String> packages) {
        this.debugit("Vehicle is set to \"" + vehicle + "\"");
        if (packages != null) {
            Object outStr = "";
            for (String item : packages) {
                outStr = (String)outStr + item + " ";
            }
            this.debugit((String)outStr);
        } else {
            this.debugit("no packages found");
        }
        this.debugit("// dumpPackages *****");
    }

    public static void main(String[] args) {
        JakartaEESigTest theTests = new JakartaEESigTest();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        super.setup(args, p);
    }

    public void signatureTest() throws Exception {
        super.signatureTest();
    }

    static {
        EnumMap tempMap = new EnumMap(Containers.class);
        HashMap EJB_MAP = new HashMap();
        HashMap SERVLET_MAP = new HashMap();
        HashMap JSP_MAP = new HashMap();
        HashMap<String, String[]> APPCLIENT_MAP = new HashMap<String, String[]>();
        APPCLIENT_MAP.put("ejb", new String[]{"jakarta.ejb", "jakarta.ejb.spi", "jakarta.ejb.embeddable", "jakarta.interceptor"});
        APPCLIENT_MAP.put("interceptors", new String[]{"jakarta.interceptor"});
        APPCLIENT_MAP.put("caj", new String[]{"jakarta.annotation", "jakarta.annotation.security", "jakarta.annotation.sql"});
        APPCLIENT_MAP.put("jms", new String[]{"jakarta.jms"});
        APPCLIENT_MAP.put("javamail", new String[]{"jakarta.mail", "jakarta.mail.event", "jakarta.mail.internet", "jakarta.mail.search", "jakarta.mail.util"});
        APPCLIENT_MAP.put("persistence", new String[]{"jakarta.persistence", "jakarta.persistence.spi", "jakarta.persistence.criteria", "jakarta.persistence.metamodel"});
        APPCLIENT_MAP.put("cdi", new String[]{"jakarta.decorator", "jakarta.enterprise.context", "jakarta.enterprise.context.control", "jakarta.enterprise.context.spi", "jakarta.enterprise.event", "jakarta.enterprise.inject", "jakarta.enterprise.inject.spi", "jakarta.enterprise.inject.literal", "jakarta.enterprise.inject.spi.configurator", "jakarta.enterprise.util", "jakarta.enterprise.inject.spi.el", "jakarta.inject"});
        APPCLIENT_MAP.put("beanval", new String[]{"jakarta.validation", "jakarta.validation.bootstrap", "jakarta.validation.constraints", "jakarta.validation.groups", "jakarta.validation.metadata", "jakarta.validation.constraintvalidation", "jakarta.validation.executable", "jakarta.validation.spi", "jakarta.validation.valueextraction"});
        APPCLIENT_MAP.put("jsonp", new String[]{"jakarta.json", "jakarta.json.spi", "jakarta.json.stream"});
        APPCLIENT_MAP.put("jsonb", new String[]{"jakarta.json.bind", "jakarta.json.bind.adapter", "jakarta.json.bind.annotation", "jakarta.json.bind.config", "jakarta.json.bind.serializer", "jakarta.json.bind.spi"});
        EJB_MAP.putAll(APPCLIENT_MAP);
        EJB_MAP.put("connector", new String[]{"jakarta.resource", "jakarta.resource.cci", "jakarta.resource.spi", "jakarta.resource.spi.work", "jakarta.resource.spi.endpoint", "jakarta.resource.spi.security"});
        EJB_MAP.put("jacc", new String[]{"jakarta.security.jacc"});
        EJB_MAP.put("jaspic", new String[]{"jakarta.security.auth.message", "jakarta.security.auth.message.callback", "jakarta.security.auth.message.config", "jakarta.security.auth.message.module"});
        EJB_MAP.put("jta", new String[]{"jakarta.transaction"});
        EJB_MAP.put("batch", new String[]{"jakarta.batch.api", "jakarta.batch.api.chunk", "jakarta.batch.api.chunk.listener", "jakarta.batch.api.listener", "jakarta.batch.api.partition", "jakarta.batch.operations", "jakarta.batch.runtime", "jakarta.batch.runtime.context"});
        EJB_MAP.put("securityapi", new String[]{"jakarta.security.enterprise", "jakarta.security.enterprise.authentication.mechanism.http", "jakarta.security.enterprise.credential", "jakarta.security.enterprise.identitystore"});
        EJB_MAP.put("concurrency", new String[]{"jakarta.enterprise.concurrent"});
        SERVLET_MAP.putAll(EJB_MAP);
        SERVLET_MAP.put("el", new String[]{"jakarta.el"});
        SERVLET_MAP.put("servlet", new String[]{"jakarta.servlet", "jakarta.servlet.annotation", "jakarta.servlet.descriptor", "jakarta.servlet.http", "jakarta.servlet.jsp", "jakarta.servlet.jsp.el", "jakarta.servlet.jsp.jstl.core", "jakarta.servlet.jsp.jstl.fmt", "jakarta.servlet.jsp.jstl.sql", "jakarta.servlet.jsp.jstl.tlv", "jakarta.servlet.jsp.tagext"});
        SERVLET_MAP.put("jsf", new String[]{"jakarta.faces", "jakarta.faces.application", "jakarta.faces.annotation", "jakarta.faces.component", "jakarta.faces.bean", "jakarta.faces.flow", "jakarta.faces.flow.builder", "jakarta.faces.component.behavior", "jakarta.faces.component.html", "jakarta.faces.component.visit", "jakarta.faces.component.search", "jakarta.faces.context", "jakarta.faces.convert", "jakarta.faces.el", "jakarta.faces.event", "jakarta.faces.lifecycle", "jakarta.faces.model", "jakarta.faces.push", "jakarta.faces.render", "jakarta.faces.validator", "jakarta.faces.view", "jakarta.faces.view.facelets", "jakarta.faces.webapp"});
        SERVLET_MAP.put("jaxrs", new String[]{"jakarta.ws.rs", "jakarta.ws.rs.core", "jakarta.ws.rs.ext", "jakarta.ws.rs.client", "jakarta.ws.rs.container", "jakarta.ws.rs.sse"});
        SERVLET_MAP.put("websocket", new String[]{"jakarta.websocket", "jakarta.websocket.server"});
        JSP_MAP = SERVLET_MAP;
        tempMap.put(Containers.ejb, Collections.unmodifiableMap(EJB_MAP));
        tempMap.put(Containers.servlet, Collections.unmodifiableMap(SERVLET_MAP));
        tempMap.put(Containers.jsp, Collections.unmodifiableMap(JSP_MAP));
        tempMap.put(Containers.appclient, Collections.unmodifiableMap(APPCLIENT_MAP));
        CONTAINER_PACKAGE_MAPS = Collections.unmodifiableMap(tempMap);
    }

    static enum Containers {
        ejb,
        servlet,
        jsp,
        appclient;

    }
}

