/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxrs.lib.implementation.sun.jersey;

import com.sun.ts.lib.util.TestUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

public class TSWebConfiguration {
    private static Boolean runningS1AS;
    public static final String WEB_XML = "web.xml.template";
    private File tempFile;
    private PrintWriter log;
    private static Hashtable htReplacementProps;
    private Hashtable htReplacerTable = new Hashtable();
    private static String sTempDir;
    private StringReplacer replacer = new StringReplacer();
    private static File jteFile;
    private static String servlet_adaptor;
    private static String implementation_name;
    static Properties props;
    static List<String> props_name;

    public TSWebConfiguration() {
        System.out.println("Dummy TSWebConfiguration Conctructor");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        TSWebConfiguration webconfig = new TSWebConfiguration();
        implementation_name = webconfig.findProps(implementation_name);
        System.out.println("++++++++++++=" + implementation_name);
        servlet_adaptor = webconfig.findProps(servlet_adaptor);
        servlet_adaptor = servlet_adaptor.replace(".class", "").replace("/", ".");
        System.out.println("Replacement value for servlet_adaptor =" + servlet_adaptor);
        PrintWriter logOut = new PrintWriter(System.out, true);
        File fileList = new File(System.getProperty("TS_HOME") + File.separator + "bin" + File.separator + "jaxrs_filelist");
        try (BufferedReader input = new BufferedReader(new FileReader(fileList));){
            String line = null;
            while ((line = input.readLine()) != null) {
                System.out.println("Processing file " + line);
                File file = new File(System.getProperty("TS_HOME") + File.separator + line);
                try {
                    htReplacementProps.put("servlet_adaptor", servlet_adaptor);
                    webconfig.sweepwebFile(file);
                    System.out.println("Done with file " + file.toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println("Failed to modify xml files with correct settings.  Please check the values of");
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String findProps(String prop) {
        System.out.println("Processing jte file");
        String replace = null;
        try (BufferedReader input = new BufferedReader(new FileReader(jteFile));){
            String line = null;
            do {
                if ((line = input.readLine()) == null) return null;
            } while (!line.startsWith(prop));
            String string = replace = line.split("=")[1];
            return string;
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public String sweepwebFile(File file) throws FileNotFoundException, IOException {
        if (this.htReplacerTable != null && !this.htReplacerTable.isEmpty()) {
            this.htReplacerTable = this.replaceOnWebInfoStrings(this.htReplacerTable);
        }
        String dir = file.getParent();
        File xml = new File(dir + File.separator + file.getName());
        return this.replacer.replace(file, htReplacementProps, this.htReplacerTable, dir);
    }

    private Hashtable replaceOnWebInfoStrings(Hashtable extras) {
        boolean changeIt = false;
        String[] searchFor = new String[]{"servlet_adaptor"};
        Enumeration e = extras.keys();
        while (e.hasMoreElements()) {
            String sKey = (String)e.nextElement();
            Object val = (String)extras.get(sKey);
            String oldJndi = val;
            changeIt = false;
            String buff = null;
            int startPos = 0;
            for (String element : searchFor) {
                System.out.println("\n###Searching for=" + element);
                startPos = ((String)val).lastIndexOf(element);
                if (startPos == -1) continue;
                changeIt = true;
                String startBuff = ((String)val).substring(0, startPos);
                buff = (String)htReplacementProps.get(element);
                val = startBuff + buff + ((String)val).substring(startPos + element.length());
            }
            if (!changeIt) continue;
            extras.put(sKey, val);
            System.out.println("\n###\nold webInfo Val=" + oldJndi + "\nNew webInfo Val = " + (String)val);
        }
        return extras;
    }

    static {
        htReplacementProps = new Hashtable();
        sTempDir = "";
        jteFile = new File(System.getProperty("TS_HOME") + File.separator + "bin" + File.separator + "ts.jte");
        servlet_adaptor = "servlet_adaptor";
        implementation_name = "jaxrs_impl_name";
        props_name = Arrays.asList("servlet_adaptor");
    }

    final class StringReplacer {
        public String sFindString;
        public String sReplaceString;
        public String sDirString;
        public String sFileNameStringToReplace;
        public String sNewFileNameString;
        public int iHowMany = -1;
        public String[] sFileList;
        public boolean bNewFile = false;
        private Hashtable htFindAndReplace = null;
        private Hashtable htCustomTable = null;
        private Vector vInfoObjects = new Vector();
        private Vector vMatchingInfoObjects = new Vector();
        private Vector vNonMatchingInfoObjects = new Vector();
        private boolean bSomethingWasReplaced = false;

        StringReplacer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String replace(File file, Hashtable htStrings, Hashtable htReplacerTable, String sTempDir) {
            Object sFileList = null;
            this.htFindAndReplace = htStrings;
            this.htCustomTable = htReplacerTable;
            String sTemp = "";
            ReplacementInfo ri = null;
            Object sNewFileName = "";
            StringBuffer sFoundBuffer = new StringBuffer();
            this.bSomethingWasReplaced = false;
            BufferedReader fReader = null;
            BufferedWriter fNewWriter = null;
            try {
                this.vInfoObjects = new Vector();
                String sKey = "";
                Enumeration e = this.htFindAndReplace.keys();
                while (e.hasMoreElements()) {
                    sKey = (String)e.nextElement();
                    this.vInfoObjects.addElement(new ReplacementInfo(sKey, (String)this.htFindAndReplace.get(sKey)));
                }
                if (this.htCustomTable != null) {
                    e = this.htCustomTable.keys();
                    while (e.hasMoreElements()) {
                        sKey = (String)e.nextElement();
                        this.vInfoObjects.addElement(new ReplacementInfo(sKey, (String)this.htCustomTable.get(sKey)));
                    }
                }
                fReader = new BufferedReader(new FileReader(file));
                System.out.println("File to read: " + file.getAbsolutePath());
                StringWriter sWriter = new StringWriter();
                boolean bCheckForDot = false;
                String sHold = "";
                this.vMatchingInfoObjects.addAll(this.vInfoObjects);
                while (true) {
                    Enumeration e2;
                    int iCharRead;
                    if ((iCharRead = fReader.read()) != -1) {
                        block25: {
                            char c = (char)iCharRead;
                            if (bCheckForDot) {
                                if (c != '.') {
                                    sHold = new String(Character.valueOf(c).toString());
                                    System.out.println("sHold = " + sHold);
                                    break block25;
                                } else {
                                    sFoundBuffer.append(c);
                                    bCheckForDot = false;
                                    continue;
                                }
                            }
                            if (sHold != null) {
                                sWriter.write(sHold);
                                sHold = null;
                            }
                            sFoundBuffer.append(c);
                        }
                        sTemp = new String(sFoundBuffer);
                        e2 = this.vMatchingInfoObjects.elements();
                    } else {
                        fReader.close();
                        if (this.bSomethingWasReplaced) {
                            sNewFileName = sTempDir + File.separator + "web.xml." + implementation_name;
                            System.out.println("New filename:" + (String)sNewFileName);
                            fNewWriter = new BufferedWriter(new FileWriter(new File((String)sNewFileName)));
                            fNewWriter.write(sWriter.toString());
                            fNewWriter.flush();
                            return sNewFileName;
                        }
                        sNewFileName = null;
                        return sNewFileName;
                    }
                    while (e2.hasMoreElements()) {
                        ri = (ReplacementInfo)e2.nextElement();
                        if (ri.sFind.startsWith(sTemp)) {
                            if (!ri.sFind.equals(sTemp)) continue;
                            System.out.println("REPLACER:MATCH found:  " + ri.sFind + " matches " + sTemp);
                            ri.foundOccurance();
                            this.bSomethingWasReplaced = true;
                            sWriter.write(ri.sReplace);
                            sFoundBuffer = new StringBuffer();
                            this.vMatchingInfoObjects.removeAllElements();
                            this.vMatchingInfoObjects.addAll(this.vInfoObjects);
                            break;
                        }
                        this.vNonMatchingInfoObjects.addElement(ri);
                    }
                    this.vMatchingInfoObjects.removeAll(this.vNonMatchingInfoObjects);
                    this.vNonMatchingInfoObjects.removeAllElements();
                    if (!this.vMatchingInfoObjects.isEmpty()) continue;
                    sWriter.write(sTemp);
                    sFoundBuffer = new StringBuffer();
                    this.vMatchingInfoObjects.removeAllElements();
                    this.vMatchingInfoObjects.addAll(this.vInfoObjects);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return sNewFileName;
            }
            finally {
                if (fNewWriter != null) {
                    try {
                        fNewWriter.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        class ReplacementInfo {
            private int iFoundOccurances = 0;
            private String sFind = null;
            private String sReplace = null;

            ReplacementInfo(String sFindString, String sReplaceString) {
                this.sFind = sFindString;
                this.sReplace = sReplaceString;
                this.iFoundOccurances = 0;
            }

            public void foundOccurance() {
                ++this.iFoundOccurances;
                if (TestUtil.harnessDebug) {
                    System.out.println("we found an occurance #" + this.iFoundOccurances + " of '" + this.sFind + "'");
                }
            }
        }
    }
}

