/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.access.field;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.core.annotations.access.field.Client;
import ee.jakarta.tck.persistence.core.annotations.access.field.DataTypes;
import java.util.Properties;

public class Client3
extends Client {
    public static void main(String[] args) {
        Client3 theTests = new Client3();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createTestData3();
            this.logTrace("Done creating test data");
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void createTestData3() {
        this.logTrace("createTestData3");
        try {
            this.getEntityTransaction().begin();
            this.d1 = new DataTypes(1, 5);
            this.getEntityManager().persist((Object)this.d1);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception in createTestData:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transientTest() throws Exception {
        boolean pass = false;
        byte newByte = 111;
        try {
            this.getEntityTransaction().begin();
            this.clearCache();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                if (this.d1.getTransient() == 0) {
                    this.logTrace("First find returned expected result:" + this.d1.getTransient());
                    this.d1.setTransient(newByte);
                    this.getEntityManager().merge((Object)this.d1);
                    this.getEntityManager().flush();
                    this.clearCache();
                    this.d1 = null;
                    this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
                    if (this.d1.getTransient() == 0) {
                        pass = true;
                        this.logTrace("Second find returned expected value:" + this.d1.getTransient());
                    } else {
                        this.logErr("Second find expected:0, actual:" + this.d1.getTransient());
                    }
                } else {
                    this.logErr("Expected first find to return:0, actual:" + this.d1.getTransient());
                }
                this.getEntityTransaction().commit();
            } else {
                this.logErr("find returned null");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("transientTest failed");
        }
    }
}

