/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.lite.packaging.war.enventry;

import com.sun.ts.tests.ejb30.common.helper.Helper;
import com.sun.ts.tests.ejb30.lite.packaging.war.enventry.ComponentBase;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import jakarta.ejb.EJBContext;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.InvocationContext;
import java.util.List;

public abstract class InterceptorBase
extends ComponentBase {
    @Resource
    private EJBContext ejbContext;
    @Resource(lookup="java:comp/env/com.sun.ts.tests.ejb30.lite.packaging.war.enventry.OneBean/myFloat", description="declared in ejb-jar.xml#OneBean")
    private float myFloatFromOne;
    @Resource(lookup="java:comp/env/com.sun.ts.tests.ejb30.lite.packaging.war.enventry.TwoBean/myFloat", description="declared in ejb-jar.xml#TwoBean")
    private float myFloatFromTwo;
    @Resource(lookup="java:comp/env/com.sun.ts.tests.ejb30.lite.packaging.war.enventry.ThreeBean/myFloat", description="declared in ejb-jar.xml#ThreeBean")
    private float myFloatFromThree;

    @PostConstruct
    private void postConstruct(InvocationContext inv) {
        this.verifyInterceptorBase();
        try {
            inv.proceed();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected void verifyInterceptorBase() throws RuntimeException {
        StringBuilder sb = new StringBuilder();
        try {
            Helper.assertNotEquals("Check injected EJBContext ", this.ejbContext, null);
            Helper.assertEquals("Check myFloatFromOne ", Float.valueOf(1.0f), Float.valueOf(this.myFloatFromOne), sb);
            Helper.assertEquals("Check myFloatFromTwo ", Float.valueOf(2.0f), Float.valueOf(this.myFloatFromTwo), sb);
            Helper.assertEquals("Check myFloatFromThree ", Float.valueOf(3.0f), Float.valueOf(this.myFloatFromThree), sb);
            this.setInjectionStatusAndRecord(true, sb.toString(), new Throwable[0]);
        }
        catch (Throwable e) {
            this.setInjectionStatusAndRecord(false, sb.toString(), e);
        }
    }

    @AroundInvoke
    private Object intercept(InvocationContext inv) throws Exception {
        String methodName = inv.getMethod().getName();
        Object[] params = inv.getParameters();
        if (methodName.equals("getInjectionStatusForInterceptors")) {
            Object param = params[0];
            List sta = (List)param;
            sta.add(this.getInjectionStatus());
        } else if (methodName.equals("getInjectionRecordsForInterceptors")) {
            Object param = params[0];
            List rec = (List)param;
            List<String> injectionRecords = this.getInjectionRecords();
            if (injectionRecords != null) {
                rec.add(injectionRecords);
            }
        }
        return inv.proceed();
    }
}

