/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.bb.mdb.customlistener;

import com.sun.ts.tests.common.connector.util.TSMessageListenerInterface;
import com.sun.ts.tests.ejb30.common.callback.CallbackBeanBase;
import com.sun.ts.tests.ejb30.common.helper.TLogger;
import com.sun.ts.tests.ejb30.common.messaging.StatusReporter;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import jakarta.ejb.ActivationConfigProperty;
import jakarta.ejb.EJBContext;
import jakarta.ejb.MessageDriven;
import jakarta.ejb.MessageDrivenContext;
import jakarta.ejb.TransactionAttribute;
import jakarta.ejb.TransactionAttributeType;
import jakarta.ejb.TransactionManagement;
import jakarta.ejb.TransactionManagementType;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnectionFactory;

@MessageDriven(name="MDBean", messageListenerInterface=TSMessageListenerInterface.class, activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="java.lang.String")})
@TransactionManagement(value=TransactionManagementType.CONTAINER)
public class MDBean
extends CallbackBeanBase
implements TSMessageListenerInterface {
    @Resource(name="mdc")
    private MessageDrivenContext mdc;
    @Resource(name="qFactory")
    private QueueConnectionFactory qFactory;
    @Resource(name="replyQueue")
    private Queue replyQueue;
    private static boolean replySent = false;

    @Override
    public EJBContext getEJBContext() {
        return this.mdc;
    }

    @PostConstruct
    private void setValue() {
        this.setPostConstructCalled(true);
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void onMessage(String msg) {
        boolean status = false;
        String reason = null;
        String testname = "isPostConstructCalledTest";
        TLogger.log("**** MDBean onMessage called with message = " + msg + " ****");
        status = this.isPostConstructCalled();
        reason = "isPostConstructCalled() in onMessage returns: " + status;
        TLogger.log(reason);
        if (!replySent) {
            StatusReporter.report(testname, status, reason, (QueueConnectionFactory)this.getEJBContext().lookup("qFactory"), (Queue)this.getEJBContext().lookup("replyQueue"));
            replySent = true;
        }
    }
}

